/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.LunWWN;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResEntityWWPN;
import org.eclipse.aperi.repository.table.TResLogicalDisk;
import org.eclipse.aperi.xmsg.MessageLog;

public class TResLunWWN
extends StorageRepositoryAccessor {
    private static final String INSERT = "insert into t_res_lun_wwn (computer_id, lun_id, wwn, swwn, host) values (?,?,?,?,?)";
    private static final String DELETE_BY_COMPUTER = "delete from t_res_lun_wwn where computer_id = ";
    private static final String SELECT_BY_COMPUTER = "select lun_id, swwn from t_res_lun_wwn where computer_id = ?";

    public TResLunWWN(Connection dbc) {
        super(dbc);
        this.tableName = "t_res_lun_wwn";
    }

    public void deleteByComputer(int computerID) throws GeneralException {
        String delete = DELETE_BY_COMPUTER + Integer.toString(computerID);
        this.deleteStmt = this.prepareStmt(delete);
        try {
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException e) {
            this.stmtType = 3;
            this.sqlError(e);
        }
        this.commit();
    }

    public void prepInsert() throws GeneralException {
        this.insertStmt = this.prepareStmt(INSERT);
    }

    public void insert(int computerID, LogicalDisk ld) throws GeneralException {
        try {
            LunWWN lw = ld.ldLunWWNs;
            while (lw != null) {
                block5: {
                    long work_wwn;
                    try {
                        work_wwn = Long.parseLong(lw.lwWWN, 16);
                    }
                    catch (NumberFormatException e) {
                        MessageLog.logMessage((String)"BTM0573E", (Object)lw.lwWWN, (Object)e.toString());
                        break block5;
                    }
                    this.setPhase();
                    this.setInt(this.insertStmt, computerID);
                    this.setInt(this.insertStmt, ld.ldID);
                    this.setLong(this.insertStmt, work_wwn);
                    this.setString(this.insertStmt, lw.lwWWN);
                    this.setString(this.insertStmt, lw.lwHost);
                    this.executeUpdate(this.insertStmt);
                }
                lw = lw.lwNext;
            }
        }
        catch (SQLException e) {
            this.stmtType = 1;
            this.sqlError(e);
        }
    }

    public LunWWN SelectByComputerId(int compID) throws GeneralException {
        LunWWN lunWWNList = null;
        this.selectStmt = this.prepareStmt(SELECT_BY_COMPUTER);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, compID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                LunWWN lun_wwn = new LunWWN();
                lun_wwn.lwComputerID = compID;
                this.fetchLunWWPN(lun_wwn, this.resultSet);
                lun_wwn.lwNext = lunWWNList;
                lunWWNList = lun_wwn;
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResEntityWWPN.class.getName(), (String)"selectByComputerId", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        LunWWN traceResult = lunWWNList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResEntityWWPN.class.getName(), (String)"selectByComputerId", traceResult);
        }
        return traceResult;
    }

    public int fetchLunWWPN(LunWWN temp, ResultSet resultSet) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"fetchLunWWPN", (String)"temp, resultSet");
        }
        this.colIndex = 1;
        temp.lwLunID = this.getInt(resultSet);
        temp.lwWWN = this.getString(resultSet);
        int traceResult = this.colIndex;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"fetchLunWWPN", (int)traceResult);
        }
        return traceResult;
    }
}

