/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.TStorm.common.NasFilerAdmin;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TResLdapTree;
import org.eclipse.aperi.repository.table.TStatComputer;

public class TResPwd
extends RepositoryAccessor {
    public static final String TABLE_NAME = "t_res_pwd";
    public static final String ID_COLUMN = "resource_id";
    public static final int DEFAULT_FILER_LOGIN = -1;
    private static final String INSERT = "insert into t_res_pwd (resource_id, user_name, pwd) values (?,?,?)";
    private static final String UPDATE = "update t_res_pwd set user_name = ?, pwd = ? where resource_id = ?";
    private static final String SELECT = "select resource_id, user_name, pwd from t_res_pwd";
    private static final String SELECT_LOGIN = "select user_name, pwd from t_res_pwd where resource_id = ?";
    private static final String SELECT_DOMAIN_VISIBLE_FILERS_START = "select c.host_name, c.computer_id, p.user_name, p.pwd from t_res_pwd p, t_res_host c, t_res_share s, t_res_domain d where d.domain_id = s.computer_id and s.resource_id = c.computer_id and s.resource_type = 1 and c.computer_id = p.resource_id and d.name = ? union all select cc.host_name, cc.computer_id, ";
    private static final String SELECT_DOMAIN_VISIBLE_FILERS_END = " from t_res_host cc, t_res_share ss, t_res_domain dd where dd.domain_id = ss.computer_id and ss.resource_id = cc.computer_id and ss.resource_type = 1 and dd.name = ? and ss.resource_id not in (select resource_id from t_res_pwd)";
    private static String selectDomainVisibleFilers;

    public TResPwd(Connection dbc) {
        super(dbc);
        this.tableName = TABLE_NAME;
    }

    public void prepLoginUpdate() throws GeneralException {
        this.insertStmt = this.prepareStmt(INSERT);
        this.updateStmt = this.prepareStmt(UPDATE);
    }

    public void closeLoginUpdate() throws GeneralException {
        this.closeInsert();
        this.closeUpdate();
    }

    public void updateLogin(int resourceID, String userName, String pwd) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResPwd.class.getName(), (String)"updateLogin", (String)"resourceID, userName, pwd");
        }
        this.updateLogin(resourceID, userName, pwd, true);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResPwd.class.getName(), (String)"updateLogin");
        }
    }

    public void updateLogin(int resourceID, String userName, String pwd, boolean commit) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResPwd.class.getName(), (String)"updateLogin", (String)"resourceID, userName, pwd, commit");
        }
        if (!this.update(resourceID, userName, pwd, commit) && !this.insert(resourceID, userName, pwd, commit)) {
            this.update(resourceID, userName, pwd, commit);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResPwd.class.getName(), (String)"updateLogin");
        }
    }

    private boolean update(int resourceID, String userName, String pwd, boolean commit) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResPwd.class.getName(), (String)"update", (String)"resourceID, userName, pwd, commit");
        }
        boolean updated = false;
        try {
            this.setPhase();
            this.setString(this.updateStmt, userName);
            this.setString(this.updateStmt, pwd);
            this.setInt(this.updateStmt, resourceID);
            boolean bl = updated = this.executeUpdate(this.updateStmt) > 0;
            if (commit) {
                this.dbc.commit();
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResPwd.class.getName(), (String)"update", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        boolean traceResult = updated;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResPwd.class.getName(), (String)"update", (boolean)traceResult);
        }
        return traceResult;
    }

    private boolean insert(int resourceID, String userName, String pwd, boolean commit) throws GeneralException {
        boolean inserted;
        block6: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)TResPwd.class.getName(), (String)"insert", (String)"resourceID, userName, pwd, commit");
            }
            inserted = false;
            try {
                this.setPhase();
                this.setInt(this.insertStmt, resourceID);
                this.setString(this.insertStmt, userName);
                this.setString(this.insertStmt, pwd);
                this.executeUpdate(this.insertStmt);
                if (commit) {
                    this.dbc.commit();
                }
                inserted = true;
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TResPwd.class.getName(), (String)"insert", (Throwable)e);
                }
                if (SQLUtil.isDuplicateKeyViolation(e)) break block6;
                this.stmtType = 1;
                this.sqlError(e);
            }
        }
        boolean traceResult = inserted;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResPwd.class.getName(), (String)"insert", (boolean)traceResult);
        }
        return traceResult;
    }

    public NasFilerAdmin getWindowsFilers() throws GeneralException {
        NasFilerAdmin head;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResPwd.class.getName(), (String)"getWindowsFilers", (String)"");
        }
        if ((head = new TStatComputer(this.dbc).selectWindowsFilers()) != null) {
            try {
                this.staticStmt = this.createStatement();
                this.resultSet = this.staticStmt.executeQuery(SELECT);
                block2: while (this.nextResult()) {
                    this.getPhase();
                    int ID = this.getInt(this.resultSet);
                    NasFilerAdmin filer = head;
                    while (filer != null) {
                        if (filer.nfaFilerID == ID) {
                            filer.nfaUserName = this.getString(this.resultSet);
                            filer.nfaPassword = this.getString(this.resultSet);
                            continue block2;
                        }
                        filer = filer.nfaNext;
                    }
                }
                this.closeStaticStmt();
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TResPwd.class.getName(), (String)"getWindowsFilers", (Throwable)e);
                }
                this.stmtType = 0;
                this.sqlError(e);
            }
        }
        NasFilerAdmin traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResPwd.class.getName(), (String)"getWindowsFilers", (Object)traceResult);
        }
        return traceResult;
    }

    public NasFiler getDomainVisibleFilers(String domainName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResPwd.class.getName(), (String)"getDomainVisibleFilers", (String)"domainName");
        }
        NasFiler filerList = null;
        this.selectStmt = this.prepareStmt(selectDomainVisibleFilers);
        try {
            this.setPhase();
            this.setString(this.selectStmt, domainName);
            this.setString(this.selectStmt, domainName);
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                NasFiler filer = new NasFiler();
                this.getPhase();
                filer.nfName = this.getString(this.resultSet);
                filer.nfComputerID = this.getInt(this.resultSet);
                String userName = this.getString(this.resultSet);
                if (!this.resultSet.wasNull()) {
                    LdapTree tree;
                    filer.nfLdapTree = tree = new LdapTree();
                    tree.ltLdapUser = userName;
                    tree.ltPassword = this.getString(this.resultSet);
                }
                filer.nfNext = filerList;
                filerList = filer;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResPwd.class.getName(), (String)"getDomainVisibleFilers", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        NasFiler traceResult = filerList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResPwd.class.getName(), (String)"getDomainVisibleFilers", traceResult);
        }
        return traceResult;
    }

    public String[] getDefaultLogin() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResPwd.class.getName(), (String)"getDefaultLogin", (String)"");
        }
        String[] result = null;
        this.selectStmt = this.prepareStmt(SELECT_LOGIN);
        result = new String[2];
        if (!this.fetchLogin(-1, result)) {
            result = null;
        }
        this.closeSelect();
        String[] traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResPwd.class.getName(), (String)"getDefaultLogin", (Object)traceResult);
        }
        return traceResult;
    }

    private boolean fetchLogin(int resourceID, String[] login) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResPwd.class.getName(), (String)"fetchLogin", (String)"resourceID, login");
        }
        boolean rowFetched = false;
        try {
            this.setPhase();
            this.setInt(this.selectStmt, resourceID);
            this.resultSet = this.selectStmt.executeQuery();
            rowFetched = this.nextResult();
            if (rowFetched) {
                this.getPhase();
                login[0] = this.getString(this.resultSet);
                login[1] = this.getString(this.resultSet);
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResPwd.class.getName(), (String)"fetchLogin", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        boolean traceResult = rowFetched;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResPwd.class.getName(), (String)"fetchLogin", (boolean)traceResult);
        }
        return traceResult;
    }

    public void getFilerLogins(Iterator i) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResPwd.class.getName(), (String)"getFilerLogins", (String)"i");
        }
        NasFiler nasFilers = null;
        HashMap<String, LdapTree> treeMap = new HashMap<String, LdapTree>();
        TResLdapTree treeAccessor = new TResLdapTree(this.dbc);
        treeAccessor.prepGetByName();
        while (i.hasNext()) {
            NasFiler filer = (NasFiler)i.next();
            if (filer.nfManufacturer.equals("NOVELL")) {
                int start = filer.nfName.lastIndexOf(58);
                if (start == -1) continue;
                String treeName = filer.nfName.substring(start + 1);
                LdapTree tree = (LdapTree)treeMap.get(treeName);
                if (tree == null) {
                    tree = treeAccessor.getByName(treeName);
                    if (tree == null) continue;
                    treeMap.put(treeName, tree);
                }
                filer.nfLdapTree = tree;
                continue;
            }
            filer.nfNext = nasFilers;
            nasFilers = filer;
        }
        treeAccessor.closeSelect();
        treeAccessor = null;
        if (nasFilers != null) {
            TResDomain domAccessor = new TResDomain(this.dbc);
            domAccessor.prepFetchByComputerID();
            Domain domain = new Domain();
            NasFiler filer = nasFilers;
            while (filer != null) {
                domain.domID = filer.nfComputerID;
                domAccessor.fetchByID(domain, false);
                if (domain.domName != null) {
                    filer.nfDomain = domain;
                    domain = new Domain();
                }
                filer = filer.nfNext;
            }
            domAccessor.closeSelect();
            this.getNasLogins(nasFilers, true);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResPwd.class.getName(), (String)"getFilerLogins");
        }
    }

    private void getNasLogins(NasFiler filerList, boolean getDefaultLogin) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResPwd.class.getName(), (String)"getNasLogins", (String)"filerList, getDefaultLogin");
        }
        LdapTree defaultLogin = null;
        boolean defaultFetched = !getDefaultLogin;
        String[] buffer = new String[2];
        this.selectStmt = this.prepareStmt(SELECT_LOGIN);
        NasFiler filer = filerList;
        while (filer != null) {
            if (this.fetchLogin(filer.nfComputerID, buffer)) {
                filer.nfLdapTree = this.makeLdapTree(buffer);
            } else {
                if (!defaultFetched) {
                    defaultFetched = true;
                    if (this.fetchLogin(-1, buffer)) {
                        defaultLogin = this.makeLdapTree(buffer);
                    }
                }
                filer.nfLdapTree = defaultLogin;
            }
            filer = filer.nfNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResPwd.class.getName(), (String)"getNasLogins");
        }
    }

    private LdapTree makeLdapTree(String[] buffer) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResPwd.class.getName(), (String)"makeLdapTree", (String)"buffer");
        }
        LdapTree tree = new LdapTree();
        tree.ltLdapUser = buffer[0];
        tree.ltPassword = buffer[1];
        LdapTree traceResult = tree;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResPwd.class.getName(), (String)"makeLdapTree", (Object)traceResult);
        }
        return traceResult;
    }

    static {
        StringBuffer buf = new StringBuffer(900);
        buf.append(SELECT_DOMAIN_VISIBLE_FILERS_START);
        String middleSection = SQLUtil.isDerby() || SQLUtil.isCloudscape() || SQLUtil.isUDB() ? "cast (null as varchar(64)), cast (null as varchar(128))" : "null, null";
        buf.append(middleSection);
        buf.append(SELECT_DOMAIN_VISIBLE_FILERS_END);
        selectDomainVisibleFilers = buf.toString();
    }
}

