/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiSavedReportReq;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.CreatorNameQueryable;
import org.eclipse.aperi.repository.EditableObjectProxy;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.xmsg.MessageLog;

public class TSavedReport
extends StorageRepositoryAccessor
implements CreatorNameQueryable {
    private static final String SELECT_BY_CREATOR = "select name, report_id from t_saved_report where creator = ? and report_id ";
    private static final String PRODUCT = " and product_code = '";
    private static final String ORDER_BY = " order by name desc";
    private static final String WHERE_ID = " where report_id = ";
    private static final String COLUMNS = "definition, product_code";
    private static final String ID_COLUMN = "report_id";

    public TSavedReport(Connection dbc) {
        super(dbc);
        this.tableName = "t_saved_report";
    }

    public NameList selectNames(GuiListReq glr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSavedReport.class.getName(), (String)"selectNames", (String)"glr");
        }
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(SELECT_BY_CREATOR);
        if (glr.qualifier == 1) {
            buffer.append(" <= ");
        } else {
            buffer.append(" > ");
        }
        buffer.append(299);
        buffer.append(PRODUCT);
        buffer.append(Short.toString(glr.resourceType));
        buffer.append('\'');
        buffer.append(ORDER_BY);
        this.selectStmt = this.prepareStmt(buffer.toString());
        NameList list = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setString(this.selectStmt, (String)glr.qualifierObject);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                NameList name = new NameList();
                this.colIndex = 1;
                name.nlName = this.getString(this.resultSet);
                name.nlID = this.getInt(this.resultSet);
                name.nlInfo = (short)35;
                name.nlNext = list;
                list = name;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TSavedReport.class.getName(), (String)"selectNames", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        NameList traceResult = list;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSavedReport.class.getName(), (String)"selectNames", traceResult);
        }
        return traceResult;
    }

    public String getIDColumnName() {
        return ID_COLUMN;
    }

    public void appendWhereClause(GuiListReq glr, StringBuffer buf) {
    }

    public void addQualifiers(GuiListReq glr, NameList name) {
    }

    public GuiSavedReportReq selectByID(int reportID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSavedReport.class.getName(), (String)"selectByID", (String)"reportID");
        }
        GuiSavedReportReq savedReport = new GuiSavedReportReq();
        savedReport.ID = reportID;
        EditableObjectProxy proxy = new EditableObjectProxy(this, (CreateHeader)savedReport, this.getObjectType());
        proxy.initSelect(COLUMNS);
        InputStream is = null;
        ObjectInputStream oi = null;
        try {
            is = this.resultSet.getBinaryStream(this.colIndex++);
            oi = new ObjectInputStream(is);
            savedReport.grr = (GuiReportReq)oi.readObject();
            if (savedReport.grr.productCode == 0) {
                savedReport.grr.productCode = 1;
            }
            savedReport.productCode = this.getByte(this.resultSet);
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TSavedReport.class.getName(), (String)"selectByID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        catch (Exception e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TSavedReport.class.getName(), (String)"selectByID", (Throwable)e);
            }
            this.cleanup();
            String msg = MessageLog.getMessageWithException((String)"STS0152E", (Exception)e, (Object)e.toString());
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TSavedReport.class.getName(), (String)"selectByID");
            }
            throw new GeneralException(msg);
        }
        finally {
            block29: {
                block28: {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ignored) {
                            if (!TraceLogger.enableTrace) break block28;
                            TraceLogger.exception((String)TSavedReport.class.getName(), (String)"selectByID", (Throwable)ignored);
                        }
                    }
                }
                if (oi != null) {
                    try {
                        oi.close();
                    }
                    catch (IOException ignored) {
                        if (!TraceLogger.enableTrace) break block29;
                        TraceLogger.exception((String)TSavedReport.class.getName(), (String)"selectByID", (Throwable)ignored);
                    }
                }
            }
        }
        GuiSavedReportReq traceResult = savedReport;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSavedReport.class.getName(), (String)"selectByID", (Object)traceResult);
        }
        return traceResult;
    }

    private String getObjectType() {
        return MessageLog.getMessageNoID((String)"STG4153L");
    }

    public void insert(GuiSavedReportReq savedReport) throws GeneralException {
        this.insert(savedReport, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(GuiSavedReportReq savedReport, boolean ignoreDuplicates) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSavedReport.class.getName(), (String)"insert", (String)"savedReport, ignoreDuplicates");
        }
        EditableObjectProxy proxy = new EditableObjectProxy(this, (CreateHeader)savedReport, this.getObjectType());
        proxy.initInsert(COLUMNS);
        ByteArrayOutputStream bs = null;
        ObjectOutputStream os = null;
        try {
            bs = new ByteArrayOutputStream(512);
            os = new ObjectOutputStream(bs);
            os.writeObject(savedReport.grr);
            os.flush();
            this.setBytes(this.insertStmt, bs.toByteArray());
            this.setByte(this.insertStmt, savedReport.productCode);
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TSavedReport.class.getName(), (String)"insert", (Throwable)e);
            }
            this.cleanup();
            String msg = MessageLog.getMessageWithException((String)"STS0151E", (Exception)e);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TSavedReport.class.getName(), (String)"insert");
            }
            throw new GeneralException(msg);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TSavedReport.class.getName(), (String)"insert", (Throwable)e);
            }
            this.sqlError(e);
        }
        finally {
            block27: {
                block26: {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException ignored) {
                            if (!TraceLogger.enableTrace) break block26;
                            TraceLogger.exception((String)TSavedReport.class.getName(), (String)"insert", (Throwable)ignored);
                        }
                    }
                }
                if (bs != null) {
                    try {
                        bs.close();
                    }
                    catch (IOException ignored) {
                        if (!TraceLogger.enableTrace) break block27;
                        TraceLogger.exception((String)TSavedReport.class.getName(), (String)"insert", (Throwable)ignored);
                    }
                }
            }
        }
        proxy.finishInsert(ignoreDuplicates);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSavedReport.class.getName(), (String)"insert");
        }
    }

    public void delete(int reportID, boolean commit) throws GeneralException {
        this.delete(this.tableName, WHERE_ID + Integer.toString(reportID), commit);
    }
}

