/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResDevice;
import org.eclipse.aperi.repository.table.TStormSettings;
import org.eclipse.aperi.xmsg.MessageLog;

public class TStatDiskHist
extends StorageRepositoryAccessor {
    private Settings settings;
    private long oldestDaily;
    private long oldestWeekly;
    private long oldestMonthly;
    private static final int NULL_TEMPERATURE = -274;
    private static final String FETCH = "select disk_id, statistic_time, statistic_type, primary_defects, grown_defects, recovrd_wrt_errs, unrecovrd_wrt_errs, bytes_written, recovrd_rd_errs, unrecovrd_rd_errs, bytes_read, recovrd_vfy_errs, unrecovrd_vfy_errs, non_medium_errs, temperature, free_space, capacity from t_stat_disk_hist where";
    private static final String FETCH_GROWN_DEFECTS = "select grown_defects, free_space from t_stat_disk_hist where disk_id = ? and statistic_type = '3'";
    private static final String INSERT_HIST = "insert into t_stat_disk_hist (disk_id, statistic_time, statistic_type, primary_defects, grown_defects, recovrd_wrt_errs, unrecovrd_wrt_errs, bytes_written, recovrd_rd_errs, unrecovrd_rd_errs, bytes_read, recovrd_vfy_errs, unrecovrd_vfy_errs, non_medium_errs, temperature, free_space, capacity) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SELECT_SS_DISKS = "select h.disk_id, h.capacity from t_stat_disk_hist h, t_res_physical_volume pv  where h.disk_id = pv.physical_volume_id and ";
    private static final String SELECT_SVC_MDISKS = "select h.disk_id, h.capacity from t_stat_disk_hist h, t_res_storage_extent se  where h.disk_id = se.storage_extent_id and ";
    private static final String SELECT_SVC_ALLOCATED_MDISK_SPACE = "select ( sum((chunk_size * 1024 * 1024) / 512) ) from t_res_chunk where disk_id = ?";
    private static final String SELECT_FASTT_ALLOCATED_DISK_SPACE = "select ( sum(chunk_size) ) from t_res_chunk where disk_id = ?";
    private static final String SELECT_SS_ALLOCATED_DISK_SPACE = "select (chunk_size + offset) from t_res_chunk where disk_id = ? and offset = (select MAX(offset) from t_res_chunk where disk_id = ?)";
    private static final String UPDATE_DISK_FREE_SPACE = "update t_stat_disk_hist  set free_space = ? where statistic_type = '3' and disk_id = ?";
    private static final String INSERT_SS_DISK_HIST = "insert into t_stat_disk_hist (disk_id, statistic_time, statistic_type, primary_defects, grown_defects, recovrd_wrt_errs, unrecovrd_wrt_errs, bytes_written, recovrd_rd_errs, unrecovrd_rd_errs, bytes_read, recovrd_vfy_errs, unrecovrd_vfy_errs, non_medium_errs, capacity, free_space, temperature) select pv.PHYSICAL_VOLUME_ID, pv.update_timestamp, '3', -1, -1, -1, -1, -1.0, -1, -1, -1.0, -1, -1, -1, CASE WHEN pv.capacity  IS NULL  THEN 0  ELSE pv.capacity  END, CASE WHEN pv.capacity  IS NULL  THEN 0  ELSE pv.capacity  END, -274 from t_res_physical_volume pv where ";
    private static final String INSERT_SVC_MDISK_HIST = "insert into t_stat_disk_hist (disk_id, statistic_time, statistic_type, primary_defects, grown_defects, recovrd_wrt_errs, unrecovrd_wrt_errs, bytes_written, recovrd_rd_errs, unrecovrd_rd_errs, bytes_read, recovrd_vfy_errs, unrecovrd_vfy_errs, non_medium_errs, capacity, free_space, temperature) select se.storage_extent_id, se.update_timestamp, '3', -1, -1, -1, -1, -1.0, -1, -1, -1.0, -1, -1, -1, CASE WHEN se.total_capacity  IS NULL  THEN 0  ELSE se.total_capacity  END, CASE WHEN se.free_space      IS NULL  THEN (CASE WHEN se.total_capacity  IS NULL  THEN 0  ELSE se.total_capacity  END)   ELSE se.free_space      END, -274 from t_res_storage_extent se where ";
    private static final String RESET_CURRENT = "update t_stat_disk_hist set statistic_type = '0' where disk_id = ? and statistic_type = '3'";
    private static final String AGE_OFF_HIST = "delete from t_stat_disk_hist where disk_id = ? and statistic_time < ? and statistic_type = ?";
    private static final String DELETE_BY_DISK = "delete from t_stat_disk_hist where disk_id = ?";
    private static final String MOST_RECENT = " statistic_type = '3' ";
    private static final String BY_ID = " disk_id = ?";
    private static final String ORDER_BY_TIME = " order by statistic_time desc";
    private static final String AGGREGATE_BY_COMPUTER = " select s.computer_id, sum(h.free_space), sum(h.capacity)  from t_stat_disk_hist h, t_res_share s where s.resource_type = 10 and s.resource_id = h.disk_id and statistic_type = '3'  group by s.computer_id UNION select ss.subsystem_id, sum(h.free_space), sum(h.capacity) from t_stat_disk_hist h, t_res_storage_subsystem ss, t_res_physical_volume pv where h.disk_id = pv.physical_volume_id and pv.subsystem_id = ss.subsystem_id and  statistic_type = '3'  group by ss.subsystem_id UNION select ss.subsystem_id, sum(h.free_space), sum(h.capacity) from t_stat_disk_hist h, t_res_storage_subsystem ss, t_res_storage_extent se where h.disk_id = se.storage_extent_id and se.subsystem_id = ss.subsystem_id and  statistic_type = '3'  group by ss.subsystem_id";
    private static final String AGGREGATE_BY_COMPUTER_GROUP = " select g.group_id, sum(h.free_space), sum(h.capacity) from t_stat_disk_hist h, t_group g where  statistic_type = '3'  and h.disk_id in (select distinct(resource_id) from t_res_share s, t_stat_computer c where s.resource_type = 10 and s.computer_id = c.computer_id) and g.group_id in ( select g2.group_id from t_group g2 where g2.group_id in(select distinct(gr.group_id) from t_group2res gr where  gr.resource_id in (select distinct(c.computer_id) from  t_res_share s, t_stat_computer c where   s.computer_id = c.computer_id))) group by g.group_id";
    private static final String AGGREGATE_BY_DOMAIN = " select d.domain_id, sum(h.free_space), sum(h.capacity) from t_stat_disk_hist h, t_res_domain d where statistic_type = '3' and h.disk_id in (select distinct(resource_id) from t_res_share s, t_stat_computer c where s.resource_type = 10 and s.computer_id = c.computer_id and c.domain_id = d.domain_id) group by d.domain_id";
    private static final String AGGREGATE_BY_NETWORK = " select sum(h.free_space), sum(h.capacity) from t_stat_disk_hist h, t_stat_disk d where h.disk_id = d.disk_id and statistic_type = '3' ";

    public TStatDiskHist(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"TStatDiskHist", (String)"dbc");
        }
        this.tableName = "t_stat_disk_hist";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"TStatDiskHist");
        }
    }

    private String getSelectSVCMDisks(int[] svcIDs) throws GeneralException {
        StringBuffer selectSVCDisks = new StringBuffer();
        selectSVCDisks.append(SELECT_SVC_MDISKS);
        SQLUtil.appendInClause(selectSVCDisks, "se.subsystem_id", svcIDs);
        return selectSVCDisks.toString();
    }

    private String getSelectSSDisks(int[] ssIDs) throws GeneralException {
        StringBuffer selectSSDisks = new StringBuffer();
        selectSSDisks.append(SELECT_SS_DISKS);
        SQLUtil.appendInClause(selectSSDisks, "pv.subsystem_id", ssIDs);
        return selectSSDisks.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSubsystemDiskHistory(String selectText) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"resetSubsystemDiskHistory", (String)"selectText");
        }
        PreparedStatement disksStmt = null;
        ResultSet disksRS = null;
        int disk_id = -1;
        try {
            disksStmt = this.dbc.prepareStatement(selectText);
            disksRS = disksStmt.executeQuery();
            while (disksRS.next()) {
                disk_id = disksRS.getInt(1);
                DiskHistory dh = new DiskHistory();
                dh.dkhDiskID = disk_id;
                this.resetCurrentToDaily(dh);
            }
        }
        catch (SQLException sqle) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDiskHist.class.getName(), (String)"resetSubsystemDiskHistory", (Throwable)sqle);
            }
            this.sqlError(sqle);
        }
        finally {
            try {
                if (disksStmt != null) {
                    disksStmt.close();
                }
                if (disksRS != null) {
                    disksRS.close();
                }
            }
            catch (SQLException sqle) {}
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"resetSubsystemDiskHistory");
        }
    }

    public int insertSSandSVCDisks(int[] svcIDs, int[] ssIDs) throws GeneralException {
        int insertedRows = 0;
        TStormSettings setAccessor = new TStormSettings(this.dbc);
        this.settings = setAccessor.getSettings(true);
        this.prepSaveHist(this.settings, -1L);
        if (svcIDs.length > 0) {
            String selectSVCDisks = this.getSelectSVCMDisks(svcIDs);
            this.resetSubsystemDiskHistory(selectSVCDisks);
            StringBuffer insertTStatDiskHistMDisk = new StringBuffer();
            insertTStatDiskHistMDisk.append(INSERT_SVC_MDISK_HIST);
            SQLUtil.appendInClause(insertTStatDiskHistMDisk, "se.subsystem_id", svcIDs);
            insertedRows += this.executeInsertDisks(insertTStatDiskHistMDisk.toString());
            this.setDiskFreeSpace(selectSVCDisks);
        }
        if (ssIDs.length > 0) {
            String selectSSDisks = this.getSelectSSDisks(ssIDs);
            this.resetSubsystemDiskHistory(selectSSDisks);
            StringBuffer insertTStatDiskHistSS = new StringBuffer();
            insertTStatDiskHistSS.append(INSERT_SS_DISK_HIST);
            SQLUtil.appendInClause(insertTStatDiskHistSS, "pv.subsystem_id", ssIDs);
            insertedRows += this.executeInsertDisks(insertTStatDiskHistSS.toString());
            this.setDiskFreeSpace(selectSSDisks);
        }
        this.closeSaveHist();
        return insertedRows;
    }

    public int executeInsertDisks(String sqlText) throws GeneralException {
        int insertedRows = 0;
        try {
            Statement insertStatement = this.dbc.createStatement();
            insertedRows = insertStatement.executeUpdate(sqlText);
            insertStatement.close();
            this.dbc.commit();
        }
        catch (SQLException sqle) {
            this.sqlError(sqle);
        }
        return insertedRows;
    }

    public void saveDailyHist(Settings settings, Device devList, long probeTime) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"saveDailyHist", (String)"settings, devList, probeTime");
        }
        this.prepSaveHist(settings, probeTime);
        this.selectStmt = this.prepareStmt(FETCH_GROWN_DEFECTS);
        Device device = devList;
        while (device != null) {
            if (device.isFixedDisk()) {
                Disk disk = (Disk)device;
                if (disk.dskHistory != null) {
                    DiskHistory hist = disk.dskHistory;
                    hist.dkhTimestamp = probeTime;
                    hist.dkhType = (byte)3;
                    hist.dkhDiskID = disk.devID;
                    hist.dkhOldGrownDefects = (device.devFlags & 4) == 0 ? this.getGrownDefects(hist) : Integer.MAX_VALUE;
                    if (hist.dkhFreeSpace < 0L) {
                        hist.dkhFreeSpace = hist.dkhCapacity;
                    }
                    this.resetCurrentToDaily(hist);
                    this.insertHist(hist);
                    this.ageHist(hist);
                }
            }
            device = device.devNext;
        }
        this.closeSelect();
        this.closeSaveHist();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"saveDailyHist");
        }
    }

    private void prepSaveHist(Settings settings, long probeTime) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"prepSaveHist", (String)"settings, probeTime");
        }
        if (probeTime == -1L) {
            try {
                probeTime = SQLUtil.getTimestamp(this.dbc).getTime();
            }
            catch (SQLException sqle) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TStatDiskHist.class.getName(), (String)"prepSaveHist", (Throwable)sqle);
                }
                this.sqlError(sqle);
            }
        }
        this.settings = settings;
        this.setRetentionTimes(probeTime);
        this.insertStmt = this.prepareStmt(INSERT_HIST);
        this.updateStmt = this.prepareStmt(RESET_CURRENT);
        this.deleteStmt = this.prepareStmt(AGE_OFF_HIST);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"prepSaveHist");
        }
    }

    private void closeSaveHist() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"closeSaveHist", (String)"");
        }
        this.closeInsert();
        this.closeUpdate();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"closeSaveHist");
        }
    }

    private void setRetentionTimes(long probeTime) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"setRetentionTimes", (String)"probeTime");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        Date probeDate = new Date(probeTime);
        calendar.setTime(probeDate);
        if (this.settings.seDiskDailyHist != 0) {
            calendar.add(5, -this.settings.seDiskDailyHist);
        }
        this.oldestDaily = calendar.getTime().getTime();
        if (this.settings.seDiskWeeklyHist != 0) {
            calendar.setTime(probeDate);
            calendar.add(5, -(this.settings.seDiskWeeklyHist * 7));
            this.oldestWeekly = calendar.getTime().getTime();
        }
        if (this.settings.seDiskMonthlyHist != 0) {
            calendar.setTime(probeDate);
            calendar.add(2, -this.settings.seDiskMonthlyHist);
            this.oldestMonthly = calendar.getTime().getTime();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"setRetentionTimes");
        }
    }

    public int getGrownDefects(DiskHistory hist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"getGrownDefects", (String)"hist");
        }
        int grownDefects = Integer.MAX_VALUE;
        int deadlockRetries = 3;
        while (true) {
            try {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, hist.dkhDiskID);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                if (this.nextResult()) {
                    this.colIndex = 1;
                    grownDefects = this.getInt(this.resultSet);
                    if (hist.dkhFreeSpace < 0L) {
                        hist.dkhFreeSpace = this.getLong(this.resultSet);
                    }
                }
                this.resultSet.close();
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TStatDiskHist.class.getName(), (String)"getGrownDefects", (Throwable)e);
                }
                if (SQLUtil.isDeadlock(e) && --deadlockRetries >= 0) {
                    try {
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                this.stmtType = 0;
                this.sqlError(e);
                continue;
            }
            break;
        }
        int traceResult = grownDefects;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"getGrownDefects", (int)traceResult);
        }
        return traceResult;
    }

    public void resetCurrentToDaily(DiskHistory hist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"resetCurrentToDaily", (String)"hist");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.updateStmt, hist.dkhDiskID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDiskHist.class.getName(), (String)"resetCurrentToDaily", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"resetCurrentToDaily");
        }
    }

    public void insertHist(DiskHistory hist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"insertHist", (String)"hist");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setKey(this.insertStmt, hist);
            this.setInt(this.insertStmt, hist.dkhPrimaryDefects);
            this.setInt(this.insertStmt, hist.dkhGrownDefects);
            this.setInt(this.insertStmt, hist.dkhRecoveredWriteErrors);
            this.setInt(this.insertStmt, hist.dkhUnrecoveredWriteErrors);
            double byteCount = hist.dkhBytesWritten;
            this.setDouble(this.insertStmt, byteCount);
            this.setInt(this.insertStmt, hist.dkhRecoveredReadErrors);
            this.setInt(this.insertStmt, hist.dkhUnrecoveredReadErrors);
            byteCount = hist.dkhBytesRead;
            this.setDouble(this.insertStmt, byteCount);
            this.setInt(this.insertStmt, hist.dkhRecoveredVerifyErrors);
            this.setInt(this.insertStmt, hist.dkhUnrecoveredVerifyErrors);
            this.setInt(this.insertStmt, hist.dkhNonMediumErrors);
            this.setShort(this.insertStmt, hist.dkhTemperature);
            this.setLong(this.insertStmt, hist.dkhFreeSpace);
            this.setLong(this.insertStmt, hist.dkhCapacity);
            this.executeUpdate(this.insertStmt);
            this.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDiskHist.class.getName(), (String)"insertHist", (Throwable)e);
            }
            PrintWriter p = MessageLog.getThreadLog();
            p.println("PrimaryDefects: " + hist.dkhPrimaryDefects);
            p.println("GrownDefects: " + hist.dkhGrownDefects);
            p.println("RecoveredWriteErrors: " + hist.dkhRecoveredWriteErrors);
            p.println("UnrecoveredWriteErrors: " + hist.dkhUnrecoveredWriteErrors);
            p.println("BytesWritten: " + hist.dkhBytesWritten);
            p.println("RecoveredReadErrors: " + hist.dkhRecoveredReadErrors);
            p.println("UnrecoveredReadErrors: " + hist.dkhUnrecoveredReadErrors);
            p.println("BytesRead: " + hist.dkhBytesRead);
            p.println("RecoveredVerifyErrors: " + hist.dkhRecoveredVerifyErrors);
            p.println("UnrecoveredVerifyErrors: " + hist.dkhUnrecoveredVerifyErrors);
            p.println("NonMediumErrors: " + hist.dkhNonMediumErrors);
            p.println("Temperature: " + hist.dkhTemperature);
            p.println("FreeSpace: " + hist.dkhFreeSpace);
            p.println("Capacity: " + hist.dkhCapacity);
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"insertHist");
        }
    }

    private void setKey(PreparedStatement pStmt, DiskHistory hist) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"setKey", (String)"pStmt, hist");
        }
        this.setInt(pStmt, hist.dkhDiskID);
        this.setTimestamp(pStmt, hist.dkhTimestamp);
        this.setByte(pStmt, hist.dkhType);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"setKey");
        }
    }

    private void ageHist(DiskHistory hist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"ageHist", (String)"hist");
        }
        try {
            hist.dkhTimestamp = this.oldestDaily;
            hist.dkhType = 0;
            this.ageOff(hist);
            if (this.settings.seDiskWeeklyHist != 0) {
                hist.dkhTimestamp = this.oldestWeekly;
                hist.dkhType = 1;
                this.ageOff(hist);
            }
            if (this.settings.seDiskMonthlyHist != 0) {
                hist.dkhTimestamp = this.oldestMonthly;
                hist.dkhType = (byte)2;
                this.ageOff(hist);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDiskHist.class.getName(), (String)"ageHist", (Throwable)e);
            }
            this.stmtType = 3;
            MessageLog.logMessage((String)"STS0027E");
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"ageHist");
        }
    }

    private void ageOff(DiskHistory hist) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"ageOff", (String)"hist");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setKey(this.deleteStmt, hist);
        this.executeUpdate(this.deleteStmt);
        this.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"ageOff");
        }
    }

    public void deleteHist(Device devList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"deleteHist", (String)"devList");
        }
        try {
            this.deleteStmt = this.prepareStmt(DELETE_BY_DISK);
            Device device = devList;
            while (device != null) {
                if (device.isFixedDisk()) {
                    this.stmtPhase = 0;
                    this.colIndex = 1;
                    this.setInt(this.deleteStmt, device.devID);
                    this.executeUpdate(this.deleteStmt);
                    this.dbc.commit();
                }
                device = device.devNext;
            }
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDiskHist.class.getName(), (String)"deleteHist", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"deleteHist");
        }
    }

    public void prepSnapShots() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"prepSnapShots", (String)"");
        }
        this.insertStmt = this.prepareStmt(INSERT_HIST);
        this.selectStmt = this.prepareStmt("select disk_id, statistic_time, statistic_type, primary_defects, grown_defects, recovrd_wrt_errs, unrecovrd_wrt_errs, bytes_written, recovrd_rd_errs, unrecovrd_rd_errs, bytes_read, recovrd_vfy_errs, unrecovrd_vfy_errs, non_medium_errs, temperature, free_space, capacity from t_stat_disk_hist where statistic_type = '3' ");
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDiskHist.class.getName(), (String)"prepSnapShots", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"prepSnapShots");
        }
    }

    public void closeSnapShots() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"closeSnapShots", (String)"");
        }
        this.closeResultSet();
        this.closeSelect();
        this.closeInsert();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"closeSnapShots");
        }
    }

    public boolean fetchMostRecent(DiskHistory hist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"fetchMostRecent", (String)"hist");
        }
        boolean status = false;
        try {
            status = this.nextResult();
            if (status) {
                this.getHistory(hist);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDiskHist.class.getName(), (String)"fetchMostRecent", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        boolean traceResult = status;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"fetchMostRecent", (boolean)traceResult);
        }
        return traceResult;
    }

    public void prepFetchMostRecentByDiskID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"prepFetchMostRecentByDiskID", (String)"");
        }
        StringBuffer sb = new StringBuffer(1000);
        sb = sb.append(FETCH);
        sb = sb.append(MOST_RECENT);
        sb = sb.append(" and ");
        sb = sb.append(BY_ID);
        this.selectStmt = this.prepareStmt(sb.toString());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"prepFetchMostRecentByDiskID");
        }
    }

    public void prepFetchAllByDiskID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"prepFetchAllByDiskID", (String)"");
        }
        StringBuffer sb = new StringBuffer(1000);
        sb = sb.append(FETCH);
        sb = sb.append(BY_ID);
        sb = sb.append(ORDER_BY_TIME);
        this.selectStmt = this.prepareStmt(sb.toString());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"prepFetchAllByDiskID");
        }
    }

    public DiskHistory fetchByDiskID(int diskID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"fetchByDiskID", (String)"diskID");
        }
        DiskHistory dkhList = null;
        DiskHistory dkh = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, diskID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                dkh = new DiskHistory();
                this.getHistory(dkh);
                dkh.dkhNext = dkhList;
                dkhList = dkh;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDiskHist.class.getName(), (String)"fetchByDiskID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        DiskHistory traceResult = dkhList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"fetchByDiskID", traceResult);
        }
        return traceResult;
    }

    private void getHistory(DiskHistory hist) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"getHistory", (String)"hist");
        }
        this.stmtPhase = 1;
        this.colIndex = 1;
        hist.dkhDiskID = this.getInt(this.resultSet);
        hist.dkhTimestamp = this.getTimestamp(this.resultSet);
        hist.dkhType = this.getByte(this.resultSet);
        hist.dkhPrimaryDefects = this.getInt(this.resultSet);
        hist.dkhGrownDefects = this.getInt(this.resultSet);
        hist.dkhRecoveredWriteErrors = this.getInt(this.resultSet);
        hist.dkhUnrecoveredWriteErrors = this.getInt(this.resultSet);
        hist.dkhBytesWritten = (long)this.getDouble(this.resultSet);
        hist.dkhRecoveredReadErrors = this.getInt(this.resultSet);
        hist.dkhUnrecoveredReadErrors = this.getInt(this.resultSet);
        hist.dkhBytesRead = (long)this.getDouble(this.resultSet);
        hist.dkhRecoveredVerifyErrors = this.getInt(this.resultSet);
        hist.dkhUnrecoveredVerifyErrors = this.getInt(this.resultSet);
        hist.dkhNonMediumErrors = this.getInt(this.resultSet);
        hist.dkhTemperature = this.getShort(this.resultSet);
        hist.dkhFreeSpace = this.getLong(this.resultSet);
        hist.dkhCapacity = this.getLong(this.resultSet);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"getHistory");
        }
    }

    public void aggregateHist(Settings settings, long runTime) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"aggregateHist", (String)"settings, runTime");
        }
        this.prepSaveHist(settings, runTime);
        DiskHistory hist = new DiskHistory();
        hist.dkhPrimaryDefects = -1;
        hist.dkhGrownDefects = -1;
        hist.dkhRecoveredWriteErrors = -1;
        hist.dkhUnrecoveredWriteErrors = -1;
        hist.dkhBytesWritten = -1L;
        hist.dkhRecoveredReadErrors = -1;
        hist.dkhUnrecoveredReadErrors = -1;
        hist.dkhBytesRead = -1L;
        hist.dkhRecoveredVerifyErrors = -1;
        hist.dkhUnrecoveredVerifyErrors = -1;
        hist.dkhNonMediumErrors = -1;
        hist.dkhTemperature = (short)-274;
        this.aggregate(AGGREGATE_BY_COMPUTER, hist, runTime, true);
        this.aggregate(AGGREGATE_BY_COMPUTER_GROUP, hist, runTime, true);
        this.aggregate(AGGREGATE_BY_DOMAIN, hist, runTime, true);
        hist.dkhDiskID = -3;
        this.aggregate(AGGREGATE_BY_NETWORK, hist, runTime, false);
        this.closeSaveHist();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"aggregateHist");
        }
    }

    private void aggregate(String sqlText, DiskHistory hist, long runTime, boolean fetchID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"aggregate", (String)"sqlText, hist, runTime, fetchID");
        }
        this.selectStmt = this.prepareStmt(sqlText);
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                if (fetchID) {
                    hist.dkhDiskID = this.getInt(this.resultSet);
                }
                hist.dkhFreeSpace = this.getLong(this.resultSet);
                hist.dkhCapacity = this.getLong(this.resultSet);
                hist.dkhTimestamp = runTime;
                hist.dkhType = (byte)3;
                this.resetCurrentToDaily(hist);
                this.insertHist(hist);
                this.ageHist(hist);
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDiskHist.class.getName(), (String)"aggregate", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"aggregate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDiskFreeSpace(String selectDisks) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"setDiskFreeSpace", (String)"ids, selectDisks");
        }
        PreparedStatement disksStmt = null;
        Statement updateDisksStmt = null;
        ResultSet disksRS = null;
        int disk_id = -1;
        long capacity = 0L;
        long allocatedSpace = 0L;
        long freespace = 0L;
        try {
            disksStmt = this.dbc.prepareStatement(selectDisks);
            updateDisksStmt = this.dbc.prepareStatement(UPDATE_DISK_FREE_SPACE);
            disksRS = disksStmt.executeQuery();
            while (disksRS.next()) {
                disk_id = disksRS.getInt(1);
                capacity = disksRS.getLong(2);
                allocatedSpace = this.getAllocatedDiskSpace(disk_id);
                DiskHistory dh = new DiskHistory();
                dh.dkhDiskID = disk_id;
                this.ageHist(dh);
                if (capacity >= allocatedSpace) {
                    freespace = capacity - allocatedSpace;
                }
                if (TraceLogger.enableTrace) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("disk_id: " + disk_id);
                    buf.append("   capacity: " + capacity);
                    buf.append("   allocatedSpace: " + allocatedSpace);
                    buf.append("   free space: " + freespace);
                    TraceLogger.traceMessage((int)3, (String)TStatDiskHist.class.getName(), (String)"setDiskFreeSpace", (String)buf.toString());
                }
                updateDisksStmt.setLong(1, freespace);
                updateDisksStmt.setInt(2, disk_id);
                updateDisksStmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDiskHist.class.getName(), (String)"setDiskFreeSpace", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        finally {
            try {
                if (disksStmt != null) {
                    disksStmt.close();
                }
                if (updateDisksStmt != null) {
                    updateDisksStmt.close();
                }
                if (disksRS != null) {
                    disksRS.close();
                }
            }
            catch (SQLException sqle) {}
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"setDiskFreeSpace");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getAllocatedDiskSpace(int disk_id) throws GeneralException {
        long allocatedSpace = 0L;
        Statement allocatedSpaceStmt = null;
        ResultSet rs = null;
        int ssType = -1;
        boolean diskIDSubQuery = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDiskHist.class.getName(), (String)"getAllocatedDiskSpace", (String)"disk_id, selectAllocatedSpace");
        }
        try {
            String selectAllocatedSpace = null;
            TResDevice devAccessor = new TResDevice(this.dbc);
            ssType = devAccessor.getStorageSubsystemTypeForDisk(disk_id);
            switch (ssType) {
                case 21: {
                    selectAllocatedSpace = SELECT_SVC_ALLOCATED_MDISK_SPACE;
                    break;
                }
                case 15: {
                    selectAllocatedSpace = SELECT_FASTT_ALLOCATED_DISK_SPACE;
                    break;
                }
                default: {
                    selectAllocatedSpace = SELECT_SS_ALLOCATED_DISK_SPACE;
                    diskIDSubQuery = true;
                }
            }
            allocatedSpaceStmt = this.dbc.prepareStatement(selectAllocatedSpace);
            allocatedSpaceStmt.setInt(1, disk_id);
            if (diskIDSubQuery) {
                allocatedSpaceStmt.setInt(2, disk_id);
            }
            if ((rs = allocatedSpaceStmt.executeQuery()).next()) {
                allocatedSpace = rs.getLong(1);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDiskHist.class.getName(), (String)"getAllocatedDiskSpace", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        finally {
            try {
                if (allocatedSpaceStmt != null) {
                    allocatedSpaceStmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqle) {}
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDiskHist.class.getName(), (String)"getAllocatedDiskSpace", (long)allocatedSpace);
        }
        return allocatedSpace;
    }
}

