/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.aperi.TStorm.common.FoundComputer;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.UnmanagedCompHndlr;
import org.eclipse.aperi.repository.report.RptDiskCapacity;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.guireq.DashTotalsRow;

public class TStatTotals
extends RepositoryAccessor {
    private static final String TOTALS_LOCK = "TOTALLER";
    private static String SELECT_FILESYSTEM_STATS = "select sum(capacity), sum(used_space), sum(free_space), sum(directory_count), sum(file_count) from t_res_filesystem";
    private static String SELECT_FILESYSTEM_COUNT = "select count(*) from t_res_filesystem";
    private static String SELECT_MANAGED_COMPUTER_COUNT = "select count(*) from t_stat_computer s where " + TStatComputer.EXCLUDE_UNMANAGED_OSTYPES;
    private static String SELECT_DISK_COUNT = "select count(*) from t_stat_disk";
    private static String SELECT_SS_COUNT = "select count(distinct (ss.subsystem_id))  from t_res_storage_subsystem ss, t_res_storage_volume sv  where ss.subsystem_id = sv.subsystem_id";
    private static String SELECT_SS_STATS = " select count(svid), sum(distinct(allocated_capacity)) from  t_res_storage_subsystem ss, t_res_storage_volume sv  where sv.subsystem_id = ss.subsystem_id ";
    private static String SELECT_SS_USABLE_LUN_CAP = " select sum(capacity)  from  t_res_storage_volume sv, t_res_storage_subsystem ss  where   sv.subsystem_id = ss.subsystem_id  and snap_source_id < 0  and is_vcmdb = '0'  and replication_mode <> '" + Integer.toString(2) + "'";
    private static String ACTIVE_ALERT = "'0'";
    private static String SELECT_ALL_ALERT_COUNT = "select count(*) from t_alert_log where (state = " + ACTIVE_ALERT + " and product_id = " + 0 + ") or (product_id = " + 3 + " and state = " + ACTIVE_ALERT + ")";
    private static String SELECT_COMPUTER_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " and resource_type = " + 1;
    private static String SELECT_HARD_DISK_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " and resource_type = " + 10;
    private static String SELECT_FILESYSTEM_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " and resource_type = " + 3;
    private static String SELECT_STORAGE_SUBSYTEM_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 3 + " and resource_type = " + 78;
    private static String SELECT_SWITCH_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " and resource_type = " + 121;
    private static String SELECT_FABRIC_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " and resource_type = " + 114;
    private static String SELECT_TAPE_LIBRARY_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " and resource_type = " + 134;
    private static String SELECT_ENDPOINT_DEVICE_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " and (resource_type = " + 129 + " or resource_type = " + 138 + " or resource_type = " + 137 + " or resource_type = " + 139 + ")";
    private static String SELECT_EXTERNAL_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " and resource_type = " + 128;
    private static String SELECT_USER_ALERT_COUNT = "select notify_user, count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " group by notify_user";
    private static String SELECT_COMPUTER_TYPES = "select os_type, count(*) from t_stat_computer group by os_type";
    private static String SELECT_FS_CAPACITY_BY_OSTYPE = "select c.os_type, sum(f.capacity) from t_res_share s, t_stat_computer c, t_res_filesystem f where s.resource_type = 3 and s.computer_id = c.computer_id and s.resource_id = f.filesystem_id group by c.os_type";
    private static String SELECT_DISK_CAPACITY_BY_OSTYPE = "select c.os_type, d.disk_id, d.capacity, s.removed_time from t_res_share s, t_stat_computer c, t_stat_disk d where s.resource_type = 10 and s.computer_id = c.computer_id and s.resource_id = d.disk_id order by c.os_type, d.disk_id";
    private static String SELECT_FILESYSTEM_PERCENTS = "select (f.free_space * 100) / (f.free_space + f.used_space), f.capacity, c.host_name, f.mount_point from t_res_filesystem f, t_res_host c where (f.free_space > 0 or f.used_space > 0) and f.computer_id = c.computer_id order by 1";
    private static String DELETE = "delete from t_stat_totals";
    private static String INSERT = "insert into t_stat_totals (statistic_type, update_time, fs_capacity, used_space, free_space, disk_capacity, disk_unallocated, total_directories, total_files, total_filesystems, total_agents, total_computers, total_users, total_disks, all_alerts, computer_alerts, hard_disk_alerts, filesystem_alerts, directory_alerts, user_quota_alerts, grp_quota_alerts, user_alerts, computer_type, user_name, filesystem_name, total_ss, total_luns, lun_capacity, usable_lun_cap, ss_alerts, switch_alerts, fabric_alerts, endpt_alerts, tape_lib_alerts, external_alerts) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static String SELECT = "select statistic_type, user_name, user_alerts, filesystem_name, used_space, fs_capacity, free_space, computer_type, total_computers, disk_capacity, update_time, disk_unallocated, total_directories, total_files, total_filesystems, total_agents, total_users, total_disks, all_alerts, computer_alerts, hard_disk_alerts, filesystem_alerts, directory_alerts, user_quota_alerts, grp_quota_alerts, total_ss, total_luns, lun_capacity, usable_lun_cap, ss_alerts, switch_alerts, fabric_alerts, endpt_alerts, tape_lib_alerts, external_alerts from t_stat_totals";
    private static String DECOMMSELECT = "SELECT host_name, host_url, network_name, os_type from t_res_host";
    private int deComAgents = 0;
    private int agentCount = 0;
    private int decomTemp = 0;

    public TStatTotals(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatTotals.class.getName(), (String)"TStatTotals", (String)"dbc");
        }
        this.tableName = "t_stat_totals";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatTotals.class.getName(), (String)"TStatTotals");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DashTotalsRow aggregate(String userID) throws GeneralException {
        DashTotalsRow node;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatTotals.class.getName(), (String)"aggregate", (String)"userID");
        }
        DashTotalsRow totalsRow = new DashTotalsRow();
        totalsRow.dtrNext = null;
        totalsRow.dtrStatisticType = 1;
        try {
            totalsRow.dtrUpdateTime = SQLUtil.getTimestamp(this.dbc).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatTotals.class.getName(), (String)"aggregator", (Throwable)e);
            }
            return null;
        }
        boolean OK = false;
        try {
            long capacity;
            short osType;
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(SELECT_FILESYSTEM_STATS);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrFilesystemCapacity = this.getLong(this.resultSet);
                totalsRow.dtrUsedSpace = this.getLong(this.resultSet);
                totalsRow.dtrFreeSpace = this.getLong(this.resultSet);
                totalsRow.dtrTotalDirectories = this.getInt(this.resultSet);
                totalsRow.dtrTotalFiles = this.getInt(this.resultSet);
            }
            RespFSspace fsNode = new RespFSspace();
            RptDiskCapacity diskAccessor = new RptDiskCapacity(this.dbc);
            diskAccessor.getNetworkValues(fsNode);
            totalsRow.dtrDiskCapacity = fsNode.capacity;
            totalsRow.dtrDiskUnallocated = fsNode.unallocated;
            this.resultSet = this.staticStmt.executeQuery(SELECT_FILESYSTEM_COUNT);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrTotalFilesystems = this.getInt(this.resultSet);
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_MANAGED_COMPUTER_COUNT);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrTotalAgents = this.getInt(this.resultSet);
            }
            totalsRow.dtrTotalAgents -= this.getDecommAgentCount();
            UnmanagedCompHndlr foundAccessor = new UnmanagedCompHndlr(this.dbc);
            FoundComputer[] array = foundAccessor.getUnmanaged();
            totalsRow.dtrTotalComputers = array.length;
            this.resultSet = this.staticStmt.executeQuery(SELECT_SS_COUNT);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrTotalStorageSubsystems = this.getInt(this.resultSet);
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_SS_STATS);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrTotalLUNs = this.getInt(this.resultSet);
                totalsRow.dtrLunCapacity = this.getLong(this.resultSet);
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_SS_USABLE_LUN_CAP);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrUsableLunCap = this.getLong(this.resultSet);
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_DISK_COUNT);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrTotalDisks = this.getInt(this.resultSet);
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_ALL_ALERT_COUNT);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrAllAlerts = this.getInt(this.resultSet);
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_COMPUTER_ALERT_COUNT);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrComputerAlerts = this.getInt(this.resultSet);
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_HARD_DISK_ALERT_COUNT);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrHardDiskAlerts = this.getInt(this.resultSet);
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_STORAGE_SUBSYTEM_ALERT_COUNT);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrStorageSubsystemAlerts = this.getInt(this.resultSet);
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_SWITCH_ALERT_COUNT);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrSwitchAlerts = this.getInt(this.resultSet);
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_FABRIC_ALERT_COUNT);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrFabricAlerts = this.getInt(this.resultSet);
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_ENDPOINT_DEVICE_ALERT_COUNT);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrEndpointDeviceAlerts = this.getInt(this.resultSet);
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_TAPE_LIBRARY_ALERT_COUNT);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrTapeLibraryAlerts = this.getInt(this.resultSet);
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_EXTERNAL_ALERT_COUNT);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrExternalAlerts = this.getInt(this.resultSet);
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_FILESYSTEM_ALERT_COUNT);
            if (this.nextResult()) {
                this.getPhase();
                totalsRow.dtrFilesystemAlerts = this.getInt(this.resultSet);
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_USER_ALERT_COUNT);
            while (this.nextResult()) {
                node = new DashTotalsRow();
                node.dtrStatisticType = (short)2;
                this.getPhase();
                node.dtrUserName = this.getString(this.resultSet);
                node.dtrUserAlerts = this.getInt(this.resultSet);
                if (node.dtrUserName.equals(userID)) {
                    totalsRow.dtrUserAlerts = node.dtrUserAlerts;
                }
                node.dtrNext = totalsRow.dtrNext;
                totalsRow.dtrNext = node;
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_COMPUTER_TYPES);
            while (this.nextResult()) {
                node = new DashTotalsRow();
                node.dtrStatisticType = (short)5;
                this.getPhase();
                node.dtrComputerType = this.getShort(this.resultSet);
                node.dtrTotalComputers = this.getInt(this.resultSet);
                node.dtrNext = totalsRow.dtrNext;
                totalsRow.dtrNext = node;
            }
            this.resultSet = this.staticStmt.executeQuery(SELECT_FS_CAPACITY_BY_OSTYPE);
            block11: while (this.nextResult()) {
                this.getPhase();
                osType = this.getShort(this.resultSet);
                capacity = this.getLong(this.resultSet);
                node = totalsRow.dtrNext;
                while (node != null) {
                    if (node.dtrStatisticType == 5 && node.dtrComputerType == osType) {
                        node.dtrFilesystemCapacity = capacity;
                        continue block11;
                    }
                    node = node.dtrNext;
                }
            }
            short prevOsType = -777;
            int prevDiskID = -777;
            long totalCapacity = 0L;
            this.resultSet = this.staticStmt.executeQuery(SELECT_DISK_CAPACITY_BY_OSTYPE);
            while (this.nextResult()) {
                this.getPhase();
                osType = this.getShort(this.resultSet);
                int diskID = this.getInt(this.resultSet);
                capacity = this.getLong(this.resultSet);
                long removedTime = this.getTimestamp(this.resultSet);
                if (osType != prevOsType) {
                    this.updateDiskCapacity(totalsRow.dtrNext, prevOsType, totalCapacity);
                    prevOsType = osType;
                    prevDiskID = -777;
                    totalCapacity = 0L;
                }
                if (diskID == prevDiskID) continue;
                if (removedTime < 86400000L) {
                    totalCapacity += capacity;
                }
                prevDiskID = diskID;
            }
            this.updateDiskCapacity(totalsRow.dtrNext, prevOsType, totalCapacity);
            this.resultSet = this.staticStmt.executeQuery(SELECT_FILESYSTEM_PERCENTS);
            for (int fsCount = 0; this.nextResult() && fsCount < 10; ++fsCount) {
                node = new DashTotalsRow();
                node.dtrStatisticType = (short)4;
                this.getPhase();
                node.dtrFreeSpace = this.getLong(this.resultSet);
                node.dtrFilesystemCapacity = this.getLong(this.resultSet);
                node.dtrFilesystemName = this.getString(this.resultSet) + "." + this.getString(this.resultSet);
                node.dtrNext = totalsRow.dtrNext;
                totalsRow.dtrNext = node;
            }
            OK = true;
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatTotals.class.getName(), (String)"aggregate", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (OK) {
            try {
                boolean gotLock = LockManager.lock((short)0, (String)TOTALS_LOCK, (String)TOTALS_LOCK, (byte)1, (boolean)false);
                if (gotLock) {
                    this.staticStmt = this.createStatement();
                    this.staticStmt.executeUpdate(DELETE);
                    this.closeStaticStmt();
                    this.insertStmt = this.prepareStmt(INSERT);
                    node = totalsRow;
                    while (node != null) {
                        this.insert(node);
                        node = node.dtrNext;
                    }
                    this.insertStmt.close();
                    this.dbc.commit();
                } else {
                    LockManager.lock((short)0, (String)TOTALS_LOCK, (String)TOTALS_LOCK, (byte)1, (boolean)true);
                    totalsRow = this.select(userID);
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TStatTotals.class.getName(), (String)"aggregate", (Throwable)e);
                }
                this.sqlError(e);
            }
            finally {
                LockManager.unLock((short)0, (String)TOTALS_LOCK, (String)TOTALS_LOCK);
            }
            this.getAgentsDown(totalsRow);
        }
        DashTotalsRow traceResult = totalsRow;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatTotals.class.getName(), (String)"aggregate", (Object)traceResult);
        }
        return traceResult;
    }

    private void updateDiskCapacity(DashTotalsRow node, int osType, long capacity) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatTotals.class.getName(), (String)"updateDiskCapacity", (String)"node, osType, capacity");
        }
        while (node != null) {
            if (node.dtrStatisticType == 5 && node.dtrComputerType == osType) {
                node.dtrDiskCapacity = capacity;
                break;
            }
            node = node.dtrNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatTotals.class.getName(), (String)"updateDiskCapacity");
        }
    }

    private void insert(DashTotalsRow totalsRow) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatTotals.class.getName(), (String)"insert", (String)"totalsRow");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setShort(this.insertStmt, totalsRow.dtrStatisticType);
            this.setTimestamp(this.insertStmt, totalsRow.dtrUpdateTime);
            this.setLong(this.insertStmt, totalsRow.dtrFilesystemCapacity);
            this.setLong(this.insertStmt, totalsRow.dtrUsedSpace);
            this.setLong(this.insertStmt, totalsRow.dtrFreeSpace);
            this.setLong(this.insertStmt, totalsRow.dtrDiskCapacity);
            this.setLong(this.insertStmt, totalsRow.dtrDiskUnallocated);
            this.setInt(this.insertStmt, totalsRow.dtrTotalDirectories);
            this.setInt(this.insertStmt, totalsRow.dtrTotalFiles);
            this.setInt(this.insertStmt, totalsRow.dtrTotalFilesystems);
            this.setInt(this.insertStmt, totalsRow.dtrTotalAgents);
            this.setInt(this.insertStmt, totalsRow.dtrTotalComputers);
            this.setInt(this.insertStmt, totalsRow.dtrTotalUsers);
            this.setInt(this.insertStmt, totalsRow.dtrTotalDisks);
            this.setInt(this.insertStmt, totalsRow.dtrAllAlerts);
            this.setInt(this.insertStmt, totalsRow.dtrComputerAlerts);
            this.setInt(this.insertStmt, totalsRow.dtrHardDiskAlerts);
            this.setInt(this.insertStmt, totalsRow.dtrFilesystemAlerts);
            this.setInt(this.insertStmt, totalsRow.dtrDirectoryAlerts);
            this.setInt(this.insertStmt, totalsRow.dtrUserQuotaAlerts);
            this.setInt(this.insertStmt, totalsRow.dtrGroupQuotaAlerts);
            this.setInt(this.insertStmt, totalsRow.dtrUserAlerts);
            this.setShort(this.insertStmt, totalsRow.dtrComputerType);
            this.setString(this.insertStmt, totalsRow.dtrUserName);
            this.setString(this.insertStmt, totalsRow.dtrFilesystemName);
            this.setInt(this.insertStmt, totalsRow.dtrTotalStorageSubsystems);
            this.setInt(this.insertStmt, totalsRow.dtrTotalLUNs);
            this.setLong(this.insertStmt, totalsRow.dtrLunCapacity);
            this.setLong(this.insertStmt, totalsRow.dtrUsableLunCap);
            this.setInt(this.insertStmt, totalsRow.dtrStorageSubsystemAlerts);
            this.setInt(this.insertStmt, totalsRow.dtrSwitchAlerts);
            this.setInt(this.insertStmt, totalsRow.dtrFabricAlerts);
            this.setInt(this.insertStmt, totalsRow.dtrEndpointDeviceAlerts);
            this.setInt(this.insertStmt, totalsRow.dtrTapeLibraryAlerts);
            this.setInt(this.insertStmt, totalsRow.dtrExternalAlerts);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatTotals.class.getName(), (String)"insert", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatTotals.class.getName(), (String)"insert");
        }
    }

    public DashTotalsRow select(String userID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatTotals.class.getName(), (String)"select", (String)"userID");
        }
        int userAlerts = 0;
        DashTotalsRow totalsRow = null;
        DashTotalsRow head = null;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(SELECT);
            while (this.nextResult()) {
                this.getPhase();
                short statisticType = this.getShort(this.resultSet);
                String userName = this.getString(this.resultSet);
                int workAlerts = this.getInt(this.resultSet);
                if (statisticType == 2) {
                    if (userName != userID) continue;
                    userAlerts = workAlerts;
                    continue;
                }
                DashTotalsRow node = new DashTotalsRow();
                node.dtrStatisticType = statisticType;
                node.dtrUserName = userName;
                node.dtrFilesystemName = this.getString(this.resultSet);
                node.dtrUsedSpace = this.getLong(this.resultSet);
                node.dtrFilesystemCapacity = this.getLong(this.resultSet);
                node.dtrFreeSpace = this.getLong(this.resultSet);
                node.dtrComputerType = this.getShort(this.resultSet);
                node.dtrTotalComputers = this.getInt(this.resultSet);
                node.dtrDiskCapacity = this.getLong(this.resultSet);
                if (statisticType != 1) {
                    node.dtrNext = head;
                    head = node;
                    continue;
                }
                totalsRow = node;
                totalsRow.dtrUpdateTime = this.getTimestamp(this.resultSet);
                totalsRow.dtrDiskUnallocated = this.getLong(this.resultSet);
                totalsRow.dtrTotalDirectories = this.getInt(this.resultSet);
                totalsRow.dtrTotalFiles = this.getInt(this.resultSet);
                totalsRow.dtrTotalFilesystems = this.getInt(this.resultSet);
                totalsRow.dtrTotalAgents = this.getInt(this.resultSet);
                totalsRow.dtrTotalUsers = this.getInt(this.resultSet);
                totalsRow.dtrTotalDisks = this.getInt(this.resultSet);
                totalsRow.dtrAllAlerts = this.getInt(this.resultSet);
                totalsRow.dtrComputerAlerts = this.getInt(this.resultSet);
                totalsRow.dtrHardDiskAlerts = this.getInt(this.resultSet);
                totalsRow.dtrFilesystemAlerts = this.getInt(this.resultSet);
                totalsRow.dtrDirectoryAlerts = this.getInt(this.resultSet);
                totalsRow.dtrUserQuotaAlerts = this.getInt(this.resultSet);
                totalsRow.dtrGroupQuotaAlerts = this.getInt(this.resultSet);
                totalsRow.dtrTotalStorageSubsystems = this.getInt(this.resultSet);
                totalsRow.dtrTotalLUNs = this.getInt(this.resultSet);
                totalsRow.dtrLunCapacity = this.getLong(this.resultSet);
                totalsRow.dtrUsableLunCap = this.getLong(this.resultSet);
                totalsRow.dtrStorageSubsystemAlerts = this.getInt(this.resultSet);
                totalsRow.dtrSwitchAlerts = this.getInt(this.resultSet);
                totalsRow.dtrFabricAlerts = this.getInt(this.resultSet);
                totalsRow.dtrEndpointDeviceAlerts = this.getInt(this.resultSet);
                totalsRow.dtrTapeLibraryAlerts = this.getInt(this.resultSet);
                totalsRow.dtrExternalAlerts = this.getInt(this.resultSet);
            }
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatTotals.class.getName(), (String)"select", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (totalsRow != null) {
            totalsRow.dtrNext = head;
            totalsRow.dtrUserAlerts = userAlerts;
            this.decomTemp = this.getDecommAgentCount();
            if (this.decomTemp > 0) {
                totalsRow.dtrTotalAgents = this.agentCount == totalsRow.dtrTotalAgents ? (totalsRow.dtrTotalAgents -= this.decomTemp) : this.agentCount - this.decomTemp;
            }
            this.getAgentsDown(totalsRow);
        }
        DashTotalsRow traceResult = totalsRow;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatTotals.class.getName(), (String)"select", traceResult);
        }
        return traceResult;
    }

    private void getAgentsDown(DashTotalsRow totalsRow) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatTotals.class.getName(), (String)"getAgentsDown", (String)"totalsRow");
        }
        totalsRow.dtrTotalAgentsDown = 0;
        Iterator i = Server.agentMgr.listAgents();
        while (i.hasNext()) {
            AgentManager.AgentAddress agent = (AgentManager.AgentAddress)i.next();
            if (agent.computerID <= 0 || agent.state != 0 && agent.state != 2 && (agent.state != 1 || agent.consecutiveErrors <= 0)) continue;
            ++totalsRow.dtrTotalAgentsDown;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatTotals.class.getName(), (String)"getAgentsDown");
        }
    }

    public int getDecommAgentCount() {
        block7: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)TStatTotals.class.getName(), (String)"getDecommAgentCount", (String)"");
            }
            try {
                this.staticStmt = this.createStatement();
                this.resultSet = this.staticStmt.executeQuery(DECOMMSELECT);
                while (this.nextResult()) {
                    this.getPhase();
                    String agentName = this.getString(this.resultSet);
                    String hostName = this.getString(this.resultSet);
                    String nwName = this.getString(this.resultSet);
                    int osType = this.getInt(this.resultSet);
                    if (agentName.startsWith("DECOMM-") && hostName.startsWith("DECOMM-") && nwName.startsWith("DECOMM-")) {
                        ++this.deComAgents;
                    }
                    if (osType > 7) continue;
                    ++this.agentCount;
                }
            }
            catch (SQLException sqle) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TStatTotals.class.getName(), (String)"getDecommAgentCount", (Throwable)sqle);
                }
            }
            catch (GeneralException e) {
                if (!TraceLogger.enableTrace) break block7;
                TraceLogger.exception((String)TStatTotals.class.getName(), (String)"getDecommAgentCount", (Throwable)e);
            }
        }
        return this.deComAgents;
    }
}

