/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.scheduler;

import java.sql.Connection;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.scheduler.SchScheduleNode;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScheduleAlerter {
    private Connection dbc;
    private AlertDefinition alertDef;
    private TAlertDefinition alertAccessor;
    private String[] alertParms;
    private StringBuffer buffer = new StringBuffer(65);
    private static final int SCHEDULE_NAME = 0;
    private static final int SCHEDULE_TYPE = 1;
    private static final int SCHEDULE_RUN = 2;
    private static final int ALERT_TYPE = 3;
    private static final int FAILED_JOBS = 4;
    private static final int TOTAL_JOBS = 5;
    private static final int KEY_COUNT = 6;
    private static final int[] SCHEDULE_NAME_OID = new int[]{3, 1, 1};
    private static final int[] SCHEDULE_TYPE_OID = new int[]{3, 1, 2};
    private static final int[] SCHEDULE_RUN_OID = new int[]{3, 1, 3};
    private static final String SCHEDULE_NAME_SLOT = "scheduleName";
    private static final String SCHEDULE_TYPE_SLOT = "scheduleType";
    private static final String SCHEDULE_RUN_SLOT = "scheduleRun";
    public static final int FAILED_JOB_TRAP = 20;
    public static final String FAILED_JOB_EVENT_CLASS = "JobFailure";
    public static final String FAILED_JOB_EVENT_MSG = MessageLog.getMessageNoID((String)"ALR1339W", null);
    public static final String FAILED_JOB_EVENT_MSG_ID = "ALR1339W";
    private static final String alertType = MessageLog.getMessageNoID((String)"ALR1040W");
    private static final int[][] snmpOIDs = new int[6][];
    private static final String[] tecSlotNames = new String[6];

    public ScheduleAlerter(Connection dbc) {
        ScheduleAlerter.snmpOIDs[1] = SCHEDULE_TYPE_OID;
        ScheduleAlerter.snmpOIDs[0] = SCHEDULE_NAME_OID;
        ScheduleAlerter.snmpOIDs[2] = SCHEDULE_RUN_OID;
        ScheduleAlerter.snmpOIDs[3] = Alerter.ALERT_TYPE_OID;
        ScheduleAlerter.tecSlotNames[1] = SCHEDULE_TYPE_SLOT;
        ScheduleAlerter.tecSlotNames[0] = SCHEDULE_NAME_SLOT;
        ScheduleAlerter.tecSlotNames[2] = SCHEDULE_RUN_SLOT;
        ScheduleAlerter.tecSlotNames[3] = "alertType";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleAlerter.class.getName(), (String)"ScheduleAlerter", (String)"dbc");
        }
        this.dbc = dbc;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleAlerter.class.getName(), (String)"ScheduleAlerter");
        }
    }

    public static String getTECEventMsg(int trapType) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleAlerter.class.getName(), (String)"getTECEventMsg", (String)"trapType");
        }
        String msg = "";
        switch (trapType) {
            case 20: {
                msg = MessageLog.getMessageNoID((String)FAILED_JOB_EVENT_MSG_ID, null);
            }
        }
        String traceResult = msg;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleAlerter.class.getName(), (String)"getTECEventMsg", (Object)traceResult);
        }
        return traceResult;
    }

    public void alert(SchScheduleNode schedule) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleAlerter.class.getName(), (String)"alert", (String)"schedule");
        }
        if (schedule.alertID <= 0) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ScheduleAlerter.class.getName(), (String)"alert");
            }
            return;
        }
        if (this.alertAccessor == null) {
            this.alertAccessor = new TAlertDefinition(this.dbc);
            this.alertAccessor.prepSelectByID(false, false);
        }
        this.alertDef = this.alertAccessor.getByID(schedule.alertID);
        if (this.alertDef == null || !this.alertDef.aldEnabled) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ScheduleAlerter.class.getName(), (String)"alert");
            }
            return;
        }
        short oldCondition = this.alertDef.aldCondition;
        switch (this.alertDef.aldCondition) {
            case 15: {
                this.alertDef.aldCondition = (short)25;
                break;
            }
            case 31: {
                this.alertDef.aldCondition = (short)26;
                break;
            }
            case 55: {
                this.alertDef.aldCondition = (short)54;
            }
        }
        if (oldCondition != this.alertDef.aldCondition) {
            this.alertDef.aldScriptComputerID = -1;
        }
        this.alertParms = new String[6];
        this.alertParms[3] = alertType;
        this.buffer.setLength(0);
        this.buffer.append(schedule.creator);
        this.buffer.append('.');
        this.buffer.append(schedule.getName());
        this.alertParms[0] = this.buffer.toString();
        this.alertParms[1] = ResourceTypeManager.getJobName((short)schedule.jobType);
        short resourceType = schedule.jobType;
        this.setNumParm(2, schedule.runNumber);
        this.setNumParm(4, schedule.numberRuns - schedule.successfulRuns);
        this.setNumParm(5, schedule.numberRuns);
        Alert alert = new Alert(-1, schedule.SID, resourceType, this.alertDef, this.alertParms, 20, snmpOIDs, tecSlotNames, -1, -1, schedule.runNumber, 33, 9, -1);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleAlerter.class.getName(), (String)"alert");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleAlerter.class.getName(), (String)"close", (String)"");
        }
        if (this.alertAccessor != null) {
            try {
                this.alertAccessor.closeSelect();
            }
            catch (GeneralException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ScheduleAlerter.class.getName(), (String)"close", (Throwable)e);
                }
            }
            finally {
                this.alertAccessor = null;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleAlerter.class.getName(), (String)"close");
        }
    }

    private void setNumParm(int parmKey, int value) {
        this.alertParms[parmKey] = Integer.toString(value);
    }
}

