/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.scheduler;

import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.scheduler.SchRunNode;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScheduleRunning {
    int index;
    private static final int ARRAYSIZE = 512;
    SchRunNode[] runningArray = new SchRunNode[512];

    public synchronized void addRun(SchRunNode runPtr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleRunning.class.getName(), (String)"addRun", (String)"runPtr");
        }
        this.index = runPtr.runNumber % 512;
        runPtr.overflowNext = this.runningArray[this.index];
        this.runningArray[this.index] = runPtr;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleRunning.class.getName(), (String)"addRun");
        }
    }

    public synchronized SchRunNode getRun(int runNum) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleRunning.class.getName(), (String)"getRun", (String)"runNum");
        }
        this.index = runNum % 512;
        SchRunNode runPtr = this.runningArray[this.index];
        if (runPtr != null) {
            if (runPtr.runNumber == runNum) {
                this.runningArray[this.index] = runPtr.overflowNext;
            } else {
                SchRunNode trailingRunPtr = runPtr;
                runPtr = runPtr.overflowNext;
                while (runPtr != null) {
                    if (runPtr.runNumber == runNum) {
                        trailingRunPtr.overflowNext = runPtr.overflowNext;
                        runPtr.overflowNext = null;
                        break;
                    }
                    trailingRunPtr = runPtr;
                    runPtr = runPtr.overflowNext;
                }
            }
        }
        SchRunNode traceResult = runPtr;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleRunning.class.getName(), (String)"getRun", (Object)traceResult);
        }
        return traceResult;
    }

    public synchronized void displayRuns() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleRunning.class.getName(), (String)"displayRuns", (String)"");
        }
        this.index = 0;
        while (this.index < this.runningArray.length) {
            SchRunNode runPtr = this.runningArray[this.index];
            if (runPtr != null) {
                MessageLog.logMessage((String)"JSS0024I", (Object)Integer.toString(runPtr.runNumber));
            }
            ++this.index;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleRunning.class.getName(), (String)"displayRuns");
        }
    }
}

