/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.scheduler;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.agent.req.RunReq;
import org.eclipse.aperi.agent.req.RunScriptReq;
import org.eclipse.aperi.backend.JobUtil;
import org.eclipse.aperi.backend.WindowsScript;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.jobs.JobUtils;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.scheduler.SchRunNode;
import org.eclipse.aperi.scheduler.SchScheduleNode;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.scheduler.ScheduleRunning;
import org.eclipse.aperi.scheduler.ScheduleSubmitted;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.ScriptSubmitter;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.VMTransceiver;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.server.svp.SchedulerSvp;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScheduleSubmit
extends TSThread {
    public ScheduleSubmit next;
    public boolean initialized;
    Connection connection;
    PreparedStatement runStmt;
    PreparedStatement nameStmt;
    public static PrintWriter logWriter;
    JobRun agentJobRun;
    Request agentRequest;
    Request scriptRequest;
    Response response;
    RunScriptReq scriptRun;
    AgentManager agentRoutine;
    ScheduleRunning runningRoutine;
    ScheduleSubmitted submittedRoutine;
    SchRunNode runPtr;
    SchScheduleNode schedulePtr;
    long delayLimit;
    long limitMillis;
    boolean checkingAgent;
    Object[] args = new Object[]{"update", "t_run_jobs", "ScheduleSubmit.run"};
    Object[] args2 = new Object[5];
    private String space = " ";

    public ScheduleSubmit(ThreadGroup group, String name) {
        super(group, name);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleSubmit.class.getName(), (String)"ScheduleSubmit", (String)"group, name");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleSubmit.class.getName(), (String)"ScheduleSubmit");
        }
    }

    public void run() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleSubmit.class.getName(), (String)"run", (String)"");
        }
        logWriter = MessageLog.getThreadLog();
        MessageLog.setThreadLog((PrintWriter)logWriter);
        this.connection = Server.getConnection();
        this.delayLimit = SchCommon.delayLimit;
        if (this.connection == null) {
            MessageLog.logMessage((String)"JSS0006E", (Object[])this.args);
            SchCommon.stopped = true;
        } else {
            this.agentRoutine = Server.getAgentManager();
            this.runningRoutine = SchCommon.runningRoutine;
            this.submittedRoutine = SchCommon.submittedRoutine;
            try {
                this.runStmt = this.connection.prepareStatement("update t_run_jobs                                                                   set    submit_status  = -1                                                          where  job_run_number = ?");
                this.nameStmt = this.connection.prepareStatement("update t_run_jobs                                                                   set    log_file_name  = ?                                                           where  job_run_number = ?");
            }
            catch (SQLException e1) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ScheduleSubmit.class.getName(), (String)"run", (Throwable)e1);
                }
                String msg = SQLUtil.getSQLExceptionMsg("JSS0007E", e1, this.args);
                logWriter.println(msg);
                SchCommon.stopped = true;
            }
            this.initialized = true;
            this.agentJobRun = new JobRun();
            this.agentRequest = new Request();
            this.agentRequest.typeCode = "org.eclipse.aperi.agent.svp.AgentSvp";
            this.agentRequest.subType = "org.eclipse.aperi.agent.handler.job.JavaJobHandler";
            this.agentRequest.serviceName = RequestTypeManager.getInternalName((String)"org.eclipse.aperi.agent.svp.AgentSvp");
            this.agentRequest.requestData = this.agentJobRun;
            this.scriptRun = new RunScriptReq();
            this.scriptRequest = new Request();
            this.scriptRequest.typeCode = "org.eclipse.aperi.agent.svp.AgentSvp";
            this.scriptRequest.subType = "org.eclipse.aperi.agent.handler.script.ScriptHandlerFactory";
            this.scriptRequest.serviceName = RequestTypeManager.getInternalName((String)"org.eclipse.aperi.agent.svp.AgentSvp");
            this.scriptRequest.requestData = this.scriptRun;
            this.args[0] = "insert";
            this.args[2] = "ScheduleSubmit.insertRun";
            while (!SchCommon.stopped) {
                this.runPtr = null;
                while (this.runPtr == null && !SchCommon.stopped) {
                    this.runPtr = this.submittedRoutine.getNext(this.connection);
                    if (this.runPtr != null) continue;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.exception((String)ScheduleSubmit.class.getName(), (String)"run", (Throwable)e);
                    }
                }
                if (SchCommon.stopped) continue;
                this.schedulePtr = this.runPtr.back;
                boolean internalJob = ScheduleQueue.isInternal(this.schedulePtr.SID);
                boolean ok = internalJob ? true : this.insertRun();
                if (!ok) {
                    this.cancelRun("JSS0011E");
                    continue;
                }
                try {
                    this.limitMillis = SQLUtil.getTimestamp(this.connection).getTime() - this.delayLimit;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)ScheduleSubmit.class.getName(), (String)"run", (Throwable)e);
                    }
                    return;
                }
                if (this.runPtr.submitMillis < this.limitMillis && this.runPtr.submitMillis > 0L) {
                    this.runPtr.returnCode = 20;
                    this.cancelRun("JSS0012E");
                    continue;
                }
                this.checkingAgent = true;
                ConfigSettings settings = Server.getSettings();
                if (this.schedulePtr.jobType == 67) {
                    AgentManager.AgentAddress agent = Server.agentMgr.getAgent(this.runPtr.CID);
                    if (agent == null) {
                        this.runPtr.returnCode = 34;
                        this.cancelRun("JSS0046E");
                    } else {
                        this.scriptRun.setComputerID(this.runPtr.CID);
                        this.scriptRun.setRunNumber(this.runPtr.runNumber);
                        this.scriptRun.setSchedCreator(this.schedulePtr.creator);
                        this.scriptRun.setSchedName(this.schedulePtr.getTrueName());
                        this.scriptRun.setSchedRunNumber(this.schedulePtr.runNumber);
                        this.scriptRun.setJobName("script");
                        this.scriptRun.setRetention(settings.csRetainCopies);
                        this.scriptRun.setRetainDays(settings.csRetainDays);
                        this.scriptRun.scrArgv = new String[1];
                        this.scriptRun.scrArgv[0] = this.schedulePtr.scriptName;
                        StringBuffer buffer = new StringBuffer(120);
                        String file = null;
                        if (Constants.isWindows((short)agent.osType)) {
                            WindowsScript ws = JobUtil.resolveWindowsScript((String)this.schedulePtr.scriptName, (StringBuffer)buffer);
                            if (ws != null) {
                                if (buffer.length() > 0) {
                                    this.scriptRun.scrExtension = buffer.toString();
                                }
                                buffer.setLength(0);
                                buffer.append(JobUtil.scriptsDir);
                                buffer.append(File.separatorChar);
                                buffer.append(ws.wsResolvedName);
                                file = buffer.toString();
                            }
                        } else {
                            buffer.append(JobUtil.scriptsDir);
                            buffer.append(File.separatorChar);
                            if (JobUtil.resolveUnixScript((String)this.schedulePtr.scriptName, (StringBuffer)buffer) != null) {
                                file = buffer.toString();
                            }
                        }
                        this.scriptRun.scrData = new byte[1][];
                        MutableBoolean good = new MutableBoolean(true);
                        if (file != null) {
                            this.scriptRun.scrData[0] = ScriptSubmitter.loadFile(file, good);
                        }
                        if (!good.value) {
                            this.cancelRun("JSS0073E");
                        } else {
                            this.response = Server.agentMgr.transmitToAgent(this.scriptRequest, null, this.runPtr.CID, false);
                            if (this.response != null && this.response.status <= 4) {
                                this.runPtr.logFileName = JobUtils.generateLogFileName((RunReq)this.scriptRun, null);
                                SchCommon.completeHdr.process(this.runPtr, null);
                                this.checkingAgent = false;
                            }
                        }
                    }
                } else {
                    this.runningRoutine.addRun(this.runPtr);
                    String agentJobName = ResourceTypeManager.getAgentJobRunName((short)this.schedulePtr.jobType);
                    if (agentJobName != null && this.runPtr.CID != -999999998 && this.runPtr.CID != -999999997 && this.runPtr.CID != -999999999) {
                        this.agentRequest.subType = "org.eclipse.aperi.agent.handler.job.JavaJobHandler";
                        this.agentJobRun.setRunNumber(this.runPtr.runNumber);
                        this.agentJobRun.setRetention(settings.csRetainCopies);
                        this.agentJobRun.setRetainDays(settings.csRetainDays);
                        this.agentJobRun.setSchedCreator(this.schedulePtr.creator);
                        this.agentJobRun.setSchedName(this.schedulePtr.getTrueName());
                        this.agentJobRun.setSchedID(this.schedulePtr.SID);
                        this.agentJobRun.setSchedRunNumber(this.schedulePtr.runNumber);
                        this.agentJobRun.setJobName(agentJobName);
                        this.agentJobRun.setCommandLine(ResourceTypeManager.getAgentJobRunCommand((short)this.schedulePtr.jobType));
                        if (this.runPtr.globalJob) {
                            this.agentJobRun.setDesiredStartTime(0L);
                        } else {
                            this.agentJobRun.setDesiredStartTime(this.runPtr.submitMillis);
                        }
                        this.response = this.agentRoutine.transmitToAgent(this.agentRequest, null, this.runPtr.CID, false);
                    } else {
                        Serializable rd;
                        Request serverRequest = this.schedulePtr.request;
                        if (serverRequest == null) {
                            JobRun stormJobRun = new JobRun();
                            stormJobRun.setComputerList(this.schedulePtr.pingList);
                            stormJobRun.setRunNumber(this.runPtr.runNumber);
                            stormJobRun.setRetention(settings.csRetainCopies);
                            stormJobRun.setRetainDays(settings.csRetainDays);
                            stormJobRun.setSchedCreator(this.schedulePtr.creator);
                            stormJobRun.setSchedName(this.schedulePtr.getTrueName());
                            stormJobRun.setSchedID(this.schedulePtr.SID);
                            stormJobRun.setSchedRunNumber(this.schedulePtr.runNumber);
                            serverRequest = new Request();
                            serverRequest.typeCode = ResourceTypeManager.getServerJobRunRequestCode((short)this.schedulePtr.jobType);
                            serverRequest.subType = ResourceTypeManager.getServerJobRunHandlerCode((short)this.schedulePtr.jobType);
                            serverRequest.serviceName = RequestTypeManager.getInternalName((String)serverRequest.typeCode);
                            serverRequest.requestData = stormJobRun;
                            if (this.schedulePtr.jobType == 16) {
                                if (this.runPtr.CID == -999999998) {
                                    stormJobRun.setJobName("probe_fabric");
                                    stormJobRun.setCommandLine("org.eclipse.aperi.server.jobs.ExecProbeFabric");
                                } else if (this.runPtr.CID == -999999997) {
                                    stormJobRun.setJobName("probe_tape");
                                    stormJobRun.setCommandLine("org.eclipse.aperi.server.jobs.ExecProbeTape");
                                } else {
                                    stormJobRun.setJobName("probe_ss");
                                    stormJobRun.setCommandLine("org.eclipse.aperi.server.jobs.ExecProbeSS");
                                }
                            } else {
                                stormJobRun.setJobName(ResourceTypeManager.getServerJobRunName((short)this.schedulePtr.jobType));
                                String commandLine = ResourceTypeManager.getServerJobRunCommand((short)this.schedulePtr.jobType);
                                commandLine = commandLine + this.space + this.schedulePtr.arguments;
                                if (this.schedulePtr.jobType == 17) {
                                    commandLine = commandLine + this.space + Integer.toString(this.schedulePtr.alertID);
                                }
                                stormJobRun.setCommandLine(commandLine);
                            }
                        }
                        if ((serverRequest.flags & 2) == 0) {
                            rd = null;
                        } else {
                            rd = serverRequest.requestData;
                            serverRequest.requestData = null;
                        }
                        VMTransceiver transceiver = new VMTransceiver();
                        this.response = transceiver.transmitRequest(serverRequest, rd);
                        transceiver.close();
                    }
                }
                if (!this.checkingAgent) continue;
                if (this.response == null) {
                    this.runPtr.returnCode = 16;
                    this.cancelRun("JSS0013E");
                } else if (this.response.status > 4) {
                    switch (this.response.status) {
                        case 28: {
                            this.runPtr.returnCode = 28;
                            break;
                        }
                        case 32: {
                            this.runPtr.returnCode = 32;
                            break;
                        }
                        case 34: {
                            this.runPtr.returnCode = 34;
                            break;
                        }
                        case 36: {
                            this.runPtr.returnCode = 36;
                            break;
                        }
                        default: {
                            this.runPtr.returnCode = 12;
                        }
                    }
                    this.cancelRun("JSS0046E");
                } else if (this.response.responseData != null && !internalJob) {
                    this.updateRow();
                }
                this.response = null;
            }
        }
        this.close();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleSubmit.class.getName(), (String)"run");
        }
    }

    private void cancelRun(String message) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleSubmit.class.getName(), (String)"cancelRun", (String)"message");
        }
        this.checkingAgent = false;
        this.runningRoutine.getRun(this.runPtr.runNumber);
        this.args2[0] = Integer.toString(this.runPtr.runNumber);
        String name = null;
        if (this.runPtr.CID > 0) {
            name = this.agentRoutine.getAgentHostAddress(this.runPtr.CID);
        }
        if (name == null) {
            name = Integer.toString(this.runPtr.CID);
        }
        this.args2[1] = name;
        this.args2[2] = Integer.toString(this.schedulePtr.runNumber);
        this.args2[3] = ResourceTypeManager.getJobName((short)this.schedulePtr.jobType);
        this.args2[4] = this.schedulePtr.creator + "." + this.schedulePtr.getName();
        MessageLog.logMessage((String)message, (Object[])this.args2);
        SchCommon.completeHdr.process(this.runPtr, null);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleSubmit.class.getName(), (String)"cancelRun");
        }
    }

    private boolean insertRun() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleSubmit.class.getName(), (String)"insertRun", (String)"");
        }
        boolean worked = true;
        try {
            this.runStmt.setInt(1, this.runPtr.runNumber);
            this.runStmt.executeUpdate();
            this.connection.commit();
        }
        catch (SQLException e2) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleSubmit.class.getName(), (String)"insertRun", (Throwable)e2);
            }
            if (SchedulerSvp.connectBad(this.connection)) {
                SchCommon.stopped = true;
                SchCommon.bounceNeeded = true;
            }
            String msg = SQLUtil.getSQLExceptionMsg("JSS0008E", e2, this.args);
            logWriter.println(msg);
            worked = false;
        }
        boolean traceResult = worked;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleSubmit.class.getName(), (String)"insertRun", (boolean)traceResult);
        }
        return traceResult;
    }

    private void updateRow() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleSubmit.class.getName(), (String)"updateRow", (String)"");
        }
        boolean testConnection = false;
        try {
            this.nameStmt.setString(1, this.response.responseData.toString());
            this.nameStmt.setInt(2, this.runPtr.runNumber);
            this.nameStmt.executeUpdate();
            this.connection.commit();
        }
        catch (SQLException ignored) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleSubmit.class.getName(), (String)"updateRow", (Throwable)ignored);
            }
            testConnection = true;
        }
        if (!testConnection && this.schedulePtr.alertLogID > 0) {
            int alertLogID = this.schedulePtr.alertLogID;
            this.schedulePtr.alertLogID = -1;
            String jobLogFile = JobUtils.generateLogFileName((RunReq)this.agentJobRun, null);
            TAlertLog accessor = new TAlertLog(this.connection);
            try {
                accessor.updateJobLogFile(alertLogID, jobLogFile);
            }
            catch (GeneralException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ScheduleSubmit.class.getName(), (String)"updateRow", (Throwable)e);
                }
                testConnection = true;
            }
        }
        if (testConnection && SchedulerSvp.connectBad(this.connection)) {
            SchCommon.stopped = true;
            SchCommon.bounceNeeded = true;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleSubmit.class.getName(), (String)"updateRow");
        }
    }

    private void close() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleSubmit.class.getName(), (String)"close", (String)"");
        }
        if (this.runStmt != null) {
            block9: {
                try {
                    this.runStmt.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block9;
                    TraceLogger.exception((String)ScheduleSubmit.class.getName(), (String)"close", (Throwable)ignored);
                }
            }
            this.runStmt = null;
        }
        if (this.nameStmt != null) {
            block10: {
                try {
                    this.nameStmt.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block10;
                    TraceLogger.exception((String)ScheduleSubmit.class.getName(), (String)"close", (Throwable)ignored);
                }
            }
            this.nameStmt = null;
        }
        if (this.connection != null) {
            Server.returnConnection(this.connection);
            this.connection = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleSubmit.class.getName(), (String)"close");
        }
    }

    protected void finalize() throws Throwable {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleSubmit.class.getName(), (String)"finalize", (String)"");
        }
        this.close();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleSubmit.class.getName(), (String)"finalize");
        }
    }
}

