/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;

public class AgentLessManagedNode {
    public int computerID;
    public short osType;
    public String name;
    public String networkAddress;
    public boolean expired = false;

    public AgentLessManagedNode() {
    }

    public AgentLessManagedNode(int computerID, String name) {
        this(computerID, 0, name, name, null, null);
    }

    public AgentLessManagedNode(int computerID, short osType, String trellisoftName, String localHostName, String networkName, String domainName) {
        this.computerID = computerID;
        this.setAttributes(osType, trellisoftName, localHostName, networkName, domainName);
    }

    public void setAttributes(short osType, String trellisoftName, String localHostName, String networkName, String domainName) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AgentLessManagedNode.class.getName(), (String)"setAttributes", (String)"osType, trellisoftName, localHostName, networkName, domainName");
        }
        this.osType = osType;
        if (Constants.isDiskArray((short)osType)) {
            this.name = localHostName;
        } else {
            this.name = trellisoftName;
            if (Constants.isVirtualServer((int)osType) && !Util.isEmpty((String)networkName)) {
                this.networkAddress = networkName;
                if (!Util.isEmpty((String)domainName)) {
                    this.networkAddress = this.networkAddress + "." + domainName;
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AgentLessManagedNode.class.getName(), (String)"setAttributes");
        }
    }

    public int hashCode() {
        return this.computerID;
    }

    public boolean equals(Object pRight) {
        AgentLessManagedNode right = (AgentLessManagedNode)pRight;
        return this.computerID == right.computerID;
    }

    public void updateExpiredFlag(boolean pExpired) {
        this.expired = pExpired;
    }
}

