/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import com.tivoli.tec.event_delivery.EDException;
import com.tivoli.tec.event_delivery.TECAgent;
import com.tivoli.tec.event_delivery.TECEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.agent.req.RunReq;
import org.eclipse.aperi.agent.req.RunScriptReq;
import org.eclipse.aperi.backend.JobUtil;
import org.eclipse.aperi.backend.WindowsScript;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.ListElement;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.jobs.JobUtils;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.AlertUtil;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.ScriptQElement;
import org.eclipse.aperi.server.ScriptSubmitter;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServiceQueue;
import org.eclipse.aperi.server.StatDataWriter;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.server.guireq.AlertLog;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.server.guireq.SmtpSettings;
import org.eclipse.aperi.server.guireq.SnmpDestination;
import org.eclipse.aperi.server.util.smtp.Email;
import org.eclipse.aperi.server.util.smtp.SmtpTransmitter;
import org.eclipse.aperi.server.util.snmp.SnmpUtil;
import org.eclipse.aperi.snmp.SnmpSocketException;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpTrapSession;
import org.eclipse.aperi.snmp.SnmpUnknownHostException;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;
import org.eclipse.aperi.xmsg.NestableException;

public class Alerter
extends Thread {
    private static ServiceQueue alertQueue;
    private static Alerter alerter;
    private static PrintWriter logWriter;
    private static final int STOP_WAIT_TIME = 300000;
    private static final int MIN_EVENT_CATEGORY = 1;
    private static final int MIN_EVENT_ID = 64;
    private static final int ID_ALLOC_SIZE = 64;
    private static int currentID;
    private static SnmpVarBind serverLocation;
    private static String tecBufEvtPath;
    private static final OID SERVER_OID;
    private static final OID ALERT_NAME_OID;
    public static final int[] ALERT_TYPE_OID;
    public static final String ALERT_TYPE_SLOT = "alertType";
    private SnmpDestination[] savedSnmp;
    private Snmp snmpList;
    private boolean snmpInitialized;
    private Connection dbc;
    private StringBuffer msgBuffer = new StringBuffer(512);
    private long osLogHandle;
    private TECAgent tecAgent;
    private String tecServer;
    private int tecPort;
    private TAlertLog alAccessor;
    private TResFS fsAccessor;
    private Alert alert;
    private AlertDefinition alertDef;
    private boolean alertError;
    private byte shutdownMode = 0;
    private File tempDir = new File(Server.TEMP_DIR);

    public static void queueAlert(Alert alert) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"queueAlert", (String)"alert");
        }
        alertQueue.add((ListElement)alert, false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"queueAlert");
        }
    }

    public static void deleteAlert(Connection dbc, int alertID, boolean commit) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"deleteAlert", (String)"dbc, alertID, commit");
        }
        StorageRepositoryAccessor deleter = new StorageRepositoryAccessor(dbc);
        String selectAlertLogID = "(SELECT alert_log_id FROM t_alert_log where alert_id = " + Integer.toString(alertID) + ")";
        String whereClause = " WHERE attribute_id in " + selectAlertLogID + " AND attribute_type = " + 140;
        deleter.delete("t_res_attribute", whereClause, commit);
        whereClause = " WHERE alert_id = " + Integer.toString(alertID);
        deleter.delete("t_alert_email", whereClause, false);
        deleter.delete("t_alert_log", whereClause, false);
        deleter.delete("t_alert_definition", whereClause, commit);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"deleteAlert");
        }
    }

    protected static void startThreads(ThreadGroup serverThreadGroup) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"startThreads", (String)"serverThreadGroup");
        }
        String s = MessageLog.getMessageNoID((String)"ALR1201L", (Object)Server.getServerHostName());
        serverLocation = new SnmpVarBind(SERVER_OID, (Serializable)new OctetString(s, true));
        logWriter = MessageLog.getThreadLog();
        alertQueue = new ServiceQueue();
        ScriptSubmitter.init(serverThreadGroup);
        alerter = new Alerter(serverThreadGroup);
        alerter.start();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"startThreads");
        }
    }

    protected static void stopThreads(byte pShutdownMode) {
        block10: {
            long timeout;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Alerter.class.getName(), (String)"stopThreads", (String)"pShutdownMode");
            }
            if (alerter == null) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Alerter.class.getName(), (String)"stopThreads");
                }
                return;
            }
            Alerter.alerter.shutdownMode = pShutdownMode;
            alertQueue.setState(pShutdownMode);
            switch (pShutdownMode) {
                case 1: {
                    timeout = 0L;
                    break;
                }
                case 2: {
                    timeout = 300000L;
                    break;
                }
                default: {
                    timeout = 1L;
                }
            }
            try {
                alerter.join(timeout);
            }
            catch (InterruptedException e) {
                if (!TraceLogger.enableTrace) break block10;
                TraceLogger.exception((String)Alerter.class.getName(), (String)"stopThreads", (Throwable)e);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"stopThreads");
        }
    }

    private Alerter(ThreadGroup serverThreadGroup) {
        super(serverThreadGroup, "Alerter");
        tecBufEvtPath = System.getProperty("user.dir", "") + File.separator + "tec" + File.separator + "cache";
    }

    public void run() {
        block11: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Alerter.class.getName(), (String)"run", (String)"");
            }
            while ((this.alert = (Alert)alertQueue.get()) != null) {
                this.alertError = false;
                this.alertDef = this.alert.getAlertDefinition();
                if (this.alertDef.aldSALog) {
                    this.logAlert();
                }
                if (this.alertDef.aldEmail) {
                    this.sendEmail();
                }
                if (this.alertDef.aldSnmpTrap) {
                    this.sendTrap();
                }
                if (this.alertDef.aldOsLog) {
                    this.osLog();
                }
                if (this.alertDef.aldTecEvent) {
                    this.sendTecEvent();
                }
                if (!this.shouldRunAgentJob()) continue;
                this.runAgentJob();
            }
            this.close();
            if (this.shutdownMode == 0) {
                this.shutdownMode = 1;
            }
            ScriptSubmitter.queue.setState(this.shutdownMode);
            try {
                ScriptSubmitter.thread.join();
            }
            catch (InterruptedException e) {
                if (!TraceLogger.enableTrace) break block11;
                TraceLogger.exception((String)Alerter.class.getName(), (String)"run", (Throwable)e);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"run");
        }
    }

    private int nextID() throws GeneralException {
        int result;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"nextID", (String)"");
        }
        if ((currentID & 0x3F) == 1) {
            try {
                currentID = SQLUtil.getIdentifier(6, 64, this.dbc);
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"nextID", (Throwable)e);
                }
                String errorMsg = SQLUtil.getSQLExceptionMsg("SRV0100E", e, null);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Alerter.class.getName(), (String)"nextID");
                }
                throw new GeneralException(errorMsg);
            }
        }
        int traceResult = result = currentID++;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"nextID", (int)traceResult);
        }
        return traceResult;
    }

    private boolean makeTempFile(String[] array, int i, StatDataWriter writer, boolean forWindows) {
        boolean ok;
        block18: {
            String fileName;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Alerter.class.getName(), (String)"makeTempFile", (String)"array, i, writer, forWindows");
            }
            File tempFile = null;
            try {
                tempFile = File.createTempFile("ALR", null, this.tempDir);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"makeTempFile", (Throwable)e);
                }
                Object[] args = new Object[]{e.getMessage()};
                LocalizableException exc = new LocalizableException("GEN0037E", args);
                this.handleException((Exception)((Object)exc));
            }
            if (tempFile == null) {
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Alerter.class.getName(), (String)"makeTempFile", (boolean)traceResult);
                }
                return traceResult;
            }
            array[i] = fileName = tempFile.getPath();
            FileWriter mid = null;
            try {
                mid = new FileWriter(fileName);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"makeTempFile", (Throwable)e);
                }
                Object[] args = new Object[]{e.getMessage()};
                LocalizableException exc = new LocalizableException("GEN0037E", args);
                this.handleException((Exception)((Object)exc));
            }
            if (mid == null) {
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Alerter.class.getName(), (String)"makeTempFile", (boolean)traceResult);
                }
                return traceResult;
            }
            BufferedWriter out = new BufferedWriter(mid);
            ok = false;
            boolean triedClose = false;
            try {
                writer.writeDataset(i, out, forWindows);
                triedClose = true;
                out.close();
                ok = true;
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"makeTempFile", (Throwable)e);
                }
                String msg = MessageLog.getMessageWithException((String)"SRV0065E", (Exception)e, (Object)fileName);
                GeneralException exc = new GeneralException(msg);
                this.handleException((Exception)((Object)exc));
            }
            if (!triedClose) {
                try {
                    out.close();
                }
                catch (IOException ignored) {
                    if (!TraceLogger.enableTrace) break block18;
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"makeTempFile", (Throwable)ignored);
                }
            }
        }
        boolean traceResult = ok;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"makeTempFile", (boolean)traceResult);
        }
        return traceResult;
    }

    private void submitScript(AlertLog record) {
        String[] fileArray;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"submitScript", (String)"record");
        }
        record.alScriptComputerID = -1;
        if (this.alertDef.aldScriptComputerID < 0 || Util.isEmpty((String)this.alertDef.aldScriptName)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Alerter.class.getName(), (String)"submitScript");
            }
            return;
        }
        AgentManager.AgentAddress agent = null;
        RunScriptReq requestData = new RunScriptReq();
        if (this.alertDef.aldScriptComputerID > 0) {
            requestData.setComputerID(this.alertDef.aldScriptComputerID);
        } else {
            int computerID = this.alert.getComputerID();
            if (computerID <= 0) {
                LocalizableException e = new LocalizableException("SRV0139E", null);
                this.handleException((Exception)((Object)e));
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Alerter.class.getName(), (String)"submitScript");
                }
                return;
            }
            agent = Server.agentMgr.getAgent(computerID);
            if (agent == null) {
                if (this.alert.getResourceType() != 3) {
                    Object[] args = new Object[]{new Integer(this.alert.getResourceType()), new Integer(computerID)};
                    LocalizableException e = new LocalizableException("SRV0157E", args);
                    this.handleException((Exception)((Object)e));
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)Alerter.class.getName(), (String)"submitScript");
                    }
                    return;
                }
                Throwable ex = null;
                try {
                    if (this.fsAccessor == null) {
                        this.fsAccessor = new TResFS(this.dbc);
                        this.fsAccessor.prepSelectScanningCompID();
                    }
                    computerID = this.fsAccessor.selectScanningCompID(this.alert.getResourceID());
                }
                catch (LocalizableException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Alerter.class.getName(), (String)"submitScript", (Throwable)e);
                    }
                    ex = e;
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Alerter.class.getName(), (String)"submitScript", (Throwable)e);
                    }
                    this.repositoryClose();
                    ex = e;
                }
                if (ex != null) {
                    this.handleException((Exception)ex);
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)Alerter.class.getName(), (String)"submitScript");
                    }
                    return;
                }
            }
            requestData.setComputerID(computerID);
        }
        ConfigSettings settings = Server.getSettings();
        requestData.setRetainDays(settings.csRetainDays);
        requestData.setRetention(settings.csRetainCopies);
        String[] parms = this.alert.getParameters();
        int highestIndex = parms.length - 1;
        try {
            int[] indexArray = AlertConditionManager.getScriptParameterList((short)this.alertDef.aldCondition);
            int length = indexArray == null || parms == null ? 1 : indexArray.length + 1;
            requestData.scrArgv = new String[length];
            requestData.scrArgv[0] = this.alertDef.aldScriptName;
            for (int i = 1; i < length; ++i) {
                if (indexArray[i - 1] > highestIndex) continue;
                requestData.scrArgv[i] = parms[indexArray[i - 1]];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Alerter.class.getName(), (String)"submitScript", (Throwable)e);
            }
            Object[] args = new Object[]{new Integer(this.alertDef.aldCondition)};
            LocalizableException exc = new LocalizableException("SRV0141E", args);
            this.handleException((Exception)((Object)exc));
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Alerter.class.getName(), (String)"submitScript");
            }
            return;
        }
        if (agent == null && (agent = Server.agentMgr.getAgent(requestData.getComputerID())) == null) {
            Object[] args = new Object[]{String.valueOf(requestData.getComputerID())};
            LocalizableException e = new LocalizableException("SRV0040E", args);
            this.handleException((Exception)((Object)e));
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Alerter.class.getName(), (String)"submitScript");
            }
            return;
        }
        boolean forWindows = Constants.isWindows((short)agent.osType);
        StatDataWriter writer = this.alert.statWriter;
        if (writer == null) {
            fileArray = new String[1];
        } else {
            int arrayLength = writer.getNDatasets() + 1;
            fileArray = new String[arrayLength];
            boolean ok = true;
            int i = 1;
            while (i < arrayLength && ok) {
                if (this.makeTempFile(fileArray, i, writer, forWindows)) {
                    ++i;
                    continue;
                }
                ok = false;
            }
            if (!ok) {
                while (i > 0) {
                    if (fileArray[i] != null) {
                        File file = new File(fileArray[i]);
                        file.delete();
                    }
                    --i;
                }
                MessageLog.logMessage((String)"SRV0140E", (Object)this.alertDef.aldCreator, (Object)this.alertDef.getAldName());
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Alerter.class.getName(), (String)"submitScript");
                }
                return;
            }
        }
        requestData.setRunNumber(record.alAlertLogID);
        requestData.setSchedRunNumber(record.alAlertLogID);
        requestData.setSchedCreator(this.alertDef.aldCreator);
        requestData.setSchedName(this.alertDef.getAldName());
        requestData.setJobName("alert");
        record.alScriptLogFile = JobUtils.generateLogFileName((RunReq)requestData, null);
        record.alScriptComputerID = requestData.getComputerID();
        record.alScriptName = this.alertDef.aldScriptName;
        StringBuffer buf = new StringBuffer(120);
        if (Constants.isWindows((short)agent.osType)) {
            WindowsScript ws = JobUtil.resolveWindowsScript((String)this.alertDef.aldScriptName, (StringBuffer)buf);
            if (ws != null) {
                if (buf.length() > 0) {
                    requestData.scrExtension = buf.toString();
                }
                buf.setLength(0);
                buf.append(JobUtil.scriptsDir);
                buf.append(File.separatorChar);
                buf.append(ws.wsResolvedName);
                fileArray[0] = buf.toString();
            }
        } else {
            buf.append(JobUtil.scriptsDir);
            buf.append(File.separatorChar);
            if (JobUtil.resolveUnixScript((String)this.alertDef.aldScriptName, (StringBuffer)buf) != null) {
                fileArray[0] = buf.toString();
            }
        }
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.agent.svp.AgentSvp";
        request.subType = "org.eclipse.aperi.agent.handler.script.ScriptHandlerFactory";
        request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
        request.requestData = requestData;
        ScriptQElement scriptAnchor = new ScriptQElement();
        scriptAnchor.sqRequest = request;
        scriptAnchor.sqAlertLogID = record.alAlertLogID;
        scriptAnchor.sqRetryCounter = 2;
        scriptAnchor.sqFiles = fileArray;
        ScriptSubmitter.queue.add(scriptAnchor, false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"submitScript");
        }
    }

    private void logAlert() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"logAlert", (String)"");
        }
        if (this.dbc == null) {
            this.repositoryPrep();
        }
        if (this.alAccessor != null) {
            AlertLog record = AlertUtil.getAlertLog(this.alert);
            try {
                record.alAlertLogID = this.nextID();
                this.submitScript(record);
                if (this.alAccessor != null) {
                    this.alAccessor.save(record, this.alertDef.accumulateAlertLog());
                }
                if (this.alert.hasAffectedResources()) {
                    TResAttr tresattr = new TResAttr(this.dbc);
                    tresattr.setAffectedResources(record.alAlertLogID, this.alert.getAffectedResources(), (short)1, (short)140);
                    this.alert.setAffectedHosts(tresattr.getAffectedHosts(record.alAlertLogID));
                }
            }
            catch (GeneralException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"logAlert", (Throwable)e);
                }
                this.handleException((Exception)((Object)e));
                this.repositoryClose();
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"logAlert");
        }
    }

    private void repositoryPrep() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"repositoryPrep", (String)"");
        }
        try {
            this.dbc = Server.getConnection();
            if (this.dbc == null) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Alerter.class.getName(), (String)"repositoryPrep");
                }
                throw new GeneralException(MessageLog.getMessage((String)"SRV0089E", null));
            }
            this.alAccessor = new TAlertLog(this.dbc);
            this.alAccessor.prepSave();
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Alerter.class.getName(), (String)"repositoryPrep", (Throwable)e);
            }
            this.handleException((Exception)((Object)e));
            this.repositoryClose();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"repositoryPrep");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEmail() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"sendEmail", (String)"");
        }
        SmtpTransmitter smtp = null;
        Email email = null;
        ConfigSettings settings = Server.getSettings();
        if (settings.csSmtp.ssServer != null) {
            try {
                smtp = new SmtpTransmitter(settings.csSmtp.ssServer, settings.csSmtp.ssPort);
                email = AlertUtil.getEmail(this.alert);
                if (SQLUtil.isNullString(this.alertDef.aldEmailDef.aleSubject)) {
                    email.subject = "Alert: " + email.subject;
                }
                if (SQLUtil.isNullString(this.alertDef.aldEmailDef.aleText)) {
                    email.text = this.prependAlertName(email.text, false);
                }
                smtp.sendMail(email);
            }
            catch (LocalizableException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"sendEmail", (Throwable)e);
                }
                this.handleException((Exception)((Object)e));
            }
            catch (Exception e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"sendEmail", (Throwable)e);
                }
                this.handleException(e);
            }
            finally {
                if (smtp != null) {
                    smtp.close();
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"sendEmail");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownNotification(String subjectMsgID, String bodyMsgID, Object[] parms) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"shutdownNotification", (String)"subjectMsgID, bodyMsgID, parms");
        }
        SmtpTransmitter smtp = null;
        ConfigSettings settings = Server.getSettings();
        if (settings != null && settings.csSmtp.ssServer != null && settings.csSmtp.ssSrmAdmin != null) {
            String hostName = "localhost";
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ignored) {
                // empty catch block
            }
            int argCount = 1;
            if (parms != null) {
                argCount += parms.length;
            }
            Object[] args = new Object[argCount];
            args[0] = hostName;
            if (parms != null) {
                System.arraycopy(parms, 0, args, 1, parms.length);
            }
            String subject = MessageLog.getMessageNoID((String)subjectMsgID);
            String body = MessageLog.getMessageNoID((String)bodyMsgID, (Object[])args);
            String from = MessageLog.getMessageNoID((String)"ALR1201L", (Object)hostName);
            Email email = new Email(subject, body, from, settings.csSmtp.ssReplyTo, settings.csSmtp.ssReturn, settings.csSmtp.ssDfltDomain);
            SmtpSettings smtpSettings = settings.csSmtp;
            for (int i = 0; i < smtpSettings.ssSrmAdmin.length; ++i) {
                email.addRecipient(smtpSettings.ssSrmAdmin[i]);
            }
            try {
                smtp = new SmtpTransmitter(settings.csSmtp.ssServer, settings.csSmtp.ssPort);
                smtp.sendMail(email);
            }
            catch (LocalizableException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"shutdownNotification", (Throwable)e);
                }
                e.print();
            }
            finally {
                if (smtp != null) {
                    smtp.close();
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"shutdownNotification");
        }
    }

    private void sendTrap() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"sendTrap", (String)"");
        }
        ConfigSettings settings = Server.getSettings();
        if (settings.csSnmp != this.savedSnmp) {
            this.snmpPrep(settings);
        }
        if (this.snmpList != null) {
            try {
                SnmpTrap trap = AlertUtil.getTrapPdu(this.alert);
                if (!(this.alert instanceof FabricAlert)) {
                    String s = this.alertDef.aldCreator + '.' + this.alertDef.getAldName();
                    trap.addVarBind(ALERT_NAME_OID, (Serializable)new OctetString(s, true));
                    trap.addVarBind(serverLocation);
                }
                Snmp snmp = this.snmpList;
                while (snmp != null) {
                    snmp.send(trap);
                    snmp = snmp.next;
                }
            }
            catch (LocalizableException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"sendTrap", (Throwable)e);
                }
                this.handleException((Exception)((Object)e));
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"sendTrap", (Throwable)e);
                }
                this.handleException((Exception)new NestableException("GEN0108E", null, (Exception)e));
            }
            catch (NullPointerException e) {
                if (TraceLogger.enableTrace) {
                    String msg = "Unable to create the SNMP trap. The trap's enterprise is null.";
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"sendTrap", (Throwable)e);
                    TraceLogger.traceMessage((int)1, (String)Alerter.class.getName(), (String)"sendTrap", (String)msg);
                }
            }
            catch (Exception e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"sendTrap", (Throwable)e);
                }
                this.handleException((Exception)new NestableException("GEN0108E", null, e));
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"sendTrap");
        }
    }

    private void sendTecEvent() {
        boolean tecConfigChange;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"sendTecEvent", (String)"");
        }
        ConfigSettings settings = Server.getSettings();
        boolean bl = tecConfigChange = settings.csTecServer != this.tecServer || settings.csTecPort != this.tecPort;
        if (tecConfigChange) {
            this.tecPrep(settings);
        }
        if (this.tecAgent != null) {
            int rc = 0;
            try {
                TECEvent tecEvent = AlertUtil.getTecEvent(this.alert);
                rc = this.tecAgent.sendEvent(tecEvent.toString(true));
            }
            catch (LocalizableException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"sendTecEvent", (Throwable)e);
                }
                Object[] args = new Object[]{new Integer(rc)};
                this.handleException((Exception)new NestableException("SRV0206E", args, (Exception)((Object)e)));
            }
            catch (NullPointerException e) {
                if (TraceLogger.enableTrace && TraceLogger.enableTrace) {
                    TraceLogger.exception((String)FabricAlert.class.getName(), (String)"getTecEvent", (Throwable)e);
                    String msg = "Unable to create TEC event. The TEC event class is null.";
                    TraceLogger.traceMessage((int)1, (String)Alerter.class.getName(), (String)"sendTrap", (String)msg);
                }
            }
            catch (Exception e) {
                Object[] args = new Object[]{new Integer(rc)};
                this.handleException((Exception)new NestableException("SRV0206E", args, e));
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"sendTecEvent");
        }
    }

    private void snmpPrep(ConfigSettings settings) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"snmpPrep", (String)"settings");
        }
        SnmpDestination[] oldSnmp = this.savedSnmp;
        this.savedSnmp = settings.csSnmp;
        if (oldSnmp != null) {
            int i;
            for (i = 1; i >= 0; --i) {
                SnmpDestination oldDest = oldSnmp[i];
                SnmpDestination newDest = settings.csSnmp[i];
                if (oldDest.csSnmpPort != newDest.csSnmpPort || !oldDest.csSnmpServer.equalsIgnoreCase(newDest.csSnmpServer)) break;
            }
            if (i < 0) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Alerter.class.getName(), (String)"snmpPrep");
                }
                return;
            }
        }
        Snmp snmp = this.snmpList;
        while (snmp != null) {
            snmp.close();
            snmp = snmp.next;
        }
        this.snmpList = null;
        for (int i = 1; i >= 0; --i) {
            SnmpDestination destination = settings.csSnmp[i];
            if (Util.isEmpty((String)destination.csSnmpServer)) continue;
            Snmp snmp2 = new Snmp(destination);
            this.snmpList = snmp2.add(this.snmpList);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"snmpPrep");
        }
    }

    private void tecPrep(ConfigSettings settings) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"tecPrep", (String)"settings");
        }
        if (this.tecAgent != null) {
            this.tecAgent.disconnect();
            this.tecAgent = null;
        }
        if (settings.csTecServer != null) {
            try {
                String connectString = "ServerLocation=" + settings.csTecServer + "\nServerPort=" + settings.csTecPort + "\nBufferEvents=YES" + "\nBufEvtPath=" + tecBufEvtPath + "\n";
                this.tecServer = settings.csTecServer;
                this.tecPort = settings.csTecPort;
                this.tecAgent = new TECAgent((Reader)new StringReader(connectString), 0, false);
            }
            catch (EDException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"tecPrep", (Throwable)e);
                }
                this.handleException((Exception)((Object)e));
            }
            catch (Exception e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"tecPrep", (Throwable)e);
                }
                this.handleException((Exception)new NestableException("SRV0205E", null, e));
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"tecPrep");
        }
    }

    private void osLog() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"osLog", (String)"");
        }
        try {
            if (this.osLogHandle == 0L) {
                this.osLogHandle = this.osLogOpen(Server.instanceID);
            }
            String logMsg = this.prependAlertName(AlertUtil.getLogMsg(this.alert), true);
            int categoryID = this.alertDef.aldProductID + 1;
            int eventID = this.alertDef.aldCondition + 64;
            this.osLogAlert(this.osLogHandle, logMsg, this.alertDef.aldOsLogSeverity, (short)categoryID, eventID, this.alertDef.aldSyslogFacility);
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Alerter.class.getName(), (String)"osLog", (Throwable)e);
            }
            this.handleException((Exception)((Object)e));
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"osLog");
        }
    }

    private String prependAlertName(String rawMsg, boolean includeMsgID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"prependAlertName", (String)"rawMsg, includeMsgID");
        }
        Object[] alertNameParms = new Object[]{this.alertDef.aldCreator, this.alertDef.getAldName()};
        String alertName = MessageLog.getMessageNoID((String)"ALR0000W", (Object[])alertNameParms);
        this.msgBuffer.setLength(0);
        if (includeMsgID) {
            this.msgBuffer.append(rawMsg.substring(0, 10));
        }
        this.msgBuffer.append(alertName);
        this.msgBuffer.append(' ');
        if (includeMsgID) {
            this.msgBuffer.append(rawMsg.substring(10));
        } else {
            this.msgBuffer.append(rawMsg);
        }
        String traceResult = this.msgBuffer.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"prependAlertName", (Object)traceResult);
        }
        return traceResult;
    }

    private native long osLogOpen(int var1) throws LocalizableException;

    private native void osLogAlert(long var1, String var3, byte var4, short var5, int var6, byte var7) throws LocalizableException;

    private native void osLogClose(long var1);

    private boolean shouldRunAgentJob() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"shouldRunAgentJob", (String)"");
        }
        boolean traceResult = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"shouldRunAgentJob", (boolean)traceResult);
        }
        return traceResult;
    }

    private void runAgentJob() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"runAgentJob", (String)"");
        }
        ScheduleQueue.routine.run(this.alertDef.aldAlertID, this.alert.getComputerID(), this.alert.jobData, currentID - 1);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"runAgentJob");
        }
    }

    private void close() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"close", (String)"");
        }
        while (this.snmpList != null) {
            this.snmpList.session.close();
            this.snmpList = this.snmpList.next;
        }
        if (this.tecAgent != null) {
            this.tecAgent.disconnect();
        }
        if (this.osLogHandle != 0L) {
            this.osLogClose(this.osLogHandle);
        }
        this.repositoryClose();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"close");
        }
    }

    private void repositoryClose() {
        block10: {
            block9: {
                if (TraceLogger.enableTrace) {
                    TraceLogger.entry((String)Alerter.class.getName(), (String)"repositoryClose", (String)"");
                }
                if (this.alAccessor != null) {
                    try {
                        this.alAccessor.closeSave();
                    }
                    catch (GeneralException e) {
                        if (!TraceLogger.enableTrace) break block9;
                        TraceLogger.exception((String)Alerter.class.getName(), (String)"repositoryClose", (Throwable)e);
                    }
                }
            }
            if (this.fsAccessor != null) {
                try {
                    this.fsAccessor.closeSelect();
                }
                catch (GeneralException e) {
                    if (!TraceLogger.enableTrace) break block10;
                    TraceLogger.exception((String)Alerter.class.getName(), (String)"repositoryClose", (Throwable)e);
                }
            }
        }
        if (this.dbc != null) {
            Server.returnConnection(this.dbc);
        }
        this.dbc = null;
        this.alAccessor = null;
        this.fsAccessor = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"repositoryClose");
        }
    }

    private void handleException(Exception e) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Alerter.class.getName(), (String)"handleException", (String)"e");
        }
        if (!this.alertError) {
            this.alertError = true;
            MessageLog.logMessage((String)"SRV0090E", (Object)this.alertDef.aldCreator, (Object)this.alertDef.getAldName());
            logWriter.println("               " + AlertUtil.getLogMsg(this.alert));
        }
        logWriter.println(e.getMessage());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Alerter.class.getName(), (String)"handleException");
        }
    }

    static {
        currentID = 1;
        SERVER_OID = SnmpUtil.tivoliSRMOID(new int[]{1, 1, 1});
        ALERT_NAME_OID = SnmpUtil.tivoliSRMOID(new int[]{1, 1, 2});
        ALERT_TYPE_OID = new int[]{1, 1, 3};
    }

    private class Snmp {
        Snmp next;
        SnmpTrapSession session;
        SnmpDestination destination;

        public Snmp(SnmpDestination destination) {
            this.destination = destination;
        }

        public Snmp add(Snmp list) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Snmp.class.getName(), (String)"add", (String)"list");
            }
            this.next = list;
            list = this;
            Snmp traceResult = this;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Snmp.class.getName(), (String)"add", (Object)traceResult);
            }
            return traceResult;
        }

        public void send(SnmpTrap trap) throws IOException {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Snmp.class.getName(), (String)"send", (String)"trap");
            }
            if (this.session != null || this.open()) {
                trap.communityString = new OctetString(this.destination.csSnmpCommunity, true);
                this.session.send(trap);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Snmp.class.getName(), (String)"send");
            }
        }

        public void close() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Snmp.class.getName(), (String)"close", (String)"");
            }
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Snmp.class.getName(), (String)"close");
            }
        }

        private boolean open() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Snmp.class.getName(), (String)"open", (String)"");
            }
            try {
                if (!Alerter.this.snmpInitialized) {
                    SnmpV1API.initialize((int)-1);
                    Alerter.this.snmpInitialized = true;
                }
                this.session = SnmpTrapSession.open((String)this.destination.csSnmpServer, (int)this.destination.csSnmpPort);
                boolean traceResult = true;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Snmp.class.getName(), (String)"open", (boolean)traceResult);
                }
                return traceResult;
            }
            catch (SnmpUnknownHostException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Snmp.class.getName(), (String)"open", (Throwable)e);
                }
                Object[] args = new Object[]{this.destination.csSnmpServer, String.valueOf(this.destination.csSnmpPort)};
                Alerter.this.handleException((Exception)new NestableException("SRV0209E", args, (Exception)((Object)e)));
            }
            catch (SnmpSocketException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Snmp.class.getName(), (String)"open", (Throwable)e);
                }
                Object[] args = new Object[]{this.destination.csSnmpServer, String.valueOf(this.destination.csSnmpPort)};
                Alerter.this.handleException((Exception)new NestableException("SRV0210E", args, (Exception)((Object)e)));
            }
            catch (Exception e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Snmp.class.getName(), (String)"open", (Throwable)e);
                }
                Alerter.this.handleException((Exception)new NestableException("SRV0204E", null, e));
            }
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Snmp.class.getName(), (String)"open", (boolean)traceResult);
            }
            return traceResult;
        }
    }
}

