/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Server;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.SRMServerInfo;

public class DeviceServerManager {
    private Hashtable deviceServerHT = null;
    private static DeviceServerManager devMgr = null;
    private int serverCount = 0;

    private static synchronized void init() {
        devMgr = new DeviceServerManager();
        DeviceServerManager.devMgr.deviceServerHT = new Hashtable();
        DeviceServerManager.loadDeviceServersInfo();
    }

    public static DeviceServerManager getDeviceServerManager() {
        if (devMgr == null) {
            DeviceServerManager.init();
        }
        return devMgr;
    }

    public synchronized void registerDeviceServer(SRMServerInfo devServerInfo) {
        if (this.deviceServerHT.put(devServerInfo.getServerName(), devServerInfo) == null) {
            ++this.serverCount;
        }
    }

    public synchronized void unRegisterDeviceServer(SRMServerInfo devServerInfo) {
        if (this.deviceServerHT.remove(devServerInfo.getServerName()) != null) {
            --this.serverCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDeviceServersInfo() {
        String methodName = "loadDeviceServersInfo()";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceServerManager.class.getName(), (String)methodName, (String)"");
        }
        DBConnPoolDataSource ds = null;
        DBConnection connection = null;
        Server.ServerCursor serverCursor = null;
        try {
            ds = DBConnPoolDataSource.getInstance();
            connection = (DBConnection)ds.getPooledConnection();
            Hashtable<ColumnInfo, String> ht = new Hashtable<ColumnInfo, String>(1);
            ht.put(Server.getColumnInfo((String)"SERVER_TYPE"), Integer.toString(1));
            serverCursor = Server.getCursor((DBConnection)connection, ht, null);
            if (serverCursor == null) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage((int)3, (String)DeviceServerManager.class.getName(), (String)methodName, (String)"ServerCursor returned is null.");
                }
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)DeviceServerManager.class.getName(), (String)methodName, (Object)"Exiting.  ServerCursor is null.");
                }
                return;
            }
            while (serverCursor.next()) {
                Server devServer = serverCursor.getObject();
                if (DeviceServerManager.devMgr.deviceServerHT.put(devServer.getServerName(), devServer) != null) continue;
                ++DeviceServerManager.devMgr.serverCount;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)DeviceServerManager.class.getName(), (String)methodName, (Throwable)e);
            }
        }
        catch (Exception e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)DeviceServerManager.class.getName(), (String)methodName, (Throwable)e);
            }
        }
        finally {
            try {
                if (serverCursor != null) {
                    serverCursor.close();
                }
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
            if (connection != null) {
                try {
                    connection.close();
                    if (serverCursor != null) {
                        serverCursor.close();
                    }
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public Server getDeviceServer() {
        String methodName = "getDeviceServer()";
        Server devServer = null;
        Enumeration e = this.deviceServerHT.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            try {
                devServer = (Server)this.deviceServerHT.get(key);
            }
            catch (Exception ex) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)DeviceServerManager.class.getName(), (String)methodName, (Throwable)ex);
                }
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)DeviceServerManager.class.getName(), (String)methodName, (Object)"Exiting.  Something went wrong while getting entries from the hashtable.");
                }
                return null;
            }
        }
        return devServer;
    }

    public synchronized void refresh() {
        this.deviceServerHT.clear();
        DeviceServerManager.loadDeviceServersInfo();
    }

    public int getServerCount() {
        return this.serverCount;
    }
}

