/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.net.Socket;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.ReusableObjectPool;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.server.Server;

public class ServerSocketTransceiver
extends SocketTransceiver {
    private static final int POOL_SIZE = 40;
    private static ReusableObjectPool pool = new ReusableObjectPool(40);
    private boolean closed = false;

    public ServerSocketTransceiver(Socket pSocket) {
        super(pSocket);
    }

    public static ServerSocketTransceiver getServerSocketTransceiver(Socket pSocket) {
        ServerSocketTransceiver transceiver;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ServerSocketTransceiver.class.getName(), (String)"getServerSocketTransceiver", (String)"pSocket");
        }
        if ((transceiver = (ServerSocketTransceiver)((Object)pool.getObject())) == null) {
            ServerSocketTransceiver traceResult = new ServerSocketTransceiver(pSocket);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ServerSocketTransceiver.class.getName(), (String)"getServerSocketTransceiver", (Object)((Object)traceResult));
            }
            return traceResult;
        }
        transceiver.init(pSocket, null, 60);
        ServerSocketTransceiver traceResult = transceiver;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ServerSocketTransceiver.class.getName(), (String)"getServerSocketTransceiver", (Object)((Object)traceResult));
        }
        return traceResult;
    }

    public void returnTransceiver() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ServerSocketTransceiver.class.getName(), (String)"returnTransceiver", (String)"");
        }
        this.clear();
        pool.returnObject((Object)this);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ServerSocketTransceiver.class.getName(), (String)"returnTransceiver");
        }
    }

    public boolean close() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ServerSocketTransceiver.class.getName(), (String)"close", (String)"");
        }
        this.closed = true;
        Server.bumpConnectionCount(-1);
        boolean traceResult = super.close();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ServerSocketTransceiver.class.getName(), (String)"close", (boolean)traceResult);
        }
        return traceResult;
    }

    protected void finalize() throws Throwable {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ServerSocketTransceiver.class.getName(), (String)"finalize", (String)"");
        }
        if (!this.closed) {
            this.close();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ServerSocketTransceiver.class.getName(), (String)"finalize");
        }
    }
}

