/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.common.dbaccess.ViewReportTablesUpdater;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAgent;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.guireq.ResourceAttribute;
import org.eclipse.aperi.xmsg.MessageLog;

public class UninstallAgentDriver
extends TSThread {
    private int computerID;
    private byte productCode;

    public UninstallAgentDriver(int computerID, byte productCode) {
        this.computerID = computerID;
        this.productCode = productCode;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection connection;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)UninstallAgentDriver.class.getName(), (String)"run", (String)"");
        }
        if ((connection = Server.getConnection()) == null) {
            Object[] args = new Object[]{"UninstallAgentDriver.run"};
            MessageLog.logMessage((String)"SRV0102E", (Object[])args);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)UninstallAgentDriver.class.getName(), (String)"run");
            }
            return;
        }
        try {
            UninstallAgentDriver.lockAndRemove(this.computerID, true, this.productCode, connection, true);
        }
        finally {
            Server.returnConnection(connection);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UninstallAgentDriver.class.getName(), (String)"run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean lockAndRemove(int computerID, boolean deleteTResComputer, byte productCode, Connection connection, boolean removeAgent) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)UninstallAgentDriver.class.getName(), (String)"lockAndRemove", (String)"computerID, deleteTResComputer, productCode, connection, removeAgent");
        }
        boolean result = false;
        try {
            LockManager.lock((short)2, (String)"Computer", (String)Integer.toString(computerID), (byte)1, (boolean)true);
            result = UninstallAgentDriver.remove(computerID, deleteTResComputer, productCode, connection, removeAgent);
        }
        finally {
            LockManager.unLock((short)2, (String)"Computer", (String)Integer.toString(computerID));
        }
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UninstallAgentDriver.class.getName(), (String)"lockAndRemove", (boolean)traceResult);
        }
        return traceResult;
    }

    public static boolean remove(int computerID, boolean deleteTResComputer, byte productCode, Connection connection, boolean removeAgent) {
        boolean result;
        block23: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)UninstallAgentDriver.class.getName(), (String)"remove", (String)"computerID, deleteTResComputer, productCode, connection, removeAgent");
            }
            result = true;
            boolean killAll = false;
            boolean OStoDET = false;
            boolean killRdbms = false;
            boolean resDeleted = false;
            boolean isNasBox = false;
            boolean killAgent = false;
            boolean isVirtualServer = false;
            if (productCode == 0 || productCode == 1) {
                killAll = true;
            }
            if (productCode == -1) {
                OStoDET = true;
            }
            if (Server.agentMgr.get(computerID) == null) {
                isNasBox = true;
            }
            try {
                TAlertLog alertDeleter;
                TStatComputer tStatAccessor = new TStatComputer(connection);
                isVirtualServer = tStatAccessor.isVirtualServer(computerID);
                if (killAll && !isNasBox && !isVirtualServer) {
                    killAgent = true;
                }
                if (!result || !result) break block23;
                if (killAll || productCode == 4) {
                    alertDeleter = new TAlertLog(connection);
                    alertDeleter.deleteByComputer(computerID);
                }
                if (productCode == 9) {
                    alertDeleter = new TAlertLog(connection);
                    alertDeleter.deleteByDiskArray(computerID);
                }
                TResAttr attrDeleter = new TResAttr(connection);
                if (killAll || productCode == 4 || productCode == 9) {
                    attrDeleter.deleteByID(computerID);
                } else if (OStoDET) {
                    int[] dts = new int[ResourceAttribute.DOWNGRADE_TYPES.length];
                    System.arraycopy(ResourceAttribute.DOWNGRADE_TYPES, 0, dts, 0, ResourceAttribute.DOWNGRADE_TYPES.length);
                    attrDeleter.deleteByTypes(computerID, dts);
                }
                if (killAll || productCode == 4 || productCode == 9) {
                    String columnName;
                    String tableName;
                    StorageRepositoryAccessor statAccessor = new StorageRepositoryAccessor(connection);
                    if (productCode == 9) {
                        tableName = "t_res_storage_subsystem";
                        columnName = "subsystem_id";
                    } else {
                        tableName = "t_stat_computer";
                        columnName = "computer_id";
                    }
                    statAccessor.deleteByIdColumn(tableName, columnName, computerID);
                    if (deleteTResComputer && computerID != Server.getServerComputerID()) {
                        try {
                            boolean isDevAgtInstalled = UninstallAgentDriver.isDeviceAgentInstalled(computerID);
                            if (!isDevAgtInstalled) {
                                TResComputer resDeleter = new TResComputer(connection);
                                resDeleter.deleteByID(computerID, false);
                                resDeleted = true;
                            }
                        }
                        catch (SQLException sqlEx) {
                            MessageLog.logException((String)"SRV0120E", (Exception)sqlEx);
                            if (TraceLogger.enableTrace) {
                                TraceLogger.exception((String)UninstallAgentDriver.class.getName(), (String)"remove", (Throwable)sqlEx);
                            }
                            result = false;
                        }
                    }
                }
                if (killAgent) {
                    TAgent agentDeleter = new TAgent();
                    TAgent.deleteAgent(computerID, connection);
                    Server.agentMgr.delete(computerID);
                }
                TResCluster clAccessor = new TResCluster(connection);
                clAccessor.cleanupClusters();
                new ViewReportTablesUpdater().deleteDependentViews("host", String.valueOf(computerID));
                ScheduleQueue.routine.rebuild();
            }
            catch (GeneralException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)UninstallAgentDriver.class.getName(), (String)"remove", (Throwable)e);
                }
                MessageLog.logException((String)"SRV0120E", (Exception)((Object)e));
                result = false;
            }
        }
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UninstallAgentDriver.class.getName(), (String)"remove", (boolean)traceResult);
        }
        return traceResult;
    }

    private static boolean isDeviceAgentInstalled(int computerID) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)UninstallAgentDriver.class.getName(), (String)"isDeviceAgentInstalled", (String)"computerID");
        }
        DBConnection connection = null;
        DeviceAgent.DeviceAgentCursor cursor = null;
        boolean status = false;
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            connection = (DBConnection)ds.getPooledConnection();
            cursor = DeviceAgent.getCursor((DBConnection)connection, null, null);
            if (cursor != null) {
                while (cursor.next()) {
                    DeviceAgent dbHelper = cursor.getObject();
                    if (computerID != dbHelper.getHostId()) continue;
                    status = true;
                }
            }
        }
        catch (SQLException ex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)UninstallAgentDriver.class.getName(), (String)"isDeviceAgentInstalled", (Object)ex);
            }
            throw ex;
        }
        catch (NullPointerException dbEx) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)UninstallAgentDriver.class.getName(), (String)"isDeviceAgentInstalled", (Object)dbEx);
            }
            SQLException sqlEx = new SQLException(dbEx.getMessage());
            throw sqlEx;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UninstallAgentDriver.class.getName(), (String)"isDeviceAgentInstalled", (boolean)status);
        }
        return status;
    }
}

