/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.alert;

import java.io.Serializable;
import java.sql.Connection;
import java.text.DecimalFormat;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class BaseAlerter {
    protected Connection dbc;
    protected AlertDefinition alertDef;
    protected TAlertDefinition alertAccessor;
    protected String[] alertParms;
    protected String hostName;
    protected int computerID;
    private TAlertLog logAccessor;
    private static DecimalFormat formatter = new DecimalFormat();
    protected static final int COMPUTER = 0;
    public static final int[] COMPUTER_OID = new int[]{2, 1, 1};
    public static final int[] RESOURCE_NAME_OID = new int[]{2, 1, 2};
    public static final int[] RESOURCE_TYPE_OID = new int[]{2, 1, 3};
    public static final int[] THRESHOLD_OID = new int[]{2, 1, 4};
    public static final int[] NEW_VALUE_OID = new int[]{2, 1, 5};
    public static final int[] OLD_VALUE_OID = new int[]{2, 1, 6};
    public static final int[] VIOLATOR_NAME_OID = new int[]{2, 1, 8};
    public static final int[] VIOLATOR_TYPE_OID = new int[]{2, 1, 9};
    public static final int[] FILER_NAME_OID = new int[]{2, 1, 10};
    public static final int[] CURRENT_CAPACITY_OID = new int[]{2, 1, 11};
    public static final int[] TARGET_CAPACITY_OID = new int[]{2, 1, 12};
    public static final int[] FREESPACE_OID = new int[]{2, 1, 13};
    public static final int[] VIRTUAL_SERVER_NAME_OID = new int[]{2, 1, 14};
    public static final int[] CLUSTER_NAME_OID = new int[]{2, 1, 15};
    public static final int[] CURRENT_NODE_NAME_OID = new int[]{2, 1, 16};
    public static final int[] OLD_NODE_NAME_OID = new int[]{2, 1, 17};
    public static final int[] STORAGE_SUBSYSTEM_OID = new int[]{2, 1, 18};
    public static final int[] DEVICE_NAME_OID = new int[]{2, 1, 19};
    public static final int[] THRESHOLD_BOUNDARY_OID = new int[]{2, 1, 20};
    public static final int[] THRESHOLD_TIME_OID = new int[]{2, 1, 21};
    public static final int[] THRESHOLD_NAME_OID = new int[]{2, 1, 22};
    public static final int[] THRESH_DESCRIPTION_OID = new int[]{2, 1, 23};
    public static final int[] START_TIME_OID = new int[]{2, 1, 24};
    public static final int[] STOP_TIME_OID = new int[]{2, 1, 25};
    public static final int[] ERROR_OID = new int[]{2, 1, 26};
    public static final int[] RECORDS_CNT_OID = new int[]{2, 1, 27};
    public static final String COMPUTER_SLOT = "hostname";
    public static final String RESOURCE_NAME_SLOT = "resourceName";
    public static final String RESOURCE_TYPE_SLOT = "resourceType";
    public static final String THRESHOLD_SLOT = "threshold";
    public static final String NEW_VALUE_SLOT = "currentValue";
    public static final String OLD_VALUE_SLOT = "previousValue";
    public static final String VIOLATOR_NAME_SLOT = "violatorName";
    public static final String VIOLATOR_TYPE_SLOT = "violatorType";
    public static final String FILER_NAME_SLOT = "filerName";
    public static final String RDBMS_TYPE_SLOT = "rdbmsType";
    public static final String RDBMS_NAME_SLOT = "rdbmsName";
    public static final String DATABASE_NAME_SLOT = "databaseName";
    public static final String CURRENT_CAPACITY_SLOT = "currentCapacity";
    public static final String TARGET_CAPACITY_SLOT = "targetCapacity";
    public static final String FREESPACE_SLOT = "freespace";
    public static final String VIRTUAL_SERVER_NAME_SLOT = "vsName";
    public static final String CLUSTER_NAME_SLOT = "clusterName";
    public static final String CURRENT_NODE_NAME_SLOT = "currentNodeName";
    public static final String OLD_NODE_NAME_SLOT = "previousNodeName";
    public static final String STORAGE_SUBSYSTEM_NAME_SLOT = "storageSubsystemName";
    public static final String DEVICE_NAME_SLOT = "deviceName";
    public static final String THRESHOLD_BOUNDARY_SLOT = "thresholdBoundary";
    public static final String THRESHOLD_NAME_SLOT = "thresholdName";
    public static final String THRESHOLD_TIME_SLOT = "thresholdTime";
    public static final String THRESH_DESCRIPTION_SLOT = "threshDescription";
    public static final String START_TIME_SLOT = "startTime";
    public static final String STOP_TIME_SLOT = "stopTime";
    public static final String ERROR_SLOT = "error";
    public static final String RECORDS_CNT_SLOT = "recordCnt";
    protected int[][] snmpOIDs;
    protected String[] tecSlotNames;

    protected BaseAlerter(Connection dbc, int computerID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"BaseAlerter", (String)"dbc, computerID");
        }
        this.dbc = dbc;
        this.setComputer(computerID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"BaseAlerter");
        }
    }

    protected void initAlertAccessor() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"initAlertAccessor", (String)"");
        }
        this.alertAccessor = new TAlertDefinition(this.dbc);
        this.alertAccessor.prepSelectByID(false, true);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"initAlertAccessor");
        }
    }

    protected void setComputer(int computerID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"setComputer", (String)"computerID");
        }
        this.computerID = computerID;
        this.hostName = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"setComputer");
        }
    }

    protected void setHostName() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"setHostName", (String)"");
        }
        if (this.hostName == null) {
            AgentManager agentMgr = Server.getAgentManager();
            this.hostName = agentMgr.getAgentName(this.computerID);
        }
        this.alertParms[0] = this.hostName;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"setHostName");
        }
    }

    protected void setHostName(int computerID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"setHostName", (String)"computerID");
        }
        this.setComputer(computerID);
        this.setHostName();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"setHostName");
        }
    }

    protected void setNumParm(int parmKey, long value, String suffix) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"setNumParm", (String)"parmKey, value, suffix");
        }
        String s = Long.toString(value);
        if (suffix != null) {
            s = s + suffix;
        }
        this.alertParms[parmKey] = s;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"setNumParm");
        }
    }

    protected void setNumParm(int parmKey, double value, String suffix) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"setNumParm", (String)"parmKey, value, suffix");
        }
        formatter.setMaximumFractionDigits(2);
        String s = formatter.format(value);
        if (suffix != null) {
            s = s + suffix;
        }
        this.alertParms[parmKey] = s;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"setNumParm");
        }
    }

    protected void setByteSizeParm(int parmKey, long value) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"setByteSizeParm", (String)"parmKey, value");
        }
        if (value < 2L) {
            this.setNumParm(parmKey, value * 512L, " bytes");
        } else if (value < 2048L) {
            this.setNumParm(parmKey, (double)value / 2.0, "KB");
        } else if (value < 0x200000L) {
            this.setNumParm(parmKey, (double)value / 2048.0, "MB");
        } else {
            this.setNumParm(parmKey, (double)value / 2097152.0, "GB");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"setByteSizeParm");
        }
    }

    protected void setParmFromMsg(int parmKey, String msgID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"setParmFromMsg", (String)"parmKey, msgID");
        }
        this.alertParms[parmKey] = MessageLog.getMessageNoID((String)msgID, null);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"setParmFromMsg");
        }
    }

    protected void clearAlert(int resourceID, short resourceType) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"clearAlert", (String)"resourceID, resourceType");
        }
        this.clearAlert(resourceID, resourceType, -1, (short)-1);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"clearAlert");
        }
    }

    protected void clearAlert(int resourceID, short resourceType, int violatorID, short violatorType) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"clearAlert", (String)"resourceID, resourceType, violatorID, violatorType");
        }
        try {
            if (this.logAccessor == null) {
                this.logAccessor = new TAlertLog(this.dbc);
                this.logAccessor.prepDeactivate();
            }
            this.logAccessor.deactivate(this.alertDef.aldAlertID, this.computerID, resourceID, resourceType, this.alertDef.aldCondition, violatorID, violatorType);
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)BaseAlerter.class.getName(), (String)"clearAlert", (Throwable)e);
            }
            this.close();
            MessageLog.logException((String)"STS0078E", (Exception)((Object)e), (Object)this.alertDef.aldCreator, (Object)this.alertDef.getAldName());
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"clearAlert");
        }
    }

    protected void genAlert(int resourceID, short resourceType, int trapType, int violatingValue, int oldValue) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"genAlert", (String)"resourceID, resourceType, trapType, violatingValue, oldValue");
        }
        Alert alert = new Alert(this.computerID, resourceID, resourceType, this.alertDef, this.alertParms, trapType, this.snmpOIDs, this.tecSlotNames, violatingValue, oldValue);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"genAlert");
        }
    }

    protected void genAlert(int resourceID, short resourceType, int trapType, int violatingValue, int oldValue, int targetValue, Serializable jobData) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"genAlert", (String)"resourceID, resourceType, trapType, violatingValue, oldValue, targetValue, jobData");
        }
        Alert alert = new Alert(this.computerID, resourceID, resourceType, this.alertDef, this.alertParms, trapType, this.snmpOIDs, this.tecSlotNames, violatingValue, oldValue, targetValue, -1);
        alert.jobData = jobData;
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"genAlert");
        }
    }

    protected void genAlert(int resourceID, short resourceType, int trapType, int violatingValue, int oldValue, byte dbmsType, int parentID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"genAlert", (String)"resourceID, resourceType, trapType, violatingValue, oldValue, dbmsType, parentID");
        }
        Alert alert = new Alert(this.computerID, resourceID, resourceType, this.alertDef, this.alertParms, trapType, this.snmpOIDs, this.tecSlotNames, violatingValue, oldValue, dbmsType, parentID);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"genAlert");
        }
    }

    protected void genAlert(int resourceID, short resourceType, int trapType, int violatingValue, int violatorID, short violatorType) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"genAlert", (String)"resourceID, resourceType, trapType, violatingValue, violatorID, violatorType");
        }
        Alert alert = new Alert(this.computerID, resourceID, resourceType, this.alertDef, this.alertParms, trapType, this.snmpOIDs, this.tecSlotNames, violatingValue, -1, violatorID, violatorType);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"genAlert");
        }
    }

    protected void genAlert(int resourceID, short resourceType, int trapType, int violatingValue, int violatorID, short violatorType, byte dbmsType, int parentID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"genAlert", (String)"resourceID, resourceType, trapType, violatingValue, violatorID, violatorType, dbmsType, parentID");
        }
        Alert alert = new Alert(this.computerID, resourceID, resourceType, this.alertDef, this.alertParms, trapType, this.snmpOIDs, this.tecSlotNames, violatingValue, -1, violatorID, violatorType, dbmsType, parentID);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"genAlert");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BaseAlerter.class.getName(), (String)"close", (String)"");
        }
        if (this.logAccessor != null) {
            try {
                this.logAccessor.closeUpdate();
            }
            catch (GeneralException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)BaseAlerter.class.getName(), (String)"close", (Throwable)e);
                }
            }
            finally {
                this.logAccessor = null;
            }
        }
        if (this.alertAccessor != null) {
            try {
                this.alertAccessor.closeSelect();
            }
            catch (GeneralException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)BaseAlerter.class.getName(), (String)"close", (Throwable)e);
                }
            }
            finally {
                this.alertAccessor = null;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BaseAlerter.class.getName(), (String)"close");
        }
    }
}

