/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.TStorm.common.Rank;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.common.SoftwareVersion;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Fabric;
import org.eclipse.aperi.infrastructure.database.objects.PhyPe;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.Zone;
import org.eclipse.aperi.infrastructure.database.objects.Zset;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.ReportingGroupMemberList;
import org.eclipse.aperi.repository.table.TFoundFilesystem;
import org.eclipse.aperi.repository.table.TResController;
import org.eclipse.aperi.repository.table.TResDevAccess;
import org.eclipse.aperi.repository.table.TResExport;
import org.eclipse.aperi.repository.table.TResFabric;
import org.eclipse.aperi.repository.table.TResLdapTree;
import org.eclipse.aperi.repository.table.TResLibraries;
import org.eclipse.aperi.repository.table.TResLogicalDisk;
import org.eclipse.aperi.repository.table.TResPwd;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.repository.table.TResStorExtent;
import org.eclipse.aperi.repository.table.TResVolGroup;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiListHndlr
implements RequestHandler,
ThreadSafe {
    private static Export[] packExports(Export head) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiListHndlr.class.getName(), (String)"packExports", (String)"head");
        }
        int nElements = 0;
        Export export = head;
        while (export != null) {
            ++nElements;
            export = export.xpNext;
        }
        Export[] result = new Export[nElements];
        nElements = 0;
        while (head != null) {
            export = head.xpNext;
            head.xpNext = null;
            result[nElements] = head;
            ++nElements;
            head = export;
        }
        Export[] traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiListHndlr.class.getName(), (String)"packExports", (Object)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        Connection dbc;
        block221: {
            NameList fabrics;
            NameList head;
            Object accessor;
            dbc = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)GuiListHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
            }
            if (!RequestChecker.isDesiredType(GuiListReq.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
                Response traceResult = response;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)GuiListHndlr.class.getName(), (String)"handle", (Object)traceResult);
                }
                return traceResult;
            }
            GuiListReq glr = (GuiListReq)request.requestData;
            if (glr.listRequested != 10114 && (dbc = Server.getConnection()) == null) {
                Server.setResponseError(response, "GEN0050E");
                Response traceResult = response;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)GuiListHndlr.class.getName(), (String)"handle", (Object)traceResult);
                }
                return traceResult;
            }
            if (glr.listRequested == 1) {
                try {
                    accessor = new TStatComputer(dbc);
                    NameList list = ((TStatComputer)accessor).getComputerNames(glr.excludeNAS);
                    response.responseData = NameList.packList((NameList)list);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
            } else if (glr.listRequested == 12) {
                response.responseData = GuiListHndlr.getAgentList(glr);
            } else if (glr.listRequested == 100) {
                try {
                    accessor = new TStatComputer(dbc);
                    NameList list = ((TStatComputer)accessor).selectVirtualServersInCluster(glr.computerID);
                    response.responseData = NameList.packList((NameList)list);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
            } else if (glr.listRequested == 101) {
                try {
                    accessor = new TStatComputer(dbc);
                    NameList list = ((TStatComputer)accessor).selectAgentsInCluster(glr.computerID);
                    response.responseData = NameList.packList((NameList)list);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
            } else if (glr.listRequested == 102) {
                try {
                    accessor = new TStatComputer(dbc);
                    NameList list = ((TStatComputer)accessor).getClusterMembers(glr.computerID);
                    response.responseData = NameList.packList((NameList)list);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
            } else if (glr.listRequested == 2) {
                try {
                    accessor = new TResController(dbc);
                    Controller controllers = ((TResController)accessor).getControllers(glr.computerID, glr.qualifier);
                    response.responseData = (Serializable)Packer.pack((Packable)controllers);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
            } else if (glr.listRequested == 3) {
                try {
                    accessor = new TResDevAccess(dbc);
                    response.responseData = ((TResDevAccess)accessor).selectNames(glr);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
            } else if (glr.listRequested == 4) {
                try {
                    accessor = new TResLogicalDisk(dbc);
                    response.responseData = ((TResLogicalDisk)accessor).getLDlist(glr.computerID, glr.diskID, glr.groupID);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
            } else if (glr.listRequested == 6) {
                try {
                    accessor = new TResExport(dbc);
                    Export list = ((TResExport)accessor).selectByComputer(glr.computerID);
                    response.responseData = GuiListHndlr.packExports(list);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
            } else if (glr.listRequested == 8) {
                try {
                    Object[] result = new Object[2];
                    TResLdapTree treeAccessor = new TResLdapTree(dbc);
                    result[0] = treeAccessor.getPackedTree();
                    TResShare shAccessor = new TResShare(dbc);
                    result[1] = shAccessor.getTreeAgents();
                    response.responseData = result;
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
            } else if (glr.listRequested == 9) {
                GuiListHndlr.getNasFsList(dbc, response);
            } else if (glr.listRequested == 13) {
                GuiListHndlr.getManNasList(dbc, response);
            } else if (glr.listRequested == 10) {
                try {
                    accessor = new TResVolGroup(dbc);
                    NameList list = glr.vgID == -1 ? null : (glr.vgID > 0 ? ((TResVolGroup)accessor).selectNamesByVGID(glr) : ((TResVolGroup)accessor).selectNames(glr));
                    response.responseData = NameList.packList(list);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
            } else if (glr.listRequested == 11) {
                try {
                    accessor = new ReportingGroupMemberList(dbc);
                    NameList list = ((ReportingGroupMemberList)accessor).getMatchedResources(glr);
                    response.responseData = NameList.packList((NameList)list);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
            } else if (glr.listRequested == 14) {
                try {
                    Rank ranks = null;
                    TResStorExtent accessor2 = new TResStorExtent(dbc);
                    ranks = glr.controllerID > 0 ? accessor2.getStorExtentByController(glr.controllerID) : accessor2.getStorExtentByComputer(glr.computerID);
                    Rank head2 = ranks;
                    response.responseData = (Serializable)Packer.pack((Packable)head2);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
            } else if (glr.listRequested == 10114) {
                try {
                    TResFabric fabricHelper = new TResFabric();
                    NameList list = fabricHelper.getFabricList();
                    response.responseData = NameList.packList((NameList)list);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
            } else if (glr.listRequested == 10134) {
                try {
                    TResLibraries librariesHelper = new TResLibraries();
                    NameList list = librariesHelper.getLibrariesList(glr);
                    response.responseData = NameList.packList((NameList)list);
                }
                catch (Exception e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, e);
                }
            } else if (glr.listRequested == 10134) {
                head = null;
                NameList tail = null;
                TapeLibrary.TapeLibraryCursor cursor = null;
                DBConnection dbConnection = null;
                try {
                    DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
                    dbConnection = (DBConnection)ds.getPooledConnection();
                    dbConnection.setAutoCommit(true);
                    Hashtable whereClause = null;
                    Vector columns = null;
                    cursor = TapeLibrary.getCursor((DBConnection)dbConnection, whereClause, columns);
                    while (cursor.next()) {
                        TapeLibrary tempTapeLibrary = cursor.getObject();
                        NameList item = new NameList();
                        item.nlInfo = (short)134;
                        item.nlID = tempTapeLibrary.getTapeLibraryId();
                        item.nlName = tempTapeLibrary.getDisplayName();
                        if (tail != null) {
                            tail.nlNext = item;
                        } else {
                            head = item;
                        }
                        tail = item;
                    }
                }
                catch (Exception e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, e);
                }
                finally {
                    try {
                        cursor.close();
                        dbConnection.close();
                    }
                    catch (Exception e) {}
                }
                response.responseData = (Serializable)Packer.pack(head);
            } else if (glr.listRequested == 10114) {
                fabrics = null;
                try {
                    fabrics = this.getFabrics();
                }
                catch (Exception e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, e);
                }
                response.responseData = (Serializable)Packer.pack((Packable)fabrics);
            } else if (glr.listRequested == 10127) {
                head = null;
                NameList tail = null;
                Zone.ZoneCursor cursor = null;
                DBConnection dbConnection = null;
                try {
                    DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
                    dbConnection = (DBConnection)ds.getPooledConnection();
                    dbConnection.setAutoCommit(true);
                    Hashtable whereClause = null;
                    Vector columns = null;
                    cursor = Zone.getCursor((DBConnection)dbConnection, whereClause, columns);
                    while (cursor.next()) {
                        Zone tempZone = cursor.getObject();
                        if (tempZone.getActive() != 1) continue;
                        NameList item = new NameList();
                        item.nlInfo = (short)127;
                        item.nlID = tempZone.getZoneId();
                        String fabricLabel = FabricDbAccess.getFabricLabel((String)tempZone.getFabricWwn());
                        item.nlName = tempZone.getZoneName() + "(Fabric " + fabricLabel + ")";
                        if (tail != null) {
                            tail.nlNext = item;
                        } else {
                            head = item;
                        }
                        tail = item;
                    }
                }
                catch (Exception e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, e);
                }
                finally {
                    try {
                        cursor.close();
                        dbConnection.close();
                    }
                    catch (Exception e) {}
                }
                response.responseData = (Serializable)Packer.pack(head);
            } else if (glr.listRequested == 10126) {
                head = null;
                NameList tail = null;
                Zset.ZsetCursor cursor = null;
                DBConnection dbConnection = null;
                try {
                    DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
                    dbConnection = (DBConnection)ds.getPooledConnection();
                    Hashtable whereClause = null;
                    Vector columns = null;
                    cursor = Zset.getCursor((DBConnection)dbConnection, whereClause, columns);
                    while (cursor.next()) {
                        Zset tempZset = cursor.getObject();
                        if (tempZset.getActive() != 1) continue;
                        NameList item = new NameList();
                        item.nlInfo = (short)126;
                        item.nlID = tempZset.getZsetId();
                        String fabricLabel = FabricDbAccess.getFabricLabel((String)tempZset.getFabricWwn());
                        item.nlName = tempZset.getZsetName() + "(Fabric " + fabricLabel + ")";
                        if (tail != null) {
                            tail.nlNext = item;
                        } else {
                            head = item;
                        }
                        tail = item;
                    }
                }
                catch (Exception e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, e);
                }
                finally {
                    try {
                        cursor.close();
                        dbConnection.close();
                    }
                    catch (Exception e) {}
                }
                response.responseData = (Serializable)Packer.pack(head);
            } else if (glr.listRequested == 10129) {
                String displayName;
                NameList item;
                head = null;
                NameList tail = null;
                NameList portHead = null;
                NameList portTail = null;
                NameList nodeHead = null;
                NameList nodeTail = null;
                PhyPe.PhyPeCursor cursor = null;
                DBConnection dbConnection = null;
                try {
                    DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
                    dbConnection = (DBConnection)ds.getPooledConnection();
                    dbConnection.setAutoCommit(true);
                    Hashtable whereClause = null;
                    Vector columns = null;
                    cursor = PhyPe.getCursor((DBConnection)dbConnection, whereClause, columns);
                    while (cursor.next()) {
                        PhyPe tempPhyPe = cursor.getObject();
                        item = new NameList();
                        item.nlInfo = (short)139;
                        item.nlID = tempPhyPe.getPhyPeId();
                        String displayName2 = tempPhyPe.getDisplayName();
                        item.nlName = displayName2 != null && !displayName2.equals("") ? tempPhyPe.getDisplayName() : "PhysicalEntity." + tempPhyPe.getPeName();
                        if (tail != null) {
                            tail.nlNext = item;
                        } else {
                            head = item;
                        }
                        tail = item;
                    }
                }
                catch (Exception e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, e);
                }
                finally {
                    try {
                        cursor.close();
                        dbConnection.close();
                    }
                    catch (Exception e) {}
                }
                try {
                    String[] portIDs = FabricDbAccess.getDeadEndPorts();
                    String[] portAttribList = new String[]{"PORT_ID", "DISPLAY_NAME", "NAME"};
                    HashMap[] portMaps = FabricDbAccess.getPortAttributes((String[])portIDs, (String[])portAttribList);
                    for (int i = 0; i < portMaps.length; ++i) {
                        item = new NameList();
                        item.nlInfo = (short)137;
                        Integer tempPortID = (Integer)portMaps[i].get("PORT_ID");
                        item.nlID = tempPortID;
                        displayName = (String)portMaps[i].get("DISPLAY_NAME");
                        item.nlName = displayName != null && !displayName.equals("") ? displayName : "Port." + (String)portMaps[i].get("NAME");
                        if (portTail != null) {
                            portTail.nlNext = item;
                        } else {
                            portHead = item;
                        }
                        portTail = item;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    String[] nodeIDs = FabricDbAccess.getDeadEndNodes();
                    String[] nodeAttribList = new String[]{"NODE_ID", "DISPLAY_NAME", "NAME"};
                    HashMap[] nodeMaps = FabricDbAccess.getNodeAttributes((String[])nodeIDs, (String[])nodeAttribList);
                    for (int i = 0; i < nodeMaps.length; ++i) {
                        item = new NameList();
                        item.nlInfo = (short)138;
                        Integer tempNodeID = (Integer)nodeMaps[i].get("NODE_ID");
                        item.nlID = tempNodeID;
                        displayName = (String)nodeMaps[i].get("DISPLAY_NAME");
                        item.nlName = displayName != null && !displayName.equals("") ? displayName : "Node." + (String)nodeMaps[i].get("NAME");
                        if (nodeTail != null) {
                            nodeTail.nlNext = item;
                        } else {
                            nodeHead = item;
                        }
                        nodeTail = item;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (portHead != null) {
                    if (tail != null) {
                        tail.nlNext = portHead;
                    } else {
                        head = portHead;
                    }
                    tail = portTail;
                }
                if (nodeHead != null) {
                    if (tail != null) {
                        tail.nlNext = nodeHead;
                    } else {
                        head = nodeHead;
                    }
                    tail = nodeTail;
                }
                response.responseData = (Serializable)Packer.pack((Packable)head);
            } else if (glr.listRequested == 10122) {
                fabrics = null;
                try {
                    fabrics = this.getFabrics();
                }
                catch (Exception e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, e);
                }
                response.responseData = (Serializable)Packer.pack((Packable)fabrics);
            } else if (glr.listRequested == 10121) {
                head = null;
                NameList tail = null;
                Switch.SwitchCursor cursor = null;
                DBConnection dbConnection = null;
                try {
                    DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
                    dbConnection = (DBConnection)ds.getPooledConnection();
                    dbConnection.setAutoCommit(true);
                    Hashtable whereClause = null;
                    Vector columns = null;
                    cursor = Switch.getCursor((DBConnection)dbConnection, whereClause, columns);
                    while (cursor.next()) {
                        Switch tempSwitch = cursor.getObject();
                        NameList item = new NameList();
                        item.nlInfo = (short)121;
                        item.nlID = tempSwitch.getSwitchId();
                        String displayName = tempSwitch.getDisplayName();
                        item.nlName = displayName != null && displayName.trim().length() > 0 ? displayName : ((displayName = tempSwitch.getLogicalName()) != null && displayName.trim().length() > 0 ? displayName : "Switch." + tempSwitch.getSwitchWwn());
                        if (tail != null) {
                            tail.nlNext = item;
                        } else {
                            head = item;
                        }
                        tail = item;
                    }
                }
                catch (Exception e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, e);
                }
                finally {
                    try {
                        cursor.close();
                        dbConnection.close();
                    }
                    catch (Exception e) {}
                }
                response.responseData = (Serializable)Packer.pack(head);
            } else if (glr.listRequested == 10120) {
                fabrics = null;
                try {
                    fabrics = this.getFabrics();
                }
                catch (Exception e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, e);
                }
                response.responseData = (Serializable)Packer.pack((Packable)fabrics);
            } else if (glr.listRequested == 10154 || glr.listRequested == 10155) {
                NameList[] regularAlerts;
                accessor = null;
                try {
                    Class c = ResourceTypeManager.getListAccessor((short)20);
                    accessor = this.getAccessor(c, dbc);
                }
                catch (Exception e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)this.getClass().getName(), (String)"handle", (Throwable)e);
                    }
                    response.status = (short)12;
                    response.errorMessage = MessageLog.getMessageWithException((String)"STS0094E", (Exception)e, (Object[])new Object[]{new Integer(glr.listRequested)});
                    response.responseData = null;
                    break block221;
                }
                int regularAlertType = glr.listRequested == 10154 ? 31 : 20;
                glr.listRequested = 20;
                try {
                    glr.resourceType = (short)regularAlertType;
                    regularAlerts = NameList.packList((NameList)accessor.selectNames(glr));
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)this.getClass().getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                    break block221;
                }
                response.responseData = regularAlerts;
            } else {
                Class c = null;
                if (glr.listRequested >= 10000) {
                    glr.listRequested -= 10000;
                    c = ResourceTypeManager.getListAccessor((short)((short)glr.listRequested));
                }
                if (c == null) {
                    response.status = (short)12;
                    Object[] args = new Object[]{new Integer(glr.listRequested)};
                    response.errorMessage = MessageLog.getMessage((String)"STS0093E", (Object[])args);
                    response.responseData = null;
                } else {
                    NameListQueryable accessor3 = null;
                    try {
                        Class[] argdef = new Class[]{Connection.class};
                        Constructor constr = c.getConstructor(argdef);
                        accessor3 = (NameListQueryable)constr.newInstance(dbc);
                    }
                    catch (Exception e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                        }
                        System.err.println(e);
                        e.printStackTrace();
                        response.status = (short)12;
                        Object[] args = new Object[]{new Integer(glr.listRequested)};
                        response.errorMessage = MessageLog.getMessageWithException((String)"STS0094E", (Exception)e, (Object[])args);
                        response.responseData = null;
                    }
                    if (accessor3 != null) {
                        try {
                            NameList list = accessor3.selectNames(glr);
                            response.responseData = NameList.packList((NameList)list);
                        }
                        catch (GeneralException e) {
                            if (TraceLogger.enableTrace) {
                                TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"handle", (Throwable)e);
                            }
                            Server.setResponseError(response, (Exception)((Object)e));
                        }
                    }
                }
            }
        }
        Server.returnConnection(dbc);
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiListHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    private NameList getFabrics() throws Exception {
        NameList firstFabric = null;
        NameList lastFabric = null;
        Fabric.FabricCursor cursor = null;
        DBConnection dbConnection = null;
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            dbConnection = (DBConnection)ds.getPooledConnection();
            dbConnection.setAutoCommit(true);
            Hashtable whereClause = null;
            Vector columns = null;
            cursor = Fabric.getCursor((DBConnection)dbConnection, whereClause, columns);
            while (cursor.next()) {
                Fabric tempFabric = cursor.getObject();
                NameList item = new NameList();
                item.nlInfo = (short)114;
                item.nlID = tempFabric.getFabricId();
                String displayName = tempFabric.getDisplayName();
                String fabricName = tempFabric.getName();
                item.nlName = displayName != null && !displayName.equals("") ? displayName : (fabricName != null && !fabricName.equals("") ? "Fabric." + fabricName : "Fabric." + tempFabric.getFabricWwn());
                if (lastFabric != null) {
                    lastFabric.nlNext = item;
                } else {
                    firstFabric = item;
                }
                lastFabric = item;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            cursor.close();
            dbConnection.close();
        }
        return firstFabric;
    }

    public static void getNasFsList(Connection dbc, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiListHndlr.class.getName(), (String)"getNasFsList", (String)"dbc, response");
        }
        try {
            Object[] result = new Object[3];
            TFoundFilesystem fsAccessor = new TFoundFilesystem(dbc);
            result[0] = fsAccessor.getNasFilesystems();
            TResShare shAccessor = new TResShare(dbc);
            result[1] = shAccessor.getTreeAgents();
            TStatComputer compAccessor = new TStatComputer(dbc);
            result[2] = NameList.packList((NameList)compAccessor.selectAgents());
            response.responseData = result;
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GuiListHndlr.class.getName(), (String)"getNasFsList", (Throwable)e);
            }
            Server.setResponseError(response, (Exception)((Object)e));
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiListHndlr.class.getName(), (String)"getNasFsList");
        }
    }

    public static void getManNasList(Connection dbc, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"GuiListHndlr", (String)"getManNasList", (String)"dbc, response");
        }
        try {
            Object[] result = new Object[3];
            TResShare shAccessor = new TResShare(dbc);
            result[0] = shAccessor.getManualNasEntries();
            TResLdapTree treeAccessor = new TResLdapTree(dbc);
            LdapTree[] trees = treeAccessor.getPackedTree();
            TResPwd pwdAccessor = new TResPwd(dbc);
            String[] defaultLogin = pwdAccessor.getDefaultLogin();
            pwdAccessor = null;
            if (defaultLogin == null && trees != null && trees.length > 0) {
                LdapTree tempTree;
                int goodCnt = 0;
                for (int i = 0; i < trees.length; ++i) {
                    tempTree = trees[i];
                    if (Util.isEmpty((String)tempTree.ltLdapUser) || Util.isEmpty((String)tempTree.ltPassword)) continue;
                    ++goodCnt;
                }
                LdapTree[] goodTrees = new LdapTree[goodCnt];
                goodCnt = 0;
                for (int i = 0; i < trees.length; ++i) {
                    tempTree = trees[i];
                    if (Util.isEmpty((String)tempTree.ltLdapUser) || Util.isEmpty((String)tempTree.ltPassword)) continue;
                    goodTrees[goodCnt++] = tempTree;
                }
                trees = goodTrees;
            }
            result[1] = trees;
            GuiListReq glr = new GuiListReq();
            glr.excludeNAS = true;
            glr.excludeVS = true;
            glr.excludeUnder21 = true;
            result[2] = GuiListHndlr.getAgentList(glr);
            response.responseData = result;
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)"GuiListHndlr", (String)"getManNasList", (Throwable)e);
            }
            Server.setResponseError(response, (Exception)((Object)e));
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"GuiListHndlr", (String)"getManNasList");
        }
    }

    private static Serializable getAgentList(GuiListReq glr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiListHndlr.class.getName(), (String)"getAgentList", (String)"glr");
        }
        NameList list = null;
        NameList item = null;
        AgentManager.AgentAddress agentNode = new AgentManager.AgentAddress();
        Iterator i = Server.agentMgr.listAgents(agentNode);
        while (i.hasNext()) {
            agentNode = (AgentManager.AgentAddress)i.next();
            if (agentNode.computerID <= 0 || agentNode.state == 2 || glr.excludeNAS && Constants.isNasBox((short)agentNode.osType) || glr.excludeVS && Constants.isVirtualServer((int)agentNode.osType) || glr.excludeUnder21 && agentNode.softwareVersion < SoftwareVersion.VERSION_2_1_0) continue;
            item = new NameList();
            item.nlName = agentNode.tsName;
            item.nlID = agentNode.computerID;
            item.nlID2 = agentNode.softwareVersion;
            item.nlID3 = agentNode.osType;
            item.nlNext = list;
            list = item;
        }
        NameList[] array = NameList.packList(list);
        Arrays.sort(array, new NameSorter());
        NameList[] traceResult = array;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiListHndlr.class.getName(), (String)"getAgentList", (Object)traceResult);
        }
        return traceResult;
    }

    private NameListQueryable getAccessor(Class accessorClass, Connection connection) throws Exception {
        Constructor<?> connectionConstructor = null;
        Constructor<?>[] constructors = accessorClass.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> c = constructors[i];
            Class<?>[] parameterTypes = c.getParameterTypes();
            if (parameterTypes.length != 1 || !parameterTypes[0].equals(Connection.class)) continue;
            connectionConstructor = c;
            break;
        }
        if (connectionConstructor != null) {
            return (NameListQueryable)connectionConstructor.newInstance(connection);
        }
        return (NameListQueryable)accessorClass.newInstance();
    }

    private static class NameSorter
    implements Comparator {
        private NameSorter() {
        }

        public int compare(Object o1, Object o2) {
            NameList r1 = (NameList)o1;
            NameList r2 = (NameList)o2;
            int traceResult = r1.nlName.compareTo(r2.nlName);
            return traceResult;
        }
    }
}

