/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.TStorm.common.Script;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListSaver;
import org.eclipse.aperi.repository.RaceConditionChecker;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.repository.table.TSchedule;
import org.eclipse.aperi.repository.table.TScript;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.guireq.ResourceAttribute;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiScriptHndlr
implements RequestHandler,
ThrowAway {
    private Connection dbc;
    private Response response;
    private Script newScript;
    public static final String SCRIPT_JOB_TYPE = "SCRIPT";
    public static final String SCRIPT_JOB_TYPE_LABEL = MessageLog.getMessageNoID((String)"STS0106L");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiScriptHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        this.response = Response.getResponse((short)0, null);
        if (RequestChecker.isDesiredType(Script.class, (Request)request, (Response)this.response)) {
            this.newScript = (Script)request.requestData;
            this.dbc = Server.getConnection();
            if (this.dbc == null) {
                this.response.status = (short)12;
            } else {
                String resourceName;
                boolean forRetrieve = this.newScript.isEmpty();
                if (this.newScript.ID <= 0) {
                    resourceName = null;
                } else {
                    resourceName = Integer.toString(this.newScript.ID);
                    byte lockType = forRetrieve ? (byte)2 : 1;
                    LockManager.lock((short)0, (String)SCRIPT_JOB_TYPE, (String)resourceName, (byte)lockType, (boolean)true);
                }
                try {
                    if (forRetrieve) {
                        this.response.responseData = this.retrieve();
                    } else {
                        this.save();
                        this.response.responseData = this.newScript;
                    }
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiScriptHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    if (this.response.status <= 4) {
                        this.response.status = (short)12;
                    }
                    this.response.errorMessage = e.getMessage();
                }
                finally {
                    if (resourceName != null) {
                        LockManager.unLock((short)0, (String)SCRIPT_JOB_TYPE, (String)resourceName);
                    }
                    Server.returnConnection(this.dbc);
                }
            }
        }
        Response traceResult = this.response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiScriptHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    private Serializable retrieve() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiScriptHndlr.class.getName(), (String)"retrieve", (String)"");
        }
        if (this.newScript.ID > 0) {
            TSchedule parentAccessor = new TSchedule(this.dbc);
            parentAccessor.retrieve((ScheduleHeader)this.newScript, SCRIPT_JOB_TYPE_LABEL);
            int ID = this.newScript.ID;
            TScript scriptAccessor = new TScript(this.dbc);
            this.newScript.scrName = scriptAccessor.select(ID);
            TStatComputer compAccessor = new TStatComputer(this.dbc);
            this.newScript.scrComputers = compAccessor.queryDependents(ID);
            TResAttr accessor = new TResAttr(this.dbc);
            this.newScript.scrAllComputers = NameListSaver.allObjectsSelected(accessor, ID, (short)67);
            this.newScript.scrComputerGroups = accessor.queryDependents("t_group", "group_id", ID, (short)0);
            TAlertDefinition alertAccessor = new TAlertDefinition(this.dbc);
            alertAccessor.prepSelectByID(false, false);
            this.newScript.scrAlert = alertAccessor.getByID(ID);
            alertAccessor.closeSelect();
        }
        String scriptsDir = System.getProperty("user.dir") + File.separatorChar + "scripts";
        File dir = new File(scriptsDir);
        this.newScript.nameArray = dir.list();
        if (this.newScript.nameArray == null) {
            this.newScript.nameArray = new String[0];
        }
        Script traceResult = this.newScript;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiScriptHndlr.class.getName(), (String)"retrieve", (Object)traceResult);
        }
        return traceResult;
    }

    private void save() throws GeneralException {
        boolean rowExists;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiScriptHndlr.class.getName(), (String)"save", (String)"");
        }
        TScript scriptAccessor = null;
        String checkerWarning = null;
        Script currentDefinition = new Script(67);
        if (this.newScript.ID <= 0) {
            this.newScript.ID = StorageRepositoryAccessor.getIdentifier(1, 1, this.dbc);
            rowExists = false;
        } else {
            RaceConditionChecker checker = new RaceConditionChecker(this.dbc, "t_schedule", TSchedule.ID_COLUMN_NAME, (CreateHeader)this.newScript, SCRIPT_JOB_TYPE_LABEL);
            checker.check();
            checkerWarning = checker.message;
            rowExists = !checker.wasDeleted;
            checker = null;
            if (rowExists) {
                scriptAccessor = new TScript(this.dbc);
                currentDefinition.scrName = scriptAccessor.select(this.newScript.ID);
                TResAttr accessor = new TResAttr(this.dbc);
                accessor.prepQueryByAttr();
                ResourceAttribute attr = new ResourceAttribute();
                attr.raAttributeID = this.newScript.ID;
                attr.raAttributeType = (short)67;
                attr.raResourceType = 1;
                currentDefinition.scrComputers = accessor.getResAttr(attr);
                attr.raResourceType = 0;
                currentDefinition.scrComputerGroups = accessor.getResAttr(attr);
                attr.raResourceType = (short)13;
                currentDefinition.scrAllComputers = accessor.getResAttr(attr) != null;
                accessor.closeSelect();
            }
        }
        this.newScript.alertID = this.newScript.ID;
        TAlertDefinition alertAccessor = new TAlertDefinition(this.dbc);
        if (rowExists) {
            alertAccessor.deleteByID(this.newScript.ID);
        }
        alertAccessor.insert((CreateHeader)this.newScript, this.newScript.scrAlert);
        TSchedule parentAccessor = new TSchedule(this.dbc);
        if (rowExists) {
            parentAccessor.deleteByID(this.newScript.ID, SCRIPT_JOB_TYPE_LABEL);
            if (!this.newScript.scrName.equals(currentDefinition.scrName)) {
                scriptAccessor.update(this.newScript);
            }
        } else {
            scriptAccessor = new TScript(this.dbc);
            scriptAccessor.insert(this.newScript);
        }
        ScheduleQueue.routine.getHighRunNumber((ScheduleHeader)this.newScript);
        parentAccessor.insert((ScheduleHeader)this.newScript, SCRIPT_JOB_TYPE_LABEL);
        NameList[] newDef = new NameList[]{this.newScript.scrComputers, this.newScript.scrComputerGroups};
        NameList[] oldDef = new NameList[]{currentDefinition.scrComputers, currentDefinition.scrComputerGroups};
        NameListSaver nlSaver = new NameListSaver(this.dbc, this.response);
        nlSaver.saveAllObjectsSelected(this.newScript.scrAllComputers, this.newScript.ID, (short)67);
        nlSaver.save((CreateHeader)this.newScript, SCRIPT_JOB_TYPE_LABEL, (short)67, this.newScript.ID, newDef, oldDef, this.createTablesMap(), rowExists);
        if (rowExists) {
            ScheduleQueue.routine.addEdit((ScheduleHeader)this.newScript);
        } else {
            ScheduleQueue.routine.addCreate((ScheduleHeader)this.newScript);
        }
        if (checkerWarning != null) {
            this.response.status = (short)4;
            this.response.errorMessage = checkerWarning;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiScriptHndlr.class.getName(), (String)"save");
        }
    }

    private Map createTablesMap() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiScriptHndlr.class.getName(), (String)"createTablesMap", (String)"");
        }
        HashMap map = new HashMap();
        this.fillMap(map, (short)1, "t_stat_computer", "computer_id");
        this.fillMap(map, (short)0, "t_group", "group_id");
        HashMap traceResult = map;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiScriptHndlr.class.getName(), (String)"createTablesMap", traceResult);
        }
        return traceResult;
    }

    private void fillMap(Map map, short resourceType, String tableName, String idColumnName) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiScriptHndlr.class.getName(), (String)"fillMap", (String)"map, resourceType, tableName, idColumnName");
        }
        MutableInteger key = new MutableInteger((int)resourceType);
        String[] value = new String[]{tableName, idColumnName};
        map.put(key, value);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiScriptHndlr.class.getName(), (String)"fillMap");
        }
    }
}

