/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.aperi.TStorm.server.guireq.GuiSelectionReq;
import org.eclipse.aperi.TStorm.server.guireq.RespSelectionObject;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiSelectionHndlr
implements RequestHandler,
ThrowAway {
    static final String directorySelect = "select d.directory_id,        f.computer_id,         d.name          from   t_stat_directory d,        t_res_filesystem f  where  d.filesystem_id = f.filesystem_id";
    static final String filesystemSelect = "select f.computer_id,          f.filesystem_id,        f.mount_point,          f.capacity,             f.free_space     from   t_res_filesystem f ";
    static final String computerSelect = "select os_type, computer_id, manufacturer, cpu_architecture from t_stat_computer";
    static final String groupSelect = "select group_id, creator, name, description, group_type from t_group where group_type = ? ";
    static final String domainSelect = "select domain_id,        name       from   t_res_domain";
    static final String quotaSelect = "select q.quota_id,           q.creator,            q.name,               q.quota_type,         q.description,        s.creator,            s.name         from   t_quota_definition q,        t_stat_definition  s  where  q.statistic_id = s.statistic_id";
    static final String diskSelect = "select d.device_id,          s.computer_id,        d.path         from   t_res_dev_access d,        t_stat_disk      z,        t_res_share      s,        t_res_controller c  where  s.resource_type = 10 and   s.resource_id   = d.device_id     and   s.resource_id   = z.disk_id       and   s.computer_id   = c.computer_id   and   d.controller_id = c.controller_id and   z.logical_disk_id < 0 union select pv.physical_volume_id, ss.subsystem_id, pv.name from t_res_physical_volume pv, t_res_storage_subsystem ss where pv.subsystem_id = ss.subsystem_id  union select se.storage_extent_id, ss.subsystem_id,  se.element_name from t_res_storage_extent se, t_res_storage_subsystem ss where se.subsystem_id = ss.subsystem_id and ss.os_type = 21";
    static final String diskArraySelect = "select subsystem_id,  case when user_provided_name is not null  and user_provided_name <> ''  then user_provided_name else display_name end display_name  from   t_res_storage_subsystem";
    static final String diskArrayDiskSelect = "select d.device_id,       case when a.user_provided_name is not null  and a.user_provided_name <> ''  then a.user_provided_name else a.display_name end display_name,        d.path            from   t_res_dev_access d,        t_res_disk_group n,        t_res_storage_subsystem a  where  n.subsystem_id   = a.subsystem_id and   d.controller_id = n.disk_group_id";
    static final String lunSelect = "select s.resource_id,     case when a.user_provided_name is not null  and a.user_provided_name <> ''  then a.user_provided_name else a.display_name end display_name,        s.path,                  s.name            from   t_res_storage_subsystem a,        t_res_share      s  where  s.resource_type = 11 and   s.computer_id   = a.subsystem_id";
    static final String instanceSelect = "select rdbms_id,      computer_id,   rdbms_name,    rdbms_type,    rdbms_version from   t_res_rdbms";
    static final String databaseSelect = "select d.database_id, r.computer_id, r.rdbms_name,  d.name,        r.rdbms_type,  u.full_name,   d.total_size,  d.freespace   from   t_res_database  d,        t_res_rdbms     r,        t_res_comp_user u  where  d.rdbms_id = r.rdbms_id  and   d.owner_id = u.user_id";
    static final String tablespaceSelect = "select t.tablespace_id, r.computer_id,   r.rdbms_name,    d.name,          t.name,          r.rdbms_type,    u.full_name,     t.total_size,    t.freespace     from   t_res_tablespace t,        t_res_database   d,        t_res_rdbms      r,        t_res_comp_user  u  where  t.database_id = d.database_id  and   d.rdbms_id    = r.rdbms_id     and   d.owner_id    = u.user_id";
    static final String datafileSelect = "select f.file_id,     r.computer_id, r.rdbms_name,  d.name,        t.name,        f.name,        r.rdbms_type,  t.total_size,  t.freespace   from   t_res_datafile   f,        t_res_tablespace t,        t_res_database   d,        t_res_rdbms      r  where  f.tablespace_id = t.tablespace_id  and   t.database_id   = d.database_id    and   d.rdbms_id      = r.rdbms_id";
    static final String tableSelect = "select t.statistic_id, r.computer_id,  r.rdbms_name,   d.name,         u.full_name,    t.name,         s.name,         t.total_size,   t.unused_space, t.partitions,   t.indexes      from   t_stat_table     t,        t_res_tablespace s,        t_res_database   d,        t_res_rdbms      r,        t_res_comp_user  u  where  t.statistic_type = '1'              and   t.tablespace_id  = s.tablespace_id  and   s.database_id    = d.database_id    and   d.rdbms_id       = r.rdbms_id       and   t.creator_id     = u.user_id";
    static final String deviceSelect = "select d.device_id,   r.computer_id, r.rdbms_name,  d.name,        r.rdbms_type,  d.capacity,    d.freespace   from   t_res_dbdevice   d,        t_res_rdbms      r  where  d.rdbms_id       = r.rdbms_id";
    static final String dbmsTypeSelect = "select distinct r.rdbms_type   from   t_res_rdbms r";
    private static final String GOOD_LDTYPES = " and l.logical_disk_type not in ('7', '4')";
    private static final String noFSLogicalDiskSelect = "select l.logical_disk_id, r.host_name, s.path from t_res_logical_disk l, t_res_host r, t_res_share s, t_stat_computer c where s.resource_type = 11 and s.resource_id = l.logical_disk_id and s.computer_id = c.computer_id and r.computer_id = s.computer_id and r.computer_id = c.computer_id and l.logical_disk_type not in ('7', '4') and l.logical_disk_id not in (select logical_disk_id from t_res_filesystem) order by 1";
    private static final String fsLogicalDiskSelect = "select f.logical_disk_id, r.host_name, f.mount_point from t_res_filesystem f, t_res_host r, t_res_logical_disk l where r.computer_id = f.computer_id and l.logical_disk_id = f.logical_disk_id and l.logical_disk_type not in ('7', '4')";
    private static final String fileTypeSelect = "select file_type_id, file_extension, description from t_file_type";
    static final String COMPUTER = MessageLog.getMessageNoID((String)"STS0054I");
    static final String FILESYSTEM = MessageLog.getMessageNoID((String)"STS0067I");
    static final String NETWORK_WIDE = MessageLog.getMessageNoID((String)"STS0141L");
    private Connection connection;
    private ResultSet results;
    private Statement statement;
    private PreparedStatement pStatement;
    private RespSelectionObject head;
    private int count;

    /*
     * Unable to fully structure code
     */
    public Response handle(Request request, Transceiver transceiver) {
        block29: {
            block32: {
                block33: {
                    block31: {
                        block30: {
                            if (TraceLogger.enableTrace) {
                                TraceLogger.entry((String)GuiSelectionHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
                            }
                            this.connection = null;
                            this.statement = null;
                            this.results = null;
                            this.head = null;
                            this.count = 0;
                            errorMsg = null;
                            response = Response.getResponse((short)0, null);
                            if (!RequestChecker.isDesiredType(GuiSelectionReq.class, (Request)request, (Response)response)) break block29;
                            gsr = (GuiSelectionReq)request.requestData;
                            response.responseData = gsr;
                            this.connection = Server.getConnection();
                            if (this.connection != null) break block30;
                            args = new Object[]{"GuiSelectionHndlr.handle"};
                            errorMsg = MessageLog.getMessageNoID((String)"SRV0102E", (Object[])args);
                            break block29;
                        }
                        gsr.computerColumn = 0;
                        gsr.appendUserComputerColumn = 0;
                        if (gsr.objectType != 3) break block31;
                        errorMsg = this.getFilesystems(gsr);
                        break block32;
                    }
                    if (gsr.objectType != 4) break block33;
                    errorMsg = this.getGroups(gsr, (short)2);
                    break block32;
                }
                if (gsr.objectType == 5) ** GOTO lbl-1000
                if (gsr.objectType == 21) ** GOTO lbl-1000
                if (gsr.objectType == 29) lbl-1000:
                // 3 sources

                {
                    errorMsg = this.getComputers(gsr);
                } else if (gsr.objectType == 6) {
                    errorMsg = this.getGroups(gsr, (short)0);
                } else if (gsr.objectType == 28) {
                    errorMsg = this.getGroups(gsr, (short)99);
                } else if (gsr.objectType == 7) {
                    errorMsg = this.getDomains(gsr);
                } else if (gsr.objectType == 11) {
                    errorMsg = this.getDisks(gsr);
                } else if (gsr.objectType == 24) {
                    errorMsg = this.getDiskArrays(gsr);
                } else if (gsr.objectType == 26) {
                    errorMsg = this.getDiskArrayDisks(gsr);
                } else if (gsr.objectType == 25) {
                    errorMsg = this.getLuns(gsr);
                } else if (gsr.objectType == 27) {
                    errorMsg = this.getLogicalVolumes(gsr);
                }
            }
            this.packItUp(gsr);
        }
        if (this.results != null) {
            block27: {
                try {
                    this.results.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block27;
                    TraceLogger.exception((String)GuiSelectionHndlr.class.getName(), (String)"handle", (Throwable)ignored);
                }
            }
            this.results = null;
        }
        if (this.statement != null) {
            block28: {
                try {
                    this.statement.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block28;
                    TraceLogger.exception((String)GuiSelectionHndlr.class.getName(), (String)"handle", (Throwable)ignored);
                }
            }
            this.statement = null;
        }
        if (this.connection != null) {
            Server.returnConnection(this.connection);
            this.connection = null;
        }
        if (errorMsg != null) {
            response.status = (short)12;
            response.responseData = null;
            response.errorMessage = errorMsg;
        }
        traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiSelectionHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    private void packItUp(GuiSelectionReq gsr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiSelectionHndlr.class.getName(), (String)"packItUp", (String)"gsr");
        }
        RespSelectionObject[] objectHdr = new RespSelectionObject[this.count];
        this.count = 0;
        while (this.head != null) {
            RespSelectionObject next = this.head.next;
            this.head.next = null;
            objectHdr[this.count] = this.head;
            ++this.count;
            this.head = next;
        }
        gsr.objectHdr = objectHdr;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiSelectionHndlr.class.getName(), (String)"packItUp");
        }
    }

    private String getFilesystems(GuiSelectionReq gsr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiSelectionHndlr.class.getName(), (String)"getFilesystems", (String)"gsr");
        }
        String errorMsg = "SRV0103E";
        String newSelect = filesystemSelect;
        gsr.numberColumns = 5;
        gsr.nameArray = RespSelectionObject.FILESYSTEM_NAMES;
        gsr.typeArray = RespSelectionObject.FILESYSTEM_TYPES;
        gsr.computerColumn = 1;
        gsr.sortColumns = 2;
        try {
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(newSelect);
            errorMsg = "SRV0104E";
            while (this.results.next()) {
                int computerID = this.results.getInt(1);
                RespSelectionObject node = new RespSelectionObject();
                node.stringArray = new String[gsr.numberColumns];
                node.longArray = new long[gsr.numberColumns];
                node.CID = computerID;
                node.ID = this.results.getInt(2);
                node.stringArray[2] = this.results.getString(3);
                node.longArray[3] = this.results.getLong(4) * 512L;
                node.longArray[4] = this.results.getLong(5) * 512L;
                node.next = this.head;
                this.head = node;
                ++this.count;
            }
            errorMsg = null;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GuiSelectionHndlr.class.getName(), (String)"getFilesystems", (Throwable)e);
            }
            Object[] args = new Object[]{"t_res_filesystem", "GuiSelectionHndlr.getFilesystems"};
            errorMsg = SQLUtil.getSQLExceptionMsg(errorMsg, e, args);
        }
        String traceResult = errorMsg;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiSelectionHndlr.class.getName(), (String)"getFilesystems", (Object)traceResult);
        }
        return traceResult;
    }

    /*
     * Unable to fully structure code
     */
    private String getComputers(GuiSelectionReq gsr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiSelectionHndlr.class.getName(), (String)"getComputers", (String)"gsr");
        }
        errorMsg = "SRV0103E";
        newSelect = "select os_type, computer_id, manufacturer, cpu_architecture from t_stat_computer";
        gsr.numberColumns = 5;
        gsr.nameArray = RespSelectionObject.COMPUTER_NAMES;
        gsr.typeArray = RespSelectionObject.COMPUTER_TYPES;
        gsr.computerColumn = 1;
        gsr.sortColumns = 1;
        if (gsr.productCode != 1) ** GOTO lbl-1000
        if (gsr.objectType != 21) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        nasOK = v0;
        vsOK = true;
        if (gsr.objectType == 29) {
            vsOK = false;
            nasOK = false;
        }
        try {
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(newSelect);
            errorMsg = "SRV0104E";
            while (this.results.next()) {
                osType = this.results.getShort(1);
                if (!nasOK && Constants.isNasBox((short)osType) || !vsOK && Constants.isVirtualServer((int)osType)) continue;
                computerID = this.results.getInt(2);
                node = new RespSelectionObject();
                node.next = this.head;
                this.head = node;
                node.stringArray = new String[gsr.numberColumns];
                node.ID = computerID;
                node.CID = computerID;
                str = this.results.getString(3);
                node.stringArray[2] = str.trim().equalsIgnoreCase("unknown") != false ? MessageLog.getMessageNoID((String)"STG1020L") : str;
                node.stringArray[3] = MessageLog.getMessageNoID((String)Constants.OSTYPES[osType]);
                cpuArch = this.results.getShort(4);
                node.stringArray[4] = Constants.getCPUArchDisplayName((int)cpuArch);
                ++this.count;
            }
            errorMsg = null;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GuiSelectionHndlr.class.getName(), (String)"getComputers", (Throwable)e);
            }
            args = new Object[]{"t_stat_computer, t_res_host", "GuiSelectionHndlr.getComputers"};
            errorMsg = SQLUtil.getSQLExceptionMsg(errorMsg, e, args);
        }
        traceResult = errorMsg;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiSelectionHndlr.class.getName(), (String)"getComputers", (Object)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGroups(GuiSelectionReq gsr, short type) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiSelectionHndlr.class.getName(), (String)"getGroups", (String)"gsr, type");
        }
        String errorMsg = "SRV0103E";
        if (gsr.objectType == 28) {
            gsr.numberColumns = 3;
            gsr.nameArray = RespSelectionObject.CLUSTER_NAMES;
            gsr.typeArray = RespSelectionObject.CLUSTER_TYPES;
            gsr.sortColumns = 1;
        } else {
            gsr.numberColumns = 5;
            gsr.nameArray = RespSelectionObject.RPT_GROUP_NAMES;
            gsr.typeArray = RespSelectionObject.RPT_GROUP_TYPES;
            gsr.sortColumns = 2;
        }
        try {
            switch (type) {
                case 0: 
                case 2: {
                    String extendedSelect = "select group_id, creator, name, description, group_type from t_group where group_type = ?  or group_type = ?";
                    this.pStatement = this.connection.prepareStatement(extendedSelect);
                    this.pStatement.setShort(1, type);
                    switch (type) {
                        case 2: {
                            this.pStatement.setInt(2, 90);
                            break;
                        }
                        case 0: {
                            this.pStatement.setInt(2, 89);
                        }
                    }
                    break;
                }
                default: {
                    this.pStatement = this.connection.prepareStatement(groupSelect);
                    this.pStatement.setShort(1, type);
                }
            }
            this.results = this.pStatement.executeQuery();
            errorMsg = "SRV0104E";
            while (this.results.next()) {
                RespSelectionObject node = new RespSelectionObject();
                node.next = this.head;
                this.head = node;
                node.stringArray = new String[gsr.numberColumns];
                node.ID = this.results.getInt(1);
                if (gsr.objectType == 28) {
                    node.stringArray[1] = this.results.getString(3);
                    node.stringArray[2] = ResourceTypeManager.getName((short)this.results.getShort(5));
                } else {
                    node.stringArray[1] = this.results.getString(2);
                    node.stringArray[2] = this.results.getString(3);
                    node.stringArray[3] = this.results.getString(4);
                    node.stringArray[4] = this.results.getInt(5) == type ? MessageLog.getMessageNoID((String)"STS0807L") : MessageLog.getMessageNoID((String)"STS0806L");
                }
                ++this.count;
            }
            errorMsg = null;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GuiSelectionHndlr.class.getName(), (String)"getGroups", (Throwable)e);
            }
            Object[] args = new Object[]{"t_group", "GuiSelectionHndlr.getGroups"};
            errorMsg = SQLUtil.getSQLExceptionMsg(errorMsg, e, args);
        }
        finally {
            block27: {
                try {
                    this.results.close();
                    this.pStatement.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block27;
                    TraceLogger.exception((String)GuiSelectionHndlr.class.getName(), (String)"getGroups", (Throwable)ignored);
                }
            }
        }
        String traceResult = errorMsg;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiSelectionHndlr.class.getName(), (String)"getGroups", (Object)traceResult);
        }
        return traceResult;
    }

    private String getDomains(GuiSelectionReq gsr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiSelectionHndlr.class.getName(), (String)"getDomains", (String)"gsr");
        }
        String errorMsg = "SRV0103E";
        String newSelect = domainSelect;
        gsr.numberColumns = 2;
        gsr.nameArray = RespSelectionObject.DOMAIN_NAMES;
        gsr.typeArray = RespSelectionObject.DOMAIN_TYPES;
        gsr.sortColumns = 1;
        try {
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(newSelect);
            errorMsg = "SRV0104E";
            while (this.results.next()) {
                RespSelectionObject node = new RespSelectionObject();
                node.next = this.head;
                this.head = node;
                node.stringArray = new String[gsr.numberColumns];
                node.ID = this.results.getInt(1);
                node.stringArray[1] = this.results.getString(2);
                ++this.count;
            }
            errorMsg = null;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GuiSelectionHndlr.class.getName(), (String)"getDomains", (Throwable)e);
            }
            Object[] args = new Object[]{"t_res_domain", "GuiSelectionHndlr.getDomains"};
            errorMsg = SQLUtil.getSQLExceptionMsg(errorMsg, e, args);
        }
        String traceResult = errorMsg;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiSelectionHndlr.class.getName(), (String)"getDomains", (Object)traceResult);
        }
        return traceResult;
    }

    private String getDisks(GuiSelectionReq gsr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiSelectionHndlr.class.getName(), (String)"getDisks", (String)"gsr");
        }
        String errorMsg = "SRV0103E";
        gsr.numberColumns = 3;
        gsr.nameArray = RespSelectionObject.DISK_NAMES;
        gsr.typeArray = RespSelectionObject.DISK_TYPES;
        gsr.computerColumn = 1;
        gsr.sortColumns = 2;
        try {
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(diskSelect);
            errorMsg = "SRV0104E";
            while (this.results.next()) {
                RespSelectionObject node = new RespSelectionObject();
                node.next = this.head;
                this.head = node;
                node.stringArray = new String[gsr.numberColumns];
                node.ID = this.results.getInt(1);
                node.CID = this.results.getInt(2);
                node.stringArray[2] = this.results.getString(3);
                ++this.count;
            }
            errorMsg = null;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GuiSelectionHndlr.class.getName(), (String)"getDisks", (Throwable)e);
            }
            Object[] args = new Object[]{"t_res_dev_access, t_res_share, t_res_controller", "GuiSelectionHndlr.getDisks"};
            errorMsg = SQLUtil.getSQLExceptionMsg(errorMsg, e, args);
        }
        String traceResult = errorMsg;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiSelectionHndlr.class.getName(), (String)"getDisks", (Object)traceResult);
        }
        return traceResult;
    }

    private String getDiskArrays(GuiSelectionReq gsr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiSelectionHndlr.class.getName(), (String)"getDiskArrays", (String)"gsr");
        }
        String errorMsg = "SRV0103E";
        gsr.numberColumns = 2;
        gsr.nameArray = RespSelectionObject.DISK_ARRAY_NAMES;
        gsr.typeArray = RespSelectionObject.DISK_ARRAY_TYPES;
        gsr.sortColumns = 1;
        try {
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(diskArraySelect);
            errorMsg = "SRV0104E";
            while (this.results.next()) {
                RespSelectionObject node = new RespSelectionObject();
                node.next = this.head;
                this.head = node;
                node.stringArray = new String[gsr.numberColumns];
                node.ID = this.results.getInt(1);
                node.stringArray[1] = this.results.getString(2);
                ++this.count;
            }
            errorMsg = null;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GuiSelectionHndlr.class.getName(), (String)"getDiskArrays", (Throwable)e);
            }
            Object[] args = new Object[]{"t_res_storage_subsystem", "GuiSelectionHndlr.getDiskArrays"};
            errorMsg = SQLUtil.getSQLExceptionMsg(errorMsg, e, args);
        }
        String traceResult = errorMsg;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiSelectionHndlr.class.getName(), (String)"getDiskArrays", (Object)traceResult);
        }
        return traceResult;
    }

    private String getDiskArrayDisks(GuiSelectionReq gsr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiSelectionHndlr.class.getName(), (String)"getDiskArrayDisks", (String)"gsr");
        }
        String errorMsg = "SRV0103E";
        gsr.numberColumns = 3;
        gsr.nameArray = RespSelectionObject.DISK_ARRAY_DISK_NAMES;
        gsr.typeArray = RespSelectionObject.DISK_ARRAY_DISK_TYPES;
        gsr.sortColumns = 2;
        try {
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(diskArrayDiskSelect);
            errorMsg = "SRV0104E";
            while (this.results.next()) {
                RespSelectionObject node = new RespSelectionObject();
                node.next = this.head;
                this.head = node;
                node.stringArray = new String[gsr.numberColumns];
                node.ID = this.results.getInt(1);
                node.stringArray[1] = this.results.getString(2);
                node.stringArray[2] = this.results.getString(3);
                ++this.count;
            }
            errorMsg = null;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GuiSelectionHndlr.class.getName(), (String)"getDiskArrayDisks", (Throwable)e);
            }
            Object[] args = new Object[]{"t_res_dev_access, t_res_disk_group, t_res_storage_subsystem, GuiSelectionHndlr.getDiskArrayDisks"};
            errorMsg = SQLUtil.getSQLExceptionMsg(errorMsg, e, args);
        }
        String traceResult = errorMsg;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiSelectionHndlr.class.getName(), (String)"getDiskArrayDisks", (Object)traceResult);
        }
        return traceResult;
    }

    private String selectLogicalVolumes(GuiSelectionReq gsr, String sqlText) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiSelectionHndlr.class.getName(), (String)"selectLogicalVolumes", (String)"gsr, sqlText");
        }
        String errorMsg = "SRV0103E";
        int lastID = -1;
        try {
            if (this.statement == null) {
                this.statement = this.connection.createStatement();
            }
            this.results = this.statement.executeQuery(sqlText);
            errorMsg = "SRV0104E";
            while (this.results.next()) {
                int id = this.results.getInt(1);
                if (id == lastID) continue;
                lastID = id;
                RespSelectionObject node = new RespSelectionObject();
                node.next = this.head;
                this.head = node;
                node.stringArray = new String[gsr.numberColumns];
                node.ID = id;
                node.stringArray[1] = this.results.getString(2);
                node.stringArray[2] = this.results.getString(3);
                ++this.count;
            }
            errorMsg = null;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GuiSelectionHndlr.class.getName(), (String)"selectLogicalVolumes", (Throwable)e);
            }
            Object[] args = new Object[]{"t_res_logical_disk", "GuiSelectionHndlr.selectLogicalVolumes"};
            errorMsg = SQLUtil.getSQLExceptionMsg(errorMsg, e, args);
        }
        if (this.results != null) {
            block10: {
                try {
                    this.results.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block10;
                    TraceLogger.exception((String)GuiSelectionHndlr.class.getName(), (String)"selectLogicalVolumes", (Throwable)ignored);
                }
            }
            this.results = null;
        }
        String traceResult = errorMsg;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiSelectionHndlr.class.getName(), (String)"selectLogicalVolumes", (Object)traceResult);
        }
        return traceResult;
    }

    private String getLogicalVolumes(GuiSelectionReq gsr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiSelectionHndlr.class.getName(), (String)"getLogicalVolumes", (String)"gsr");
        }
        gsr.numberColumns = 3;
        gsr.nameArray = RespSelectionObject.FSLV_NAMES;
        gsr.typeArray = RespSelectionObject.FSLV_TYPES;
        gsr.sortColumns = 2;
        String errorMsg = this.selectLogicalVolumes(gsr, noFSLogicalDiskSelect);
        if (errorMsg == null) {
            errorMsg = this.selectLogicalVolumes(gsr, fsLogicalDiskSelect);
        }
        String traceResult = errorMsg;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiSelectionHndlr.class.getName(), (String)"getLogicalVolumes", (Object)traceResult);
        }
        return traceResult;
    }

    private String getLuns(GuiSelectionReq gsr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiSelectionHndlr.class.getName(), (String)"getLuns", (String)"gsr");
        }
        String errorMsg = "SRV0103E";
        gsr.numberColumns = 3;
        gsr.nameArray = RespSelectionObject.LUN_NAMES;
        gsr.typeArray = RespSelectionObject.LUN_TYPES;
        gsr.sortColumns = 2;
        try {
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(lunSelect);
            errorMsg = "SRV0104E";
            while (this.results.next()) {
                RespSelectionObject node = new RespSelectionObject();
                node.next = this.head;
                this.head = node;
                node.stringArray = new String[gsr.numberColumns];
                node.ID = this.results.getInt(1);
                node.stringArray[1] = this.results.getString(2);
                String path = this.results.getString(3);
                String name = this.results.getString(4);
                node.stringArray[2] = Util.isEmpty((String)name) ? path : name;
                ++this.count;
            }
            errorMsg = null;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GuiSelectionHndlr.class.getName(), (String)"getLuns", (Throwable)e);
            }
            Object[] args = new Object[]{"t_res_storage_subsystem, t_res_share", "GuiSelectionHndlr.getLuns"};
            errorMsg = SQLUtil.getSQLExceptionMsg(errorMsg, e, args);
        }
        String traceResult = errorMsg;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiSelectionHndlr.class.getName(), (String)"getLuns", (Object)traceResult);
        }
        return traceResult;
    }
}

