/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TBatchReport;
import org.eclipse.aperi.repository.table.TChartSettings;
import org.eclipse.aperi.repository.table.TSchedule;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.gui.GuiBatchReportHndlr;

public class ReportDeleteHndlr
implements RequestHandler,
ThrowAway {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ReportDeleteHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (RequestChecker.isDesiredType(NameList.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            NameList requestData = (NameList)request.requestData;
            int reportID = requestData.nlID;
            Connection dbc = Server.getConnection();
            if (dbc == null) {
                Server.setResponseError(response, "GEN0050E");
            } else {
                String resourceName = Integer.toString(reportID);
                try {
                    LockManager.lock((short)0, (String)"REPORT", (String)resourceName, (byte)1, (boolean)true);
                    TBatchReport reportAccessor = new TBatchReport(dbc);
                    reportAccessor.delete(reportID, false);
                    TChartSettings chSetAccessor = new TChartSettings(dbc);
                    chSetAccessor.delete_batch(reportID);
                    TSchedule scheduleAccessor = new TSchedule(dbc);
                    ScheduleHeader row = new ScheduleHeader();
                    row.ID = reportID;
                    scheduleAccessor.retrieve(row, GuiBatchReportHndlr.JOB_TYPE_LABEL);
                    if (row.alertID > 0) {
                        Alerter.deleteAlert(dbc, row.alertID, false);
                    }
                    scheduleAccessor.deleteByID(reportID, GuiBatchReportHndlr.JOB_TYPE_LABEL, true);
                    scheduleAccessor.commit();
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)ReportDeleteHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
                finally {
                    LockManager.unLock((short)0, (String)"REPORT", (String)resourceName);
                    Server.returnConnection(dbc);
                }
                ScheduleQueue.routine.addDelete(reportID);
            }
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ReportDeleteHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }
}

