/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.io.Serializable;
import java.sql.Connection;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TStormSettings;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;

public class SettingsHndlr
implements RequestHandler,
ThrowAway {
    private String subType;
    private TStormSettings accessor;
    private Settings settings;
    private static String USER;

    private void save() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SettingsHndlr.class.getName(), (String)"save", (String)"response");
        }
        if (TraceLogger.enableAudit) {
            TraceLogger.entry((String)SettingsHndlr.class.getName(), (String)"save", (String)USER);
        }
        int rowsUpdated = -1;
        if (this.subType.equals("org.eclipse.aperi.server.handler.gui.SettingsHndlr.History")) {
            rowsUpdated = this.accessor.updateHist(this.settings, 0);
        } else if (this.subType.equals("org.eclipse.aperi.server.handler.gui.SettingsHndlr.Removed")) {
            rowsUpdated = this.accessor.updateRemoved(this.settings, 0);
        } else if (this.subType.equals("org.eclipse.aperi.server.handler.gui.SettingsHndlr.Email")) {
            rowsUpdated = this.accessor.updateEmailRules(this.settings);
        }
        if (rowsUpdated == 0) {
            this.accessor.insert(this.settings);
        }
        this.accessor.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SettingsHndlr.class.getName(), (String)"save");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SettingsHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        USER = request.userName;
        Response response = Response.getResponse((short)0, null);
        Serializable requestData = request.requestData;
        this.settings = null;
        if (requestData != null) {
            if (!RequestChecker.isDesiredType(Settings.class, (Request)request, (Response)response)) {
                Response traceResult = response;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)SettingsHndlr.class.getName(), (String)"handle", (Object)traceResult);
                }
                return traceResult;
            }
            this.settings = (Settings)requestData;
        }
        this.subType = request.subType;
        Connection dbc = Server.getConnection();
        this.accessor = new TStormSettings(dbc);
        try {
            if (this.settings == null) {
                response.responseData = this.accessor.getSettings(false);
            } else {
                this.save();
            }
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SettingsHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            Server.setResponseError(response, (Exception)((Object)e));
        }
        finally {
            Server.returnConnection(dbc);
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SettingsHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }
}

