/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.disk;

import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.common.dbaccess.ViewReportTablesUpdater;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.disk.api.IDiskManagerService;
import org.eclipse.aperi.fabric.api.IFabricManagerService;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler;
import org.eclipse.aperi.server.handler.scheduler.FabricActionHandler;

public class DiskDeviceActionHandler
extends DeviceRequestHndlr {
    private IDiskManagerService dmService = null;
    private IFabricManagerService fmService = null;

    public int deviceAPI(DeviceRequest request, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DiskDeviceActionHandler.class.getName(), (String)"deviceAPI", (String)"request, response");
        }
        GUIRequestData reqData = (GUIRequestData)request.requestData;
        try {
            DeviceRequestHndlr.initDeviceServerComm(request);
            this.dmService = (IDiskManagerService)ConnectorClient.getService((String)request.deviceServerHost, (int)request.deviceServerPort, IDiskManagerService.class, (String)"DiskManagerService");
            this.fmService = (IFabricManagerService)ConnectorClient.getService((String)request.deviceServerHost, (int)request.deviceServerPort, IFabricManagerService.class, (String)"FabricManagerService");
            if (reqData.getActionId() == 11) {
                this.deleteStorageSubsystems(reqData, response);
            } else if (reqData.getActionId() == 32) {
                this.releaseFabric(reqData, response);
            } else if (reqData.getActionId() == 33) {
                this.rollbackFabricTransaction(reqData, response);
            }
        }
        catch (Exception ex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)DiskDeviceActionHandler.class.getName(), (String)"deviceAPI", (Throwable)ex);
            }
            response.status = (short)12;
            if (ex instanceof SRMRuntimeException) {
                response.errorMessage = ((SRMRuntimeException)ex).getLocalizedMessage();
            } else {
                String[] inserts = new String[]{};
                String msg = ex.getMessage();
                if (msg != null) {
                    inserts = new String[]{msg};
                }
                response.errorMessage = new SRMMessage("HWN021503E", inserts).getLocalizedMessage();
            }
            response.responseData = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DiskDeviceActionHandler.class.getName(), (String)"deviceAPI", (int)0);
        }
        return 0;
    }

    private Result[] deleteStorageSubsystems(GUIRequestData reqData, Response response) throws Exception {
        String[] subsystemIds = (String[])reqData.getParameter("subsystem.ids");
        String[] ssInternalIds = (String[])reqData.getParameter("subsystem.internalIds");
        TraceLogger.traceMessage((int)1, (String)SubsystemInfoHandler.class.getName(), (String)"deleteStorageSubsystems", (String)("subsystemIds: " + subsystemIds));
        Result[] res = this.dmService.deleteStorageSubsystems(subsystemIds);
        ViewReportTablesUpdater vrtu = new ViewReportTablesUpdater();
        for (String ssInternalId : ssInternalIds) {
            vrtu.deleteDependentViews("subsystem", ssInternalId);
        }
        return res;
    }

    private int releaseFabric(GUIRequestData reqData, Response response) throws Exception {
        String fabricId = (String)((Object)reqData.getParameter("fabric.id"));
        TraceLogger.traceMessage((int)1, (String)FabricActionHandler.class.getName(), (String)"releaseFabric", (String)("fabricId: " + fabricId));
        return this.fmService.release(fabricId);
    }

    private int rollbackFabricTransaction(GUIRequestData reqData, Response response) throws Exception {
        String fabricId = (String)((Object)reqData.getParameter("fabric.id"));
        TraceLogger.traceMessage((int)1, (String)FabricActionHandler.class.getName(), (String)"rollbackFabricTransaction", (String)("fabricId: " + fabricId));
        return this.fmService.rollbackTransaction(fabricId);
    }
}

