/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.fabric;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.SRMException;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.fabric.api.IFabricManagerService;
import org.eclipse.aperi.fabric.api.SNMPAgent;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.IpTarget;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.guireq.OutOfBandFabricAgentInfo;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.gui.fabric.GUIDeviceAccessor;
import org.eclipse.aperi.xmsg.MessageLog;

public class OutOfBandFabricAgentHandler
implements RequestHandler,
ThreadSafe {
    private static String IP_ADDRESS_COLUMN = "IP_ADDRESS";

    private void log(String logmessage) {
        if (TraceLogger.enableTrace) {
            TraceLogger.traceMessage((int)3, (String)"OutOfBandFabricAgentHandler", (String)"log", (String)logmessage);
        }
    }

    private void setResponseError(Response response, String logmessage, String localizedMessage) {
        this.log(logmessage);
        response.responseData = null;
        response.status = (short)12;
        response.errorMessage = logmessage;
        if (localizedMessage != null) {
            response.errorMessage = localizedMessage;
        }
        if (response.errorMessage == null) {
            response.errorMessage = "";
        }
    }

    private String getExceptionMessage(Exception e) {
        String message = "NO MESSAGE";
        if (e instanceof SRMRuntimeException) {
            message = ((SRMRuntimeException)e).getLocalizedMessage();
        } else if (e.getMessage() == null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                message = "[" + sw.toString() + "]";
            }
            catch (Exception exception) {
                // empty catch block
            }
            message = "exception thrown " + e.getClass().getName() + " " + message;
        } else {
            message = e.getMessage();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SNMPAgent getSNMPAgent(String ipaddress) throws SQLException {
        DBConnection connection = ServiceUtils.getConnection();
        try {
            Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
            htWhereClause.put(IpTarget.getColumnInfo((String)IP_ADDRESS_COLUMN), ipaddress);
            IpTarget target = IpTarget.retrieve((DBConnection)connection, htWhereClause);
            if (target == null) {
                SNMPAgent sNMPAgent = null;
                return sNMPAgent;
            }
            SNMPAgent sNMPAgent = new SNMPAgent(target.getIpAddress(), target.getHostName(), target.getReadCommunityName(), target.getRwCommunityName(), target.getUserId(), target.getPassword());
            return sNMPAgent;
        }
        finally {
            if (connection != null) {
                connection.commit();
                connection.close();
            }
        }
    }

    private void fillInHostInformation(OutOfBandFabricAgentInfo oobfai) {
        String hostname = oobfai.hostname;
        String ipaddress = oobfai.ipaddress;
        try {
            InetAddress addr = InetAddress.getByName(oobfai.ipaddress);
            hostname = addr.getHostName();
            ipaddress = addr.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            this.log("REQUEST_ADD_AGENT/REQUEST_MODIFY_AGENT unknown host exception add or modify will be attempted using host:" + hostname + " ipaddress " + ipaddress);
        }
        oobfai.hostname = hostname;
        oobfai.ipaddress = ipaddress;
    }

    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        String userName = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (!RequestChecker.isDesiredType(OutOfBandFabricAgentInfo.class, (Request)request, (Response)(response = Response.getResponse((short)12, null)))) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        userName = request.userName;
        StringBuffer auditMsgBuffer = new StringBuffer("Username = " + userName);
        DeviceRequest dr = new DeviceRequest();
        DeviceRequestHndlr.initDeviceServerComm(dr);
        OutOfBandFabricAgentInfo oobfai = (OutOfBandFabricAgentInfo)request.requestData;
        if (oobfai.request_type == 1) {
            try {
                String ipaddress = oobfai.ipaddress;
                String hostname = oobfai.hostname;
                String address = ipaddress;
                if (oobfai.ipaddress == null || oobfai.ipaddress.equals("")) {
                    ipaddress = "";
                    try {
                        InetAddress addr = InetAddress.getByName(hostname);
                        hostname = addr.getHostName();
                        address = ipaddress = addr.getHostAddress();
                    }
                    catch (UnknownHostException uhe) {
                        address = oobfai.hostname;
                    }
                }
                this.log(" REQUEST_GET_INFO getOutBandAgents address: " + address + " hostname " + hostname + " ipaddress: " + ipaddress);
                SNMPAgent[] snmpAgent = FabricDbAccess.getOutbandAgents((String)address);
                if (snmpAgent == null) {
                    this.log(" REQUEST_GET_INFO getOutBandAgents address: " + address + " hostname " + hostname + " ipaddress: " + ipaddress + " returned null");
                } else if (snmpAgent.length > 0) {
                    this.log(" REQUEST_GET_INFO getOutBandAgents address: " + address + " hostname " + hostname + " ipaddress: " + ipaddress + " snmpAgent.length=" + snmpAgent.length);
                } else {
                    this.log(" REQUEST_GET_INFO getOutBandAgents address: " + address + " hostname " + hostname + " ipaddress: " + ipaddress + " 0 agents returned");
                }
                if (snmpAgent != null && snmpAgent.length > 0) {
                    oobfai.hostname = snmpAgent[0].getDnsName();
                    oobfai.ipaddress = snmpAgent[0].getIpAddress();
                    oobfai.communityname = snmpAgent[0].getCommunityName();
                    oobfai.communityname_rw = snmpAgent[0].getRWCommunityName();
                    oobfai.username = snmpAgent[0].getUserName();
                    oobfai.password = snmpAgent[0].getPassword();
                    oobfai.status = 3;
                    if (snmpAgent[0].getEnabled() == 1) {
                        oobfai.status = 2;
                    }
                    response.status = 0;
                    response.responseData = request.requestData;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle", (Object)response);
                    }
                    return response;
                }
                if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage((int)1, (String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle", (String)"database helper did not return an agent");
                }
                String info = "";
                info = snmpAgent == null ? "snmpAgent is null" : "snmpAgent array length is " + snmpAgent.length;
                this.setResponseError(response, "no agent returned", "no agent returned for agent [" + address + "] " + info);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            catch (Exception e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle", (Throwable)e);
                }
                this.setResponseError(response, "REQUEST_GET_INFO UNDECLARED EXCEPTION THROWN " + e.getMessage(), this.getExceptionMessage(e));
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
        }
        if (oobfai.request_type == 3) {
            IFabricManagerService iAMS;
            String ipaddress = oobfai.ipaddress;
            String hostname = oobfai.hostname;
            String address = ipaddress;
            if (oobfai.ipaddress == null || oobfai.ipaddress.equals("")) {
                ipaddress = "";
                try {
                    InetAddress addr = InetAddress.getByName(hostname);
                    hostname = addr.getHostName();
                    address = ipaddress = addr.getHostAddress();
                }
                catch (UnknownHostException uhe) {
                    address = oobfai.hostname;
                }
            }
            if ((iAMS = (IFabricManagerService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IFabricManagerService.class, (String)"FabricManagerService")) == null) {
                this.setResponseError(response, "REQUEST_REMOVE_AGENT Bind to IFabricManagerService on device server failed host: " + dr.deviceServerHost + " port: " + dr.deviceServerPort + " ", null);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            String[] agents = new String[]{address};
            auditMsgBuffer.append("\n Agents: Delete Out of Band Fabric Agent ");
            auditMsgBuffer.append("\n host name = ");
            auditMsgBuffer.append(hostname);
            auditMsgBuffer.append("\n IP address = ");
            auditMsgBuffer.append(ipaddress);
            auditMsgBuffer.append("\n");
            if (TraceLogger.enableAudit) {
                TraceLogger.auditMessage((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle()-if REQUEST_REMOVE_AGENT", (String)String.valueOf(auditMsgBuffer));
            }
            try {
                iAMS.deleteSNMPAgents(agents);
                response.status = 0;
                response.responseData = request.requestData;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            catch (InvalidParameterException e) {
                this.setResponseError(response, "REQUEST_REMOVE_AGENT INVALID PARAMETER EXCEPTION " + e.getMessage(), this.getExceptionMessage((Exception)((Object)e)));
            }
            catch (MissingParameterException e) {
                this.setResponseError(response, "REQUEST_REMOVE_AGENT MISSING PARAMETER EXCEPTION" + e.getMessage(), this.getExceptionMessage((Exception)((Object)e)));
            }
            catch (SRMException e) {
                this.setResponseError(response, "REQUEST_REMOVE_AGENT TPC EXCEPTION " + e.getMessage(), this.getExceptionMessage((Exception)((Object)e)));
            }
            catch (Exception e) {
                this.setResponseError(response, "REQUEST_REMOVE_AGENT UNDECLARED EXCEPTION THROWN " + e.getMessage(), this.getExceptionMessage(e));
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle", (Object)response);
            }
            return response;
        }
        if (oobfai.request_type == 2 || oobfai.request_type == 5) {
            String hostname = oobfai.hostname;
            String ipaddress = oobfai.ipaddress;
            try {
                InetAddress addr = InetAddress.getByName(oobfai.ipaddress);
                hostname = addr.getHostName();
                ipaddress = addr.getHostAddress();
            }
            catch (UnknownHostException uhe) {
                uhe.printStackTrace();
                StringTokenizer st = new StringTokenizer(uhe.getLocalizedMessage(), ":");
                String str = MessageLog.getMessageNoID((String)"GEN0039E", (Object)st.nextToken().trim());
                this.setResponseError(response, "REQUEST_ADD_AGENT/REQUEST_MODIFY_AGENT UNKNOWN HOST EXCEPTION THROWN " + uhe.getMessage(), str);
                return response;
            }
            IFabricManagerService iAMS = (IFabricManagerService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IFabricManagerService.class, (String)"FabricManagerService");
            if (iAMS == null) {
                this.setResponseError(response, "REQUEST_ADD_AGENT/REQUEST_MODIFY_AGENT Bind to IFabricManagerService on device server failed host: " + dr.deviceServerHost + " port: " + dr.deviceServerPort + " ", null);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            int operationState = 1;
            SNMPAgent agent = new SNMPAgent(ipaddress, hostname, oobfai.communityname, oobfai.communityname_rw, oobfai.username, oobfai.password);
            SNMPAgent[] agents = new SNMPAgent[]{agent};
            try {
                boolean nonBrocadeAgent = false;
                if (oobfai.username != null || oobfai.password != null) {
                    operationState = 2;
                    this.log("REQUEST_ADD_AGENT/REQUEST_MODIFY_AGENT testBrocadeAgentUserPassword host: " + agents[0].getDnsName() + " ip: " + agents[0].getIpAddress() + " community: " + agents[0].getCommunityName() + " community_rw: " + agents[0].getRWCommunityName() + " username:" + agents[0].getUserName() + " password: " + agents[0].getPassword());
                    this.setResponseError(response, "REQUEST_ADD/MODIFY no data (null) returned from testBrocadeAgentUserPassword", null);
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle", (Object)response);
                    }
                    return response;
                }
                nonBrocadeAgent = true;
                agents[0].setPassword("");
                agents[0].setUserName("");
                if (oobfai.request_type == 5) {
                    operationState = 3;
                    auditMsgBuffer.append("\n Agents: Modify Out of Band Fabric Agent ");
                    this.log("REQUEST_MODIFY_AGENT calling modifySNMPAgents host: " + agents[0].getDnsName() + " ip: " + agents[0].getIpAddress() + " community: " + agents[0].getCommunityName() + " community_rw: " + agents[0].getRWCommunityName() + " username:" + agents[0].getUserName());
                    iAMS.modifySNMPAgents(agents);
                    this.log("REQUEST_MODIFY_AGENT finished calling modifySNMPAgents host: " + agents[0].getDnsName() + " ip: " + agents[0].getIpAddress() + " community: " + agents[0].getCommunityName() + " community_rw: " + agents[0].getRWCommunityName() + " username:" + agents[0].getUserName());
                } else {
                    operationState = 4;
                    auditMsgBuffer.append("\n Agents: Add Out of Band Fabric Agent ");
                    this.log("REQUEST_ADD_AGENT addSNMPAgents host: " + agents[0].getDnsName() + " ip: " + agents[0].getIpAddress() + " community: " + agents[0].getCommunityName() + " community_rw: " + agents[0].getRWCommunityName() + " username:" + agents[0].getUserName());
                    iAMS.addSNMPAgents(agents);
                    this.log("REQUEST_ADD_AGENT addSNMPAgents  Returned host: " + agents[0].getDnsName() + " ip: " + agents[0].getIpAddress() + " community: " + agents[0].getCommunityName() + " community_rw: " + agents[0].getRWCommunityName() + " username:" + agents[0].getUserName());
                }
                auditMsgBuffer.append("\n host name = ");
                auditMsgBuffer.append(hostname);
                auditMsgBuffer.append("\n IP address = ");
                auditMsgBuffer.append(ipaddress);
                auditMsgBuffer.append("\n");
                if (TraceLogger.enableAudit) {
                    TraceLogger.auditMessage((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle()-if REQUEST_ADD/MODIFY_AGENT", (String)String.valueOf(auditMsgBuffer));
                }
                oobfai.hostname = hostname;
                oobfai.ipaddress = ipaddress;
                int status = GUIDeviceAccessor.getIpTargetStatus(agents[0]);
                oobfai.message_status = 3;
                if (status == 1) {
                    this.log("REQUEST_ADD_AGENT status of agent " + agents[0].getIpAddress() + " " + agents[0].getDnsName() + " agent is responding");
                    oobfai.message_status = 2;
                } else {
                    this.log("REQUEST_ADD_AGENT status of agent " + agents[0].getIpAddress() + " " + agents[0].getDnsName() + " is not responding");
                }
                oobfai.status = 0;
                response.status = 0;
                response.responseData = request.requestData;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            catch (InvalidParameterException e) {
                this.setResponseError(response, "REQUEST_ADD_AGENT/REQUEST_MODIFY_AGENT INVALID PARAMETER EXCEPTION " + e.getMessage(), this.getExceptionMessage((Exception)((Object)e)));
            }
            catch (MissingParameterException e) {
                this.setResponseError(response, "REQUEST_ADD_AGENT/REQUEST_MODIFY_AGENT MISSING PARAMETER EXCEPTION " + e.getMessage() + "(" + operationState + ")", this.getExceptionMessage((Exception)((Object)e)) + " (" + operationState + ")");
            }
            catch (SRMException e) {
                this.setResponseError(response, "REQUEST_ADD_AGENT/REQUEST_MODIFY_AGENT TPC EXCEPTION " + e.getMessage() + "(" + operationState + ")", this.getExceptionMessage((Exception)((Object)e)) + " (" + operationState + ")");
            }
            catch (Exception e) {
                this.setResponseError(response, "REQUEST_ADD_AGENT/REQUEST_MODIFY_AGENT UNDECLARED EXCEPTION THROWN " + e.getMessage() + "(" + operationState + ")", this.getExceptionMessage(e) + " (" + operationState + ")");
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle", (Object)response);
            }
            return response;
        }
        if (oobfai.request_type == 4) {
            block74: {
                InetAddress addr;
                String hostname = null;
                String ipaddress = null;
                String givenhostname = "";
                String givenipaddress = "";
                if (oobfai.ipaddress != null && !oobfai.ipaddress.equals("")) {
                    givenipaddress = oobfai.ipaddress;
                    try {
                        addr = InetAddress.getByName(oobfai.ipaddress);
                        hostname = addr.getHostName();
                        ipaddress = addr.getHostAddress();
                    }
                    catch (UnknownHostException uhe) {}
                } else if (oobfai.hostname != null && !oobfai.hostname.equals("")) {
                    givenhostname = oobfai.hostname;
                    try {
                        addr = InetAddress.getByName(oobfai.hostname);
                        hostname = addr.getHostName();
                        ipaddress = addr.getHostAddress();
                    }
                    catch (UnknownHostException uhe) {
                        // empty catch block
                    }
                }
                if (hostname != null && ipaddress != null) {
                    IFabricManagerService iAMS = (IFabricManagerService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IFabricManagerService.class, (String)"FabricManagerService");
                    if (iAMS == null) {
                        this.setResponseError(response, "REQUEST_CHECK Bind to IFabricManagerService on device server failed host: " + dr.deviceServerHost + " port: " + dr.deviceServerPort + " ", null);
                        return response;
                    }
                    SNMPAgent agent = new SNMPAgent(ipaddress, hostname, oobfai.communityname, oobfai.communityname_rw, oobfai.username, oobfai.password);
                    SNMPAgent[] agents = new SNMPAgent[]{agent};
                    try {
                        int[] checkResult = iAMS.testSNMPAgentConnection(agents);
                        if (checkResult != null && checkResult.length > 0) {
                            oobfai.status = 3;
                            if (checkResult[0] == 0) {
                                oobfai.status = 2;
                            }
                            response.status = 0;
                            response.responseData = request.requestData;
                            if (TraceLogger.enableTrace) {
                                TraceLogger.exit((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle", (Object)response);
                            }
                            return response;
                        }
                        if (checkResult == null) {
                            this.setResponseError(response, "REQUEST_CHECK no data (null) returned from testSNMPAgentConnection", null);
                            break block74;
                        }
                        this.setResponseError(response, "REQUEST_CHECK not not enough data returned from testSNMPAgentConnection expected " + agents.length + " items to be returned but only " + checkResult.length + " items were returned. ", null);
                    }
                    catch (InvalidParameterException e) {
                        this.setResponseError(response, "REQUEST_CHECK INVALID PARAMETER EXCEPTION " + e.getMessage(), this.getExceptionMessage((Exception)((Object)e)));
                    }
                    catch (MissingParameterException e) {
                        this.setResponseError(response, "REQUEST_CHECK MISSING PARAMETER EXCEPTION " + e.getMessage(), this.getExceptionMessage((Exception)((Object)e)));
                    }
                    catch (SRMException e) {
                        this.setResponseError(response, "REQUEST_CHECK TPC EXCEPTION " + e.getMessage(), this.getExceptionMessage((Exception)((Object)e)));
                    }
                    catch (Exception e) {
                        this.setResponseError(response, "REQUEST_CHECK UNDECLARED EXCEPTION THROWN " + e.getMessage(), this.getExceptionMessage(e));
                        e.printStackTrace();
                    }
                } else {
                    this.setResponseError(response, "REQUEST_CHECK failed to determine hostname and ip address for " + givenhostname + " " + givenipaddress, null);
                }
            }
            return response;
        }
        oobfai.status = 1;
        response.responseData = oobfai;
        Response traceResult = response;
        this.setResponseError(response, "OutOfBandFabricAgentHandler unknown request type " + oobfai.request_type, null);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)OutOfBandFabricAgentHandler.class.getName(), (String)"handle", (Object)traceResult);
        }
        return response;
    }
}

