/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.nas;

import java.sql.Connection;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.agentreq.ManNasReq;
import org.eclipse.aperi.TStorm.server.guireq.RespManNas;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.FilerSaver;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TResLdapTree;
import org.eclipse.aperi.repository.table.TResPwd;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.repository.table.TSnmpCommunity;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.agent.DiscoveryHndlr;
import org.eclipse.aperi.server.handler.gui.GuiListHndlr;
import org.eclipse.aperi.server.svp.AgentSvp;
import org.eclipse.aperi.xmsg.MessageLog;

public class NasGuiManEntryHndlr
implements RequestHandler,
ThrowAway {
    private Response response;
    private Connection dbc;
    private ManNasReq manNasReq;
    private NameList communities;
    private TSnmpCommunity snmpAccessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"NasGuiManEntryHndlr", (String)"handle", (String)"request, transceiver");
        }
        this.response = Response.getResponse((short)12, null);
        this.dbc = Server.getConnection();
        if (this.dbc == null) {
            Server.setResponseError(this.response, "GEN0050E");
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)"NasGuiManEntryHndlr", (String)"handle", (Object)this.response);
            }
            return this.response;
        }
        try {
            if (request.requestData instanceof RespManNas) {
                this.delMan(request);
            } else {
                this.addMan(request);
            }
            if (this.response.status <= 4) {
                GuiListHndlr.getManNasList(this.dbc, this.response);
            }
        }
        catch (GeneralException e) {
            try {
                this.dbc.rollback();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)"NasGuiManEntryHndlr", (String)"handle", (Throwable)e);
            }
            Server.setResponseError(this.response, (Exception)((Object)e));
        }
        finally {
            Server.returnConnection(this.dbc);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"NasGuiManEntryHndlr", (String)"handle", (Object)this.response);
        }
        return this.response;
    }

    private void delMan(Request request) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"NasGuiManEntryHndlr", (String)"delMan", (String)"request");
        }
        RespManNas mannas = (RespManNas)request.requestData;
        Share filer = new Share();
        filer.shComputerID = mannas.mnComputerID;
        filer.shResourceID = mannas.mnResourceID;
        filer.shResourceType = (short)103;
        FilerSaver fs = new FilerSaver(this.dbc, mannas.mnComputerID);
        fs.removeFilers(filer, false);
        this.response.status = 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"NasGuiManEntryHndlr", (String)"delMan");
        }
    }

    private void addMan(Request request) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"NasGuiManEntryHndlr", (String)"addMan", (String)"request");
        }
        if (!RequestChecker.isDesiredType(ManNasReq.class, (Request)request, (Response)this.response)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)"NasGuiManEntryHndlr", (String)"addMan");
            }
            return;
        }
        this.manNasReq = (ManNasReq)request.requestData;
        boolean bl = this.manNasReq.mnRejectNonRoot = !AgentSvp.saveNonRootExports;
        if (this.manNasReq.mnAddNas) {
            this.snmpAccessor = new TSnmpCommunity(this.dbc);
            this.communities = this.snmpAccessor.getCommunities();
            if (Util.isEmpty((String)this.manNasReq.mnCommunityName)) {
                this.manNasReq.mnCommunities = this.communities;
            } else {
                this.manNasReq.mnCommunities = new NameList();
                this.manNasReq.mnCommunities.nlName = this.manNasReq.mnCommunityName;
            }
            this.manNasReq.mnNasVendors = DiscoveryHndlr.getNasConfigFile();
        } else {
            TResLdapTree treeAccessor = new TResLdapTree(this.dbc);
            treeAccessor.prepGetByName();
            this.manNasReq.mnLdapTree = treeAccessor.getByName(this.manNasReq.mnTreeName);
        }
        this.manNasReq.pack();
        Request agentReq = new Request();
        agentReq.typeCode = "org.eclipse.aperi.agent.svp.AgentSvp";
        agentReq.subType = "org.eclipse.aperi.agent.handler.nas.ManNasConfigHandler";
        agentReq.serviceName = RequestTypeManager.getInternalName((String)agentReq.typeCode);
        agentReq.userName = request.userName;
        agentReq.flags = 0;
        agentReq.requestData = this.manNasReq;
        AgentManager am = Server.getAgentManager();
        Response agentResp = am.transmitToAgent(agentReq, null, this.manNasReq.mnAgentID, false, 1800);
        if (agentResp == null) {
            Server.setResponseError(this.response, "NAS0003E", am.getAgentName(this.manNasReq.mnAgentID));
        } else if (agentResp.status > 4) {
            this.response = agentResp;
        } else {
            this.response = agentResp;
            this.manNasReq = (ManNasReq)agentResp.responseData;
            this.manNasReq.unpack();
            short saveStatus = this.response.status;
            this.response.status = (short)12;
            this.saveFiler();
            this.response.status = saveStatus;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"NasGuiManEntryHndlr", (String)"addMan");
        }
    }

    private void saveFiler() throws GeneralException {
        int shareID;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"NasGuiManEntryHndlr", (String)"saveFiler", (String)"");
        }
        NasFiler filer = this.manNasReq.mnFiler;
        if (this.manNasReq.mnAddNas) {
            filer.nfName = filer.nfName.toLowerCase();
            if (this.manNasReq.mnIsWindows) {
                TResDomain domainAccessor = new TResDomain(this.dbc);
                domainAccessor.getIDs(filer.nfComputer.cmpDomain);
                shareID = filer.nfComputer.cmpDomain.domID;
                if (this.checkDup(filer)) {
                    throw new GeneralException(MessageLog.getMessage((String)"NAS0023E", (Object)this.manNasReq.mnNetworkName));
                }
            } else {
                shareID = this.manNasReq.mnAgentID;
            }
        } else {
            shareID = this.manNasReq.mnLdapTree.ltTreeID;
            if (this.checkDup(filer)) {
                throw new GeneralException(MessageLog.getMessage((String)"NAS0024E", (Object)this.manNasReq.mnNetworkName));
            }
        }
        FilerSaver filerSaver = new FilerSaver(this.dbc, shareID, 103, false, null, "Not Used");
        filerSaver.saveDiscoveryData(filer);
        if (!Util.isEmpty((String)this.manNasReq.mnCommunityName)) {
            NameList workComm = this.communities;
            while (workComm != null && !workComm.nlName.equalsIgnoreCase(this.manNasReq.mnCommunityName)) {
                workComm = workComm.nlNext;
            }
            if (workComm == null) {
                this.snmpAccessor.insert(this.manNasReq.mnCommunities, false);
                this.snmpAccessor.closeInsert();
            }
        }
        if (this.manNasReq.mnAddNas && this.manNasReq.mnIsWindows) {
            this.savePassword(filer);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"NasGuiManEntryHndlr", (String)"saveFiler");
        }
    }

    private boolean checkDup(NasFiler filer) throws GeneralException {
        int count = 0;
        TResComputer compAccessor = new TResComputer(this.dbc);
        int compID = compAccessor.selectCID(filer.nfName);
        compAccessor.closeSelect();
        if (compID > 0) {
            TResShare shareAccessor = new TResShare(this.dbc);
            shareAccessor.prepGetWindowsManShareCount(this.manNasReq.mnAddNas);
            count = shareAccessor.getWindowsManShareCount(compID);
            shareAccessor.closeSelect();
        }
        return count > 0;
    }

    private void savePassword(NasFiler filer) throws GeneralException {
        TResPwd pwdAccessor = new TResPwd(this.dbc);
        pwdAccessor.prepLoginUpdate();
        pwdAccessor.updateLogin(filer.nfComputerID, this.manNasReq.mnUserid, this.manNasReq.mnPassword, true);
        pwdAccessor.closeLoginUpdate();
    }
}

