/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.tape;

import java.util.Hashtable;
import org.eclipse.aperi.common.dbaccess.ViewReportTablesUpdater;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.gui.tape.common.model.GUIException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.gui.tape.GUIEntityFactory;

public class LibraryInfoHandler
implements RequestHandler,
ThrowAway {
    GUIEntityFactory entityFactory = null;

    public Response handle(Request request, Transceiver transceiver) {
        GUIRequestData reqData = (GUIRequestData)request.requestData;
        Response response = Response.getResponse((short)0, null);
        this.entityFactory = GUIEntityFactory.getInstance();
        try {
            if (reqData.getActionId() == 1) {
                this.getAllTapeLibraries(reqData, response);
            } else if (reqData.getActionId() == 3) {
                this.setLibraryAttributes(reqData, response);
            } else if (reqData.getActionId() == 4) {
                this.deleteTapeLibrary(reqData, response);
            }
        }
        catch (Exception ex) {
            Server.setResponseError(response, ex);
            response.errorMessage = ex.getMessage();
            response.responseData = null;
        }
        return response;
    }

    private void getAllTapeLibraries(GUIRequestData reqData, Response response) throws GUIException {
        response.responseData = this.entityFactory.getAllTapeLibraries();
    }

    private void setLibraryAttributes(GUIRequestData reqData, Response response) throws Exception {
        String libraryId = (String)((Object)reqData.getParameter("library.id"));
        TraceLogger.traceMessage((int)1, (String)LibraryInfoHandler.class.getName(), (String)"setLibraryAttributes", (String)("libraryId: " + libraryId));
        Hashtable attributes = (Hashtable)reqData.getParameter("library.attrs");
        response.responseData = new Integer(this.entityFactory.setLibraryAttributes(libraryId, attributes));
    }

    private void deleteTapeLibrary(GUIRequestData reqData, Response response) throws Exception {
        String libraryId = (String)((Object)reqData.getParameter("library.id"));
        TraceLogger.traceMessage((int)1, (String)LibraryInfoHandler.class.getName(), (String)"deleteTapeLibrary", (String)("libraryId: " + libraryId));
        response.responseData = new Integer(this.entityFactory.deleteTapeLibrary(libraryId));
        new ViewReportTablesUpdater().deleteDependentViews("tapelibrary", libraryId);
    }
}

