/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.SchHistoryJobNode;
import org.eclipse.aperi.scheduler.SchHistoryNameList;
import org.eclipse.aperi.scheduler.SchHistoryRequestNode;
import org.eclipse.aperi.server.DeviceServerManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;

public class ScheduleGuiHandler
implements RequestHandler {
    Connection connection;
    ResultSet results;
    Statement statement;
    Date date = new Date();
    DateFormat df = DateFormat.getDateTimeInstance();
    String errorMessage;

    public ScheduleGuiHandler() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleGuiHandler.class.getName(), (String)"ScheduleGuiHandler", (String)"");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleGuiHandler.class.getName(), (String)"ScheduleGuiHandler");
        }
    }

    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleGuiHandler.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (RequestChecker.isDesiredType(SchHistoryRequestNode.class, (Request)request, (Response)(response = new Response(0, null)))) {
            SchHistoryRequestNode requestNode = (SchHistoryRequestNode)request.requestData;
            this.connection = Server.getConnection();
            if (this.connection == null) {
                Server.setResponseError(response, "GEN0050E");
            } else if (requestNode.queryType == 1) {
                response.responseData = this.getNodes(requestNode);
            } else if (requestNode.queryType == 3) {
                response.responseData = (Serializable)Packer.pack((Packable)this.getJobs(requestNode));
            }
        }
        if (this.results != null) {
            block16: {
                try {
                    this.results.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block16;
                    TraceLogger.exception((String)ScheduleGuiHandler.class.getName(), (String)"handle", (Throwable)ignored);
                }
            }
            this.results = null;
        }
        if (this.statement != null) {
            block17: {
                try {
                    this.statement.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block17;
                    TraceLogger.exception((String)ScheduleGuiHandler.class.getName(), (String)"handle", (Throwable)ignored);
                }
            }
            this.statement = null;
        }
        if (this.connection != null) {
            Server.returnConnection(this.connection);
            this.connection = null;
        }
        if (this.errorMessage != null) {
            response.status = (short)12;
            response.errorMessage = this.errorMessage;
            this.errorMessage = null;
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleGuiHandler.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    public NameList getNodes(Connection dbc, SchHistoryRequestNode queryNode) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleGuiHandler.class.getName(), (String)"getNodes", (String)"dbc, queryNode");
        }
        this.connection = dbc;
        NameList nodes = this.getNodes(queryNode);
        if (this.results != null) {
            block8: {
                try {
                    this.results.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block8;
                    TraceLogger.exception((String)ScheduleGuiHandler.class.getName(), (String)"getNodes", (Throwable)ignored);
                }
            }
            this.results = null;
        }
        if (this.statement != null) {
            block9: {
                try {
                    this.statement.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block9;
                    TraceLogger.exception((String)ScheduleGuiHandler.class.getName(), (String)"getNodes", (Throwable)ignored);
                }
            }
            this.statement = null;
        }
        NameList traceResult = nodes;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleGuiHandler.class.getName(), (String)"getNodes", (Object)traceResult);
        }
        return traceResult;
    }

    private NameList getNodes(SchHistoryRequestNode queryNode) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleGuiHandler.class.getName(), (String)"getNodes", (String)"queryNode");
        }
        SchHistoryNameList listHdr = null;
        SchHistoryNameList listNode = null;
        try {
            String stmt = "select    run_number      ,           time_stamp      ,           status          ,           number_jobs     ,           successful_jobs ,           finish_time     ,           device_server_run_id from      t_runs            where     schedule_id =     " + Integer.toString(queryNode.queryID) + " order by run_number";
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(stmt);
            while (this.results.next()) {
                if (listHdr == null) {
                    listNode = listHdr = new SchHistoryNameList();
                } else {
                    listNode.nlNext = new SchHistoryNameList();
                    listNode = (SchHistoryNameList)listNode.nlNext;
                }
                listNode.nlID = queryNode.queryID;
                listNode.nlID2 = this.results.getInt(1);
                listNode.startTime = this.results.getLong(2);
                this.date.setTime(listNode.startTime);
                String when = this.df.format(this.date);
                listNode.nlName = listNode.nlID2 < 10 ? "   " + Integer.toString(listNode.nlID2) + " - " + when : (listNode.nlID2 < 100 ? "  " + Integer.toString(listNode.nlID2) + " - " + when : (listNode.nlID2 < 1000 ? " " + Integer.toString(listNode.nlID2) + " - " + when : Integer.toString(listNode.nlID2) + " - " + when));
                listNode.nlState = SQLUtil.getByte(this.results, 3);
                listNode.numberJobs = this.results.getInt(4);
                listNode.successfulJobs = this.results.getInt(5);
                listNode.finishTime = this.results.getLong(6);
                listNode.nlID3 = this.results.getInt(7);
            }
        }
        catch (SQLException e1) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleGuiHandler.class.getName(), (String)"getNodes", (Throwable)e1);
            }
            Object[] args = new Object[]{"t_runs"};
            this.errorMessage = SQLUtil.getSQLExceptionMsg("SRV0082E", e1, args);
        }
        SchHistoryNameList traceResult = listHdr;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleGuiHandler.class.getName(), (String)"getNodes", traceResult);
        }
        return traceResult;
    }

    private SchHistoryJobNode getJobs(SchHistoryRequestNode queryNode) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleGuiHandler.class.getName(), (String)"getJobs", (String)"queryNode");
        }
        DeviceServerManager dsm = Server.getDeviceServerManager();
        SchHistoryJobNode jobHdr = null;
        SchHistoryJobNode jobNode = null;
        if (queryNode.queryDeviceRunNumber < 1) {
            queryNode.queryDeviceRunNumber = -777;
        }
        try {
            String stmt = "select    job_run_number  ,           computer_id     ,           submit_status   ,           return_code     ,           start_time      ,           finish_time     ,           log_file_name   ,           device_server_run_id,           resource_type from      t_run_jobs        where     (schedule_id =     " + Integer.toString(queryNode.queryID) + " and      sid_run_number =  " + Integer.toString(queryNode.queryRunNumber) + " ) " + " or       device_server_run_id = " + Integer.toString(queryNode.queryDeviceRunNumber) + " order by job_run_number";
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(stmt);
            while (this.results.next()) {
                jobNode = jobHdr == null ? (jobHdr = new SchHistoryJobNode()) : (jobNode.next = new SchHistoryJobNode());
                jobNode.jobNumber = this.results.getInt(1);
                jobNode.computerID = this.results.getInt(2);
                int submitStatus = this.results.getInt(3);
                jobNode.returnCode = this.results.getInt(4);
                jobNode.startTime = this.results.getLong(5);
                jobNode.finishTime = this.results.getLong(6);
                jobNode.logFileName = this.results.getString(7);
                jobNode.deviceRunNumber = this.results.getInt(8);
                jobNode.resourceType = this.results.getShort(9);
                if (jobNode.deviceRunNumber > 0) {
                    org.eclipse.aperi.infrastructure.database.objects.Server deviceServer = dsm.getDeviceServer();
                    jobNode.computer = deviceServer.getServerName();
                } else if (jobNode.resourceType == 121 || jobNode.resourceType == 117) {
                    jobNode.computer = this.findResourceName(jobNode.resourceType, jobNode.computerID);
                }
                if (jobNode.startTime > 0L) {
                    this.date.setTime(jobNode.startTime);
                    jobNode.startTimeString = this.df.format(this.date);
                } else {
                    jobNode.startTimeString = null;
                }
                if (jobNode.finishTime > 0L) {
                    this.date.setTime(jobNode.finishTime);
                    jobNode.finishTimeString = this.df.format(this.date);
                } else {
                    jobNode.finishTimeString = null;
                }
                if (submitStatus == -1) {
                    jobNode.returnCode = -1;
                    continue;
                }
                if (submitStatus != -2) continue;
                jobNode.returnCode = -2;
            }
        }
        catch (SQLException e3) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleGuiHandler.class.getName(), (String)"getJobs", (Throwable)e3);
            }
            Object[] args = new Object[]{"t_run_jobs"};
            this.errorMessage = SQLUtil.getSQLExceptionMsg("SRV0082E", e3, args);
        }
        SchHistoryJobNode traceResult = jobHdr;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleGuiHandler.class.getName(), (String)"getJobs", traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findResourceName(short type, int id) {
        String displayName = null;
        Statement stat2 = null;
        ResultSet result2 = null;
        String table = null;
        String query = null;
        String name = null;
        try {
            if (type == 117) {
                table = "t_res_storage_subsystem";
                query = "select  name,  case when user_provided_name is not null  and user_provided_name <> ''  then user_provided_name else display_name end display_name  from " + table + " where  subsystem_id=" + Integer.toString(id);
            } else {
                table = "t_res_switch";
                query = "select  switch_wwn, display_name from " + table + " where  switch_id=" + Integer.toString(id);
            }
            stat2 = this.connection.createStatement();
            result2 = stat2.executeQuery(query);
            if (result2.next()) {
                name = result2.getString(1);
                displayName = result2.getString(2);
                if (displayName == null || displayName.length() == 0) {
                    displayName = name;
                }
            }
        }
        catch (SQLException se) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)this.getClass().getName(), (String)"findResourceName", (Throwable)se);
            }
            this.errorMessage = SQLUtil.getSQLExceptionMsg("SRV0082E", se, new String[]{table});
        }
        finally {
            block26: {
                block25: {
                    if (result2 != null) {
                        try {
                            result2.close();
                        }
                        catch (Exception exc) {
                            if (!TraceLogger.enableTrace) break block25;
                            TraceLogger.exception((String)this.getClass().getName(), (String)"findResourceName", (Throwable)exc);
                        }
                    }
                }
                if (stat2 != null) {
                    try {
                        stat2.close();
                    }
                    catch (Exception exc) {
                        if (!TraceLogger.enableTrace) break block26;
                        TraceLogger.exception((String)this.getClass().getName(), (String)"findResourceName", (Throwable)exc);
                    }
                }
            }
        }
        return displayName;
    }
}

