/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.disk.api.IDiskManagerService;
import org.eclipse.aperi.disk.api.VolumeID;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.gui.disk.common.model.DiskDataControllerConstants;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr;

public class SubsystemActionHandler
extends DeviceJobHndlr {
    private IDiskManagerService dmService = null;
    private String userName = null;
    private IJobMgmtService jobService = null;

    public int deviceAPI(DeviceRequest request, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SubsystemActionHandler.class.getName(), (String)"deviceAPI", (String)"request, response");
        }
        GUIRequestData reqData = (GUIRequestData)request.requestData;
        this.userName = request.userName;
        int jobID = DiskDataControllerConstants.INVALID_JOBID;
        try {
            DeviceRequestHndlr.initDeviceServerComm(request);
            this.dmService = (IDiskManagerService)ConnectorClient.getService((String)request.deviceServerHost, (int)request.deviceServerPort, IDiskManagerService.class, (String)"DiskManagerService");
            this.jobService = (IJobMgmtService)ConnectorClient.getService((String)request.deviceServerHost, (int)request.deviceServerPort, IJobMgmtService.class, (String)"FabricManagerService");
            AsyncResult result = null;
            if (reqData.getActionId() == 0) {
                result = this.createVolumes(reqData, response);
            } else if (reqData.getActionId() == 6) {
                result = this.createVolumesExt(reqData, response);
            } else if (reqData.getActionId() == 1) {
                result = this.createVDisks(reqData, response);
            } else if (reqData.getActionId() == 2) {
                result = this.addMDisks(reqData, response);
            } else if (reqData.getActionId() == 3) {
                result = this.deleteVolumes(reqData, response);
            } else if (reqData.getActionId() == 4) {
                result = this.assignPorts(reqData, response);
            } else if (reqData.getActionId() == 5) {
                result = this.unassignPorts(reqData, response);
            } else if (reqData.getActionId() == 7) {
                result = this.createVolumesAndAssignPorts(reqData, request, response);
            } else if (reqData.getActionId() == 8) {
                result = this.createVolumesExtAndAssignPorts(reqData, request, response);
            } else if (reqData.getActionId() == 9) {
                result = this.createVDisksAndAssignPorts(reqData, request, response);
            }
            if (result != null) {
                if (result.getReturnException() != null) {
                    throw result.getReturnException();
                }
                jobID = Integer.parseInt(result.getJobId());
                if (jobID >= 1 && !reqData.isWillWaitForComplete()) {
                    request.deviceRunNbr = jobID;
                    DeviceJobHndlr.setDeviceJobID(request);
                    new JobResultThread(jobID, response).start();
                }
            }
        }
        catch (Exception ex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SubsystemActionHandler.class.getName(), (String)"deviceAPI", (Throwable)ex);
            }
            response.status = (short)12;
            if (ex instanceof SRMRuntimeException) {
                response.errorMessage = ((SRMRuntimeException)ex).getLocalizedMessage();
            } else {
                String[] inserts = new String[]{};
                String msg = ex.getMessage();
                if (msg != null) {
                    inserts = new String[]{msg};
                }
                response.errorMessage = new SRMMessage("HWN021503E", inserts).getLocalizedMessage();
            }
            response.responseData = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SubsystemActionHandler.class.getName(), (String)"deviceAPI", (int)jobID);
        }
        return jobID;
    }

    private AsyncResult createVolumes(GUIRequestData reqData, Response response) throws Exception {
        Long volSize = (Long)reqData.getParameter("volume.size");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVolumes", (String)("volSize: " + volSize));
        StringBuffer auditMsgBuffer = new StringBuffer("Username = " + this.userName);
        auditMsgBuffer.append("\n Create Volumes ");
        String stgpoolId = (String)((Object)reqData.getParameter("storagepool.id"));
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVolumes", (String)("stgpoolId: " + stgpoolId));
        Long numVols = (Long)reqData.getParameter("num.of.volumes");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVolumes", (String)("numVols: " + numVols));
        auditMsgBuffer.append("\n Number of volume(s) = ");
        auditMsgBuffer.append(numVols);
        String[] volNames = (String[])reqData.getParameter("volume.names");
        if (volNames != null) {
            TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVolumes", (String)("volNames: " + String.valueOf(volNames)));
        }
        long[] sizes = new long[numVols.intValue()];
        auditMsgBuffer.append("\n Size of volume(s) = ");
        auditMsgBuffer.append(String.valueOf(volSize));
        if (TraceLogger.enableAudit) {
            TraceLogger.auditMessage((String)SubsystemActionHandler.class.getName(), (String)"createVolumes()", (String)String.valueOf(auditMsgBuffer));
        }
        String[] poolIds = new String[numVols.intValue()];
        for (int i = 0; i < numVols.intValue(); ++i) {
            sizes[i] = volSize;
            poolIds[i] = stgpoolId;
        }
        return this.dmService.createStorageVolumes(sizes, poolIds, volNames, null);
    }

    private AsyncResult createVolumesExt(GUIRequestData reqData, Response response) throws Exception {
        HashMap goal;
        long[] volSizes = (long[])reqData.getParameter("volume.sizes");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVolumesExt", (String)("volSizes: " + String.valueOf(volSizes)));
        StringBuffer auditMsgBuffer = new StringBuffer("Username = " + this.userName);
        auditMsgBuffer.append("\n Create Volume Extent ");
        String[] stgpoolIds = (String[])reqData.getParameter("storagepool.ids");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVolumesExt", (String)("stgpoolIds: " + String.valueOf(stgpoolIds)));
        String[] volNames = (String[])reqData.getParameter("volume.names");
        if (volNames != null) {
            TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVolumesExt", (String)("volNames: " + String.valueOf(volNames)));
            auditMsgBuffer.append("\n volume names = ");
            for (int auditCounter = 0; auditCounter < volNames.length; ++auditCounter) {
                auditMsgBuffer.append(volNames[auditCounter]);
                auditMsgBuffer.append(" ");
            }
            auditMsgBuffer.append("\n");
        }
        if (TraceLogger.enableAudit) {
            TraceLogger.auditMessage((String)SubsystemActionHandler.class.getName(), (String)"createVolumesExt()", (String)String.valueOf(auditMsgBuffer));
        }
        if ((goal = (HashMap)reqData.getParameter("volume.crgoal")) != null) {
            TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVolumesExt", (String)("goal: " + goal));
        }
        return this.dmService.createStorageVolumes(volSizes, stgpoolIds, volNames, goal);
    }

    private AsyncResult createVDisks(GUIRequestData reqData, Response response) throws Exception {
        StringBuffer auditMsgBuffer = new StringBuffer("Username = " + this.userName);
        auditMsgBuffer.append("\n Create VDisks");
        Long vdiskSize = (Long)reqData.getParameter("vdisk.size");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVDisks", (String)("vdiskSize: " + vdiskSize));
        String mdiskGroupId = (String)((Object)reqData.getParameter("mdiskgroup.id"));
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVDisks", (String)("mdiskGroupId: " + mdiskGroupId));
        String[] vdiskNames = (String[])reqData.getParameter("vdisk.names");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVDisks", (String)("vdiskNames: " + vdiskNames));
        Boolean formatOnCreate = (Boolean)reqData.getParameter("vdisk.format.oncreate");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVDisks", (String)("formatOnCreate: " + formatOnCreate));
        Integer vdiskType = (Integer)reqData.getParameter("vdisk.type");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVDisks", (String)("vdiskType: " + vdiskType));
        Integer ioGroupId = (Integer)reqData.getParameter("iogroup.id");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVDisks", (String)("ioGroupId: " + ioGroupId));
        String[] mdiskIds = (String[])reqData.getParameter("mdisk.ids");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVDisks", (String)("mdiskIds: " + mdiskIds));
        Integer numOfVDisks = (Integer)reqData.getParameter("num.of.vdisks");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVDisks", (String)("numOfVDisks: " + numOfVDisks));
        long[] sizes = new long[numOfVDisks.intValue()];
        String[] mdiskgroupIds = new String[numOfVDisks.intValue()];
        for (int i = 0; i < numOfVDisks; ++i) {
            sizes[i] = vdiskSize;
            mdiskgroupIds[i] = mdiskGroupId;
        }
        auditMsgBuffer.append("\n Number of vdisks = ");
        auditMsgBuffer.append(numOfVDisks);
        auditMsgBuffer.append("\n Size = ");
        auditMsgBuffer.append(vdiskSize);
        if (TraceLogger.enableAudit) {
            TraceLogger.auditMessage((String)SubsystemActionHandler.class.getName(), (String)"createVDisks()", (String)auditMsgBuffer.toString());
        }
        return this.dmService.createSVCVDisks(sizes, mdiskgroupIds, vdiskNames, formatOnCreate.booleanValue(), vdiskType.intValue(), ioGroupId.intValue(), mdiskIds);
    }

    private AsyncResult addMDisks(GUIRequestData reqData, Response response) throws Exception {
        StringBuffer auditMsgBuffer = new StringBuffer("Username = " + this.userName);
        auditMsgBuffer.append("\n Add Mdisks");
        String mdiskGroupId = (String)((Object)reqData.getParameter("mdiskgroup.id"));
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"addMDisks", (String)("mdiskGroupId: " + mdiskGroupId));
        String[] mdiskIds = (String[])reqData.getParameter("mdisk.ids");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"addMDisks", (String)("mdiskIds: " + String.valueOf(mdiskIds)));
        auditMsgBuffer.append("\n mdisk Group ID = ");
        auditMsgBuffer.append(mdiskGroupId);
        auditMsgBuffer.append("\n mdisk ID(s) = ");
        if (mdiskIds != null) {
            for (int auditCounter = 0; auditCounter < mdiskIds.length; ++auditCounter) {
                auditMsgBuffer.append(mdiskIds[auditCounter]);
                auditMsgBuffer.append(" ");
            }
        }
        auditMsgBuffer.append("\n");
        if (TraceLogger.enableAudit) {
            TraceLogger.auditMessage((String)SubsystemActionHandler.class.getName(), (String)"addMDisks()", (String)auditMsgBuffer.toString());
        }
        return this.dmService.modifyStoragePoolSize(mdiskGroupId, mdiskIds, null);
    }

    private AsyncResult deleteVolumes(GUIRequestData reqData, Response response) throws Exception {
        StringBuffer auditMsgBuffer = new StringBuffer("Username = " + this.userName);
        auditMsgBuffer.append("\n Delete Volumes");
        String[] volumeIds = (String[])reqData.getParameter("volume.ids");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"deleteVolumes", (String)("volumeIds: " + String.valueOf(volumeIds)));
        auditMsgBuffer.append("Volume ID(s) = ");
        if (volumeIds != null) {
            for (int auditCounter = 0; auditCounter < volumeIds.length; ++auditCounter) {
                auditMsgBuffer.append(volumeIds[auditCounter]);
                auditMsgBuffer.append(" ");
            }
            auditMsgBuffer.append("\n");
        }
        if (TraceLogger.enableAudit) {
            TraceLogger.auditMessage((String)SubsystemActionHandler.class.getName(), (String)"deleteVolumes()", (String)auditMsgBuffer.toString());
        }
        return this.dmService.deleteStorageVolumes(volumeIds);
    }

    private AsyncResult assignPorts(GUIRequestData reqData, Response response) throws Exception {
        int auditCounter;
        StringBuffer auditMsgBuffer = new StringBuffer("Username = " + this.userName);
        auditMsgBuffer.append("\n Assign Ports");
        String[] volumeIds = (String[])reqData.getParameter("volume.ids");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"assignPorts", (String)("volumeIds: " + String.valueOf(volumeIds)));
        String[] systemPortWwpns = (String[])reqData.getParameter("system.ports");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"assignPorts", (String)("systemPortWwpns: " + String.valueOf(systemPortWwpns)));
        String[] hostPortWwpns = (String[])reqData.getParameter("host.ports");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"assignPorts", (String)("hostPortWwpns: " + String.valueOf(hostPortWwpns)));
        auditMsgBuffer.append("\nVolume ID(s) = ");
        if (volumeIds != null) {
            for (auditCounter = 0; auditCounter < volumeIds.length; ++auditCounter) {
                auditMsgBuffer.append(volumeIds[auditCounter]);
                auditMsgBuffer.append(" ");
            }
        }
        auditMsgBuffer.append("\nSubsystem port WWN(s) = ");
        if (systemPortWwpns != null) {
            for (auditCounter = 0; auditCounter < systemPortWwpns.length; ++auditCounter) {
                auditMsgBuffer.append(systemPortWwpns[auditCounter]);
                auditMsgBuffer.append(" ");
            }
        }
        auditMsgBuffer.append("\n Host port WWN(s) = ");
        if (hostPortWwpns != null) {
            for (auditCounter = 0; auditCounter < hostPortWwpns.length; ++auditCounter) {
                auditMsgBuffer.append(hostPortWwpns[auditCounter]);
                auditMsgBuffer.append(" ");
            }
        }
        auditMsgBuffer.append("\n");
        if (TraceLogger.enableAudit) {
            TraceLogger.auditMessage((String)SubsystemActionHandler.class.getName(), (String)"assignPorts()", (String)auditMsgBuffer.toString());
        }
        return this.dmService.assignStorageVolumesToWWPNs(volumeIds, systemPortWwpns, null, hostPortWwpns, -1, null, null, null, true);
    }

    private AsyncResult createVolumesAndAssignPorts(GUIRequestData reqData, DeviceRequest request, Response response) throws Exception {
        int jobID;
        AsyncResult result;
        int auditCounter;
        StringBuffer auditMsgBuffer = new StringBuffer("Username = " + this.userName);
        auditMsgBuffer.append("\n Create Volume and Assign Port");
        Long volSize = (Long)reqData.getParameter("volume.size");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVolumes", (String)("volSize: " + volSize));
        String stgpoolId = (String)((Object)reqData.getParameter("storagepool.id"));
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVolumes", (String)("stgpoolId: " + stgpoolId));
        Long numVols = (Long)reqData.getParameter("num.of.volumes");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVolumes", (String)("numVols: " + numVols));
        String[] volNames = (String[])reqData.getParameter("volume.names");
        if (volNames != null) {
            TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVolumes", (String)("volNames: " + String.valueOf(volNames)));
        }
        long[] sizes = new long[numVols.intValue()];
        String[] poolIds = new String[numVols.intValue()];
        for (int i = 0; i < numVols.intValue(); ++i) {
            sizes[i] = volSize;
            poolIds[i] = stgpoolId;
        }
        auditMsgBuffer.append("\n Number of volume(s) = ");
        auditMsgBuffer.append(numVols);
        auditMsgBuffer.append("\n Volume size(s) = ");
        auditMsgBuffer.append(volSize);
        String[] systemPortWwpns = (String[])reqData.getParameter("system.ports");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"assignPorts", (String)("systemPortWwpns: " + String.valueOf(systemPortWwpns)));
        String[] hostPortWwpns = (String[])reqData.getParameter("host.ports");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"assignPorts", (String)("hostPortWwpns: " + String.valueOf(hostPortWwpns)));
        auditMsgBuffer.append("\n Subsystem port WWN(s) = ");
        if (systemPortWwpns != null) {
            for (auditCounter = 0; auditCounter < systemPortWwpns.length; ++auditCounter) {
                auditMsgBuffer.append(systemPortWwpns[auditCounter]);
                auditMsgBuffer.append(" ");
            }
        }
        auditMsgBuffer.append("\n Host port WWN(s) = ");
        if (hostPortWwpns != null) {
            for (auditCounter = 0; auditCounter < hostPortWwpns.length; ++auditCounter) {
                auditMsgBuffer.append(hostPortWwpns[auditCounter]);
                auditMsgBuffer.append(" ");
            }
        }
        auditMsgBuffer.append("\n");
        if (TraceLogger.enableAudit) {
            TraceLogger.auditMessage((String)SubsystemActionHandler.class.getName(), (String)"createVolumesAndAssignPorts()", (String)auditMsgBuffer.toString());
        }
        if ((result = this.dmService.createStorageVolumes(sizes, poolIds, volNames, null)) != null && result.getReturnException() == null && (jobID = Integer.parseInt(result.getJobId())) >= 1) {
            request.deviceRunNbr = jobID;
            DeviceJobHndlr.setDeviceJobID(request);
            new PortAssignmentThread(jobID, response, request, hostPortWwpns, systemPortWwpns).start();
        }
        return result;
    }

    private AsyncResult createVolumesExtAndAssignPorts(GUIRequestData reqData, DeviceRequest request, Response response) throws Exception {
        int jobID;
        AsyncResult result;
        int auditCounter;
        HashMap goal;
        StringBuffer auditMsgBuffer = new StringBuffer("Username = " + this.userName);
        auditMsgBuffer.append("\n Create Volume Extent and Assign Ports");
        long[] volSizes = (long[])reqData.getParameter("volume.sizes");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVolumesExt", (String)("volSizes: " + String.valueOf(volSizes)));
        String[] stgpoolIds = (String[])reqData.getParameter("storagepool.ids");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVolumesExt", (String)("stgpoolIds: " + String.valueOf(stgpoolIds)));
        String[] volNames = (String[])reqData.getParameter("volume.names");
        if (volNames != null) {
            TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVolumesExt", (String)("volNames: " + String.valueOf(volNames)));
        }
        if ((goal = (HashMap)reqData.getParameter("volume.crgoal")) != null) {
            TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVolumesExt", (String)("goal: " + goal));
        }
        String[] systemPortWwpns = (String[])reqData.getParameter("system.ports");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"assignPorts", (String)("systemPortWwpns: " + String.valueOf(systemPortWwpns)));
        String[] hostPortWwpns = (String[])reqData.getParameter("host.ports");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"assignPorts", (String)("hostPortWwpns: " + String.valueOf(hostPortWwpns)));
        auditMsgBuffer.append("\n volume names = ");
        if (volNames != null) {
            for (auditCounter = 0; auditCounter < volNames.length; ++auditCounter) {
                auditMsgBuffer.append(volNames[auditCounter]);
                auditMsgBuffer.append(" ");
            }
        }
        auditMsgBuffer.append("\nSubsystem port WWN(s) = ");
        if (systemPortWwpns != null) {
            for (auditCounter = 0; auditCounter < systemPortWwpns.length; ++auditCounter) {
                auditMsgBuffer.append(systemPortWwpns[auditCounter]);
                auditMsgBuffer.append(" ");
            }
        }
        auditMsgBuffer.append("\n Host port WWN(s) = ");
        if (hostPortWwpns != null) {
            for (auditCounter = 0; auditCounter < hostPortWwpns.length; ++auditCounter) {
                auditMsgBuffer.append(hostPortWwpns[auditCounter]);
                auditMsgBuffer.append(" ");
            }
        }
        auditMsgBuffer.append("\n");
        if (TraceLogger.enableAudit) {
            TraceLogger.auditMessage((String)SubsystemActionHandler.class.getName(), (String)"createVolumesExtAndAssignPorts()", (String)auditMsgBuffer.toString());
        }
        if ((result = this.dmService.createStorageVolumes(volSizes, stgpoolIds, volNames, goal)) != null && result.getReturnException() == null && (jobID = Integer.parseInt(result.getJobId())) >= 1) {
            request.deviceRunNbr = jobID;
            DeviceJobHndlr.setDeviceJobID(request);
            new PortAssignmentThread(jobID, response, request, hostPortWwpns, systemPortWwpns).start();
        }
        return result;
    }

    private AsyncResult createVDisksAndAssignPorts(GUIRequestData reqData, DeviceRequest request, Response response) throws Exception {
        int jobID;
        AsyncResult result;
        int auditCounter;
        StringBuffer auditMsgBuffer = new StringBuffer("Username = " + this.userName);
        auditMsgBuffer.append("\n Create Vdisks and Assign Ports");
        Long vdiskSize = (Long)reqData.getParameter("vdisk.size");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVDisks", (String)("vdiskSize: " + vdiskSize));
        String mdiskGroupId = (String)((Object)reqData.getParameter("mdiskgroup.id"));
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVDisks", (String)("mdiskGroupId: " + mdiskGroupId));
        String[] vdiskNames = (String[])reqData.getParameter("vdisk.names");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVDisks", (String)("vdiskNames: " + vdiskNames));
        Boolean formatOnCreate = (Boolean)reqData.getParameter("vdisk.format.oncreate");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVDisks", (String)("formatOnCreate: " + formatOnCreate));
        Integer vdiskType = (Integer)reqData.getParameter("vdisk.type");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVDisks", (String)("vdiskType: " + vdiskType));
        Integer ioGroupId = (Integer)reqData.getParameter("iogroup.id");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVDisks", (String)("ioGroupId: " + ioGroupId));
        String[] mdiskIds = (String[])reqData.getParameter("mdisk.ids");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVDisks", (String)("mdiskIds: " + mdiskIds));
        Integer numOfVDisks = (Integer)reqData.getParameter("num.of.vdisks");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"createVDisks", (String)("numOfVDisks: " + numOfVDisks));
        long[] sizes = new long[numOfVDisks.intValue()];
        String[] mdiskgroupIds = new String[numOfVDisks.intValue()];
        for (int i = 0; i < numOfVDisks; ++i) {
            sizes[i] = vdiskSize;
            mdiskgroupIds[i] = mdiskGroupId;
        }
        String[] systemPortWwpns = (String[])reqData.getParameter("system.ports");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"assignPorts", (String)("systemPortWwpns: " + String.valueOf(systemPortWwpns)));
        String[] hostPortWwpns = (String[])reqData.getParameter("host.ports");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"assignPorts", (String)("hostPortWwpns: " + String.valueOf(hostPortWwpns)));
        auditMsgBuffer.append("\n Number of vdisks = ");
        auditMsgBuffer.append(numOfVDisks);
        auditMsgBuffer.append("\n Size = ");
        auditMsgBuffer.append(vdiskSize);
        auditMsgBuffer.append("\n Subsystem port WWN(s) = ");
        if (systemPortWwpns != null) {
            for (auditCounter = 0; auditCounter < systemPortWwpns.length; ++auditCounter) {
                auditMsgBuffer.append(systemPortWwpns[auditCounter]);
                auditMsgBuffer.append(" ");
            }
        }
        auditMsgBuffer.append("\n Host port WWN(s) = ");
        if (hostPortWwpns != null) {
            for (auditCounter = 0; auditCounter < hostPortWwpns.length; ++auditCounter) {
                auditMsgBuffer.append(hostPortWwpns[auditCounter]);
                auditMsgBuffer.append(" ");
            }
        }
        auditMsgBuffer.append("\n");
        if (TraceLogger.enableAudit) {
            TraceLogger.auditMessage((String)SubsystemActionHandler.class.getName(), (String)"createVDisksAndAssignPorts()", (String)auditMsgBuffer.toString());
        }
        if ((result = this.dmService.createSVCVDisks(sizes, mdiskgroupIds, vdiskNames, formatOnCreate.booleanValue(), vdiskType.intValue(), ioGroupId.intValue(), mdiskIds)) != null && result.getReturnException() == null && (jobID = Integer.parseInt(result.getJobId())) >= 1) {
            request.deviceRunNbr = jobID;
            DeviceJobHndlr.setDeviceJobID(request);
            new PortAssignmentThread(jobID, response, request, hostPortWwpns, systemPortWwpns).start();
        }
        return result;
    }

    private AsyncResult unassignPorts(GUIRequestData reqData, Response response) throws Exception {
        int auditCounter;
        StringBuffer auditMsgBuffer = new StringBuffer("Username = " + this.userName);
        auditMsgBuffer.append("\n Unassign Ports");
        String[] volumeIds = (String[])reqData.getParameter("volume.ids");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"unassignPorts", (String)("volumeIds: " + String.valueOf(volumeIds)));
        String[] hostPortWwpns = (String[])reqData.getParameter("host.ports");
        TraceLogger.traceMessage((int)1, (String)SubsystemActionHandler.class.getName(), (String)"unassignPorts", (String)("hostPortWwpns: " + String.valueOf(hostPortWwpns)));
        auditMsgBuffer.append("\n Volumd ID(s) = ");
        if (volumeIds != null) {
            for (auditCounter = 0; auditCounter < volumeIds.length; ++auditCounter) {
                auditMsgBuffer.append(volumeIds[auditCounter]);
                auditMsgBuffer.append(" ");
            }
        }
        auditMsgBuffer.append("\n Host port WWN(s) = ");
        if (hostPortWwpns != null) {
            for (auditCounter = 0; auditCounter < hostPortWwpns.length; ++auditCounter) {
                auditMsgBuffer.append(hostPortWwpns[auditCounter]);
                auditMsgBuffer.append(" ");
            }
        }
        auditMsgBuffer.append("\n");
        if (TraceLogger.enableAudit) {
            TraceLogger.auditMessage((String)SubsystemActionHandler.class.getName(), (String)"unassignPorts()", (String)auditMsgBuffer.toString());
        }
        return this.dmService.unassignStorageVolumesFromWWPNs(volumeIds, hostPortWwpns, true);
    }

    public class PortAssignmentThread
    extends Thread {
        protected int jobID = 0;
        protected String[] hostPortWwpns = null;
        protected String[] systemPortWwpns = null;
        protected Response response = null;
        protected DeviceRequest request = null;
        private Vector<String> volumeVector = new Vector();
        private String[] volumeIDs = null;

        public PortAssignmentThread(int jobID, Response response, DeviceRequest request, String[] hostPortWwpns, String[] systemPortWwpns) {
            this.jobID = jobID;
            this.response = response;
            this.request = request;
            this.hostPortWwpns = hostPortWwpns;
            this.systemPortWwpns = systemPortWwpns;
        }

        public void run() {
            AsyncResult result;
            DeviceJobHndlr.waitForDeviceJob(this.response, this.jobID, SubsystemActionHandler.this.jobService);
            if (this.response != null && (result = (AsyncResult)this.response.responseData) != null) {
                AsyncResult[] subResults = result.getSubJobResults();
                for (int i = 0; i < subResults.length; ++i) {
                    Exception tpcEx = subResults[i].getReturnException();
                    if (tpcEx != null) {
                        String errorMsg = tpcEx.getMessage();
                        if (tpcEx instanceof SRMRuntimeException) {
                            errorMsg = ((SRMRuntimeException)tpcEx).getLocalizedMessage();
                        }
                        if (errorMsg != null) {
                            // empty if block
                        }
                    }
                    if (subResults[i] != null && subResults[i].getResults() != null && subResults[i].getRc() <= 0) {
                        VolumeID[] volumeIds = (VolumeID[])subResults[i].getResults();
                        this.volumeVector.add(volumeIds[0].getStorageVolumeID());
                    }
                    this.volumeIDs = this.volumeVector.toArray(new String[0]);
                }
                if (this.hostPortWwpns != null && this.hostPortWwpns.length > 0 && this.volumeIDs.length > 0) {
                    try {
                        int pajobID;
                        AsyncResult paresult = SubsystemActionHandler.this.dmService.assignStorageVolumesToWWPNs(this.volumeIDs, this.systemPortWwpns, null, this.hostPortWwpns, -1, null, null, null, true);
                        if (paresult != null && paresult.getReturnException() == null && (pajobID = Integer.parseInt(paresult.getJobId())) >= 1) {
                            this.request.deviceRunNbr = pajobID;
                            boolean status = DeviceJobHndlr.createNewScheduledJob(this.request, this.response);
                            if (!status) {
                                if (TraceLogger.enableTrace) {
                                    TraceLogger.exit((String)SubsystemActionHandler.class.getName(), (String)"PortAssignmentThread::run()");
                                }
                            } else {
                                DeviceJobHndlr.setDeviceJobID(this.request);
                                new JobResultThread(pajobID, this.response).start();
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class JobResultThread
    extends Thread {
        protected int jobID = 0;
        protected Response response = null;

        public JobResultThread(int jobID, Response response) {
            this.jobID = jobID;
            this.response = response;
        }

        public void run() {
            AsyncResult result;
            DeviceJobHndlr.waitForDeviceJob(this.response, this.jobID, SubsystemActionHandler.this.jobService);
            if (this.response != null && (result = (AsyncResult)this.response.responseData) != null) {
                AsyncResult[] subResults = result.getSubJobResults();
                for (int i = 0; i < subResults.length; ++i) {
                    Exception tpcEx = subResults[i].getReturnException();
                    if (tpcEx != null) {
                        String errorMsg = tpcEx.getMessage();
                        if (tpcEx instanceof SRMRuntimeException) {
                            errorMsg = ((SRMRuntimeException)tpcEx).getLocalizedMessage();
                        }
                        if (errorMsg != null) {
                            // empty if block
                        }
                    }
                    if (subResults[i] == null || subResults[i].getResults() == null || subResults[i].getRc() > 0) continue;
                    Object[] retvals = subResults[i].getResults();
                }
            }
        }
    }
}

