/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import org.eclipse.aperi.agent.req.AgentStatusReq;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.dbaccess.HostAgentPingDbAccess;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.handler.server.GuiHndlr;
import org.eclipse.aperi.server.jobs.Ping;
import org.eclipse.aperi.server.req.GuiToAgentReq;

public class GuiToAgentHndlr
implements RequestHandler,
ThreadSafe {
    public Response handle(Request request, Transceiver comm) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiToAgentHndlr.class.getName(), (String)"handle", (String)"request, comm");
        }
        if (!RequestChecker.isDesiredType(GuiToAgentReq.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)GuiToAgentHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        GuiToAgentReq data = (GuiToAgentReq)request.requestData;
        Request agentRequest = new Request();
        agentRequest.machineName = request.machineName;
        agentRequest.serviceName = RequestTypeManager.getInternalName((String)"org.eclipse.aperi.agent.svp.AgentSvp");
        agentRequest.userName = request.userName;
        agentRequest.typeCode = "org.eclipse.aperi.agent.svp.AgentSvp";
        agentRequest.subType = data.requestHandler;
        agentRequest.requestData = data.agentData;
        boolean isStatusReq = false;
        boolean isVerboseStatusReq = false;
        if (data.requestHandler == "org.eclipse.aperi.agent.handler.status.StatusHandler" && data.agentData != null) {
            isStatusReq = true;
            AgentStatusReq agentStatusReq = (AgentStatusReq)data.agentData;
            isVerboseStatusReq = agentStatusReq.isVerbose();
        }
        boolean forceTransmission = false;
        if (isStatusReq && !isVerboseStatusReq) {
            forceTransmission = true;
        }
        int pingStatus = 0;
        Response agentResponse = Server.agentMgr.transmitToAgent(agentRequest, null, data.computerID, forceTransmission);
        if (agentResponse == null) {
            Server.setResponseError(response, "SRV0076E");
            agentResponse = response;
            if (isStatusReq && !isVerboseStatusReq) {
                Server.agentMgr.setState(data.computerID, (byte)0);
                pingStatus = this.ping(data.computerID);
                agentResponse.responseData = GuiHndlr.getAgentStateForGui(data.computerID);
            }
        } else {
            response.returnResponse();
            if (isStatusReq && !isVerboseStatusReq) {
                if (agentResponse.status == 0) {
                    Server.agentMgr.setState(data.computerID, (byte)1);
                    pingStatus = 1;
                } else {
                    if (agentResponse.status == 34) {
                        Server.agentMgr.setState(data.computerID, (byte)0);
                    }
                    int status = this.ping(data.computerID);
                    switch (status) {
                        case 0: {
                            pingStatus = 1;
                            break;
                        }
                        default: {
                            pingStatus = 0;
                        }
                    }
                }
                agentResponse.responseData = GuiHndlr.getAgentStateForGui(data.computerID);
            }
        }
        if (isStatusReq && !isVerboseStatusReq) {
            HostAgentPingDbAccess.updateHostStatus((int)data.computerID, (int)pingStatus);
        }
        Response traceResult = agentResponse;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiToAgentHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    public int ping(int computerID) {
        int status = 2;
        AgentManager agentMgr = Server.getAgentManager();
        String hostAddress = agentMgr.getHostAddress(computerID);
        if (hostAddress != null) {
            status = Ping.pingHostByName(hostAddress);
        }
        return status;
    }
}

