/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.sql.Connection;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Rename;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.Renamer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.xmsg.MessageLog;

public class RenameHndlr
implements RequestHandler,
ThrowAway {
    private static final String T_SCHEDULE = "t_schedule";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RenameHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (!RequestChecker.isDesiredType(Rename.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RenameHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        Rename rename = (Rename)request.requestData;
        String label = ResourceTypeManager.getRenameLabel((short)rename.rnObjectType);
        String table = ResourceTypeManager.getRenameTable((short)rename.rnObjectType);
        String idColumn = ResourceTypeManager.getRenameIdColumn((short)rename.rnObjectType);
        if (label == null || table == null || idColumn == null) {
            Object[] args = new Object[]{new Integer(rename.rnObjectType)};
            Server.setResponseError(response, "SRV0099E", args);
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RenameHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        Connection dbc = Server.getConnection();
        try {
            if (ResourceTypeManager.getRenameHasAlert((short)rename.rnObjectType)) {
                new Renamer(dbc, "t_alert_definition", "alert_id", MessageLog.getMessageNoID((String)"STS0109L")).rename(rename, false);
            }
            Renamer accessor = new Renamer(dbc, table, idColumn, label);
            response.responseData = accessor.rename(rename, true);
            if (TraceLogger.enableAudit) {
                TraceLogger.auditMessage((String)RenameHndlr.class.getName(), (String)"handle()", (String)("\n Username=" + rename.rnModifyingUser + " Rename. " + "Definition type='" + label + "'.  Old name='" + rename.rnOldName + "' New name='" + rename.rnNewName + "'."));
            }
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RenameHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            Server.setResponseError(response, (Exception)((Object)e));
        }
        finally {
            Server.returnConnection(dbc);
        }
        if (table.equals(T_SCHEDULE)) {
            ScheduleQueue.routine.addRename(rename.rnID, rename.rnNewName);
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RenameHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }
}

