/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleData;
import org.eclipse.aperi.sanmgmt.middleware.data.Roles;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IDeviceServiceManager;
import org.eclipse.aperi.server.DeviceServerManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.req.RolesUpdateReq;
import org.eclipse.aperi.xmsg.MessageLog;

public class RolesUpdateHndlr
implements RequestHandler,
ThrowAway {
    private Roles roles = Roles.getInstance();

    public Response handle(Request request, Transceiver comm) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RolesUpdateHndlr.class.getName(), (String)"handle", (String)"request, comm");
        }
        if (!RequestChecker.isDesiredType(RolesUpdateReq.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RolesUpdateHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        RolesUpdateReq sr = (RolesUpdateReq)request.requestData;
        if (!this.isValidRequestData(response, sr)) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RolesUpdateHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        while (sr.flags != 0) {
            if ((sr.flags & 1) == 1) {
                sr.flags = (byte)(sr.flags ^ 1);
                continue;
            }
            if ((sr.flags & 2) == 2) {
                try {
                    if (this.roles.update(sr.roleData)) {
                        this.updateDeviceServer(response);
                        sr.flags = (byte)(sr.flags ^ 2);
                        continue;
                    }
                    Server.setResponseError(response, "SRV0700E");
                    response.responseData = this.setResponseData((byte)2, null);
                    sr.flags = 0;
                }
                catch (SQLException ex) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)RolesUpdateHndlr.class.getName(), (String)"handle", (Throwable)ex);
                    }
                    Server.setResponseError(response, ex);
                    sr.flags = 0;
                }
                continue;
            }
            if ((sr.flags & 4) == 4) {
                Hashtable myMap = this.roles.getFullRoleMap();
                if (myMap.size() != 0) {
                    RoleData[] cacheData = new RoleData[myMap.size()];
                    Collection values = myMap.values();
                    response.responseData = this.setResponseData((byte)4, values.toArray(cacheData));
                } else {
                    Server.setResponseError(response, "SRV0701E");
                    response.responseData = this.setResponseData((byte)4, null);
                }
                sr.flags = 0;
                continue;
            }
            sr.flags = 0;
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RolesUpdateHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    private RolesUpdateReq setResponseData(byte flags, RoleData[] roleData) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RolesUpdateHndlr.class.getName(), (String)"setResponseData", (String)"flags, roleData");
        }
        RolesUpdateReq responseData = new RolesUpdateReq();
        responseData.flags = flags;
        responseData.roleData = roleData;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RolesUpdateHndlr.class.getName(), (String)"setResponseData", (Object)responseData);
        }
        return responseData;
    }

    private void updateDeviceServer(Response response) {
        DeviceServerManager dsm;
        org.eclipse.aperi.infrastructure.database.objects.Server deviceServer;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RolesUpdateHndlr.class.getName(), (String)"updateDeviceServer", (String)"");
        }
        if ((deviceServer = (dsm = Server.getDeviceServerManager()).getDeviceServer()) != null) {
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            IDeviceServiceManager serviceManager = (IDeviceServiceManager)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDeviceServiceManager.class, (String)"DeviceServiceManager");
            if (serviceManager != null) {
                try {
                    serviceManager.refreshRoleCache();
                }
                catch (SQLException ex) {
                    String method = "refreshRoleCache";
                    MessageLog.logException((String)"SRV0703E", (Exception)ex, (Object)method);
                    Server.setResponseError(response, "SRV0709W", method);
                }
                catch (RuntimeException runEx) {
                    MessageLog.logMessage((String)"SRV0702W");
                    Server.setResponseWarning(response, "SRV0709W");
                }
            } else {
                String service = "DeviceServiceManager";
                MessageLog.logMessage((String)"SRV0704E", (Object)service);
                Server.setResponseError(response, "SRV0709W");
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RolesUpdateHndlr.class.getName(), (String)"updateDeviceServer");
        }
    }

    private boolean isValidRequestData(Response response, RolesUpdateReq sr) {
        boolean status = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RolesUpdateHndlr.class.getName(), (String)"isValidRequestData", (String)"response, sr");
        }
        if (!sr.isValidFlags()) {
            Server.setResponseError(response, "SRV0705E", new Byte(sr.flags));
        } else if (sr.flags == 4) {
            status = true;
        } else if (sr.roleData == null) {
            Server.setResponseError(response, "SRV0706E");
        } else {
            Vector<RoleData> rtnData = new Vector<RoleData>(sr.roleData.length);
            for (int i = 0; i < sr.roleData.length; ++i) {
                String groupName = sr.roleData[i].getGroupName();
                int roleID = RoleChecker.getRoleID((String)sr.roleData[i].getRoleName());
                if (groupName != null && !this.roles.isValidRoleData(sr.roleData[i])) {
                    rtnData.add(sr.roleData[i]);
                }
                if (groupName != null || roleID != RoleChecker.SUPERUSER) continue;
                MessageLog.logMessage((String)"SRV0708W");
            }
            if (!rtnData.isEmpty()) {
                RoleData[] data = new RoleData[rtnData.size()];
                data = rtnData.toArray(data);
                String invalidGroupNames = null;
                for (int i = 0; i < data.length; ++i) {
                    String groupName = data[i].getGroupName();
                    invalidGroupNames = invalidGroupNames == null ? groupName : invalidGroupNames + groupName;
                    if (i + 1 == data.length) continue;
                    invalidGroupNames = invalidGroupNames + ", ";
                }
                Server.setResponseError(response, data.length == 1 ? "SRV0711E" : "SRV0707E", invalidGroupNames);
                response.responseData = this.setResponseData(sr.flags, data);
            } else {
                status = true;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RolesUpdateHndlr.class.getName(), (String)"isValidRequestData", (boolean)status);
        }
        return status;
    }
}

