/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.sql.Connection;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TReportPrefs;
import org.eclipse.aperi.repository.table.TUserPrefs;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.req.UserPrefUpdReq;

public class UserPrefUpdHndlr
implements RequestHandler,
ThrowAway {
    public Response handle(Request request, Transceiver comm) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)UserPrefUpdHndlr.class.getName(), (String)"handle", (String)"request, comm");
        }
        if (!RequestChecker.isDesiredType(UserPrefUpdReq.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)UserPrefUpdHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        UserPrefUpdReq req = (UserPrefUpdReq)request.requestData;
        Connection dbc = Server.getConnection();
        if (dbc == null) {
            Server.setResponseError(response, "GEN0050E");
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)UserPrefUpdHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        try {
            new TUserPrefs(dbc).saveUserPref(req.id, req.prefs);
            new TReportPrefs(dbc).savePrefs(req.id, req.prefs.sm.reportPrefs);
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)UserPrefUpdHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            Server.setResponseError(response, (Exception)((Object)e));
        }
        Server.returnConnection(dbc);
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UserPrefUpdHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }
}

