/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TAggregator;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.repository.table.TStatDiskHist;
import org.eclipse.aperi.repository.table.TStatTotals;
import org.eclipse.aperi.repository.table.TStormSettings;
import org.eclipse.aperi.server.ServerJob;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.server.jobs.HistAvgs;
import org.eclipse.aperi.server.jobs.OSAggregationMap;
import org.eclipse.aperi.server.jobs.SummaryAggregation;
import org.eclipse.aperi.xmsg.MessageLog;

public class Aggregator
implements ServerJob {
    private Connection dbc;
    private Settings settings;
    private OSAggregationMap aggregationMap;
    private TStatDiskHist dhAccessor;
    private TAggregator taAccessor;
    private SummaryAggregation summaryBuffer;
    private long runTime;
    private static final long MILLIS_PER_WEEK = 604800000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final String AGGREGATOR_LOCK = "AGGREGATOR";
    public static final String[] AGGREGATED_FS_HISTORY = new String[]{"t_stat_fs_hist", "t_stat_space_hist", "t_stat_user_hist", "t_stat_group_hist", "t_stat_time_hist", "t_stat_ftype_hist"};
    public static final String[] AGGREGATED_DIR_HISTORY = new String[]{"t_stat_space_hist", "t_stat_time_hist"};

    public Aggregator(Connection dbc) {
        this.initialize(dbc);
    }

    public Aggregator() {
    }

    public void initialize(Connection dbc) {
        block2: {
            this.dbc = dbc;
            try {
                this.runTime = SQLUtil.getTimestamp(dbc).getTime();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception((String)Aggregator.class.getName(), (String)"Aggregator", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(VMJobResults job, String[] parms) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Aggregator.class.getName(), (String)"run", (String)"job, parms");
        }
        MessageLog.logMessage((String)"STS0128I");
        int completionCode = 8;
        boolean haveLock = false;
        try {
            haveLock = LockManager.lock((short)0, (String)AGGREGATOR_LOCK, (String)AGGREGATOR_LOCK, (byte)1, (boolean)false);
            if (!haveLock) {
                MessageLog.logMessage((String)"STS0135W");
                int traceResult = 0;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Aggregator.class.getName(), (String)"run", (int)traceResult);
                }
                int n = traceResult;
                return n;
            }
            TStormSettings seAccessor = new TStormSettings(this.dbc);
            this.settings = seAccessor.getSettings();
            seAccessor = null;
            this.summaryBuffer = new SummaryAggregation(-1);
            this.aggregationMap = new OSAggregationMap(this.dbc);
            this.aggregationMap.initMaps(this.summaryBuffer);
            MessageLog.logMessage((String)"STS0134I");
            this.dhAccessor = new TStatDiskHist(this.dbc);
            this.dhAccessor.aggregateHist(this.settings, this.runTime);
            this.dhAccessor = null;
            this.aggregationMap = null;
            this.cleanuplog();
            this.taAccessor = new TAggregator(this.dbc);
            long lastWeekly = this.taAccessor.getLastWeekly();
            long lastMonthly = this.taAccessor.getLastMonthly();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(new Date(lastMonthly));
            int lastMonth = calendar.get(2);
            calendar.setTime(new Date(this.runTime));
            int thisDay = calendar.get(7);
            int thisMonth = calendar.get(2);
            long histAvgsTime = this.runTime + 3600000L;
            HistAvgs averager = null;
            if (thisDay == 7 || lastWeekly + 604800000L <= histAvgsTime) {
                lastWeekly = this.runTime;
                averager = new HistAvgs(this.dbc);
                averager.average(0);
            }
            if (thisMonth != lastMonth) {
                lastMonthly = this.runTime;
                if (averager == null) {
                    averager = new HistAvgs(this.dbc);
                }
                averager.average(1);
            }
            if (averager != null) {
                this.taAccessor.update(lastWeekly, lastMonthly);
            }
            TStatTotals totalsAccessor = new TStatTotals(this.dbc);
            totalsAccessor.aggregate(" ");
            MessageLog.logMessage((String)"STS0126I");
            completionCode = 0;
        }
        catch (GeneralException e) {
            String exceptionMsg;
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Aggregator.class.getName(), (String)"run", (Throwable)e);
            }
            if ((exceptionMsg = e.getMessage()) != null) {
                MessageLog.getThreadLog().println(exceptionMsg);
            }
            MessageLog.logMessage((String)"STS0125E");
        }
        finally {
            if (this.dhAccessor != null) {
                this.close(this.dhAccessor);
            }
            if (this.taAccessor != null) {
                this.close(this.taAccessor);
            }
            if (haveLock) {
                LockManager.unLock((short)0, (String)AGGREGATOR_LOCK, (String)AGGREGATOR_LOCK);
            }
        }
        int traceResult = completionCode;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Aggregator.class.getName(), (String)"run", (int)traceResult);
        }
        return traceResult;
    }

    private void cleanuplog() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Aggregator.class.getName(), (String)"cleanuplog", (String)"");
        }
        Map<Short, ExtAlertLog> map = null;
        MessageLog.logMessage((String)"STS0400I");
        TAlertLog alr = new TAlertLog(this.dbc);
        try {
            map = alr.selectforcleanup();
        }
        catch (GeneralException ge) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Aggregator.class.getName(), (String)"cleanuplog", (Throwable)ge);
            }
            MessageLog.logException((String)"STS0125E", (Exception)((Object)ge));
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Aggregator.class.getName(), (String)"cleanuplog");
            }
            return;
        }
        catch (SQLException se) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Aggregator.class.getName(), (String)"cleanuplog", (Throwable)se);
            }
            MessageLog.logException((String)"STS0125E", (Exception)se);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Aggregator.class.getName(), (String)"cleanuplog");
            }
            return;
        }
        for (ExtAlertLog curr : map.values()) {
            while (curr != null) {
                this.deleteLogRec(alr, curr);
                curr = curr.alnExt;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Aggregator.class.getName(), (String)"cleanuplog");
        }
    }

    private void deleteLogRec(TAlertLog alr, ExtAlertLog record) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Aggregator.class.getName(), (String)"deleteLogRec", (String)"alr, record");
        }
        try {
            alr.deleteByID(record);
        }
        catch (GeneralException ge) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Aggregator.class.getName(), (String)"deleteLogRec", (Throwable)ge);
            }
            MessageLog.logException((String)"STS0125E", (Exception)((Object)ge));
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Aggregator.class.getName(), (String)"deleteLogRec");
            }
            return;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Aggregator.class.getName(), (String)"deleteLogRec");
        }
    }

    public void close(RepositoryAccessor accessor) {
        block13: {
            block12: {
                block11: {
                    block10: {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.entry((String)Aggregator.class.getName(), (String)"close", (String)"accessor");
                        }
                        try {
                            accessor.closeSelect();
                        }
                        catch (GeneralException e) {
                            if (!TraceLogger.enableTrace) break block10;
                            TraceLogger.exception((String)Aggregator.class.getName(), (String)"close", (Throwable)e);
                        }
                    }
                    try {
                        accessor.closeInsert();
                    }
                    catch (GeneralException e) {
                        if (!TraceLogger.enableTrace) break block11;
                        TraceLogger.exception((String)Aggregator.class.getName(), (String)"close", (Throwable)e);
                    }
                }
                try {
                    accessor.closeUpdate();
                }
                catch (GeneralException e) {
                    if (!TraceLogger.enableTrace) break block12;
                    TraceLogger.exception((String)Aggregator.class.getName(), (String)"close", (Throwable)e);
                }
            }
            try {
                accessor.closeDelete();
            }
            catch (GeneralException e) {
                if (!TraceLogger.enableTrace) break block13;
                TraceLogger.exception((String)Aggregator.class.getName(), (String)"close", (Throwable)e);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Aggregator.class.getName(), (String)"close");
        }
    }

    public static interface HistoryAggregator {
        public void aggregate(Aggregator var1, Connection var2, Settings var3) throws GeneralException;
    }
}

