/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.util.smtp;

import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class BadRecipientException
extends LocalizableException {
    static final long serialVersionUID = -6615727983018837436L;
    public String[] recipientList;
    public String[] reasonList;

    public BadRecipientException(String smtpServer, String[] recipientList, String[] reasonList, boolean isWarning) {
        super(isWarning ? "GEN0109W" : "GEN0109E", new Object[]{smtpServer});
        this.recipientList = recipientList;
        this.reasonList = reasonList;
    }

    public void print() {
        MessageLog.getThreadLog().println(this.getMessage());
    }

    public String getMessage() {
        return this.getMessageBuffer().toString();
    }

    protected StringBuffer getMessageBuffer() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BadRecipientException.class.getName(), (String)"getMessageBuffer", (String)"");
        }
        StringBuffer buffer = new StringBuffer(400);
        buffer.append(super.getMessage());
        for (int i = 0; i < this.recipientList.length && this.recipientList[i] != null; ++i) {
            this.append(buffer, this.recipientList[i]);
            this.append(buffer, this.reasonList[i]);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BadRecipientException.class.getName(), (String)"getMessageBuffer", (Object)buffer);
        }
        return buffer;
    }

    private void append(StringBuffer buffer, String s) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BadRecipientException.class.getName(), (String)"append", (String)"buffer, s");
        }
        buffer.append('\n');
        buffer.append("                         ");
        buffer.append(s);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BadRecipientException.class.getName(), (String)"append");
        }
    }
}

