/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.util.snmp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.aperi.server.util.snmp.Asn1Value;
import org.eclipse.aperi.server.util.snmp.VarBind;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.NestableException;

public class TrapPdu {
    public static final int COLD_START = 0;
    public static final int WARM_START = 1;
    public static final int LINK_DOWN = 2;
    public static final int LINK_UP = 3;
    public static final int AUTHENTICATION_FAILURE = 4;
    public static final int EGP_NEIGHBOR_LOSS = 5;
    public static final int ENTERPRISE_SPECIFIC = 6;
    private int[] productOID;
    private InetAddress networkAddress;
    private int genericTrap;
    private int specificTrap;
    private long timeTicks;
    private Vector varBinds;

    public TrapPdu(int[] productOID, int genericTrap, int specificTrap, long timeTicks, Vector varBinds) throws LocalizableException {
        try {
            this.networkAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new NestableException("GEN0106E", null, (Exception)e);
        }
        this.productOID = productOID;
        this.genericTrap = genericTrap;
        this.specificTrap = specificTrap;
        this.timeTicks = timeTicks / 10L;
        this.varBinds = new Vector();
        this.addVarBinds(varBinds);
    }

    public TrapPdu(int[] productOID, int specificTrap, long timeTicks, Vector varBinds) throws LocalizableException {
        this(productOID, 6, specificTrap, timeTicks, varBinds);
    }

    public TrapPdu(int[] productOID, int specificTrap, long timeTicks) throws LocalizableException {
        this(productOID, 6, specificTrap, timeTicks, null);
    }

    public void addVarBind(VarBind v) {
        if (v != null) {
            this.varBinds.addElement(v);
        }
    }

    public void addVarBinds(Object[] v) {
        if (v != null) {
            for (int i = 0; i < v.length; ++i) {
                this.addVarBind((VarBind)v[i]);
            }
        }
    }

    public void addVarBinds(Vector v) {
        if (v != null) {
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                this.addVarBind((VarBind)e.nextElement());
            }
        }
    }

    public Asn1Value encode() {
        Asn1Value[] vb = new Asn1Value[this.varBinds.size()];
        for (int i = 0; i < vb.length; ++i) {
            vb[i] = ((VarBind)this.varBinds.elementAt(i)).encode();
        }
        Asn1Value[] content = new Asn1Value[]{Asn1Value.trellisoftOID(this.productOID), Asn1Value.ipAddress(this.networkAddress), new Asn1Value(this.genericTrap), new Asn1Value(this.specificTrap), Asn1Value.timeTicks(this.timeTicks), new Asn1Value(vb)};
        return new Asn1Value(Asn1Value.TRAP_ID, content);
    }
}

