/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.tape.collection;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.discovery.AssociatorCIMQuery;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.DiscoverStep;
import org.eclipse.aperi.discovery.IProgressLogger;
import org.eclipse.aperi.discovery.ProgressLogger;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeMediaLocationTable;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.tape.TapeManagerConstants;
import org.eclipse.aperi.tape.TapeReportingService;
import org.eclipse.aperi.tape.collection.TapeCIMProcessor;
import org.sblim.wbem.cim.CIMInstance;

public abstract class ProbeGenericTapeLibraryProcess
extends DiscoverProcess
implements TapeManagerConstants {
    private static final String QUERY_SLOTS = "select count(*) from t_res_tape_media_location where location_type=2 and tape_library_id=?";
    protected static final String COLLECTDRIVESROMCOMPUTERSYSTEM = "collectDrivesFromComputerSystem";
    protected static final String COLLECTCHASSISFROMCOMPUTERSYSTEM = "collectChassisFromComputerSystem";
    protected static final String COLLECTLIMITEDACCESSPORTSFROMCOMPUTERSYSTEM = "collectLimitedAccessPortsFromComputerSystem";
    protected static final String COLLECTCHANGERDEVICESFROMCOMPUTERSYSTEM = "collectChangerDevicesFromComputerSystem";
    protected static final String COLLECTREMOTESERVICEACCESSPOINTFROMCOMPUTERSYSTEM = "collectRemoteServiceAccessPointFromComputerSystem";
    protected static final String COLLECTSOFTWAREIDENTITYFROMCOMPUTERSYSTEM = "collectSoftwareIdentityFromComputerSystem";
    protected static final String COLLECTCONTROLLERFROMCOMPUTERSYSTEM = "collectControllerFromComputerSystem";
    protected static final String COLLECTFCPORTSFROMCOMPUTERSYSTEM = "collectFCPortsFromComputerSystem";
    protected static final String COLLECTFCPORTSFROMCONTROLLER = "collectFCPortsFromController";
    protected static final String COLLECTCONTROLLERSFROMDRIVES = "collectControllersFromDrives";
    protected static final String COLLECTCONTROLLERSFROMCHANGERDEVICE = "collectControllersFromChangerDevice";
    protected static final String COLLECTSOFTWAREIDENTITYFROMDRIVES = "collectSoftwareIdentityFromDrives";
    protected static final String COLLECTSOFTWAREIDENTITYFROMCHANGERDEVICE = "collectSoftwareIdentityFromChangerDevice";
    protected static final String COLLECTSTORAGEMEDIALOCATIONFORDRIVES = "collectStorageMediaLocationForDrives";
    protected static final String COLLECTSTORAGEMEDIALOCATIONFORLIMITEDACCESSPORTS = "collectStorageMediaLocationForLimitedAccessPorts";
    protected static final String COLLECTSTORAGEMEDIALOCATIONFORCHANGERDEVICES = "collectStorageMediaLocationForChangerDevices";
    protected static final String COLLECTCONTROLLERFROMCHANGERDEVICE = "collectControllerFromChangerDevice";
    protected static final String COLLECTCARTRIDGESFORCHASSIS = "collectCartridgesFromChassis";
    protected static final String COLLECTSTORAGEMEDIALOCATIONFORCARTRIDGES = "collectStorageMediaLocationForCartridges";
    protected static final String COLLECTSTORAGEMEDIALOCATIONFROMLIMITEDACCESSPORTS = "collectStorageMediaLocationForLimitedAccessPorts";
    protected static final String COLLECTMAGAZINESFROMCHASSIS = "collectMagazinesFromChassis";
    protected static final String COLLECTSTORAGEMEDIALOCATIONFROMCHASSIS = "collectStorageMediaLocationFromChassis";
    protected static final String COLLECTSTORAGEMEDIALOCATIONFROMMAGAZINE = "collectStorageMediaLocationFromMagazine";
    protected static final String MESSAGE_NAME = "aperi.logger.message.TapeManager";
    protected static final String TRACE_NAME = "aperi.logger.trace.TapeManager";
    protected static ILogger msgLogger = null;
    protected static ILogger traceLogger = null;
    public static String COMPUTERSYSTEM = "COMPUTERSYSTEM";
    public static String CHASSIS = "CHASSIS";
    public static String CARTRIDGE = "CARTRIDGE";
    public static String PHYSICALPACKAGE = "PHYSICALPACKAGE";
    public static String SCSIPROTOCOLCONTROLLER = "SCSIPROTOCOLCONTROLLER";
    public static String MEDIAACCESSDEVICE = "MEDIAACCESSDEVICE";
    public static String SOFTWAREIDENTITY = "SOFTWAREIDENTITY";
    public static String STORAGEMEDIALOCATION = "STORAGEMEDIALOCATION";
    public static String CHANGERDEVICE = "CHANGERDEVICE";
    public static String LIMITEDACCESSPORT = "LIMITEDACCESSPORT";
    public static String PHYSICALTAPE = "PHYSICALTAPE";
    public static String MAGAZINE = "MAGAZINE";

    public static void addLegacyDiscoverProcess(IDiscoverRouterService pRouter) {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        pRouter.addProcess(COLLECTCHASSISFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect Chassis From ComputerSystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_ComputerSystemPackage", (String)"CIM_Chassis", null, null), "IN_SYSTEM_" + COMPUTERSYSTEM, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTCARTRIDGESFORCHASSIS, (IDiscoverProcess)new AssociatorCIMQuery("Collect Cartridges From Chassis", Query.associators((String)"CIM_Chassis", (String)"CIM_PackagedComponent", (String)"CIM_PhysicalTape", null, null), "IN_SYSTEM_" + CHASSIS, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTSTORAGEMEDIALOCATIONFORCARTRIDGES, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageMediaLocation From Cartridge", Query.associators((String)"CIM_PhysicalTape", (String)"CIM_PhysicalMediaInLocation", (String)"CIM_StorageMediaLocation", null, null), "IN_SYSTEM_" + PHYSICALTAPE, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTREMOTESERVICEACCESSPOINTFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect RemoteServiceAccessPoint From ComputerSystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SAPAvailableForElement", (String)"CIM_RemoteServiceAccessPoint", null, null), "IN_SYSTEM_" + COMPUTERSYSTEM, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTSOFTWAREIDENTITYFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect SoftwareIdentity From ComputerSystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_InstalledSoftwareIdentity", (String)"CIM_SoftwareIdentity", null, null), "IN_SYSTEM_" + COMPUTERSYSTEM, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTDRIVESROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect Drives From ComputerSystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_MediaAccessDevice", null, null), "IN_SYSTEM_" + COMPUTERSYSTEM, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTSTORAGEMEDIALOCATIONFORDRIVES, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageMediaLocation For Drives", Query.associators((String)"CIM_MediaAccessDevice", (String)"CIM_Realizes", (String)"CIM_StorageMediaLocation", null, null), "IN_SYSTEM_" + MEDIAACCESSDEVICE, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTSOFTWAREIDENTITYFROMDRIVES, (IDiscoverProcess)new AssociatorCIMQuery("Collect SoftwareIdentity From Drives", Query.associators((String)"CIM_MediaAccessDevice", (String)"CIM_ElementSoftwareIdentity", (String)"CIM_SoftwareIdentity", null, null), "IN_SYSTEM_" + MEDIAACCESSDEVICE, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTCONTROLLERSFROMDRIVES, (IDiscoverProcess)new AssociatorCIMQuery("Collect Controllers From Drives", Query.associators((String)"CIM_MediaAccessDevice", (String)"CIM_ProtocolControllerForUnit", (String)"CIM_SCSIProtocolController", null, null), "IN_SYSTEM_" + MEDIAACCESSDEVICE, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTFCPORTSFROMCONTROLLER, (IDiscoverProcess)new AssociatorCIMQuery("Collect Ports From Controllers", Query.associators((String)"CIM_SCSIProtocolController", (String)"CIM_ProtocolControllerForPort", (String)"CIM_FCPort", null, null), "IN_SYSTEM_" + SCSIPROTOCOLCONTROLLER, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTCHANGERDEVICESFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect ChangerDevice From ComputerSystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_ChangerDevice", null, null), "IN_SYSTEM_" + COMPUTERSYSTEM, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTSTORAGEMEDIALOCATIONFORCHANGERDEVICES, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageMediaLocation For ChangerDevices", Query.associators((String)"CIM_ChangerDevice", (String)"CIM_Realizes", (String)"CIM_StorageMediaLocation", null, null), "IN_SYSTEM_" + CHANGERDEVICE, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTSOFTWAREIDENTITYFROMCHANGERDEVICE, (IDiscoverProcess)new AssociatorCIMQuery("Collect SoftwareIdentity From ChangerDevice", Query.associators((String)"CIM_ChangerDevice", (String)"CIM_ElementSoftwareIdentity", (String)"CIM_SoftwareIdentity", null, null), "IN_SYSTEM_" + CHANGERDEVICE, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTCONTROLLERSFROMCHANGERDEVICE, (IDiscoverProcess)new AssociatorCIMQuery("Collect Controllers From ChangerDevice", Query.associators((String)"CIM_ChangerDevice", (String)"CIM_ProtocolControllerForUnit", (String)"CIM_SCSIProtocolController", null, null), "IN_SYSTEM_" + CHANGERDEVICE, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTLIMITEDACCESSPORTSFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect Limited Access Port From ComputerSystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_LimitedAccessPort", null, null), "IN_SYSTEM_" + COMPUTERSYSTEM, CIMInstance.class.getName(), false));
        pRouter.addProcess("collectStorageMediaLocationForLimitedAccessPorts", (IDiscoverProcess)new AssociatorCIMQuery("Collect Storage Media Location From Limited Access Port", Query.associators((String)"CIM_LimitedAccessPort", (String)"CIM_Realizes", (String)"CIM_StorageMediaLocation", null, null), "IN_SYSTEM_" + LIMITEDACCESSPORT, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTSTORAGEMEDIALOCATIONFROMCHASSIS, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageMediaLocation from Chassis", Query.associators((String)"CIM_Chassis", (String)"CIM_Container", (String)"CIM_StorageMediaLocation", null, null), "IN_SYSTEM_" + CHASSIS, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTMAGAZINESFROMCHASSIS, (IDiscoverProcess)new AssociatorCIMQuery("Collect Magazines from Chassis", Query.associators((String)"CIM_Chassis", (String)"CIM_Container", (String)"CIM_Magazine", null, null), "IN_SYSTEM_" + CHASSIS, CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTSTORAGEMEDIALOCATIONFROMMAGAZINE, (IDiscoverProcess)new AssociatorCIMQuery("Collect Storage Media Location from Magazine", Query.associators((String)"CIM_Magazine", (String)"CIM_Container", (String)"CIM_StorageMediaLocation", null, null), "IN_SYSTEM_" + MAGAZINE, CIMInstance.class.getName(), false));
    }

    public ProbeGenericTapeLibraryProcess(String description, boolean mainProcess, String[] parameters, String[] parameterTypes) {
        super(description, mainProcess, parameters, parameterTypes);
    }

    public DiscoverStep getStepCollectStorageMediaLocationsFromComputerSystem(TapeCIMProcessor pProcessor, ProgressLogger pLogger) {
        pLogger.enableHierarchicalMode();
        DiscoverStep collectChassisFromComputerSystemBasic = new DiscoverStep(COLLECTCHASSISFROMCOMPUTERSYSTEM, "IN_SYSTEM_" + CHASSIS, (CIMProcessor)pProcessor, (IProgressLogger)pLogger);
        DiscoverStep collectStorageMediaLocationFromChassis = new DiscoverStep(COLLECTSTORAGEMEDIALOCATIONFROMCHASSIS, "IN_SYSTEM_" + STORAGEMEDIALOCATION, (CIMProcessor)pProcessor);
        DiscoverStep collectMagazinesFromChassis = new DiscoverStep(COLLECTMAGAZINESFROMCHASSIS, "IN_SYSTEM_" + MAGAZINE, (CIMProcessor)pProcessor);
        DiscoverStep collectStorageMediaLocationFromMagazine = new DiscoverStep(COLLECTSTORAGEMEDIALOCATIONFROMMAGAZINE, null, (CIMProcessor)pProcessor, (IProgressLogger)new ProgressLogger.InnerProgressLogger(pLogger));
        collectChassisFromComputerSystemBasic.addNextStep((IStep)collectMagazinesFromChassis);
        collectChassisFromComputerSystemBasic.addNextStep((IStep)collectStorageMediaLocationFromChassis);
        collectMagazinesFromChassis.addNextStep((IStep)collectStorageMediaLocationFromMagazine);
        return collectChassisFromComputerSystemBasic;
    }

    public DiscoverStep getStepCollectCartridgesFromComputerSystem(TapeCIMProcessor pProcessor, ProgressLogger pLogger) {
        pLogger.enableHierarchicalMode();
        DiscoverStep collectChassisFromComputerSystem = new DiscoverStep(COLLECTCHASSISFROMCOMPUTERSYSTEM, "IN_SYSTEM_" + CHASSIS, (CIMProcessor)pProcessor, (IProgressLogger)pLogger);
        DiscoverStep collectCartridgesFromChassis = new DiscoverStep(COLLECTCARTRIDGESFORCHASSIS, "IN_SYSTEM_" + PHYSICALTAPE, (CIMProcessor)pProcessor, (IProgressLogger)new ProgressLogger.InnerProgressLogger(pLogger));
        DiscoverStep collectStorageMediaLocationFromCartridge = new DiscoverStep(COLLECTSTORAGEMEDIALOCATIONFORCARTRIDGES, null, (CIMProcessor)pProcessor);
        collectChassisFromComputerSystem.addNextStep((IStep)collectCartridgesFromChassis);
        collectCartridgesFromChassis.addNextStep((IStep)collectStorageMediaLocationFromCartridge);
        return collectChassisFromComputerSystem;
    }

    public DiscoverStep getStepCollectDrivesFromComputerSystem(TapeCIMProcessor pProcessor, ProgressLogger pLogger) {
        DiscoverStep collectDrivesFromComputerSystem = new DiscoverStep(COLLECTDRIVESROMCOMPUTERSYSTEM, "IN_SYSTEM_" + MEDIAACCESSDEVICE, (CIMProcessor)pProcessor, (IProgressLogger)pLogger);
        DiscoverStep collectStorageMediaLocationForDrives = new DiscoverStep(COLLECTSTORAGEMEDIALOCATIONFORDRIVES, null, (CIMProcessor)pProcessor);
        DiscoverStep collectSoftwareIdentityFromDrives = new DiscoverStep(COLLECTSOFTWAREIDENTITYFROMDRIVES, null, (CIMProcessor)pProcessor);
        DiscoverStep collectControllersFromDrives = new DiscoverStep(COLLECTCONTROLLERSFROMDRIVES, "IN_SYSTEM_" + SCSIPROTOCOLCONTROLLER, null);
        DiscoverStep collectFCPortFromController = new DiscoverStep(COLLECTFCPORTSFROMCONTROLLER, "IN_SYSTEM_" + SCSIPROTOCOLCONTROLLER, (CIMProcessor)pProcessor);
        collectDrivesFromComputerSystem.addNextStep((IStep)collectStorageMediaLocationForDrives);
        collectDrivesFromComputerSystem.addNextStep((IStep)collectSoftwareIdentityFromDrives);
        collectDrivesFromComputerSystem.addNextStep((IStep)collectControllersFromDrives);
        collectControllersFromDrives.addNextStep((IStep)collectFCPortFromController);
        return collectDrivesFromComputerSystem;
    }

    public DiscoverStep getStepCollectChangerDeviceFromComputerSystem(TapeCIMProcessor pProcessor, ProgressLogger pLogger) {
        DiscoverStep collectChangerDeviceFromComputerSystem = new DiscoverStep(COLLECTCHANGERDEVICESFROMCOMPUTERSYSTEM, "IN_SYSTEM_" + CHANGERDEVICE, (CIMProcessor)pProcessor, (IProgressLogger)pLogger);
        DiscoverStep collectStorageMediaLocationForChangerDevice = new DiscoverStep(COLLECTSTORAGEMEDIALOCATIONFORCHANGERDEVICES, null, (CIMProcessor)pProcessor);
        DiscoverStep collectSoftwareIdentityFromChangerDevice = new DiscoverStep(COLLECTSOFTWAREIDENTITYFROMCHANGERDEVICE, null, (CIMProcessor)pProcessor);
        DiscoverStep collectControllersFromChangerDevice = new DiscoverStep(COLLECTCONTROLLERSFROMCHANGERDEVICE, "IN_SYSTEM_" + SCSIPROTOCOLCONTROLLER, (CIMProcessor)pProcessor);
        DiscoverStep collectFCPortFromController = new DiscoverStep(COLLECTFCPORTSFROMCONTROLLER, null, (CIMProcessor)pProcessor);
        collectChangerDeviceFromComputerSystem.addNextStep((IStep)collectStorageMediaLocationForChangerDevice);
        collectChangerDeviceFromComputerSystem.addNextStep((IStep)collectSoftwareIdentityFromChangerDevice);
        collectChangerDeviceFromComputerSystem.addNextStep((IStep)collectControllersFromChangerDevice);
        collectControllersFromChangerDevice.addNextStep((IStep)collectFCPortFromController);
        return collectChangerDeviceFromComputerSystem;
    }

    public DiscoverStep getStepCollectLimitedAccessPortFromComputerSystem(TapeCIMProcessor pProcessor, ProgressLogger pLogger) {
        DiscoverStep collectLimitedAccessPortFromComputerSystem = new DiscoverStep(COLLECTLIMITEDACCESSPORTSFROMCOMPUTERSYSTEM, "IN_SYSTEM_" + LIMITEDACCESSPORT, (CIMProcessor)pProcessor, (IProgressLogger)pLogger);
        DiscoverStep collectStorageMediaLocationFromLimitedAccessPort = new DiscoverStep("collectStorageMediaLocationForLimitedAccessPorts", null, (CIMProcessor)pProcessor);
        collectLimitedAccessPortFromComputerSystem.addNextStep((IStep)collectStorageMediaLocationFromLimitedAccessPort);
        return collectLimitedAccessPortFromComputerSystem;
    }

    public String getScannerId(Map pParameters) throws ParameterException {
        String prefix = "PT1";
        String[] mCIMOM = (String[])pParameters.get("CIMOM");
        if (mCIMOM == null || mCIMOM.length < 1) {
            throw new ParameterException("Missing parameter: CIMOM");
        }
        String mCIMOMServiceURL = mCIMOM[0];
        String mTapeLibraryID = (String)pParameters.get("DEVICEID");
        if (mTapeLibraryID == null) {
            throw new ParameterException("Missing parameter: DEVICEID");
        }
        String mScannerId = prefix + ":" + mCIMOMServiceURL + "+" + mTapeLibraryID;
        return mScannerId;
    }

    public int getAuthoritativeReferenceType(Map pParameters) throws ParameterException {
        return 2;
    }

    public int getAuthoritativeReferenceId(Map pParameters) throws ParameterException {
        String mTapeLibraryDBId = (String)pParameters.get("DEVICEID");
        if (mTapeLibraryDBId == null) {
            throw new ParameterException("Missing parameter: DEVICEID");
        }
        return Integer.parseInt(mTapeLibraryDBId);
    }

    protected boolean processSteps(ArrayList pSteps, Map pParameters, String pRequestId, ILogger pJobLogger) {
        boolean mResult = true;
        int libId = Integer.parseInt((String)pParameters.get("DEVICEID"));
        for (int i = 0; i < pSteps.size(); ++i) {
            DiscoverStep mStep = (DiscoverStep)pSteps.get(i);
            long mStartTime = this.traceBegin(mStep.getCmd(), libId);
            boolean mStatus = false;
            try {
                mStatus = mStep.process(pRequestId, pParameters);
            }
            catch (Exception e) {
                pJobLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this.getClass().getName(), "processSteps", (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "traceException", "Exception from DiscoverStep's process method" + e.getStackTrace().toString());
                }
                traceLogger.exception(IRecordType.TYPE_WARN, (Object)this.getClass().getName(), "processSteps", (Throwable)e);
            }
            this.traceEnd(mStep.getCmd(), mStartTime, mStatus, libId);
            mResult = mResult && mStatus;
        }
        int collType = (Integer)pParameters.get("COLLTYPE");
        if (collType == 3) {
            this.updateMaxCartridges(pParameters);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMaxCartridges(Map pParameters) {
        String methodName = "updateMaxCartridges";
        String tapeLibKey = (String)pParameters.get("TAPELIBRARY");
        String tapeLibID = (String)pParameters.get("DEVICEID");
        try {
            DBConnection mConn = ServiceUtils.getConnection();
            Hashtable<ColumnInfo, String> mParams = new Hashtable<ColumnInfo, String>();
            mParams.put(TResTapeMediaLocationTable.getColumnInfo((String)"TAPE_LIBRARY_ID"), tapeLibID);
            DBResultSet dbResult = ComplexQuery.sqlQuery((DBConnection)mConn, (String)QUERY_SLOTS, mParams);
            int maxCarts = 0;
            try {
                while (dbResult.next()) {
                    maxCarts = dbResult.getInt(1);
                }
            }
            finally {
                if (dbResult != null) {
                    dbResult.close();
                }
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), methodName, "Updated MAX_CARTRIDGES to " + maxCarts + " for libId " + tapeLibID);
            }
            if (Configuration.debug) {
                System.out.println("*** Max. Cartridges: " + maxCarts + ", Library: " + tapeLibKey);
            }
            String libName = TapeReportingService.getNameFromKey(tapeLibKey);
            short libNameFormat = TapeReportingService.getNameFormatFromKey(tapeLibKey);
            TapeLibrary lib = new TapeLibrary();
            lib.setName(libName);
            lib.setNameFormat(libNameFormat);
            try {
                lib.retrieve(mConn);
                lib.setMaxCartridges(maxCarts);
                lib.update(mConn);
            }
            catch (SQLException e) {
                traceLogger.exception(IRecordType.TYPE_WARN, (Object)this.getClass().getName(), methodName, (Throwable)e);
            }
            if (mConn != null) {
                mConn.commit();
                mConn.close();
            }
        }
        catch (SQLException e) {
            traceLogger.exception(IRecordType.TYPE_WARN, (Object)this.getClass().getName(), methodName, (Throwable)e);
        }
    }

    protected long traceBegin(String pString, int pLibId) {
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "traceBegin", "===== Starting " + pString + " for lib id " + pLibId);
        }
        if (Configuration.debug) {
            System.out.println(this.getClass().getName() + ": ===== Starting " + pString + " for lib id " + pLibId);
        }
        return System.currentTimeMillis();
    }

    protected void traceEnd(String pString, long pTime1, boolean pStatus, int pLibId) {
        long time2 = System.currentTimeMillis();
        long mins = (long)Math.floor((double)(time2 - pTime1) / 60000.0);
        if (pStatus) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "traceEnd", "===== Completed " + pString + " for lib id " + pLibId + " after " + (time2 - pTime1) + " ms (" + mins + " min)");
            }
            if (Configuration.debug) {
                System.out.println(this.getClass().getName() + ": ===== Completed " + pString + " for lib id " + pLibId + " after " + (time2 - pTime1) + " ms (" + mins + " min)");
            }
        } else {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "traceEnd", "===== Step " + pString + " for lib id " + pLibId + " failed!");
            }
            if (Configuration.debug) {
                System.out.println(this.getClass().getName() + ": ===== Step " + pString + " for lib id " + pLibId + " failed!");
            }
        }
    }
}

