/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResBackendControllerTable;
import org.eclipse.aperi.infrastructure.database.tables.TResDataPathTable;
import org.eclipse.aperi.infrastructure.database.tables.TResHbaTable;
import org.eclipse.aperi.infrastructure.database.tables.TResNode2hbaTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalvolume2extentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResVolume2extentTable;

public class AffectedHostAnalyzer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAffectedHostsForStorageSystem(String pSubsystemId) {
        List mResult;
        LogTraceHelper mLTH;
        block3: {
            Vector vector;
            mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForStorageSystem", (Object[])new Object[]{pSubsystemId});
            mResult = null;
            try {
                if (pSubsystemId != null) break block3;
                vector = new Vector();
            }
            catch (Throwable throwable) {
                mLTH.exit(mResult);
                throw throwable;
            }
            mLTH.exit(mResult);
            return vector;
        }
        String mComplexQuery = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "SUBSYSTEM_ID" + " = " + pSubsystemId + ")" + ")";
        mResult = AffectedHostAnalyzer.getHostIDsWithComplexQuery(mComplexQuery);
        mLTH.exit((Object)mResult);
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAffectedHostsForBackendController(String pBackendControllerId) {
        List mResult;
        LogTraceHelper mLTH;
        block3: {
            Vector vector;
            mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForBackendController", (Object[])new Object[]{pBackendControllerId});
            mResult = null;
            try {
                if (pBackendControllerId != null) break block3;
                vector = new Vector();
            }
            catch (Throwable throwable) {
                mLTH.exit(mResult);
                throw throwable;
            }
            mLTH.exit(mResult);
            return vector;
        }
        String mComplexQuery = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "SUBSYSTEM_ID" + " IN " + "(select " + "OWNING_SUBSYSTEM_ID" + " from " + TResBackendControllerTable.getTablename() + " where " + "BACKEND_CONTROLLER_ID" + " = " + pBackendControllerId + ")" + ")" + ")";
        mResult = AffectedHostAnalyzer.getHostIDsWithComplexQuery(mComplexQuery);
        mLTH.exit((Object)mResult);
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAffectedHostsForNode(String pNodeId) {
        List mResult;
        LogTraceHelper mLTH;
        block3: {
            Vector vector;
            mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForNode", (Object[])new Object[]{pNodeId});
            mResult = null;
            try {
                if (pNodeId != null) break block3;
                vector = new Vector();
            }
            catch (Throwable throwable) {
                mLTH.exit(mResult);
                throw throwable;
            }
            mLTH.exit(mResult);
            return vector;
        }
        String mComplexQuery = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " = " + pNodeId + ")";
        mResult = AffectedHostAnalyzer.getHostIDsWithComplexQuery(mComplexQuery);
        mLTH.exit((Object)mResult);
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAffectedHostsForPort(String pPortId) {
        List mResult;
        LogTraceHelper mLTH;
        block3: {
            Vector vector;
            mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForPort", (Object[])new Object[]{pPortId});
            mResult = null;
            try {
                if (pPortId != null) break block3;
                vector = new Vector();
            }
            catch (Throwable throwable) {
                mLTH.exit(mResult);
                throw throwable;
            }
            mLTH.exit(mResult);
            return vector;
        }
        String mComplexQuery = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "PORT_ID" + " = " + pPortId + ")" + ")";
        mResult = AffectedHostAnalyzer.getHostIDsWithComplexQuery(mComplexQuery);
        mLTH.exit((Object)mResult);
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAffectedHostsForPool(String pPoolId) {
        List mResult;
        LogTraceHelper mLTH;
        block3: {
            Vector vector;
            mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForPool", (Object[])new Object[]{pPoolId});
            mResult = null;
            try {
                if (pPoolId != null) break block3;
                vector = new Vector();
            }
            catch (Throwable throwable) {
                mLTH.exit(mResult);
                throw throwable;
            }
            mLTH.exit(mResult);
            return vector;
        }
        String mComplexQuery = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "PORT_ID" + " IN " + "(select " + "INITIATOR_PORT_ID" + " from " + TResDataPathTable.getTablename() + " where " + "VOLUME_ID" + " IN " + "(select " + "SVID" + " from " + TResStorageVolumeTable.getTablename() + " where " + "POOL_ID" + " = " + pPoolId + ")" + ")" + ")" + ")";
        mResult = AffectedHostAnalyzer.getHostIDsWithComplexQuery(mComplexQuery);
        mLTH.exit((Object)mResult);
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAffectedHostsForExtent(String pStorageExtentId) {
        List mResult;
        LogTraceHelper mLTH;
        block3: {
            Vector vector;
            mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForExtent", (Object[])new Object[]{pStorageExtentId});
            mResult = null;
            try {
                if (pStorageExtentId != null) break block3;
                vector = new Vector();
            }
            catch (Throwable throwable) {
                mLTH.exit(mResult);
                throw throwable;
            }
            mLTH.exit(mResult);
            return vector;
        }
        String mComplexQuery = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "PORT_ID" + " IN " + "(select " + "INITIATOR_PORT_ID" + " from " + TResDataPathTable.getTablename() + " where " + "VOLUME_ID" + " IN " + "(select " + "VOLUME_ID" + " from " + TResVolume2extentTable.getTablename() + " where " + "STORAGE_EXTENT_ID" + " = " + pStorageExtentId + ")" + ")" + ")" + ")";
        mResult = AffectedHostAnalyzer.getHostIDsWithComplexQuery(mComplexQuery);
        mLTH.exit((Object)mResult);
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAffectedHostsForVolume(String pVolumeId) {
        List mResult;
        LogTraceHelper mLTH;
        block3: {
            Vector vector;
            mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForVolume", (Object[])new Object[]{pVolumeId});
            mResult = null;
            try {
                if (pVolumeId != null) break block3;
                vector = new Vector();
            }
            catch (Throwable throwable) {
                mLTH.exit(mResult);
                throw throwable;
            }
            mLTH.exit(mResult);
            return vector;
        }
        String mComplexQuery = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "PORT_ID" + " IN " + "(select " + "INITIATOR_PORT_ID" + " from " + TResDataPathTable.getTablename() + " where " + "VOLUME_ID" + " = " + pVolumeId + ")" + ")" + ")";
        mResult = AffectedHostAnalyzer.getHostIDsWithComplexQuery(mComplexQuery);
        mLTH.exit((Object)mResult);
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAffectedHostsForDiskDrive(String pPhysicalVolumeId) {
        List mResult;
        LogTraceHelper mLTH;
        block3: {
            Vector vector;
            mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForDiskDrive", (Object[])new Object[]{pPhysicalVolumeId});
            mResult = null;
            try {
                if (pPhysicalVolumeId != null) break block3;
                vector = new Vector();
            }
            catch (Throwable throwable) {
                mLTH.exit(mResult);
                throw throwable;
            }
            mLTH.exit(mResult);
            return vector;
        }
        String mComplexQuery = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "PORT_ID" + " IN " + "(select " + "INITIATOR_PORT_ID" + " from " + TResDataPathTable.getTablename() + " where " + "VOLUME_ID" + " IN " + "(select " + "VOLUME_ID" + " from " + TResVolume2extentTable.getTablename() + " where " + "STORAGE_EXTENT_ID" + " IN " + "(select " + "STORAGE_EXTENT_ID" + " from " + TResPhysicalvolume2extentTable.getTablename() + " where " + "PHYSICAL_VOLUME_ID" + " = " + pPhysicalVolumeId + ")" + ")" + ")" + ")" + ")";
        mResult = AffectedHostAnalyzer.getHostIDsWithComplexQuery(mComplexQuery);
        mLTH.exit((Object)mResult);
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAffectedHostsForDiskGroup(String pDiskGroupId) {
        List mResult;
        LogTraceHelper mLTH;
        block3: {
            Vector vector;
            mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForDiskGroup", (Object[])new Object[]{pDiskGroupId});
            mResult = null;
            try {
                if (pDiskGroupId != null) break block3;
                vector = new Vector();
            }
            catch (Throwable throwable) {
                mLTH.exit(mResult);
                throw throwable;
            }
            mLTH.exit(mResult);
            return vector;
        }
        String mComplexQuery = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "PORT_ID" + " IN " + "(select " + "INITIATOR_PORT_ID" + " from " + TResDataPathTable.getTablename() + " where " + "VOLUME_ID" + " IN " + "(select " + "VOLUME_ID" + " from " + TResVolume2extentTable.getTablename() + " where " + "STORAGE_EXTENT_ID" + " IN " + "(select " + "STORAGE_EXTENT_ID" + " from " + TResPhysicalvolume2extentTable.getTablename() + " where " + "PHYSICAL_VOLUME_ID" + " IN " + "(select " + "PHYSICAL_VOLUME_ID" + " from " + TResPhysicalVolumeTable.getTablename() + " where " + "DISK_GROUP_ID" + " = " + pDiskGroupId + ")" + ")" + ")" + ")" + ")" + ")";
        mResult = AffectedHostAnalyzer.getHostIDsWithComplexQuery(mComplexQuery);
        mLTH.exit((Object)mResult);
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAffectedHostsForDataPath(String pDataPathId) {
        List mResult;
        LogTraceHelper mLTH;
        block3: {
            Vector vector;
            mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForDataPath", (Object[])new Object[]{pDataPathId});
            mResult = null;
            try {
                if (pDataPathId != null) break block3;
                vector = new Vector();
            }
            catch (Throwable throwable) {
                mLTH.exit(mResult);
                throw throwable;
            }
            mLTH.exit(mResult);
            return vector;
        }
        String mComplexQuery = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "PORT_ID" + " IN " + "(select " + "INITIATOR_PORT_ID" + " from " + TResDataPathTable.getTablename() + " where " + "DATA_PATH_ID" + " = " + pDataPathId + ")" + ")" + ")";
        mResult = AffectedHostAnalyzer.getNegativeHostIDsWithComplexQuery(mComplexQuery);
        mLTH.exit((Object)mResult);
        return mResult;
    }

    public static List getAffectedHostsForDataPathWithPortId(String pPortId) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForDataPath", (Object[])new Object[]{pPortId});
        if (pPortId == null) {
            return new Vector();
        }
        String mComplexQuery = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "PORT_ID" + "=" + pPortId + ")" + ")";
        List mResult = AffectedHostAnalyzer.getNegativeHostIDsWithComplexQuery(mComplexQuery);
        mLTH.exit((Object)mResult);
        return mResult;
    }

    private static List getHostIDsWithComplexQuery(String pComplexQuery) {
        return AffectedHostAnalyzer.getHostIDsWithComplexQuery(pComplexQuery, false);
    }

    private static List getNegativeHostIDsWithComplexQuery(String pComplexQuery) {
        return AffectedHostAnalyzer.getHostIDsWithComplexQuery(pComplexQuery, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getHostIDsWithComplexQuery(String pComplexQuery, boolean pHostIdBeNegative) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getHostIDsWithComplexQuery", (Object[])new Object[]{pComplexQuery});
        Vector mHosts = new Vector();
        DBConnection mConn = null;
        DBResultSet mDBRS = null;
        Vector<Integer> mResult = new Vector<Integer>();
        try {
            mConn = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            mLTH.traceHigh(pComplexQuery);
            mDBRS = ComplexQuery.sqlQuery((DBConnection)mConn, (String)pComplexQuery, new Hashtable());
            if (mDBRS == null) {
                mLTH.traceError("The result set was empty when retrieving host IDs from database", null);
            } else {
                while (mDBRS.next()) {
                    if (pHostIdBeNegative) {
                        int bTemp = mDBRS.getInt(1);
                        mResult.add(new Integer(-bTemp));
                        continue;
                    }
                    mResult.add(new Integer(mDBRS.getInt(1)));
                }
            }
        }
        catch (SQLException pEx) {
            mLTH.traceError("Failed to retrieve host IDs from database", (Throwable)pEx);
        }
        finally {
            if (mConn != null) {
                try {
                    mConn.commit();
                    if (mDBRS != null) {
                        mDBRS.closeAll();
                    }
                    mConn.close();
                }
                catch (SQLException pEx) {
                    mLTH.traceError("Failed to commit or close a database connection or result set", (Throwable)pEx);
                }
            }
            mLTH.exit(mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap analyzeAffectedHostsForStorageSystem(String pSubsystemId) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"analyzeAffectedHostsForStorageSystem", (Object[])new Object[]{pSubsystemId});
        HashMap<String, List> mResult = new HashMap<String, List>();
        Vector<String> mSubsystemIDs = new Vector<String>();
        try {
            mSubsystemIDs.add(pSubsystemId);
            mResult.put("SUBSYSTEM_ID", mSubsystemIDs);
            if (pSubsystemId == null) {
                mResult.put("HOST_ID", new Vector());
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mNodeIDs = AffectedHostAnalyzer.getNodeIDsFromTResPortForSubsystemIDs(mSubsystemIDs);
            mResult.put("NODE_ID", mNodeIDs);
            if (mNodeIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mHbaWWNs = AffectedHostAnalyzer.getHbaIDsFromTResNode2hbaForNodeIDs(mNodeIDs);
            mResult.put("HBA_ID", mHbaWWNs);
            if (mHbaWWNs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mHostIDs = AffectedHostAnalyzer.getHostIDsFromTResHbaForHbaWWNs(mHbaWWNs);
            mResult.put("HOST_ID", mHostIDs);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap analyzeAffectedHostsForNode(String pNodeId) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"analyzeAffectedHostsForNode", (Object[])new Object[]{pNodeId});
        HashMap<String, List> mResult = new HashMap<String, List>();
        Vector<String> mNodeIDs = new Vector<String>();
        try {
            mNodeIDs.add(pNodeId);
            mResult.put("NODE_ID", mNodeIDs);
            if (pNodeId == null) {
                mResult.put("HOST_ID", new Vector());
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mHbaWWNs = AffectedHostAnalyzer.getHbaIDsFromTResNode2hbaForNodeIDs(mNodeIDs);
            mResult.put("HBA_ID", mHbaWWNs);
            if (mHbaWWNs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mHostIDs = AffectedHostAnalyzer.getHostIDsFromTResHbaForHbaWWNs(mHbaWWNs);
            mResult.put("HOST_ID", mHostIDs);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap analyzeAffectedHostsForPort(String pPortId) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"analyzeAffectedHostsForPort", (Object[])new Object[]{pPortId});
        HashMap<String, List> mResult = new HashMap<String, List>();
        Vector<String> mPortIDs = new Vector<String>();
        try {
            mPortIDs.add(pPortId);
            mResult.put("PORT_ID", mPortIDs);
            if (pPortId == null) {
                mResult.put("HOST_ID", new Vector());
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mNodeIDs = AffectedHostAnalyzer.getNodeIDsFromTResPortForPortIDs(mPortIDs);
            mResult.put("NODE_ID", mNodeIDs);
            if (mNodeIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mHbaWWNs = AffectedHostAnalyzer.getHbaIDsFromTResNode2hbaForNodeIDs(mNodeIDs);
            mResult.put("HBA_ID", mHbaWWNs);
            if (mHbaWWNs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mHostIDs = AffectedHostAnalyzer.getHostIDsFromTResHbaForHbaWWNs(mHbaWWNs);
            mResult.put("HOST_ID", mHostIDs);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap analyzeAffectedHostsForPool(String pPoolId) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"analyzeAffectedHostsForPool", (Object[])new Object[]{pPoolId});
        HashMap<String, List> mResult = new HashMap<String, List>();
        Vector<String> mPooIDs = new Vector<String>();
        try {
            mPooIDs.add(pPoolId);
            mResult.put("POOL_ID", mPooIDs);
            if (pPoolId == null) {
                mResult.put("HOST_ID", new Vector());
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mSVIDs = AffectedHostAnalyzer.getSVIDsFromTResStoragevolumeForPoolIDs(mPooIDs);
            mResult.put("SVID", mSVIDs);
            if (mSVIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mInitiatorPortIDs = AffectedHostAnalyzer.getInitiatorPortIDsFromTResDatapathForVolumeIDs(mSVIDs);
            mResult.put("INITIATOR_PORT_ID", mInitiatorPortIDs);
            if (mInitiatorPortIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mNodeIDs = AffectedHostAnalyzer.getNodeIDsFromTResPortForPortIDs(mInitiatorPortIDs);
            mResult.put("NODE_ID", mNodeIDs);
            if (mNodeIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mHbaWWNs = AffectedHostAnalyzer.getHbaIDsFromTResNode2hbaForNodeIDs(mNodeIDs);
            mResult.put("HBA_ID", mHbaWWNs);
            if (mHbaWWNs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mHostIDs = AffectedHostAnalyzer.getHostIDsFromTResHbaForHbaWWNs(mHbaWWNs);
            mResult.put("HOST_ID", mHostIDs);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap analyzeAffectedHostsForExtent(String pStorageExtentId) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"analyzeAffectedHostsForExtent", (Object[])new Object[]{pStorageExtentId});
        HashMap<String, List> mResult = new HashMap<String, List>();
        Vector<String> mStorageExtentIDs = new Vector<String>();
        try {
            mStorageExtentIDs.add(pStorageExtentId);
            mResult.put("STORAGE_EXTENT_ID", mStorageExtentIDs);
            if (pStorageExtentId == null) {
                mResult.put("HOST_ID", new Vector());
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mVolumeIDs = AffectedHostAnalyzer.getVolumeIDsFromTResVolume2extentForStorageExtentIDs(mStorageExtentIDs);
            mResult.put("VOLUME_ID", mVolumeIDs);
            if (mVolumeIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mInitiatorPortIDs = AffectedHostAnalyzer.getInitiatorPortIDsFromTResDatapathForVolumeIDs(mVolumeIDs);
            mResult.put("INITIATOR_PORT_ID", mInitiatorPortIDs);
            if (mInitiatorPortIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mNodeIDs = AffectedHostAnalyzer.getNodeIDsFromTResPortForPortIDs(mInitiatorPortIDs);
            mResult.put("NODE_ID", mNodeIDs);
            if (mNodeIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mHbaWWNs = AffectedHostAnalyzer.getHbaIDsFromTResNode2hbaForNodeIDs(mNodeIDs);
            mResult.put("HBA_ID", mHbaWWNs);
            if (mHbaWWNs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mHostIDs = AffectedHostAnalyzer.getHostIDsFromTResHbaForHbaWWNs(mHbaWWNs);
            mResult.put("HOST_ID", mHostIDs);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap analyzeAffectedHostsForVolume(String pVolumeId) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"analyzeAffectedHostsForVolume", (Object[])new Object[]{pVolumeId});
        HashMap<String, List> mResult = new HashMap<String, List>();
        Vector<String> mVolumeIDs = new Vector<String>();
        try {
            mVolumeIDs.add(pVolumeId);
            mResult.put("VOLUME_ID", mVolumeIDs);
            if (pVolumeId == null) {
                mResult.put("HOST_ID", mVolumeIDs);
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mInitiatorPortIDs = AffectedHostAnalyzer.getInitiatorPortIDsFromTResDatapathForVolumeIDs(mVolumeIDs);
            mResult.put("INITIATOR_PORT_ID", mInitiatorPortIDs);
            if (mInitiatorPortIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mNodeIDs = AffectedHostAnalyzer.getNodeIDsFromTResPortForPortIDs(mInitiatorPortIDs);
            mResult.put("NODE_ID", mNodeIDs);
            if (mNodeIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mHbaWWNs = AffectedHostAnalyzer.getHbaIDsFromTResNode2hbaForNodeIDs(mNodeIDs);
            mResult.put("HBA_ID", mHbaWWNs);
            if (mHbaWWNs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mHostIDs = AffectedHostAnalyzer.getHostIDsFromTResHbaForHbaWWNs(mHbaWWNs);
            mResult.put("HOST_ID", mHostIDs);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap analyzeAffectedHostsForDiskDrive(String pPhysicalVolumeId) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"analyzeAffectedHostsForDiskDrive", (Object[])new Object[]{pPhysicalVolumeId});
        HashMap<String, List> mResult = new HashMap<String, List>();
        Vector<String> mPhysicalVolumeIDs = new Vector<String>();
        try {
            mPhysicalVolumeIDs.add(pPhysicalVolumeId);
            mResult.put("PHYSICAL_VOLUME_ID", mPhysicalVolumeIDs);
            if (pPhysicalVolumeId == null) {
                mResult.put("HOST_ID", new Vector());
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mStorageExtentIDs = AffectedHostAnalyzer.getStorageExtentIDsFromTResPhysicalvolume2extentTableForPhysicalVolumeIDs(mPhysicalVolumeIDs);
            mResult.put("STORAGE_EXTENT_ID", mStorageExtentIDs);
            if (mStorageExtentIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mVolumeIDs = AffectedHostAnalyzer.getVolumeIDsFromTResVolume2extentForStorageExtentIDs(mStorageExtentIDs);
            mResult.put("VOLUME_ID", mVolumeIDs);
            if (mVolumeIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mInitiatorPortIDs = AffectedHostAnalyzer.getInitiatorPortIDsFromTResDatapathForVolumeIDs(mVolumeIDs);
            mResult.put("INITIATOR_PORT_ID", mInitiatorPortIDs);
            if (mInitiatorPortIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mNodeIDs = AffectedHostAnalyzer.getNodeIDsFromTResPortForPortIDs(mInitiatorPortIDs);
            mResult.put("NODE_ID", mNodeIDs);
            if (mNodeIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mHbaWWNs = AffectedHostAnalyzer.getHbaIDsFromTResNode2hbaForNodeIDs(mNodeIDs);
            mResult.put("HBA_ID", mHbaWWNs);
            if (mHbaWWNs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mHostIDs = AffectedHostAnalyzer.getHostIDsFromTResHbaForHbaWWNs(mHbaWWNs);
            mResult.put("HOST_ID", mHostIDs);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap analyzeAffectedHostsForDiskGroup(String pDiskGroupId) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"analyzeAffectedHostsForDiskGroup", (Object[])new Object[]{pDiskGroupId});
        HashMap<String, List> mResult = new HashMap<String, List>();
        Vector<String> mDiskGroupIDs = new Vector<String>();
        try {
            mDiskGroupIDs.add(pDiskGroupId);
            mResult.put("DISK_GROUP_ID", mDiskGroupIDs);
            if (pDiskGroupId == null) {
                mResult.put("HOST_ID", new Vector());
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mPhysicalVolumeIDs = AffectedHostAnalyzer.getPhysicalVolumeIDsFromTResPhysicalvolumeForDiskGroupIDs(mDiskGroupIDs);
            mResult.put("PHYSICAL_VOLUME_ID", mPhysicalVolumeIDs);
            if (mPhysicalVolumeIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mStorageExtentIDs = AffectedHostAnalyzer.getStorageExtentIDsFromTResPhysicalvolume2extentTableForPhysicalVolumeIDs(mPhysicalVolumeIDs);
            mResult.put("STORAGE_EXTENT_ID", mStorageExtentIDs);
            if (mStorageExtentIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mVolumeIDs = AffectedHostAnalyzer.getVolumeIDsFromTResVolume2extentForStorageExtentIDs(mStorageExtentIDs);
            mResult.put("VOLUME_ID", mVolumeIDs);
            if (mVolumeIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mInitiatorPortIDs = AffectedHostAnalyzer.getInitiatorPortIDsFromTResDatapathForVolumeIDs(mVolumeIDs);
            mResult.put("INITIATOR_PORT_ID", mInitiatorPortIDs);
            if (mInitiatorPortIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mNodeIDs = AffectedHostAnalyzer.getNodeIDsFromTResPortForPortIDs(mInitiatorPortIDs);
            mResult.put("NODE_ID", mNodeIDs);
            if (mNodeIDs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mHbaWWNs = AffectedHostAnalyzer.getHbaIDsFromTResNode2hbaForNodeIDs(mNodeIDs);
            mResult.put("HBA_ID", mHbaWWNs);
            if (mHbaWWNs.size() == 0) {
                HashMap<String, List> hashMap = mResult;
                return hashMap;
            }
            List mHostIDs = AffectedHostAnalyzer.getHostIDsFromTResHbaForHbaWWNs(mHbaWWNs);
            mResult.put("HOST_ID", mHostIDs);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getIDsFromTableForOtherIDs(String pTablename, String pSelectColumnName, String pWhereColumnName, boolean pWhereColumnIsString, List pOtherIDs) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getIDsFromTableForOtherIDs", (Object[])new Object[]{pTablename, pSelectColumnName, pWhereColumnName, new Boolean(pWhereColumnIsString), pOtherIDs});
        DBConnection mConn = null;
        DBResultSet mDBRS = null;
        Vector<String> mResult = new Vector<String>();
        try {
            String mSimpleQuery = "select " + pSelectColumnName + " from " + pTablename + " where " + pWhereColumnName + " in (";
            for (int bI = 0; bI < pOtherIDs.size(); ++bI) {
                String bID = (String)pOtherIDs.get(bI);
                if (pWhereColumnIsString) {
                    mSimpleQuery = mSimpleQuery + "'";
                }
                mSimpleQuery = mSimpleQuery + bID;
                if (pWhereColumnIsString) {
                    mSimpleQuery = mSimpleQuery + "'";
                }
                if (bI >= pOtherIDs.size() - 1) continue;
                mSimpleQuery = mSimpleQuery + ",";
            }
            mSimpleQuery = mSimpleQuery + ")";
            mConn = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            mLTH.traceHigh(mSimpleQuery);
            mDBRS = ComplexQuery.sqlQuery((DBConnection)mConn, (String)mSimpleQuery, new Hashtable());
            if (mDBRS == null) {
                mLTH.traceError("result set was null", null);
            } else {
                while (mDBRS.next()) {
                    mResult.add(mDBRS.getString(1));
                }
            }
        }
        catch (SQLException pEx) {
            mLTH.traceError("Failed to get a database connection", (Throwable)pEx);
        }
        finally {
            if (mConn != null) {
                try {
                    mConn.commit();
                    if (mDBRS != null) {
                        mDBRS.closeAll();
                    }
                    mConn.close();
                }
                catch (SQLException pEx) {
                    mLTH.traceError("Failed to get a database connection", (Throwable)pEx);
                }
            }
            mLTH.exit(mResult);
        }
        return mResult;
    }

    private static List getHbaIDsFromTResNode2hbaForNodeIDs(List pNodeIDs) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResNode2hbaTable.getTablename(), "HBA_ID", "NODE_ID", false, pNodeIDs);
    }

    private static List getNodeIDsFromTResPortForSubsystemIDs(List pSubsystemIDs) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResPortTable.getTablename(), "SUBSYSTEM_ID", "NODE_ID", false, pSubsystemIDs);
    }

    private static List getHostIDsFromTResHbaForHbaWWNs(List pHbaWWNs) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResHbaTable.getTablename(), "HOST_ID", "HBA_WWN", true, pHbaWWNs);
    }

    private static List getNodeIDsFromTResPortForPortIDs(List pPortIDs) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResPortTable.getTablename(), "NODE_ID", "PORT_ID", false, pPortIDs);
    }

    private static List getSVIDsFromTResStoragevolumeForPoolIDs(List pPoolIDs) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResStorageVolumeTable.getTablename(), "SVID", "POOL_ID", false, pPoolIDs);
    }

    private static List getInitiatorPortIDsFromTResDatapathForVolumeIDs(List pVolumeIDs) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResDataPathTable.getTablename(), "INITIATOR_PORT_ID", "VOLUME_ID", false, pVolumeIDs);
    }

    private static List getVolumeIDsFromTResVolume2extentForStorageExtentIDs(List pExtentIDs) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResVolume2extentTable.getTablename(), "VOLUME_ID", "STORAGE_EXTENT_ID", false, pExtentIDs);
    }

    private static List getStorageExtentIDsFromTResPhysicalvolume2extentTableForPhysicalVolumeIDs(List pPhysicalVolumIDs) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResPhysicalvolume2extentTable.getTablename(), "STORAGE_EXTENT_ID", "PHYSICAL_VOLUME_ID", false, pPhysicalVolumIDs);
    }

    private static List getPhysicalVolumeIDsFromTResPhysicalvolumeForDiskGroupIDs(List pDiskGroupIDs) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResPhysicalVolumeTable.getTablename(), "PHYSICAL_VOLUME_ID", "DISK_GROUP_ID", false, pDiskGroupIDs);
    }

    public static List getAffectedHostsForBackgroundController(String pID) {
        return null;
    }
}

