/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;

public class DiskEventQueue {
    private LinkedList cQueue = new LinkedList();
    private boolean bShutdown = false;

    public synchronized void shutdown() {
        this.cQueue.clear();
    }

    public synchronized void add(CIMIndicationEvent pEvent) {
        this.cQueue.add(pEvent);
        this.notifyAll();
    }

    public synchronized CIMIndicationEvent remove() throws InterruptedException {
        if (!this.cQueue.isEmpty()) {
            return (CIMIndicationEvent)this.cQueue.removeFirst();
        }
        if (this.bShutdown) {
            return null;
        }
        this.wait();
        return this.remove();
    }

    public synchronized boolean isEmpty() {
        return this.cQueue.isEmpty();
    }

    public synchronized int size() {
        return this.cQueue.size();
    }

    public synchronized boolean contains(CIMIndicationEvent pEvent) {
        ListIterator mIter = this.cQueue.listIterator();
        while (mIter.hasNext()) {
            if (!mIter.next().equals(pEvent)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean contains(CIMIndicationEvent pEvent, Comparator pComparator) {
        ListIterator mIter = this.cQueue.listIterator();
        while (mIter.hasNext()) {
            if (pComparator.compare(mIter.next(), pEvent) != 0) continue;
            return true;
        }
        return false;
    }
}

