/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.util.Comparator;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.DiskEventQueue;
import org.eclipse.aperi.disk.monitor.DiskExpiringEventQueue;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;

public class DiskFilterThread
extends Thread {
    private volatile boolean cShutdown = false;
    private Thread cThread = null;
    private DiskEventQueue cEntryQueue = null;
    private DiskExpiringEventQueue cCreationBufferQueue = null;
    private DiskExpiringEventQueue cDeletionBufferQueue = null;
    private DiskEventQueue cWorkerQueue = null;
    Comparator cComparator = new EventComparator();

    public DiskFilterThread(DiskEventQueue pEntryQueue, DiskEventQueue pWorkerQueue, DiskExpiringEventQueue pCreationBufferQueue, DiskExpiringEventQueue pDeletionBufferQueue) {
        this.cEntryQueue = pEntryQueue;
        this.cWorkerQueue = pWorkerQueue;
        this.cCreationBufferQueue = pCreationBufferQueue;
        this.cDeletionBufferQueue = pDeletionBufferQueue;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"run", null);
        try {
            this.cThread = Thread.currentThread();
            while (!this.cShutdown) {
                try {
                    CIMIndicationEvent bIndicationEntry = this.cEntryQueue.remove();
                    String bIndicationClass = bIndicationEntry.getCIMEvent().getIndication().getClassName();
                    if (bIndicationClass.equalsIgnoreCase("CIM_InstCreation")) {
                        this.processInstanceCreation(bIndicationEntry);
                        continue;
                    }
                    if (bIndicationClass.equalsIgnoreCase("CIM_InstDeletion")) {
                        this.processInstanceDeletion(bIndicationEntry);
                        continue;
                    }
                    this.processInstanceModification(bIndicationEntry);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    private void processInstanceModification(CIMIndicationEvent pIndicationEntry) {
        if (!this.cWorkerQueue.contains(pIndicationEntry, this.cComparator)) {
            this.cWorkerQueue.add(pIndicationEntry);
        }
    }

    private void processInstanceDeletion(CIMIndicationEvent pIndicationEntry) {
        if (!this.cDeletionBufferQueue.contains(pIndicationEntry, this.cComparator)) {
            this.cWorkerQueue.add(pIndicationEntry);
        }
        this.cDeletionBufferQueue.add(pIndicationEntry);
    }

    private void processInstanceCreation(CIMIndicationEvent pIndicationEntry) {
        if (!this.cCreationBufferQueue.contains(pIndicationEntry, this.cComparator)) {
            this.cWorkerQueue.add(pIndicationEntry);
        }
        this.cCreationBufferQueue.add(pIndicationEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"shutdown", null);
        this.cShutdown = true;
        try {
            if (this.cThread != null) {
                try {
                    this.cThread.interrupt();
                    this.cThread.join(30000L);
                    this.cThread = null;
                }
                catch (Exception pEx) {
                    mLTH.traceError("HWN099993E", (Throwable)pEx);
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    public static class EventComparator
    implements Comparator {
        public int compare(Object pObj1, Object pObj2) {
            CIMIndicationEvent mEvent1 = (CIMIndicationEvent)pObj1;
            CIMIndicationEvent mEvent2 = (CIMIndicationEvent)pObj2;
            int mResult = mEvent1.getCIMInstance().getClassName().compareTo(mEvent2.getCIMInstance().getClassName());
            return mResult != 0 ? mResult : mEvent1.getSourceCop().toString().compareTo(mEvent2.getSourceCop().toString());
        }
    }
}

