/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.dataservernotification;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Server;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketRegistry;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;

public class Notifier {
    private static String dataServer = null;
    private static int dataPort = -1;
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;

    public Notifier() {
        String methodName = "Notifier";
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, Notifier.class, "Notifier");
        }
        if (dataServer == null) {
            Notifier.getDataServer();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, Notifier.class, "Notifier");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getDataServer() {
        String methodName = "getDataServer";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, Notifier.class, "getDataServer");
        }
        DBConnection dbc = null;
        Server.ServerCursor sc = null;
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            dbc = (DBConnection)ds.getPooledConnection();
            Hashtable<ColumnInfo, String> htWhere = new Hashtable<ColumnInfo, String>();
            htWhere.put(Server.getColumnInfo((String)"SERVER_TYPE"), "0");
            sc = Server.getCursor((DBConnection)dbc, htWhere, null);
            if (sc.next()) {
                Server svr = sc.getAttributes();
                dataServer = svr.getServerName();
                dataPort = svr.getPortNumber();
            }
        }
        catch (SQLException e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, Notifier.class, "getDataServer", (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, Notifier.class, "getDataServer", (Throwable)e);
            }
        }
        finally {
            block24: {
                if (sc != null) {
                    try {
                        sc.close();
                    }
                    catch (SQLException e) {}
                }
                if (dbc != null) {
                    try {
                        dbc.close();
                    }
                    catch (SQLException e) {
                        if (!traceLogger.isLogging()) break block24;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, Notifier.class, "getDataServer", (Throwable)e);
                    }
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, Notifier.class, "getDataServer");
        }
    }

    private static SocketTransceiver getTransceiver() {
        String methodName = "getTransceiver";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, Notifier.class, "getTransceiver");
        }
        SocketTransceiver trans = null;
        Socket sock = null;
        if (dataServer != null) {
            block10: {
                try {
                    sock = SocketRegistry.connect((String)dataServer, (int)dataPort);
                    trans = new SocketTransceiver(sock, dataServer);
                }
                catch (UnknownHostException e) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, Notifier.class, "getTransceiver", (Throwable)e);
                    if (!traceLogger.isLogging()) break block10;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, Notifier.class, "getTransceiver", (Throwable)e);
                }
            }
            if (trans == null && sock != null) {
                try {
                    sock.close();
                }
                catch (IOException iOException) {}
            }
        } else if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_WARNING, Notifier.class, "getTransceiver", "NO DATA SERVER");
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, Notifier.class, "getTransceiver", (Object)trans);
        }
        return trans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendRequest(Request req) {
        boolean ret;
        String errorMsg;
        String methodName = "sendRequest";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, Notifier.class, "sendRequest");
        }
        SocketTransceiver trans = Notifier.getTransceiver();
        int status = 4;
        if (trans != null) {
            try {
                Response response = trans.transmitRequest(req, null);
                if (response == null) {
                    status = 12;
                    errorMsg = "Unknown error encountered - no response received";
                }
                status = response.status;
                errorMsg = response.errorMessage;
            }
            catch (Exception e) {
                status = 12;
                errorMsg = "Unable to connect to the Data server.  Please ensure that the server is up and running.";
            }
            finally {
                trans.close();
            }
        } else {
            status = 4;
            errorMsg = "NO CONNECTION TO DATA SERVER";
        }
        boolean bl = ret = status == 0;
        if (traceLogger.isLogging()) {
            if (status > 0) {
                traceLogger.text(IRecordType.TYPE_WARN, Notifier.class, "sendRequest", errorMsg);
            }
            traceLogger.exit(IRecordType.TYPE_EXIT, Notifier.class, "sendRequest", ret);
        }
        return ret;
    }

    public boolean sendAlert(Alert alert) {
        String methodName = "sendAlert";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, Notifier.class, "sendAlert");
        }
        Request req = new Request();
        req.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        req.serviceName = RequestTypeManager.getInternalName((String)req.typeCode);
        req.subType = "org.eclipse.aperi.server.handler.server.GenerateAlertHndlr";
        req.requestData = alert;
        boolean ret = this.sendRequest(req);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, Notifier.class, "sendAlert", ret);
        }
        return ret;
    }
}

