/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator;

import java.util.HashMap;
import org.eclipse.aperi.monitor.MonitorActivator;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventHandler;
import org.eclipse.aperi.monitor.eventcorrelator.NoDelayHandler;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.ExternalEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SRMEvent;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class DelayPostEventThread
extends Thread {
    static ILogger sMsgLogger = EventCorrelatorFactory.msgLogger;
    static ILogger sTraceLogger = EventCorrelatorFactory.traceLogger;
    static final String CLASSNAME = DelayPostEventThread.class.getName();
    private EventCorrelatorFactory cEventCorrelator;
    private static HashMap sQuiescedEventList = new HashMap();
    private boolean cPostEventStarted = false;
    private static DelayPostEventThread sEventThread = null;
    private static int sEventCoolOffPeriod = -1;
    private static final int CONFIG_EVENT_COOLOFF_PERIOD_DEFAULT = 30000;
    private static NoDelayHandler noDelayHandler = null;
    private static final String CONFIG_EVENT_COOLOFF_PERIOD = "EventCoolOffPeriod";
    private static final String DS_CONFIG_GROUP = "DeviceServer";

    private DelayPostEventThread(EventCorrelatorFactory ec) {
        super("DelayPostEventThread");
        String methodName = "DelayPostEventThread";
        if (sTraceLogger.isLogging()) {
            sTraceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)CLASSNAME, methodName);
        }
        this.cEventCorrelator = ec;
        if (sEventCoolOffPeriod == -1) {
            String mVal;
            sEventCoolOffPeriod = 30000;
            IConfigService configSvcProxy = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
            if (configSvcProxy != null && (mVal = configSvcProxy.getProperty(CONFIG_EVENT_COOLOFF_PERIOD, DS_CONFIG_GROUP)) != null) {
                sEventCoolOffPeriod = Integer.parseInt(mVal);
            }
        }
        if (sTraceLogger.isLogging()) {
            sTraceLogger.exit(IRecordType.TYPE_EXIT, (Object)CLASSNAME, methodName);
        }
    }

    public void run() {
        String methodName = "run";
        if (sTraceLogger.isLogging()) {
            sTraceLogger.entry(IRecordType.TYPE_API, (Object)CLASSNAME, methodName);
        }
        while (this.postEventExist()) {
            try {
                this.setPostEventStarted(false);
                if (sTraceLogger.isLogging()) {
                    sTraceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Started new thread " + this.getName());
                }
                DelayPostEventThread.sleep(sEventCoolOffPeriod);
                if (this.cEventCorrelator.shutdownRequested) {
                    if (sTraceLogger.isLogging()) {
                        sTraceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Posting event are stopped since services are shutting down");
                    }
                    if (sTraceLogger.isLogging()) {
                        sTraceLogger.exit(IRecordType.TYPE_EXIT, (Object)CLASSNAME, methodName);
                    }
                    return;
                }
                if (sTraceLogger.isLogging()) {
                    sTraceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "About to post external event");
                }
                this.setPostEventStarted(true);
                if (!sTraceLogger.isLogging()) continue;
                sTraceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "Done post event. " + this.getName());
            }
            catch (Exception e) {
                if (sTraceLogger.isLogging()) {
                    sTraceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "Exception thrown while running DelayPostEventThread");
                }
                sTraceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)CLASSNAME, methodName, (Throwable)e);
            }
        }
        if (sTraceLogger.isLogging()) {
            sTraceLogger.exit(IRecordType.TYPE_EXIT, (Object)CLASSNAME, methodName);
        }
    }

    public static synchronized void addEvent(String pSourceAddress, SRMEvent pEvent, EventCorrelatorFactory pEventCorrelator) {
        String methodName = "addEvent";
        if (sTraceLogger.isLogging()) {
            sTraceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)CLASSNAME, methodName);
        }
        boolean newThread = false;
        if (sEventThread == null) {
            sEventThread = new DelayPostEventThread(pEventCorrelator);
            newThread = true;
        }
        if (noDelayHandler == null) {
            noDelayHandler = new NoDelayHandler(pEventCorrelator);
        }
        if (pEvent instanceof CIMIndicationEvent) {
            Integer deviceType = DelayPostEventThread.sEventThread.cEventCorrelator.getIndicationSourceType(((CIMIndicationEvent)pEvent).getCIMOM());
            if (deviceType == EventCorrelatorFactory.IS_SWITCH) {
                DelayPostEventThread.addEventToQuiescedList(pSourceAddress, pEvent);
            } else {
                NoDelayHandler.publishEvent(pEvent);
            }
        } else {
            DelayPostEventThread.addEventToQuiescedList(pSourceAddress, pEvent);
        }
        if (newThread) {
            sEventThread.start();
        }
        if (sTraceLogger.isLogging()) {
            sTraceLogger.exit(IRecordType.TYPE_EXIT, (Object)CLASSNAME, methodName);
        }
    }

    private static void addEventToQuiescedList(String pSourceAddress, SRMEvent pEvent) {
        if (sQuiescedEventList == null) {
            System.out.println("sQuiescedEventList is null");
        } else {
            sQuiescedEventList.put(pSourceAddress, pEvent);
        }
    }

    private synchronized boolean postEventExist() {
        String methodName = "postEventExist";
        if (sTraceLogger.isLogging()) {
            sTraceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)CLASSNAME, methodName);
        }
        if (sQuiescedEventList.size() > 0) {
            return true;
        }
        this.deactivateThread();
        try {
            this.setPostEventStarted(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sTraceLogger.isLogging()) {
            sTraceLogger.exit(IRecordType.TYPE_EXIT, (Object)CLASSNAME, methodName);
        }
        return false;
    }

    private synchronized void setPostEventStarted(boolean pPostEventStarted) throws Exception {
        String methodName = "setPostEventStarted";
        if (sTraceLogger.isLogging()) {
            sTraceLogger.entry(IRecordType.TYPE_ENTRY, (Object)CLASSNAME, methodName, (Object)(pPostEventStarted ? "YES" : "NO"));
        }
        this.cPostEventStarted = pPostEventStarted;
        if (pPostEventStarted) {
            for (ExternalEvent event : sQuiescedEventList.values()) {
                this.cEventCorrelator.publish((SRMEvent)event);
                EventHandler.handleEventAlert((SRMEvent)event);
            }
            sQuiescedEventList.clear();
        }
        if (sTraceLogger.isLogging()) {
            sTraceLogger.exit(IRecordType.TYPE_EXIT, (Object)CLASSNAME, methodName);
        }
    }

    public synchronized void deactivateThread() {
        String methodName = "deactivateThread";
        if (sTraceLogger.isLogging()) {
            sTraceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)CLASSNAME, methodName);
        }
        sEventThread = null;
        if (sTraceLogger.isLogging()) {
            sTraceLogger.exit(IRecordType.TYPE_EXIT, (Object)CLASSNAME, methodName);
        }
    }

    public String toString() {
        return "[post event" + (this.cPostEventStarted ? "" : "not") + "started.]";
    }
}

