/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator;

import java.io.Serializable;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TopicPublisher;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.control.data.JobInfo;
import org.eclipse.aperi.discovery.RemoveMissingProcessor;
import org.eclipse.aperi.infrastructure.database.objects.Agent;
import org.eclipse.aperi.infrastructure.database.objects.Alias;
import org.eclipse.aperi.infrastructure.database.objects.Alias2member;
import org.eclipse.aperi.infrastructure.database.objects.BackendController;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.infrastructure.database.objects.Disk;
import org.eclipse.aperi.infrastructure.database.objects.DiskGroup;
import org.eclipse.aperi.infrastructure.database.objects.Fabric;
import org.eclipse.aperi.infrastructure.database.objects.Fabric2switch;
import org.eclipse.aperi.infrastructure.database.objects.Hba;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.objects.IpTarget;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.database.objects.Node2hba;
import org.eclipse.aperi.infrastructure.database.objects.Pe2node;
import org.eclipse.aperi.infrastructure.database.objects.PhyPe;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.Port2port;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.Server;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.Switch2port;
import org.eclipse.aperi.infrastructure.database.objects.SwitchBlade;
import org.eclipse.aperi.infrastructure.database.objects.TapeDrive;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.TapeMediaChanger;
import org.eclipse.aperi.infrastructure.database.objects.Zone;
import org.eclipse.aperi.infrastructure.database.objects.Zone2alias;
import org.eclipse.aperi.infrastructure.database.objects.Zone2member;
import org.eclipse.aperi.infrastructure.database.objects.ZoneMember;
import org.eclipse.aperi.infrastructure.database.objects.Zset;
import org.eclipse.aperi.infrastructure.database.objects.Zset2zone;
import org.eclipse.aperi.monitor.CIMOMEventProcessor;
import org.eclipse.aperi.monitor.CIMOMRegistrator;
import org.eclipse.aperi.monitor.DataSource;
import org.eclipse.aperi.monitor.MonitorActivator;
import org.eclipse.aperi.monitor.eventcorrelator.DelayPostEventThread;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatordDBHelper;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.EventHandler;
import org.eclipse.aperi.monitor.eventcorrelator.EventProcessor;
import org.eclipse.aperi.monitor.eventcorrelator.SnapshotProcessor;
import org.eclipse.aperi.monitor.eventcorrelator.data.AgentEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMOMEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.DeviceOperationalStatusChangeEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.DeviceStateChangeEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.DiskMgrAgentEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.EntityEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.ExternalEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.Fabric2SwitchAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.FabricAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.FabricPortAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.FifoQueue;
import org.eclipse.aperi.monitor.eventcorrelator.data.Hba2NodeAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.HbaAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.HostAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.IPTargetEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.InbandEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.JobEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.monitor.eventcorrelator.data.NewDeviceEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.NewRelationshipEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.NodeAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.Pe2NodeAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.PerEntAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.Port2PortAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.PropertyChangeEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.RelationshipStateChangeEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SNMPTrapEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SRMEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.Switch2PortAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.SwitchAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.SwitchBladeAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.Zone2AliasAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.Zone2MemberAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.ZoneAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.ZoneAliasAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.ZoneMemberAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.ZonesetAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.Zset2ZoneAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.DataManager;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.ExtractEventFailedException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.InbandChangeEventExtractor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.SanDataManager;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.SmartEvent;
import org.eclipse.aperi.monitor.snmp.EventFilter;
import org.eclipse.aperi.monitor.snmp.SnmpMonitor;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.ICallback;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.event.data.SANEventUtil;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.FactoryFactory;
import org.eclipse.aperi.sanmgmt.sanmgr.eventcorrelator.interfaces.IEventCorrelatorFactory;
import org.eclipse.aperi.sanmgmt.sanmgr.eventcorrelator.interfaces.InstantiationFailedException;
import org.eclipse.aperi.sanmgmt.sanmgr.eventcorrelator.interfaces.PostEventFailedException;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.client.indications.CIMEvent;

public class EventCorrelatorFactory
implements IEventCorrelatorFactory,
IEventMonitorService,
IService,
ICliDispatcher,
ICallback {
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    static final String className = EventCorrelatorFactory.class.getName();
    static ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.monitor.eventcorrelator.resources.EventFilterResources", Locale.getDefault());
    private Status status = null;
    private final String SERVICE_NAME = "SANEventCorrelatorFactory";
    private Factory tesFactory = null;
    private TopicPublisher tesPublisher = null;
    private DataManager dataManager = null;
    boolean shutdownRequested = false;
    private SnmpMonitor snmpMonitor = null;
    private CIMOMEventProcessor cimMonitor = null;
    Hashtable publisherList = new Hashtable();
    private Message template = null;
    private Hashtable events = new Hashtable();
    private Hashtable devices = new Hashtable();
    private Map indicationSources = new HashMap();
    private SnapshotProcessor snapshotPro = null;
    private EventProcessor eventPro = null;
    static Hashtable devAlertPopulators = new Hashtable();
    static Hashtable tableToEntityTypeMapping = new Hashtable();
    private HashSet cimomRegers = new HashSet();
    public static final Integer IS_SUBSYSTEM = new Integer(2);
    public static final Integer IS_TAPELIBRARY = new Integer(3);
    public static final Integer IS_NOTHING = new Integer(-1);
    public static final Integer IS_SWITCH = new Integer(1);
    public static String DEFAULT_PROC_ID = "DEVICE_DISCOVERY";
    public static boolean oldAPIUsed = false;
    public static final String PROPERTY_GROUP = "MonitorService";
    public static final String PROPERTY_NUM_CIMOM_REGISTRATORS = "NumCIMOMRegistrators";
    public static final int DEFAULT_NUM_RESOURCES = 5;

    public synchronized void registerAlertPopulator(String deviceType, IPopulator alertPopulator) {
        devAlertPopulators.put(deviceType, alertPopulator);
    }

    public synchronized void deregisterAlertPopulator(String deviceType) {
        devAlertPopulators.remove(deviceType);
    }

    public EventCorrelatorFactory() {
        this.status = new Status(5, 3);
        LogConstants.msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.SanEventCorrelatorFactory");
        LogConstants.traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.SanEventCorrelatorFactory");
        LogConstants.msgLogger.setMessageFile(LogConstants.MSG_FILE);
        msgLogger = LogConstants.msgLogger;
        traceLogger = LogConstants.traceLogger;
        EventCorrelatorFactory.initTableNameToDeviceTypeMap();
        EventCorrelatorFactory.initDeviceTypeToAlertPopulatorMap();
    }

    public void postSnmpEvent(SnmpTrap trap) {
        String methodName = "postSnmpEvent";
        String eventType = "SNMPTrap";
        String sourceAddress = null;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)eventType);
        }
        if (!this.shutdownRequested) {
            if (trap.agentAddr != null) {
                sourceAddress = trap.agentAddr.toString();
            }
            if (sourceAddress == null) {
                sourceAddress = "UnknownSNMPTrapSource";
                traceLogger.text(IRecordType.TYPE_WARN, (Object)this, methodName, "Received " + eventType + " from " + sourceAddress);
            }
            SNMPTrapEvent tempEvent = new SNMPTrapEvent(sourceAddress, eventType, trap);
            this.addExternalEvent((ExternalEvent)tempEvent);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void postEvent(String xmlEvent) throws PostEventFailedException {
        String methodName = "postEvent";
        String eventType = "InbandNotification";
        String sourceAddress = null;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)xmlEvent);
        }
        if (!this.shutdownRequested) {
            SmartEvent[] events = null;
            try {
                InbandChangeEventExtractor ibcee = new InbandChangeEventExtractor();
                events = ibcee.extractEvent(this.dataManager, xmlEvent);
            }
            catch (ExtractEventFailedException eefe) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)eefe);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)eefe);
                }
                throw new PostEventFailedException();
            }
            for (int i = 0; i < events.length; ++i) {
                sourceAddress = events[i].getSourceAddress();
                if (sourceAddress == null) {
                    sourceAddress = "UnknownInbandSource";
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)this, methodName, "Received " + eventType + " from " + sourceAddress);
                }
                InbandEvent tempEvent = new InbandEvent(sourceAddress, eventType);
                this.addExternalEvent((ExternalEvent)tempEvent);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void postIndicationEvent(CIMEvent indicationEvent) {
        String methodName;
        block7: {
            methodName = "postIndicationEvent";
            String eventType = "CIMIndication";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)eventType);
            }
            if (!this.shutdownRequested) {
                try {
                    String sourceIP = null;
                    InetAddress ia = indicationEvent.getInetAddress();
                    if (ia != null) {
                        sourceIP = ia.getHostAddress();
                    }
                    if (sourceIP == null) {
                        sourceIP = "UnknownCIMIndicationSource";
                        traceLogger.text(IRecordType.TYPE_WARN, (Object)this, methodName, "Received " + eventType + " from " + sourceIP);
                    }
                    CIMIndicationEvent tempEvent = new CIMIndicationEvent(sourceIP, eventType, indicationEvent);
                    this.addExternalEvent((ExternalEvent)tempEvent);
                }
                catch (Exception ex) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)ex);
                    if (!traceLogger.isLogging()) break block7;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ex);
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public synchronized void addExternalEvent(ExternalEvent myEvent) {
        String methodName = "addExternalEvent";
        String ipAddress = myEvent.getSource();
        String eventType = myEvent.getType();
        DelayPostEventThread.addEvent(ipAddress + eventType, (SRMEvent)myEvent, this);
    }

    public synchronized void addEntityEventToEventList(String processId, EntityEvent entityEvent) {
        Vector<EntityEvent> v;
        String methodName = "addEntityEventToEventList";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, new Object[]{processId, entityEvent});
        }
        if ((v = (Vector<EntityEvent>)this.events.get(processId)) == null) {
            v = new Vector<EntityEvent>();
        }
        v.add(entityEvent);
        this.events.put(processId, v);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public synchronized void addDeviceToSnapshotList(String processId, String deviceType, String deviceId) {
        String methodName = "addDeviceToSnapshotList";
        Hashtable att = new Hashtable();
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, new Object[]{processId, deviceType + ":" + deviceId});
        }
        if (this.isSnapshotDeviceType(deviceType)) {
            Vector<String> v = (Vector<String>)this.devices.get(processId);
            if (v == null) {
                v = new Vector<String>();
            }
            v.add(deviceType + ':' + deviceId);
            this.devices.put(processId, v);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private boolean isSnapshotDeviceType(String deviceType) {
        boolean bool = false;
        if (deviceType.equals("switch") || deviceType.equals("subsystem") || deviceType.equals("host")) {
            bool = true;
        }
        return bool;
    }

    public boolean startup() {
        boolean started;
        String methodName;
        block16: {
            block15: {
                methodName = "startup";
                started = false;
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
                }
                this.status.setRunStatus(9);
                this.snmpMonitor = new SnmpMonitor(this);
                this.snmpMonitor.initialize();
                try {
                    this.cimMonitor = new CIMOMEventProcessor(this);
                    this.createCIMOMRegers(this.cimMonitor);
                    RegisteredCimom[] cimoms = EventDBAccessor.getAllRegisteredCimoms();
                    if (cimoms != null && cimoms.length > 0) {
                        for (int i = 0; i < cimoms.length; ++i) {
                            try {
                                DataSource ds = new DataSource(1, cimoms[i]);
                                this.cimMonitor.addDataSource(ds);
                                continue;
                            }
                            catch (Exception exp) {
                                exp.printStackTrace();
                                if (!traceLogger.isLogging()) continue;
                                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)exp);
                            }
                        }
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                    if (!traceLogger.isLogging()) break block15;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)exp);
                }
            }
            try {
                this.snapshotPro = SnapshotProcessor.shareInstance();
                this.snapshotPro.start(this);
                this.eventPro = EventProcessor.shareInstance();
                this.eventPro.start(this);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            FifoQueue queue = FifoQueue.getQueue(10);
            try {
                this.dataManager = SanDataManager.createDataManager();
            }
            catch (InstantiationFailedException ife) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)ife);
                if (!traceLogger.isLogging()) break block16;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ife);
            }
        }
        try {
            this.tesFactory = FactoryFactory.createFactory((int)2, null);
            this.template = this.tesFactory.createMessage(null);
            this.template.setStringProperty("SANDomainID", SANEventUtil.getDomainName());
            this.template.setStringProperty("publisherID", "org.eclipse.aperi.sanmgmt.sanmgr.eventcorrelator.EventCorrelator");
        }
        catch (JMSException je) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)je);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)je);
            }
            return started;
        }
        this.status.setRunStatus(8);
        started = true;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return started;
    }

    private void createCIMOMRegers(CIMOMEventProcessor pCimMonitor) {
        String mVal;
        int numRegers = 5;
        IConfigService bConfigService = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
        if (bConfigService != null && (mVal = bConfigService.getProperty(PROPERTY_NUM_CIMOM_REGISTRATORS, PROPERTY_GROUP)) != null) {
            numRegers = Integer.parseInt(mVal);
        }
        for (int i = 0; i < numRegers; ++i) {
            this.cimomRegers.add(new CIMOMRegistrator(pCimMonitor));
        }
    }

    public boolean shutdown() {
        boolean stopped;
        String methodName;
        block19: {
            block18: {
                methodName = "shutdown";
                this.shutdownRequested = true;
                stopped = false;
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
                }
                this.status.setRunStatus(11);
                this.snmpMonitor.shutdown();
                this.snmpMonitor = null;
                this.closeAllPublishers();
                if (this.cimMonitor != null) {
                    try {
                        RegisteredCimom[] cimoms = EventDBAccessor.getAllRegisteredCimoms();
                        if (cimoms != null && cimoms.length > 0) {
                            for (int i = 0; i < cimoms.length; ++i) {
                                try {
                                    DataSource ds = new DataSource(1, cimoms[i]);
                                    this.cimMonitor.removeDataSource(ds);
                                    continue;
                                }
                                catch (Exception exp) {
                                    exp.printStackTrace();
                                    if (!traceLogger.isLogging()) continue;
                                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)exp);
                                }
                            }
                        }
                        if (cimoms != null && cimoms.length > 0) {
                            try {
                                Thread.sleep(30000L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                        if (this.cimomRegers != null) {
                            Iterator i = this.cimomRegers.iterator();
                            while (i.hasNext()) {
                                ((CIMOMRegistrator)i.next()).shutdown();
                            }
                            this.cimomRegers = null;
                        }
                    }
                    catch (Exception exp) {
                        exp.printStackTrace();
                        if (!traceLogger.isLogging()) break block18;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)exp);
                    }
                }
            }
            this.cimMonitor.exit();
            this.cimMonitor = null;
            if (this.snapshotPro != null) {
                this.snapshotPro.stop();
            }
            if (this.eventPro != null) {
                this.eventPro.stop();
            }
            try {
                this.tesFactory.close();
            }
            catch (JMSException je) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "EvcEventGenerato_tesFactoryCloseFailed");
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)je);
                if (!traceLogger.isLogging()) break block19;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)je);
            }
        }
        stopped = true;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return stopped;
    }

    public String getName() {
        return "SANEventCorrelatorFactory";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("SANEventCorrelatorFactory_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("SANEventCorrelatorFactory_Description");
    }

    public Status getStatus() {
        return new Status(5, 8);
    }

    public String getVersion() {
        return "5.0.0";
    }

    public String getDescription() {
        String methodName = "getDescription";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "getDescription");
        }
        String defaultDescription = "Processes SNMP traps from the SAN and events received from the managed hosts";
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "getDescription");
        }
        return defaultDescription;
    }

    public Hashtable getRoleMap() {
        Hashtable roleMap = new Hashtable();
        return roleMap;
    }

    public synchronized void publish(SRMEvent anEvent) {
        String methodName;
        block9: {
            methodName = "publish";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)anEvent);
            }
            String eventName = anEvent.toString();
            try {
                TopicPublisher tesPublisher = null;
                String key = anEvent.getClass().getName();
                if (this.publisherList.containsKey(key)) {
                    tesPublisher = (TopicPublisher)this.publisherList.get(key);
                } else {
                    tesPublisher = this.tesFactory.createPublisher(anEvent.getClass().getName(), this.template);
                    this.publisherList.put(key, tesPublisher);
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "Created a new publisher for key = " + key);
                    }
                }
                ObjectMessage msg = this.tesFactory.createMessage((Serializable)anEvent);
                tesPublisher.publish((Message)msg);
            }
            catch (JMSException je) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)je);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)je);
                }
            }
            catch (Exception pe) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)pe);
                if (!traceLogger.isLogging()) break block9;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pe);
            }
        }
        traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "Published TPC Event: " + anEvent.toString());
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void closeAllPublishers() {
        String methodName = "closeAllPublishers";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        Enumeration keys = this.publisherList.keys();
        while (keys.hasMoreElements()) {
            TopicPublisher tmpPublisher = (TopicPublisher)this.publisherList.get(keys.nextElement());
            try {
                tmpPublisher.close();
                if (!traceLogger.isLogging()) continue;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Closed publisher: " + tmpPublisher.toString());
            }
            catch (JMSException jmse) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "EvcEventGenerator_tesPublisherCloseFailed", (Object)tmpPublisher.toString());
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)jmse);
                if (!traceLogger.isLogging()) continue;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)jmse);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void handleNewDevice(String deviceType, String deviceId) {
        String methodName = "handleNewDevice";
        String processId = DEFAULT_PROC_ID;
        oldAPIUsed = true;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.addDeviceToSnapshotList(processId, deviceType, deviceId);
        if (deviceType.equals("cimom")) {
            try {
                RegisteredCimom om = EventDBAccessor.getCIMOMByID(deviceId);
                DataSource ds = new DataSource(1, om);
                this.cimMonitor.addDataSource(ds);
                String serverURL = om.getServiceUrl();
                int port = this.getPortNumber(serverURL);
                String change = "New CIMOM discovered";
                CIMOMEvent tmpEvent = new CIMOMEvent(serverURL, port, change);
                this.publish((SRMEvent)tmpEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (deviceType.equals("iptarget")) {
            String type = deviceType;
            String address = deviceId;
            String change = "New IP target discovered";
            IPTargetEvent tmpEvent = new IPTargetEvent(type, address, change);
            this.publish((SRMEvent)tmpEvent);
        } else if (deviceType.equals("agent")) {
            String GUID2 = deviceId;
            int port = 999;
            String change = "New agent discovered";
            DiskMgrAgentEvent tmpEvent = new DiskMgrAgentEvent(GUID2, port, change);
            this.publish((SRMEvent)tmpEvent);
        } else {
            NewDeviceEvent myEvent = new NewDeviceEvent(deviceType, deviceId);
            this.addEntityEventToEventList(processId, (EntityEvent)myEvent);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void handleDeviceStateChange(String deviceType, String deviceId, int oldState, int newState) {
        String methodName;
        block15: {
            methodName = "handleDeviceStateChange";
            String processId = DEFAULT_PROC_ID;
            oldAPIUsed = true;
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            String state = Integer.toString(newState);
            this.addDeviceToSnapshotList(processId, deviceType, deviceId);
            if (deviceType.equals("cimom")) {
                try {
                    RegisteredCimom om = EventDBAccessor.getCIMOMByID(deviceId);
                    DataSource ds = new DataSource(1, om);
                    if (newState == 1) {
                        this.cimMonitor.addDataSource(ds);
                        String serverURL = om.getServiceUrl();
                        int port = this.getPortNumber(serverURL);
                        String change = "Missing CIMOM changed to normal";
                        CIMOMEvent tmpEvent = new CIMOMEvent(serverURL, port, change);
                        this.publish((SRMEvent)tmpEvent);
                        break block15;
                    }
                    this.cimMonitor.removeDataSource(ds);
                    this.deleteIndicationSource(ds);
                    String serverURL = om.getServiceUrl();
                    int port = this.getPortNumber(serverURL);
                    String change = "Normal CIMOM changed to missing";
                    CIMOMEvent tmpEvent = new CIMOMEvent(serverURL, port, change);
                    this.publish((SRMEvent)tmpEvent);
                }
                catch (Exception e) {}
            } else if (deviceType.equals("iptarget")) {
                if (newState == 1) {
                    String type = deviceType;
                    String address = deviceId;
                    String change = "Missing IP target changed to normal.";
                    IPTargetEvent tmpEvent = new IPTargetEvent(type, address, change);
                    this.publish((SRMEvent)tmpEvent);
                } else {
                    String type = deviceType;
                    String address = deviceId;
                    String change = "Normal IP target changed to missing.";
                    IPTargetEvent tmpEvent = new IPTargetEvent(type, address, change);
                    this.publish((SRMEvent)tmpEvent);
                }
            } else if (deviceType.equals("agent")) {
                if (newState == 1) {
                    String GUID2 = deviceId;
                    String agentURL = null;
                    int port = this.getPortNumber(agentURL);
                    String change = "Missing agent changed to normal";
                    DiskMgrAgentEvent tmpEvent = new DiskMgrAgentEvent(GUID2, port, change);
                    this.publish((SRMEvent)tmpEvent);
                } else {
                    String GUID3 = deviceId;
                    String agentURL = null;
                    int port = this.getPortNumber(agentURL);
                    String change = "Normal agent changed to missing";
                    DiskMgrAgentEvent tmpEvent = new DiskMgrAgentEvent(GUID3, port, change);
                    this.publish((SRMEvent)tmpEvent);
                }
            } else {
                DeviceStateChangeEvent myEvent = new DeviceStateChangeEvent(deviceType, deviceId, oldState, newState);
                this.addEntityEventToEventList(processId, (EntityEvent)myEvent);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void handleDevicePropertyChange(String deviceType, String deviceId, Hashtable oldValues, Hashtable newValues) {
        String methodName = "handleDevicePropertyChange";
        String processId = DEFAULT_PROC_ID;
        oldAPIUsed = true;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.addDeviceToSnapshotList(processId, deviceType, deviceId);
        if (deviceType.equals("cimom")) {
            try {
                RegisteredCimom om = EventDBAccessor.getCIMOMByID(deviceId);
                String serverURL = om.getServiceUrl();
                int port = this.getPortNumber(serverURL);
                String change = "CIMOM Property changed.";
                CIMOMEvent tmpEvent = new CIMOMEvent(serverURL, port, change);
                this.publish((SRMEvent)tmpEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (deviceType.equals("iptarget")) {
            String type = deviceType;
            String address = deviceId;
            String change = "IP target property changed.";
            IPTargetEvent tmpEvent = new IPTargetEvent(type, address, change);
            this.publish((SRMEvent)tmpEvent);
        } else {
            PropertyChangeEvent myEvent = new PropertyChangeEvent(deviceType, deviceId, oldValues, newValues);
            this.addEntityEventToEventList(processId, (EntityEvent)myEvent);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void handleNewLink(String linkType, String linkId) {
        String methodName = "handleNewLink";
        String processId = DEFAULT_PROC_ID;
        oldAPIUsed = true;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        String fromDev = "fromDev";
        String toDev = "toDev";
        NewRelationshipEvent myEvent = new NewRelationshipEvent(linkType, linkId, fromDev, toDev);
        this.addEntityEventToEventList(processId, (EntityEvent)myEvent);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void handleLinkStateChange(String linkType, String linkId, int oldState, int newState) {
        String methodName = "handleLinkStateChange";
        String processId = DEFAULT_PROC_ID;
        oldAPIUsed = true;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        RelationshipStateChangeEvent myEvent = new RelationshipStateChangeEvent(linkType, linkId, oldState, newState);
        this.addEntityEventToEventList(processId, (EntityEvent)myEvent);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handleModelUpdate(String procId) {
        Hashtable hashtable;
        String methodName = "handleModelUpdate";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)procId);
        }
        String processId = procId;
        if (oldAPIUsed) {
            traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "OLD APIs USED!!!!!! NEED CHANGE");
        }
        if (!this.events.isEmpty() && this.eventPro != null) {
            Vector eventset = new Vector();
            hashtable = this.events;
            synchronized (hashtable) {
                Vector curEvents = (Vector)this.events.get(processId);
                if (curEvents != null) {
                    eventset.addAll(curEvents);
                    this.events.remove(processId);
                }
                this.eventPro.addEventsToProcess(processId, eventset);
            }
        }
        if (!this.devices.isEmpty() && this.snapshotPro != null) {
            Vector deviceset = new Vector();
            hashtable = this.devices;
            synchronized (hashtable) {
                Vector curDevices = (Vector)this.devices.get(processId);
                if (curDevices != null) {
                    deviceset.addAll(curDevices);
                    this.devices.remove(processId);
                }
                this.snapshotPro.addDevicesToProcess(deviceset);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void handleJobStatus(JobInfo job) {
        String methodName = "handleJobStatus";
        String jobId = job.getJobId();
        int state = job.getJobStatus();
        JobEvent myEvent = new JobEvent(jobId, "status");
        this.publish((SRMEvent)myEvent);
        EventHandler.handleEventAlert((SRMEvent)myEvent);
    }

    public String dispatch(String method, String[] args) {
        String methodName = "dispatch";
        StringBuffer output = new StringBuffer();
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, methodName);
        }
        boolean needHelp = false;
        if (method.equalsIgnoreCase("help")) {
            needHelp = true;
        } else if (method.equalsIgnoreCase("list")) {
            output.append(EventFilter.list());
        } else if (method.equalsIgnoreCase("add")) {
            if (args.length == 0) {
                output.append(rb.getString("OutbandChangeAgent.InvalidNumParms"));
                needHelp = true;
            } else if (args[0].equalsIgnoreCase("filter")) {
                output.append(EventFilter.addFilter(args));
            } else if (args[0].equalsIgnoreCase("address")) {
                if (args.length > 2 && Integer.parseInt(args[1]) != 0) {
                    output.append(EventFilter.addAddress(args));
                } else {
                    output.append(rb.getString("OutbandChangeAgent.InvalidNumParms"));
                    needHelp = true;
                }
            } else {
                output.append(rb.getString("OutbandChangeAgent.InvalidCommand"));
                needHelp = true;
            }
        } else if (method.equalsIgnoreCase("remove")) {
            if (args.length == 0) {
                output.append(rb.getString("OutbandChangeAgent.InvalidNumParms"));
                needHelp = true;
            } else if (args[0].equalsIgnoreCase("filter")) {
                if (args.length == 2 && Integer.parseInt(args[1]) != 0) {
                    output.append(EventFilter.removeFilter(args));
                } else {
                    output.append(rb.getString("OutbandChangeAgent.InvalidNumParms"));
                    needHelp = true;
                }
            } else if (args[0].equalsIgnoreCase("address")) {
                if (args.length > 2 && Integer.parseInt(args[1]) != 0) {
                    output.append(EventFilter.removeAddress(args));
                } else {
                    output.append(rb.getString("OutbandChangeAgent.InvalidNumParms"));
                    needHelp = true;
                }
            } else {
                output.append(rb.getString("OutbandChangeAgent.InvalidCommand"));
                needHelp = true;
            }
        } else {
            output.append(rb.getString("OutbandChangeAgent.InvalidCommand"));
            needHelp = true;
        }
        if (needHelp) {
            output.append(rb.getString("OutbandChangeAgent.help") + "\n" + "list\n" + "add filter [enterprise=<enterprise>] [genericTrap=<number>] [specificTrap=<number>] [<OID>=<value>]*\n" + "add address <ID> <ipAddress>*\n" + "remove filter <ID>\n" + "remove address <ID> <ipAddress>*\n" + "\n");
        }
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, methodName);
        }
        return output.toString();
    }

    private void testAlerts() {
        String methodName = "testAlerts";
        String processId01 = "CONTROL";
        String processId02 = "DISCOVERY";
        String fabricWWN = "1000006069101555";
        HashMap<String, String> zoneMap = new HashMap<String, String>();
        HashMap<String, String> zonesetMap = new HashMap<String, String>();
        HashMap<String, String> zset2ZoneMap = new HashMap<String, String>();
        HashMap aliasMap = new HashMap();
        HashMap memeberMap = new HashMap();
        HashMap zone2AliasMap = new HashMap();
        HashMap zone2MemberMap = new HashMap();
        zoneMap.put("ACTIVE", "true");
        zoneMap.put("ZONE_ID", "1000");
        zoneMap.put("ZONE_NAME", "Zone1000");
        zoneMap.put("FABRIC_WWN", fabricWWN);
        zonesetMap.put("ACTIVE", "true");
        zonesetMap.put("ZSET_ID", "2000");
        zonesetMap.put("ZSET_NAME", "Zoneset2000");
        zonesetMap.put("FABRIC_WWN", fabricWWN);
        zset2ZoneMap.put("ZSET_ID", "2000");
        zset2ZoneMap.put("ZONE_ID", "1000");
        zset2ZoneMap.put("ZSET2ZONE_ID", "3000");
        this.handleDeviceStateChange(processId02, Zone.getTablename(), "1000", 1, 0, zoneMap);
        this.handleDeviceStateChange(processId02, Zset.getTablename(), "2000", 1, 0, zonesetMap);
        this.handleDeviceStateChange(processId02, Zset2zone.getTablename(), "3000", 1, 0, zset2ZoneMap);
        this.handleNewDevice(processId02, Fabric2switch.getTablename(), "8400");
        this.handleModelUpdate(processId02);
    }

    private void testAllSRMEvents(boolean bool) {
        String methodName = "selfTest";
        String test = "test not enabled";
        if (bool) {
            test = "test enabled";
        }
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)test);
        }
        if (bool) {
            Object helper = null;
            Object parms = null;
            boolean state = false;
            JobInfo job = new JobInfo("1", "JobId123", true);
            this.handleJobStatus(job);
            String processId01 = "CONTROL";
            String processId02 = "DISCOVERY";
            this.handleNewDevice(processId02, Switch.getTablename(), "5");
            this.handleDeviceStateChange(processId01, Switch.getTablename(), "5", 0, 1);
            this.handleNewDevice(processId02, Fabric.getTablename(), "5");
            this.handleModelUpdate(processId02);
            this.handleDeviceStateChange(processId01, StorageSubsystem.getTablename(), "1000", 0, 1);
            this.handleDeviceStateChange(processId02, Host.getTablename(), "56", 1, 0);
            this.handleDeviceStateChange(processId01, PhyPe.getTablename(), "5100", 0, 1);
            this.handleDevicePropertyChange(processId02, Hba.getTablename(), "123", new Hashtable(), new Hashtable());
            this.handleNewDevice(processId02, Port2port.getTablename(), "25");
            this.handleDeviceStateChange(processId01, Port2port.getTablename(), "30", 0, 1);
            this.handleOperationalStatusChange(processId01, Port2port.getTablename(), "30", 0, 1);
            this.handleModelUpdate(processId01);
            this.handleOperationalStatusChange(processId02, Switch.getTablename(), "30", 1, 0);
            this.handleModelUpdate(processId02);
            try {
                SnmpTrap trap = new SnmpTrap();
                this.postSnmpEvent(trap);
                CIMEvent indicationEvent = new CIMEvent(new CIMInstance());
                this.postIndicationEvent(indicationEvent);
                InbandEvent tempEvent = new InbandEvent("inbandAddress", "InbandEvent");
                this.addExternalEvent((ExternalEvent)tempEvent);
            }
            catch (Exception ep) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ep);
            }
            String[] objects = new String[]{"fabric:2", "switch:6", "subsystem:5"};
            RemoveMissingProcessor imp = new RemoveMissingProcessor();
            imp.performDeletionForSelectedMissingEntities(objects);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public synchronized void propCallback(String name, String group, String value) {
        String methodName = "propCallback";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "propCallback", (Object)("name=" + name + ", group=" + group + ", value=" + value));
        }
        if (group.equals("user") && name.equals("SnmpTrapPort")) {
            this.snmpMonitor.shutdown();
            this.snmpMonitor.initialize();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "propCallback");
        }
    }

    public static void main(String[] args) {
        EventCorrelatorFactory factory = new EventCorrelatorFactory();
        factory.startup();
        System.out.println("Waiting for events");
        while (true) {
            // Infinite loop
        }
    }

    public synchronized void handleNewDevice(String processId, String tableName, String autoId) {
        String methodName = "handleNewDevice";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, new Object[]{processId, tableName + autoId});
        }
        String deviceType = this.getDeviceTypeByTableName(tableName);
        String deviceId = autoId;
        if (deviceType == null) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "No deviceType mapping for table " + tableName);
            }
        } else if (this.isLinkType(deviceType)) {
            NewRelationshipEvent myEvent = new NewRelationshipEvent(deviceType, deviceId);
            this.addEntityEventToEventList(processId, (EntityEvent)myEvent);
        } else {
            this.addDeviceToSnapshotList(processId, deviceType, deviceId);
            if (deviceType.equals("cimom")) {
                try {
                    RegisteredCimom om = EventDBAccessor.getCIMOMByID(deviceId);
                    DataSource ds = new DataSource(1, om);
                    this.cimMonitor.addDataSource(ds);
                    String serverURL = om.getServiceUrl();
                    int port = this.getPortNumber(serverURL);
                    String change = "New CIMOM discovered";
                    CIMOMEvent tmpEvent = new CIMOMEvent(serverURL, port, change);
                    this.publish((SRMEvent)tmpEvent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (deviceType.equals("iptarget")) {
                String type = deviceType;
                String address = deviceId;
                String change = AgentEvent.ADDED;
                IPTargetEvent tmpEvent = new IPTargetEvent(type, address, change);
                this.publish((SRMEvent)tmpEvent);
            } else if (deviceType.equals("agent")) {
                String GUID2 = deviceId;
                String agentURL = null;
                int port = this.getPortNumber(agentURL);
                String status = AgentEvent.ADDED;
                DiskMgrAgentEvent tmpEvent = new DiskMgrAgentEvent(GUID2, port, status);
                this.publish((SRMEvent)tmpEvent);
            } else {
                NewDeviceEvent myEvent = new NewDeviceEvent(deviceType, deviceId);
                this.addEntityEventToEventList(processId, (EntityEvent)myEvent);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public synchronized void handleDeviceStateChange(String processId, String devTableName, String devAutoId, int oldState, int newState) {
        String methodName;
        block17: {
            methodName = "handleDeviceStateChange";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, new Object[]{processId, devTableName + devAutoId});
            }
            String deviceType = this.getDeviceTypeByTableName(devTableName);
            String deviceId = devAutoId;
            if (this.isLinkType(deviceType)) {
                RelationshipStateChangeEvent myEvent = new RelationshipStateChangeEvent(deviceType, deviceId, oldState, newState);
                this.addEntityEventToEventList(processId, (EntityEvent)myEvent);
            } else {
                this.addDeviceToSnapshotList(processId, deviceType, deviceId);
                if (deviceType.equals("cimom")) {
                    try {
                        RegisteredCimom om = EventDBAccessor.getCIMOMByID(deviceId);
                        DataSource ds = new DataSource(1, om);
                        if (newState == 1) {
                            this.cimMonitor.addDataSource(ds);
                            String serverURL = om.getServiceUrl();
                            int port = this.getPortNumber(serverURL);
                            String change = "Missing CIMOM changed to normal";
                            CIMOMEvent tmpEvent = new CIMOMEvent(serverURL, port, change);
                            this.publish((SRMEvent)tmpEvent);
                            break block17;
                        }
                        this.cimMonitor.removeDataSource(ds);
                        this.deleteIndicationSource(ds);
                        String serverURL = om.getServiceUrl();
                        int port = this.getPortNumber(serverURL);
                        String change = "Normal CIMOM changed to missing";
                        CIMOMEvent tmpEvent = new CIMOMEvent(serverURL, port, change);
                        this.publish((SRMEvent)tmpEvent);
                    }
                    catch (Exception e) {}
                } else if (deviceType.equals("iptarget")) {
                    if (newState == 1) {
                        String type = deviceType;
                        String address = deviceId;
                        String change = AgentEvent.ACTIVE;
                        IPTargetEvent tmpEvent = new IPTargetEvent(type, address, change);
                        this.publish((SRMEvent)tmpEvent);
                    } else {
                        String type = deviceType;
                        String address = deviceId;
                        String change = AgentEvent.REMOVED;
                        IPTargetEvent tmpEvent = new IPTargetEvent(type, address, change);
                        this.publish((SRMEvent)tmpEvent);
                    }
                } else if (deviceType.equals("agent")) {
                    if (newState == 1) {
                        String GUID2 = deviceId;
                        String agentUrl = null;
                        int port = this.getPortNumber(agentUrl);
                        String status = AgentEvent.ACTIVE;
                        DiskMgrAgentEvent tmpEvent = new DiskMgrAgentEvent(GUID2, port, status);
                        this.publish((SRMEvent)tmpEvent);
                    } else {
                        String GUID3 = deviceId;
                        String agentUrl = null;
                        int port = this.getPortNumber(agentUrl);
                        String status = AgentEvent.INACTIVE;
                        DiskMgrAgentEvent tmpEvent = new DiskMgrAgentEvent(GUID3, port, status);
                        this.publish((SRMEvent)tmpEvent);
                    }
                } else {
                    DeviceStateChangeEvent myEvent = new DeviceStateChangeEvent(deviceType, deviceId, oldState, newState);
                    this.addEntityEventToEventList(processId, (EntityEvent)myEvent);
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public synchronized void handleDevicePropertyChange(String processId, String devTableName, String devAutoId, Hashtable oldValues, Hashtable newValues) {
        String methodName = "handleDevicePropertyChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, new Object[]{processId, devTableName + devAutoId});
        }
        String deviceType = this.getDeviceTypeByTableName(devTableName);
        String deviceId = devAutoId;
        this.addDeviceToSnapshotList(processId, deviceType, deviceId);
        if (deviceType.equals("cimom")) {
            try {
                RegisteredCimom om = EventDBAccessor.getCIMOMByID(deviceId);
                DataSource ds = new DataSource(1, om);
                this.cimMonitor.addDataSource(ds);
                String serverURL = om.getServiceUrl();
                int port = this.getPortNumber(serverURL);
                String change = "CIMOM Property changed.";
                CIMOMEvent tmpEvent = new CIMOMEvent(serverURL, port, change);
                this.publish((SRMEvent)tmpEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (deviceType.equals("iptarget")) {
            String type = deviceType;
            String address = deviceId;
            String change = AgentEvent.MODIFIED;
            IPTargetEvent tmpEvent = new IPTargetEvent(type, address, change);
            this.publish((SRMEvent)tmpEvent);
        } else if (deviceType.equals("agent")) {
            String GUID2 = deviceId;
            String agentUrl = null;
            int port = this.getPortNumber(agentUrl);
            String status = AgentEvent.MODIFIED;
            DiskMgrAgentEvent tmpEvent = new DiskMgrAgentEvent(GUID2, port, status);
            this.publish((SRMEvent)tmpEvent);
        } else {
            PropertyChangeEvent myEvent = new PropertyChangeEvent(deviceType, deviceId, oldValues, newValues);
            this.addEntityEventToEventList(processId, (EntityEvent)myEvent);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public synchronized void handleOperationalStatusChange(String processId, String devTableName, String devAutoId, int oldStatus, int newStatus) {
        String methodName = "handleOperationalStatusChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, new Object[]{processId, devTableName + devAutoId});
        }
        String deviceType = this.getDeviceTypeByTableName(devTableName);
        String deviceId = devAutoId;
        DeviceOperationalStatusChangeEvent myEvent = new DeviceOperationalStatusChangeEvent(deviceType, deviceId, oldStatus, newStatus);
        this.addEntityEventToEventList(processId, (EntityEvent)myEvent);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private int getPortNumber(String serverUrl) {
        int port = 9999;
        if (serverUrl != null) {
            try {
                int index = serverUrl.lastIndexOf(":");
                String portString = serverUrl.substring(index + 1);
                port = Integer.parseInt(portString);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return port;
    }

    private String getDeviceTypeByTableName(String tableName) {
        return (String)tableToEntityTypeMapping.get(tableName);
    }

    private boolean isLinkType(String deviceType) {
        boolean bool = false;
        if (deviceType.equals("fabric2switch") || deviceType.equals("switch2port") || deviceType.equals("pe2node") || deviceType.equals("node2hba") || deviceType.equals("port2port") || deviceType.equals("zset2zone") || deviceType.equals("zone2member") || deviceType.equals("zone2alias") || deviceType.equals("alias2member")) {
            bool = true;
        }
        return bool;
    }

    static void initTableNameToDeviceTypeMap() {
        tableToEntityTypeMapping.put(Fabric.getTablename(), "fabric");
        tableToEntityTypeMapping.put(Host.getTablename(), "host");
        tableToEntityTypeMapping.put(Server.getTablename(), "server");
        tableToEntityTypeMapping.put(Switch.getTablename(), "switch");
        tableToEntityTypeMapping.put(Node.getTablename(), "node");
        tableToEntityTypeMapping.put(Port.getTablename(), "port");
        tableToEntityTypeMapping.put(SwitchBlade.getTablename(), "blade");
        tableToEntityTypeMapping.put(PhyPe.getTablename(), "pe");
        tableToEntityTypeMapping.put(Hba.getTablename(), "hba");
        tableToEntityTypeMapping.put(Zone.getTablename(), "zone");
        tableToEntityTypeMapping.put(Zset.getTablename(), "zset");
        tableToEntityTypeMapping.put(ZoneMember.getTablename(), "zonemember");
        tableToEntityTypeMapping.put(Alias.getTablename(), "zonealias");
        tableToEntityTypeMapping.put(StorageSubsystem.getTablename(), "subsystem");
        tableToEntityTypeMapping.put(DataPath.getTablename(), "datapath");
        tableToEntityTypeMapping.put(StoragePool.getTablename(), "storagepool");
        tableToEntityTypeMapping.put(StorageVolume.getTablename(), "storagevolume");
        tableToEntityTypeMapping.put(RegisteredCimom.getTablename(), "cimom");
        tableToEntityTypeMapping.put(Disk.getTablename(), "disk");
        tableToEntityTypeMapping.put(BackendController.getTablename(), "tape");
        tableToEntityTypeMapping.put(TapeDrive.getTablename(), "tapedrive");
        tableToEntityTypeMapping.put(TapeLibrary.getTablename(), "tapelibrary");
        tableToEntityTypeMapping.put(TapeMediaChanger.getTablename(), "tapemediachanger");
        tableToEntityTypeMapping.put(Fabric2switch.getTablename(), "fabric2switch");
        tableToEntityTypeMapping.put(Switch2port.getTablename(), "switch2port");
        tableToEntityTypeMapping.put(Node2hba.getTablename(), "node2hba");
        tableToEntityTypeMapping.put(Pe2node.getTablename(), "pe2node");
        tableToEntityTypeMapping.put(Port2port.getTablename(), "port2port");
        tableToEntityTypeMapping.put(Zset2zone.getTablename(), "zset2zone");
        tableToEntityTypeMapping.put(Zone2member.getTablename(), "zone2member");
        tableToEntityTypeMapping.put(Alias2member.getTablename(), "alias2member");
        tableToEntityTypeMapping.put(Zone2alias.getTablename(), "zone2alias");
        tableToEntityTypeMapping.put(PhysicalVolume.getTablename(), "diskdrive");
        tableToEntityTypeMapping.put(DiskGroup.getTablename(), "diskgroup");
        tableToEntityTypeMapping.put(StorageExtent.getTablename(), "storageextent");
        tableToEntityTypeMapping.put(StorageSubsystem.getTablename(), "storagesystem");
        tableToEntityTypeMapping.put(StorageVolume.getTablename(), "storagevolume");
        tableToEntityTypeMapping.put(IpTarget.getTablename(), "iptarget");
        tableToEntityTypeMapping.put(Agent.getTablename(), "agent");
        tableToEntityTypeMapping.put(DeviceAgent.getTablename(), "agent");
        tableToEntityTypeMapping.put(RegisteredCimom.getTablename(), "cimom");
    }

    static void initDeviceTypeToAlertPopulatorMap() {
        devAlertPopulators.put("switch", new SwitchAlertPopulator());
        devAlertPopulators.put("blade", new SwitchBladeAlertPopulator());
        devAlertPopulators.put("host", new HostAlertPopulator());
        devAlertPopulators.put("hba", new HbaAlertPopulator());
        devAlertPopulators.put("pe", new PerEntAlertPopulator());
        devAlertPopulators.put("node", new NodeAlertPopulator());
        devAlertPopulators.put("port", new FabricPortAlertPopulator());
        devAlertPopulators.put("fabric2switch", new Fabric2SwitchAlertPopulator());
        devAlertPopulators.put("switch2port", new Switch2PortAlertPopulator());
        devAlertPopulators.put("pe2node", new Pe2NodeAlertPopulator());
        devAlertPopulators.put("node2hba", new Hba2NodeAlertPopulator());
        devAlertPopulators.put("port2port", new Port2PortAlertPopulator());
        devAlertPopulators.put("fabric", new FabricAlertPopulator());
        devAlertPopulators.put("zone", new ZoneAlertPopulator());
        devAlertPopulators.put("zset", new ZonesetAlertPopulator());
        devAlertPopulators.put("zonemember", new ZoneMemberAlertPopulator());
        devAlertPopulators.put("zonealias", new ZoneAliasAlertPopulator());
        devAlertPopulators.put("zone2member", new Zone2MemberAlertPopulator());
        devAlertPopulators.put("zone2alias", new Zone2AliasAlertPopulator());
        devAlertPopulators.put("zset2zone", new Zset2ZoneAlertPopulator());
    }

    private boolean isAutoDeletedType(String deviceType) {
        boolean bool = false;
        if (deviceType.equals("zone") || deviceType.equals("zset") || deviceType.equals("zonemember") || deviceType.equals("zonealias") || deviceType.equals("zset2zone") || deviceType.equals("zone2member") || deviceType.equals("zone2alias") || deviceType.equals("alias2member") || deviceType.equals("datapath")) {
            bool = true;
        }
        return bool;
    }

    public synchronized void handleDeviceStateChange(String processId, String devTableName, String devAutoId, int oldState, int newState, HashMap attributeMap) {
        String methodName;
        block19: {
            methodName = "handleDeviceStateChange";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, new Object[]{processId, devTableName + devAutoId});
            }
            String deviceType = this.getDeviceTypeByTableName(devTableName);
            String deviceId = devAutoId;
            if (this.isLinkType(deviceType)) {
                RelationshipStateChangeEvent myEvent = new RelationshipStateChangeEvent(deviceType, deviceId, oldState, newState);
                if (this.isAutoDeletedType(deviceType)) {
                    myEvent.setAttributeMap(attributeMap);
                }
                this.addEntityEventToEventList(processId, (EntityEvent)myEvent);
            } else {
                this.addDeviceToSnapshotList(processId, deviceType, deviceId);
                if (deviceType.equals("cimom")) {
                    try {
                        RegisteredCimom om = EventDBAccessor.getCIMOMByID(deviceId);
                        DataSource ds = new DataSource(1, om);
                        if (newState == 1) {
                            this.cimMonitor.addDataSource(ds);
                            String serverURL = om.getServiceUrl();
                            int port = this.getPortNumber(serverURL);
                            String change = "Missing CIMOM changed to normal";
                            CIMOMEvent tmpEvent = new CIMOMEvent(serverURL, port, change);
                            this.publish((SRMEvent)tmpEvent);
                            break block19;
                        }
                        this.cimMonitor.removeDataSource(ds);
                        this.deleteIndicationSource(ds);
                        String serverURL = om.getServiceUrl();
                        int port = this.getPortNumber(serverURL);
                        String change = "Normal CIMOM changed to missing";
                        CIMOMEvent tmpEvent = new CIMOMEvent(serverURL, port, change);
                        this.publish((SRMEvent)tmpEvent);
                    }
                    catch (Exception e) {}
                } else if (deviceType.equals("iptarget")) {
                    if (newState == 1) {
                        String type = deviceType;
                        String address = deviceId;
                        String change = AgentEvent.ACTIVE;
                        IPTargetEvent tmpEvent = new IPTargetEvent(type, address, change);
                        this.publish((SRMEvent)tmpEvent);
                    } else {
                        String type = deviceType;
                        String address = deviceId;
                        String change = AgentEvent.REMOVED;
                        IPTargetEvent tmpEvent = new IPTargetEvent(type, address, change);
                        this.publish((SRMEvent)tmpEvent);
                    }
                } else if (deviceType.equals("agent")) {
                    if (newState == 1) {
                        String GUID2 = deviceId;
                        String agentUrl = null;
                        int port = this.getPortNumber(agentUrl);
                        String status = AgentEvent.ACTIVE;
                        DiskMgrAgentEvent tmpEvent = new DiskMgrAgentEvent(GUID2, port, status);
                        this.publish((SRMEvent)tmpEvent);
                    } else {
                        String GUID3 = deviceId;
                        String agentUrl = null;
                        int port = this.getPortNumber(agentUrl);
                        String status = AgentEvent.INACTIVE;
                        DiskMgrAgentEvent tmpEvent = new DiskMgrAgentEvent(GUID3, port, status);
                        this.publish((SRMEvent)tmpEvent);
                    }
                } else {
                    DeviceStateChangeEvent myEvent = new DeviceStateChangeEvent(deviceType, deviceId, oldState, newState);
                    if (this.isAutoDeletedType(deviceType)) {
                        myEvent.setAttributeMap(attributeMap);
                    }
                    this.addEntityEventToEventList(processId, (EntityEvent)myEvent);
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public synchronized void handleDeletedDevice(String processId, String devTableName, HashMap tupleColumns) {
        String methodName = "handleDeletedDevice";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, new Object[]{processId, devTableName});
        }
        String autoIdName = EventCorrelatorFactory.determineIdName(devTableName);
        String devAutoId = "-1";
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        if (autoIdName != null) {
            for (String name : tupleColumns.keySet()) {
                String value = "";
                Object obj = tupleColumns.get(name);
                if (obj != null) {
                    value = obj.toString();
                }
                if (name.equals(autoIdName)) {
                    devAutoId = value;
                }
                attributeMap.put(name, value);
            }
            int oldState = 1;
            int newState = 0;
            this.handleDeviceStateChange(processId, devTableName, devAutoId, oldState, newState, attributeMap);
        } else {
            traceLogger.text(IRecordType.TYPE_WARN, (Object)this, methodName, "Alerts process not supported for " + devTableName);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, (Object)devAutoId);
        }
    }

    private static String determineIdName(String deviceType) {
        String idName = null;
        if (deviceType.equals(Zone.getTablename())) {
            idName = "ZONE_ID";
        } else if (deviceType.equals(Zset.getTablename())) {
            idName = "ZSET_ID";
        } else if (deviceType.equals(Zset2zone.getTablename())) {
            idName = "ZSET2ZONE_ID";
        } else if (deviceType.equals(Zone2alias.getTablename())) {
            idName = "ZONE2ALIAS_ID";
        } else if (deviceType.equals(Zone2member.getTablename())) {
            idName = "ZONE2MEMBER_ID";
        } else if (deviceType.equals(Alias.getTablename())) {
            idName = "ALIAS_ID";
        } else if (deviceType.equals(ZoneMember.getTablename())) {
            idName = "ZONE_MEMBER_ID";
        } else if (deviceType.equals(DataPath.getTablename())) {
            idName = "DATA_PATH_ID";
        }
        return idName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndicationSource(CIMOM pCimom, Integer pSourceType) {
        Map map = this.indicationSources;
        synchronized (map) {
            this.indicationSources.put(pCimom.getServiceUrl(), pSourceType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getIndicationSourceType(CIMOM pCimom) {
        Map map = this.indicationSources;
        synchronized (map) {
            if (this.indicationSources.containsKey(pCimom.getServiceUrl())) {
                return (Integer)this.indicationSources.get(pCimom.getServiceUrl());
            }
        }
        try {
            Integer type = EventCorrelatordDBHelper.determineCimomType(pCimom);
            if (type != IS_NOTHING) {
                this.addIndicationSource(pCimom, type);
            }
            return type;
        }
        catch (SQLException sQLException) {
            return IS_NOTHING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIndicationSource(DataSource pDs) {
        if (pDs.getType() == 1) {
            RegisteredCimom regCimom = (RegisteredCimom)pDs.getIdentifier();
            Map map = this.indicationSources;
            synchronized (map) {
                this.indicationSources.remove(regCimom.getServiceUrl());
            }
        }
    }
}

