/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator;

import java.util.Vector;
import org.eclipse.aperi.monitor.eventcorrelator.DeviceSnapshotHandler;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class SnapshotProcessor
implements Runnable {
    ILogger msgLogger = LogConstants.msgLogger;
    ILogger traceLogger = LogConstants.traceLogger;
    static final String className = SnapshotProcessor.class.getName();
    private Vector deviceGroup = new Vector();
    private EventCorrelatorFactory eventMonitor = null;
    private Thread workerThread = null;
    private static SnapshotProcessor mySnapshot = null;
    private DeviceSnapshotHandler snapshotHndlr = null;

    private SnapshotProcessor() {
    }

    public static SnapshotProcessor shareInstance() {
        if (mySnapshot == null) {
            mySnapshot = new SnapshotProcessor();
        }
        return mySnapshot;
    }

    public void start(EventCorrelatorFactory publisher) {
        String methodName = "start";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)publisher);
        }
        if (this.snapshotHndlr == null) {
            this.snapshotHndlr = new DeviceSnapshotHandler(publisher);
        }
        if (this.workerThread == null) {
            this.workerThread = new Thread(this);
            this.workerThread.start();
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String methodName = "stop";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.workerThread = null;
        SnapshotProcessor snapshotProcessor = this;
        synchronized (snapshotProcessor) {
            this.notifyAll();
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String methodName;
        block15: {
            methodName = "run";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            try {
                Thread curThread = Thread.currentThread();
                while (this.workerThread == curThread) {
                    String messageInfo;
                    try {
                        while (this.deviceGroup.isEmpty()) {
                            SnapshotProcessor snapshotProcessor = this;
                            synchronized (snapshotProcessor) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                if (this.workerThread == null) {
                                    if (this.traceLogger.isLogging()) {
                                        messageInfo = "SnapshotService was shutdown";
                                        this.traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, messageInfo);
                                        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                                    }
                                    return;
                                }
                            }
                        }
                        Vector devices = (Vector)this.deviceGroup.firstElement();
                        this.process(devices);
                        this.deviceGroup.removeElement(devices);
                    }
                    catch (Exception ee) {
                        messageInfo = "Failed to do Snapshot.";
                        if (!this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, messageInfo);
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ee);
                    }
                }
            }
            catch (Exception pe) {
                String messageInfo = "Failed to start EventPublishThread";
                if (!this.traceLogger.isLogging()) break block15;
                this.traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, messageInfo);
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pe);
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void process(Vector devices) {
        String methodName = "process";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)devices);
        }
        try {
            this.snapshotHndlr.doSnapshot(devices);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDevicesToProcess(Vector devices) {
        String methodName = "addDeviceToProcess";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)devices);
        }
        this.deviceGroup.add(devices);
        SnapshotProcessor snapshotProcessor = this;
        synchronized (snapshotProcessor) {
            this.notifyAll();
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public static void main(String[] args) {
    }
}

