/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.AffectedHostAnalyzer;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.data.PopulatorHelper;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class BackendControllerAlertPopulator
implements IPopulator {
    public Alert populateNew(String pID) throws AlertCreationException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"populateNew", (Object[])new Object[]{pID});
        FabricAlert mResult = null;
        try {
            short bAlertCondition = 64;
            if (!EventDBAccessor.isAlertDefined(bAlertCondition)) {
                mLTH.traceInfo("No alert defined for deviceId=" + pID + " with condition=" + bAlertCondition);
                Alert alert = null;
                return alert;
            }
            int mComputerId = EventDBAccessor.getComputerId(1);
            int mResourceId = Integer.parseInt(EventDBAccessor.getOwningSubsystemIDForBackendControllerID(pID));
            short mResourceType = 78;
            AlertDefinition mAlertDef = new AlertDefinition();
            mAlertDef.aldCondition = bAlertCondition;
            mAlertDef.aldProductID = (short)3;
            mAlertDef.aldDbmsType = 1;
            mAlertDef.aldType = (short)20;
            mAlertDef.aldAlertID = EventDBAccessor.getAlertIDByConditionForSubsystems(bAlertCondition, String.valueOf(mResourceId));
            if (mAlertDef.aldAlertID <= 0) {
                mLTH.traceInfo("No alertId found for deviceId=" + pID + " with condition=" + bAlertCondition);
                Alert alert = null;
                return alert;
            }
            int[] mEnterprise = MIBConstants.BTAphysicalEntityEvent;
            int mTrapType = 104;
            Hashtable<int[], String> mSnmpTable = new Hashtable<int[], String>();
            String mTecClass = "PhysicalEntityEvent";
            Hashtable<String, String> mTecTable = new Hashtable<String, String>();
            Hashtable<String, String> bSnmpValues = new Hashtable<String, String>();
            Hashtable<String, String> bTecValues = new Hashtable<String, String>();
            if (!EventDBAccessor.getBackendControllerData(pID, bSnmpValues, bTecValues)) {
                throw new AlertCreationException("Failed to fill SNMP/TEC data for device: backendcontroller" + pID);
            }
            int[][] bVarBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
            for (int i = 0; i < bVarBindOIDs.length; ++i) {
                mSnmpTable.put(bVarBindOIDs[i], this.getPEValue(i, bSnmpValues));
            }
            String bEventType = "TPC_NEW_DEVICE_EVENT";
            bSnmpValues.put("eventType", bEventType);
            bTecValues.put("eventType", bEventType);
            for (int i = 0; i < peTecSlotNames.length; ++i) {
                String value = (String)bTecValues.get(peTecSlotNames[i]);
                if (value == null) {
                    value = "";
                }
                mTecTable.put(peTecSlotNames[i], value);
            }
            PopulatorHelper.addCommonTecAttributes(mTecTable, "HARMLESS");
            String mMsgId = "ALR1114W";
            Object[] mMsgParms = new Object[]{""};
            int[] mAffectedResIDs = PopulatorHelper.getIntArrayFromListOfInteger(AffectedHostAnalyzer.getAffectedHostsForBackendController(pID));
            mResult = new FabricAlert(mComputerId, mResourceId, mResourceType, mAlertDef, mEnterprise, mTrapType, mSnmpTable, mTecClass, mTecTable, mMsgId, mMsgParms, mAffectedResIDs);
            mLTH.exit((Object)mResult);
        }
        catch (AlertCreationException pE) {
            throw pE;
        }
        catch (Exception pE) {
            mLTH.traceError("Exception during alert population for device: " + pID, (Throwable)pE);
            throw new AlertCreationException("Could not populate alert for device: " + pID);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    public Alert populateStateChange(String pID, int pNewState, int pOldState) throws AlertCreationException {
        return this.populateStateChange(pID, pNewState, pOldState, null);
    }

    public Alert populatePropertyChange(String pID, Hashtable pOldValues, Hashtable pNewValues) throws AlertCreationException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"populatePropertyChange", (Object[])new Object[]{pID, pOldValues, pNewValues});
        FabricAlert mResult = null;
        try {
            if (!EventDBAccessor.isAnyAlertDefined(new short[]{201})) {
                mLTH.traceInfo("No alert defined for deviceId=" + pID + " with condition=" + 201);
                Alert alert = null;
                return alert;
            }
            int mComputerId = EventDBAccessor.getComputerId(1);
            int mResourceId = Integer.parseInt(EventDBAccessor.getOwningSubsystemIDForBackendControllerID(pID));
            short mResourceType = 78;
            AlertDefinition mAlertDef = new AlertDefinition();
            int[] mEnterprise = MIBConstants.BTAphysicalEntityEvent;
            int mTrapType = 102;
            Hashtable<int[], String> mSnmpTable = new Hashtable<int[], String>();
            String mTecClass = "PEAttributeModifiedEvent";
            Hashtable<String, String> mTecTable = new Hashtable<String, String>();
            Hashtable<String, String> bSnmpValues = new Hashtable<String, String>();
            Hashtable<String, String> bTecValues = new Hashtable<String, String>();
            if (!EventDBAccessor.getBackendControllerData(pID, bSnmpValues, bTecValues)) {
                throw new AlertCreationException("Failed to fill SNMP/TEC data for device: backendcontroller" + pID);
            }
            int[][] bVarBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
            for (int i = 0; i < bVarBindOIDs.length; ++i) {
                mSnmpTable.put(bVarBindOIDs[i], this.getPEValue(i, bSnmpValues));
            }
            String bEventType = "TPC_PROPERTY_CHANGE_EVENT";
            bSnmpValues.put("eventType", bEventType);
            bTecValues.put("eventType", bEventType);
            for (int i = 0; i < peTecSlotNames.length; ++i) {
                String value = (String)bTecValues.get(peTecSlotNames[i]);
                if (value == null) {
                    value = "";
                }
                mTecTable.put(peTecSlotNames[i], value);
            }
            PopulatorHelper.addCommonTecAttributes(mTecTable, "MINOR");
            String bParameterName = null;
            String bOldValue = null;
            String bNewValue = null;
            String bOwningDisplayName = EventDBAccessor.getDisplayNameForStorageSystemID(EventDBAccessor.getOwningSubsystemIDForBackendControllerID(pID));
            String bReferencedDisplayName = EventDBAccessor.getDisplayNameForStorageSystemID(EventDBAccessor.getReferencedSubsystemIDForBackendControllerID(pID));
            if (!pOldValues.containsKey("WWPN_PATH_COUNT") || !pNewValues.containsKey("WWPN_PATH_COUNT")) {
                throw new AlertCreationException("No alert population done for uncovered properties for device: " + pID);
            }
            short bAlertCondition = 201;
            String mMsgId = "ALR4305W";
            bParameterName = "WWPN_PATH_COUNT";
            bOldValue = pOldValues.get(bParameterName) == null ? "" : pOldValues.get(bParameterName).toString();
            bNewValue = pNewValues.get(bParameterName) == null ? "" : pNewValues.get(bParameterName).toString();
            Object[] mMsgParms = new Object[]{bReferencedDisplayName, bOwningDisplayName, bOldValue, bNewValue};
            PopulatorHelper.addAttributeData(mSnmpTable, mTecTable, bParameterName, bOldValue, bNewValue);
            mAlertDef.aldCondition = bAlertCondition;
            mAlertDef.aldProductID = (short)3;
            mAlertDef.aldDbmsType = 1;
            mAlertDef.aldType = (short)20;
            mAlertDef.aldAlertID = EventDBAccessor.getAlertIDByConditionForSubsystems(bAlertCondition, String.valueOf(mResourceId));
            if (mAlertDef.aldAlertID <= 0) {
                mLTH.traceInfo("No alertId found for deviceId=" + pID + " with condition=" + bAlertCondition);
                Alert alert = null;
                return alert;
            }
            int[] mAffectedResIDs = PopulatorHelper.getIntArrayFromListOfInteger(AffectedHostAnalyzer.getAffectedHostsForBackendController(pID));
            mResult = new FabricAlert(mComputerId, mResourceId, mResourceType, mAlertDef, mEnterprise, mTrapType, mSnmpTable, mTecClass, mTecTable, mMsgId, mMsgParms, mAffectedResIDs);
            mLTH.exit((Object)mResult);
        }
        catch (AlertCreationException pE) {
            throw pE;
        }
        catch (Exception pE) {
            mLTH.traceError("Exception during alert population for device: " + pID, (Throwable)pE);
            throw new AlertCreationException("Could not populate alert for device: " + pID);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    public Alert populateOperationalStatusChange(String pID, int pOldStatus, int pNewStatus) throws AlertCreationException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"populateOperationalStatusChange", (Object[])new Object[]{pID, new Integer(pOldStatus), new Integer(pNewStatus)});
        FabricAlert mResult = null;
        try {
            String mMsgId;
            short bAlertCondition;
            if (!EventDBAccessor.isAnyAlertDefined(new short[]{147, 146})) {
                mLTH.traceInfo("No alert defined for deviceId=" + pID + " with conditions=" + 147 + "," + 146);
                Alert alert = null;
                return alert;
            }
            int mComputerId = EventDBAccessor.getComputerId(1);
            int mResourceId = Integer.parseInt(EventDBAccessor.getOwningSubsystemIDForBackendControllerID(pID));
            short mResourceType = 78;
            AlertDefinition mAlertDef = new AlertDefinition();
            int[] mEnterprise = MIBConstants.BTAphysicalEntityEvent;
            int mTrapType = 116;
            Hashtable<int[], String> mSnmpTable = new Hashtable<int[], String>();
            String mTecClass = "PEOperationalStatusChangeEvent";
            Hashtable<String, String> mTecTable = new Hashtable<String, String>();
            Hashtable<String, String> bSnmpValues = new Hashtable<String, String>();
            Hashtable<String, String> bTecValues = new Hashtable<String, String>();
            if (!EventDBAccessor.getBackendControllerData(pID, bSnmpValues, bTecValues)) {
                throw new AlertCreationException("Failed to fill SNMP/TEC data for device: backendcontroller" + pID);
            }
            int[][] bVarBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
            for (int i = 0; i < bVarBindOIDs.length; ++i) {
                mSnmpTable.put(bVarBindOIDs[i], this.getPEValue(i, bSnmpValues));
            }
            String bEventType = "TPC_DEVICE_OPERATIONAL_CHANGE_EVENT";
            bSnmpValues.put("eventType", bEventType);
            bTecValues.put("eventType", bEventType);
            for (int i = 0; i < peTecSlotNames.length; ++i) {
                String value = (String)bTecValues.get(peTecSlotNames[i]);
                if (value == null) {
                    value = "";
                }
                mTecTable.put(peTecSlotNames[i], value);
            }
            PopulatorHelper.addCommonTecAttributes(mTecTable, "MINOR");
            if (pNewStatus == 0) {
                bAlertCondition = 147;
                mMsgId = "ALR4248I";
            } else {
                bAlertCondition = 146;
                mMsgId = "ALR4249W";
            }
            String bOwningDisplayName = EventDBAccessor.getDisplayNameForStorageSystemID(EventDBAccessor.getOwningSubsystemIDForBackendControllerID(pID));
            String bReferencedDisplayName = EventDBAccessor.getDisplayNameForStorageSystemID(EventDBAccessor.getReferencedSubsystemIDForBackendControllerID(pID));
            Object[] mMsgParms = new Object[]{bReferencedDisplayName, bOwningDisplayName};
            PopulatorHelper.addOperationalStatusData(mSnmpTable, mTecTable, pOldStatus, pNewStatus);
            mAlertDef.aldCondition = bAlertCondition;
            mAlertDef.aldProductID = (short)3;
            mAlertDef.aldDbmsType = 1;
            mAlertDef.aldType = (short)20;
            mAlertDef.aldAlertID = EventDBAccessor.getAlertIDByConditionForSubsystems(bAlertCondition, String.valueOf(mResourceId));
            if (mAlertDef.aldAlertID <= 0) {
                mLTH.traceInfo("No alertId found for deviceId=" + pID + " with condition=" + bAlertCondition);
                Alert alert = null;
                return alert;
            }
            int[] mAffectedResIDs = PopulatorHelper.getIntArrayFromListOfInteger(AffectedHostAnalyzer.getAffectedHostsForBackendController(pID));
            mResult = new FabricAlert(mComputerId, mResourceId, mResourceType, mAlertDef, mEnterprise, mTrapType, mSnmpTable, mTecClass, mTecTable, mMsgId, mMsgParms, mAffectedResIDs);
            mLTH.exit((Object)mResult);
        }
        catch (AlertCreationException pE) {
            throw pE;
        }
        catch (Exception pE) {
            mLTH.traceError("Exception during alert population for device: " + pID, (Throwable)pE);
            throw new AlertCreationException("Could not populate alert for device: " + pID);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    public Alert populateStateChange(String pID, int pNewState, int pOldState, HashMap pAttributeMap) throws AlertCreationException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"populateStateChange", (Object[])new Object[]{pID, new Integer(pNewState), new Integer(pOldState), pAttributeMap});
        FabricAlert mResult = null;
        try {
            String mMsgId;
            short bAlertCondition;
            int mTrapType;
            if (!EventDBAccessor.isAnyAlertDefined(new short[]{147, 146})) {
                mLTH.traceInfo("No alert defined for deviceId=" + pID + " with conditions=" + 147 + "," + 146);
                Alert alert = null;
                return alert;
            }
            int mComputerId = EventDBAccessor.getComputerId(1);
            int mResourceId = Integer.parseInt(EventDBAccessor.getOwningSubsystemIDForBackendControllerID(pID));
            short mResourceType = 78;
            AlertDefinition mAlertDef = new AlertDefinition();
            int[] mEnterprise = MIBConstants.BTAphysicalEntityEvent;
            Hashtable<int[], String> mSnmpTable = new Hashtable<int[], String>();
            String mTecClass = "PhysicalEntityEvent";
            Hashtable<String, String> mTecTable = new Hashtable<String, String>();
            Hashtable<String, String> bSnmpValues = new Hashtable<String, String>();
            Hashtable<String, String> bTecValues = new Hashtable<String, String>();
            if (!EventDBAccessor.getBackendControllerData(pID, bSnmpValues, bTecValues)) {
                throw new AlertCreationException("Failed to fill SNMP/TEC data for device: backendcontroller" + pID);
            }
            int[][] bVarBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
            for (int i = 0; i < bVarBindOIDs.length; ++i) {
                mSnmpTable.put(bVarBindOIDs[i], this.getPEValue(i, bSnmpValues));
            }
            boolean isOnlineOrDetected = pNewState == 1;
            String bEventType = isOnlineOrDetected ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
            bSnmpValues.put("eventType", bEventType);
            bTecValues.put("eventType", bEventType);
            for (int i = 0; i < peTecSlotNames.length; ++i) {
                String value = (String)bTecValues.get(peTecSlotNames[i]);
                if (value == null) {
                    value = "";
                }
                mTecTable.put(peTecSlotNames[i], value);
            }
            String bSeverity = isOnlineOrDetected ? "HARMLESS" : "CRITICAL";
            PopulatorHelper.addCommonTecAttributes(mTecTable, bSeverity);
            String bOwningDisplayName = EventDBAccessor.getDisplayNameForStorageSystemID(EventDBAccessor.getOwningSubsystemIDForBackendControllerID(pID));
            String bReferencedDisplayName = EventDBAccessor.getDisplayNameForStorageSystemID(EventDBAccessor.getReferencedSubsystemIDForBackendControllerID(pID));
            if (isOnlineOrDetected) {
                mTrapType = 112;
                bAlertCondition = 147;
                mMsgId = "ALR4248I";
            } else {
                mTrapType = 101;
                bAlertCondition = 146;
                mMsgId = "ALR4247W";
            }
            Object[] mMsgParms = new Object[]{bReferencedDisplayName, bOwningDisplayName};
            mAlertDef.aldCondition = bAlertCondition;
            mAlertDef.aldProductID = (short)3;
            mAlertDef.aldDbmsType = 1;
            mAlertDef.aldType = (short)20;
            mAlertDef.aldAlertID = EventDBAccessor.getAlertIDByConditionForSubsystems(bAlertCondition, String.valueOf(mResourceId));
            if (mAlertDef.aldAlertID <= 0) {
                mLTH.traceInfo("No alertId found for deviceId=" + pID + " with condition=" + bAlertCondition);
                Alert alert = null;
                return alert;
            }
            int[] mAffectedResIDs = PopulatorHelper.getIntArrayFromListOfInteger(AffectedHostAnalyzer.getAffectedHostsForBackendController(pID));
            mResult = new FabricAlert(mComputerId, mResourceId, mResourceType, mAlertDef, mEnterprise, mTrapType, mSnmpTable, mTecClass, mTecTable, mMsgId, mMsgParms, mAffectedResIDs);
            mLTH.exit((Object)mResult);
        }
        catch (AlertCreationException pE) {
            throw pE;
        }
        catch (Exception pE) {
            mLTH.traceError("Exception during alert population for device: " + pID, (Throwable)pE);
            throw new AlertCreationException("Could not populate alert for device: " + pID);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    private String getPEValue(int pIndex, Hashtable pValues) {
        String peVarName = peVarNames[pIndex];
        if (peVarName.equals("description") || peVarName.equals("messageId")) {
            return peVarName;
        }
        String mValue = (String)pValues.get(peVarName);
        if (mValue != null) {
            return mValue;
        }
        return "";
    }
}

