/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class FabricPortAlertPopulator
implements IPopulator {
    public static final String deviceType = "port";
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    static final String className = FabricPortAlertPopulator.class.getName();

    public FabricPortAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String ID) throws AlertCreationException {
        String methodName = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getPortData(deviceId, snmpValues, tecValues)) {
            String hldType = ((String)snmpValues.get("HLDType")).trim();
            String hldId = ((String)snmpValues.get("HLDUniqueId")).trim();
            String eventType = "TPC_NEW_DEVICE_EVENT";
            int resourceId = this.determineResourceId(deviceId, hldId);
            short resourceType = this.determineResourceType(hldType);
            short alertCondition = this.determineAlertCondition(hldType, eventType);
            int alertId = -1;
            alertId = alertCondition == 106 ? EventDBAccessor.getAlertIDByCondition(alertCondition) : this.getAlertId(resourceType, resourceId, alertCondition, deviceId);
            if (alertId > 0) {
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                alertDef.aldCondition = alertCondition;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 104;
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalEntityEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "msgId";
                Object[] msgValues = null;
                if (hldType.equals(deviceType) || hldType.equals("")) {
                    msgId = "ALR4010I";
                    String value0 = this.getValue(snmpValues, "label");
                    if (value0 == null || value0.equals("")) {
                        value0 = this.getValue(snmpValues, "entityName");
                    }
                    msgValues = new Object[]{value0};
                } else {
                    msgId = "ALR4015I";
                    String value0 = this.getValue(snmpValues, "HLDType");
                    String value1 = this.getValue(snmpValues, "HLDLabel");
                    String value2 = this.getValue(snmpValues, "label");
                    msgValues = new Object[]{value0, value1, value2};
                }
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpValues, tecClass, tecValues, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: port" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: port" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populateStateChange(String ID, int newState, int oldState) throws AlertCreationException {
        String methodName = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getPortData(deviceId, snmpValues, tecValues)) {
            String hldType = ((String)snmpValues.get("HLDType")).trim();
            String hldId = ((String)snmpValues.get("HLDUniqueId")).trim();
            String eventType = "TPC_DEVICE_STATE_CHANGE_EVENT";
            short alertCondition = this.determineAlertCondition(hldType, eventType);
            int resourceId = this.determineResourceId(deviceId, hldId);
            short resourceType = this.determineResourceType(hldType);
            int alertId = this.getAlertId(resourceType, resourceId, alertCondition, deviceId);
            if (alertId > 0) {
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                alertDef.aldCondition = alertCondition;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 101;
                if (newState == 1) {
                    trapType = 112;
                }
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType1 = newState == 1 ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
                snmpValues.put("eventType", eventType1);
                tecValues.put("eventType", eventType1);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalEntityEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = newState == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = null;
                Object[] msgValues = null;
                if (hldType.equals(deviceType) || hldType.equals("")) {
                    String value0;
                    msgId = "ALR4011W";
                    if (newState == 1) {
                        msgId = "ALR4012I";
                    }
                    if ((value0 = this.getValue(snmpValues, "label")) == null || value0.equals("")) {
                        value0 = this.getValue(snmpValues, "entityName");
                    }
                    msgValues = new Object[]{value0};
                } else {
                    msgId = "ALR4016W";
                    if (newState == 1) {
                        msgId = "ALR4017I";
                    }
                    String value0 = this.getValue(snmpValues, "HLDType");
                    String value1 = this.getValue(snmpValues, "HLDLabel");
                    String value2 = this.getValue(snmpValues, "label");
                    msgValues = new Object[]{value0, value1, value2};
                }
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpValues, tecClass, tecValues, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: port" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: port" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populatePropertyChange(String ID, Hashtable oldValues, Hashtable newValues) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String ID, int oldStatus, int newStatus) throws AlertCreationException {
        String methodName = "populateOperationalStatusChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getPortData(deviceId, snmpValues, tecValues)) {
            short alertCondition;
            String hldType = ((String)snmpValues.get("HLDType")).trim();
            String hldId = ((String)snmpValues.get("HLDUniqueId")).trim();
            String eventType = "TPC_DEVICE_OPERATIONAL_CHANGE_EVENT";
            int resourceId = this.determineResourceId(deviceId, hldId);
            short resourceType = this.determineResourceType(hldType);
            int alertId = this.getAlertId(resourceType, resourceId, alertCondition = this.determineAlertCondition(hldType, eventType), deviceId);
            if (alertId > 0) {
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                alertDef.aldCondition = alertCondition;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 116;
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PEOperationalStatusChangeEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = "MINOR";
                this.addCommonTecAttributes(tecTable, severity);
                this.addOperationalStatusData(snmpTable, tecTable, oldStatus, newStatus);
                String msgId = null;
                Object[] msgValues = null;
                if (hldType.equals(deviceType) || hldType.equals("")) {
                    msgId = "ALR4013W";
                    if (newStatus == 0) {
                        msgId = "ALR4014I";
                    }
                    String value0 = this.getValue(snmpValues, "entityName");
                    msgValues = new Object[]{value0};
                } else {
                    msgId = "ALR4018W";
                    if (newStatus == 0) {
                        msgId = "ALR4019I";
                    }
                    String value0 = this.getValue(snmpValues, "HLDType");
                    String value1 = this.getValue(snmpValues, "HLDLabel");
                    String value2 = this.getValue(snmpValues, "label");
                    msgValues = new Object[]{value0, value1, value2};
                }
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: port" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: port" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    private void addOperationalStatusData(Hashtable snmpTable, Hashtable tecTable, int oldStatus, int newStatus) {
        snmpTable.put(MIBConstants.BTAOldStatus, "" + oldStatus);
        snmpTable.put(MIBConstants.BTANewStatus, "" + newStatus);
        tecTable.put("oldStatus", "" + oldStatus);
        tecTable.put("oldStatus", "" + newStatus);
    }

    private short determineAlertCondition(String hldType, String eventType) {
        int condition = 106;
        if (hldType.equals(deviceType)) {
            if (eventType.equals("TPC_NEW_DEVICE_EVENT")) {
                condition = 106;
            } else if (eventType.equals("TPC_DEVICE_STATE_CHANGE_EVENT")) {
                condition = 101;
            } else if (eventType.equals("TPC_DEVICE_OPERATIONAL_CHANGE_EVENT")) {
                condition = 102;
            }
        } else {
            condition = hldType.equals("switch") ? 96 : (hldType.equals("subsystem") ? 123 : (hldType.equals("host") ? 174 : 102));
        }
        return (short)condition;
    }

    private int determineResourceId(String deviceId, String hldId) {
        int resourceId = -1;
        resourceId = hldId == null || hldId.equals("") ? Integer.parseInt(deviceId) : Integer.parseInt(hldId);
        return resourceId;
    }

    private short determineResourceType(String hldType) {
        int type = 137;
        if (hldType.equals("subsystem")) {
            type = 78;
        } else if (hldType.equals("host")) {
            type = 1;
        } else if (hldType.equals("switch")) {
            type = 121;
        } else if (hldType.equals("pe")) {
            type = 139;
        } else if (hldType.equals("node")) {
            type = 138;
        }
        return (short)type;
    }

    private void addCommonTecAttributes(Hashtable tecTable, String severty) {
        String ipAddress = "";
        String hostName = "";
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
            hostName = InetAddress.getByName(ipAddress).getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        tecTable.put("hostname", hostName);
        tecTable.put("origin", ipAddress);
        tecTable.put("severity", severty);
    }

    private String getPEValue(int index, Hashtable values) {
        if (peVarNames[index].equals("description")) {
            return peVarNames[index];
        }
        if (peVarNames[index].equals("messageId")) {
            return peVarNames[index];
        }
        return (String)values.get(peVarNames[index]);
    }

    private int getAlertId(short resourceType, int resourceId, short alertCondition, String deviceId) {
        int alertId = -1;
        alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition);
        if (alertId <= 0) {
            String fabricId = EventDBAccessor.getFabricIdForPort(deviceId);
            if (fabricId != null && !fabricId.equals("")) {
                alertId = EventDBAccessor.getAlertIDByResource((short)114, Integer.parseInt(fabricId), alertCondition);
            }
            if (alertId <= 0) {
                alertId = resourceType == 137 ? EventDBAccessor.getAlertIDByResource((short)129, -1, alertCondition) : EventDBAccessor.getAlertIDByResource(resourceType, -1, alertCondition);
            }
        }
        return alertId;
    }

    private String getValue(Hashtable values, String key) {
        String tmpValue = (String)values.get(key);
        if (tmpValue == null || tmpValue.equals("")) {
            tmpValue = "UNKNOWN";
        }
        return tmpValue;
    }

    public Alert populateStateChange(String ID, int newState, int oldState, HashMap attributeMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

