/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class Hba2NodeAlertPopulator
implements IPopulator {
    public static final String deviceType = "node2hba";
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    static final String className = Hba2NodeAlertPopulator.class.getName();

    public Hba2NodeAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String ID) throws AlertCreationException {
        String methodName = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getNode2HBAData(deviceId, snmpValues, tecValues)) {
            String nodeId;
            short alertCondition;
            short resourceType = 1;
            int resourceId = this.determineResourceId(deviceId, snmpValues);
            int alertId = this.getAlertId(resourceType, resourceId, alertCondition = 174, nodeId = (String)snmpValues.get("fromObjectUniqueId"));
            if (alertId > 0) {
                String value2;
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 106;
                int[] enterprise = MIBConstants.BTAphysicalRelationshipEvent;
                int[][] varBindOIDs = MIBConstants.physicalRelationshipVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = "TPC_NEW_RELATIONSHIP_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalRelationshipEvent";
                for (int i = 0; i < prTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(prTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(prTecSlotNames[i], value);
                }
                String severity = "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4072I";
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("toObjectLabel");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("fromObjectLabel")) == null) {
                    value1 = "";
                }
                if ((value2 = (String)snmpValues.get("toObjectHLDLabel")) == null) {
                    value2 = "";
                }
                msgValues = new Object[]{value1, value0, value2};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: node2hba" + deviceId);
            }
        } else {
            throw new AlertCreationException("No object found for device: node2hba" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populateStateChange(String ID, int newState, int oldState) throws AlertCreationException {
        String methodName = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getNode2HBAData(deviceId, snmpValues, tecValues)) {
            String nodeId;
            short alertCondition;
            short resourceType = 1;
            int resourceId = this.determineResourceId(deviceId, snmpValues);
            int alertId = this.getAlertId(resourceType, resourceId, alertCondition = 174, nodeId = (String)snmpValues.get("fromObjectUniqueId"));
            if (alertId > 0) {
                String value2;
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 103;
                if (newState == 1) {
                    trapType = 114;
                }
                int[] enterprise = MIBConstants.BTAphysicalRelationshipEvent;
                int[][] varBindOIDs = MIBConstants.physicalRelationshipVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = newState == 1 ? "TPC_NORMAL_RELATIONSHIP_EVENT" : "TPC_MISSING_RELATIONSHIP_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalRelationshipEvent";
                for (int i = 0; i < prTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(prTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(prTecSlotNames[i], value);
                }
                String severity = newState == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4073W";
                if (newState == 1) {
                    msgId = "ALR4074I";
                }
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("toObjectLabel");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("fromObjectLabel")) == null) {
                    value1 = "";
                }
                if ((value2 = (String)snmpValues.get("toObjectHLDLabel")) == null) {
                    value2 = "";
                }
                msgValues = new Object[]{value1, value0, value2};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: node2hba" + deviceId);
            }
        } else {
            throw new AlertCreationException("No object found in db for device: node2hba" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populatePropertyChange(String ID, Hashtable oldValues, Hashtable newValues) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String ID, int oldStatus, int newStatus) {
        Alert tmpAlert = null;
        return tmpAlert;
    }

    private void addCommonTecAttributes(Hashtable tecTable, String severty) {
        String ipAddress = "";
        String hostName = "";
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
            hostName = InetAddress.getByName(ipAddress).getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        tecTable.put("hostname", hostName);
        tecTable.put("origin", ipAddress);
        tecTable.put("severity", severty);
    }

    private int determineResourceId(String deviceId, Hashtable snmpValues) {
        int resourceId = -1;
        String hostId = (String)snmpValues.get("toObjectHLDUniqueId");
        resourceId = hostId != null && !hostId.equals("") ? Integer.parseInt(hostId) : Integer.parseInt(deviceId);
        return resourceId;
    }

    private String getPRValue(int index, Hashtable values) {
        if (prVarNames[index].equals("description")) {
            return prVarNames[index];
        }
        if (prVarNames[index].equals("messageId")) {
            return prVarNames[index];
        }
        return (String)values.get(prVarNames[index]);
    }

    private int getAlertId(short resourceType, int resourceId, short alertCondition, String deviceId) {
        int alertId = -1;
        alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition);
        if (alertId <= 0) {
            String fabricId = EventDBAccessor.getFabricIdForNode(deviceId);
            if (fabricId != null && !fabricId.equals("")) {
                alertId = EventDBAccessor.getAlertIDByResource((short)114, Integer.parseInt(fabricId), alertCondition);
            }
            if (alertId <= 0) {
                alertId = EventDBAccessor.getAlertIDByResource(resourceType, -1, alertCondition);
            }
        }
        return alertId;
    }

    public Alert populateStateChange(String ID, int newState, int oldState, HashMap attributeMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

