/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class Pe2NodeAlertPopulator
implements IPopulator {
    public static final String deviceType = "pe2node";
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    static final String className = Pe2NodeAlertPopulator.class.getName();

    public Pe2NodeAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String ID) throws AlertCreationException {
        String methodName = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getPE2NodeData(deviceId, snmpValues, tecValues)) {
            String nodeId;
            short alertCondition;
            int resourceId;
            String hldType = (String)snmpValues.get("fromObjectHLDType");
            short resourceType = this.determineResourceType(hldType);
            int alertId = this.getAlertId(resourceType, resourceId = this.determineResourceId(deviceId, snmpValues), alertCondition = 139, nodeId = (String)snmpValues.get("toObjectUniqueId"));
            if (alertId > 0) {
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 106;
                int[] enterprise = MIBConstants.BTAphysicalRelationshipEvent;
                int[][] varBindOIDs = MIBConstants.physicalRelationshipVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = "TPC_NEW_RELATIONSHIP_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    System.out.println("value" + i + "=" + value);
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalRelationshipEvent";
                for (int i = 0; i < prTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(prTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    System.out.println("value" + i + "=" + value);
                    tecTable.put(prTecSlotNames[i], value);
                }
                String severity = "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4075I";
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("fromObjectLabel");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("toObjectLabel")) == null) {
                    value1 = "";
                }
                msgValues = new Object[]{value1, value0};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: pe2node" + deviceId);
            }
        } else {
            throw new AlertCreationException("No object found in db for device: pe2node" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populateStateChange(String ID, int newState, int oldState) throws AlertCreationException {
        String methodName = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getPE2NodeData(deviceId, snmpValues, tecValues)) {
            String nodeId;
            short alertCondition;
            int resourceId;
            String hldType = (String)snmpValues.get("fromObjectHLDType");
            short resourceType = this.determineResourceType(hldType);
            int alertId = this.getAlertId(resourceType, resourceId = this.determineResourceId(deviceId, snmpValues), alertCondition = 139, nodeId = (String)snmpValues.get("toObjectUniqueId"));
            if (alertId > 0) {
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 103;
                if (newState == 1) {
                    trapType = 114;
                }
                int[] enterprise = MIBConstants.BTAphysicalRelationshipEvent;
                int[][] varBindOIDs = MIBConstants.physicalRelationshipVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = newState == 1 ? "TPC_NORMAL_RELATIONSHIP_EVENT" : "TPC_MISSING_RELATIONSHIP_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    System.out.println("value" + i + "=" + value);
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalRelationshipEvent";
                for (int i = 0; i < prTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(prTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    System.out.println("value" + i + "=" + value);
                    tecTable.put(prTecSlotNames[i], value);
                }
                String severity = newState == 0 ? "CRITICAL" : "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4076W";
                if (newState == 1) {
                    msgId = "ALR4077I";
                }
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("fromObjectLabel");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("toObjectLabel")) == null) {
                    value1 = "";
                }
                msgValues = new Object[]{value1, value0};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db  for device: pe2node" + deviceId);
            }
        } else {
            throw new AlertCreationException("No object found in db for device: pe2node" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populatePropertyChange(String ID, Hashtable oldValues, Hashtable newValues) {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String ID, int oldStatus, int newStatus) {
        Alert tmpAlert = null;
        return tmpAlert;
    }

    private void addCommonTecAttributes(Hashtable tecTable, String severty) {
        String ipAddress = "";
        String hostName = "";
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
            hostName = InetAddress.getByName(ipAddress).getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        tecTable.put("hostname", hostName);
        tecTable.put("origin", ipAddress);
        tecTable.put("severity", severty);
    }

    private short determineResourceType(String hldType) {
        short type = -1;
        type = hldType.equals("subsystem") ? (short)78 : 139;
        return type;
    }

    private int determineResourceId(String deviceId, Hashtable snmpValues) {
        int resourceId = -1;
        String hldId = (String)snmpValues.get("fromObjectHLDUniqueId");
        resourceId = hldId != null && !hldId.equals("") ? Integer.parseInt(hldId) : Integer.parseInt(deviceId);
        return resourceId;
    }

    private String getPRValue(int index, Hashtable values) {
        if (prVarNames[index].equals("description")) {
            return prVarNames[index];
        }
        if (prVarNames[index].equals("messageId")) {
            return prVarNames[index];
        }
        return (String)values.get(prVarNames[index]);
    }

    private int getAlertId(short resourceType, int resourceId, short alertCondition, String deviceId) {
        int alertId = -1;
        alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition);
        if (alertId <= 0) {
            String fabricId = EventDBAccessor.getFabricIdForNode(deviceId);
            if (fabricId != null && !fabricId.equals("")) {
                alertId = EventDBAccessor.getAlertIDByResource((short)114, Integer.parseInt(fabricId), alertCondition);
            }
            if (alertId <= 0) {
                alertId = resourceType == 139 ? EventDBAccessor.getAlertIDByResource((short)129, -1, alertCondition) : EventDBAccessor.getAlertIDByResource(resourceType, -1, alertCondition);
            }
        }
        return alertId;
    }

    public Alert populateStateChange(String ID, int newState, int oldState, HashMap attributeMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

