/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class SwitchBladeAlertPopulator
implements IPopulator {
    public static final String deviceType = "blade";
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    static final String className = SwitchBladeAlertPopulator.class.getName();

    public SwitchBladeAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String ID) throws AlertCreationException {
        String methodName = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getBladeData(deviceId, snmpValues, tecValues)) {
            int alertCondition;
            short resourceType = 121;
            int resourceId = this.getResourceId(deviceId, snmpValues);
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition = 128);
            if (alertId <= 0) {
                String switchId = "" + resourceId;
                String fabricID = EventDBAccessor.getFabricIDFromSwitch(switchId);
                int tmpResourceId = -1;
                short tmpResourceType = 114;
                tmpResourceId = fabricID == null || fabricID.equals("") ? -1 : Integer.parseInt(fabricID);
                alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                if (alertId <= 0) {
                    tmpResourceId = -1;
                    tmpResourceType = 121;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                }
            }
            if (alertId > 0) {
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 104;
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = "TPC_NEW_DEVICE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalEntityEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4026I";
                Object[] msgValues = null;
                msgValues = new Object[]{snmpValues.get("label"), snmpValues.get("HLDLabel")};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: blade" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: blade" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populateStateChange(String ID, int newState, int oldState) throws AlertCreationException {
        String methodName = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getBladeData(deviceId, snmpValues, tecValues)) {
            int alertCondition;
            short resourceType = 121;
            int resourceId = this.getResourceId(deviceId, snmpValues);
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition = 128);
            if (alertId <= 0) {
                String switchId = "" + resourceId;
                String fabricID = EventDBAccessor.getFabricIDFromSwitch(switchId);
                int tmpResourceId = -1;
                short tmpResourceType = 114;
                tmpResourceId = fabricID == null || fabricID.equals("") ? -1 : Integer.parseInt(fabricID);
                alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                if (alertId <= 0) {
                    tmpResourceId = -1;
                    tmpResourceType = 121;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                }
            }
            if (alertId > 0) {
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 101;
                if (newState == 1) {
                    trapType = 112;
                }
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = newState == 1 ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalEntityEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = newState == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4027W";
                if (newState == 1) {
                    msgId = "ALR4028I";
                }
                Object[] msgValues = null;
                msgValues = new Object[]{snmpValues.get("label"), snmpValues.get("HLDLabel")};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: blade" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: blade" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populatePropertyChange(String ID, Hashtable oldValues, Hashtable newValues) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String ID, int oldStatus, int newStatus) throws AlertCreationException {
        String methodName = "populateOperationalStatusChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getBladeData(deviceId, snmpValues, tecValues)) {
            int alertCondition;
            short resourceType = 121;
            int resourceId = this.getResourceId(deviceId, snmpValues);
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition = newStatus == 0 ? 130 : 129);
            if (alertId <= 0) {
                String switchId = "" + resourceId;
                String fabricID = EventDBAccessor.getFabricIDFromSwitch(switchId);
                int tmpResourceId = -1;
                short tmpResourceType = 114;
                tmpResourceId = fabricID == null || fabricID.equals("") ? -1 : Integer.parseInt(fabricID);
                alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                if (alertId <= 0) {
                    tmpResourceId = -1;
                    tmpResourceType = 121;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                }
            }
            if (alertId > 0) {
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 116;
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = "TPC_DEVICE_OPERATIONAL_CHANGE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PEOperationalStatusChangeEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = "MINOR";
                this.addCommonTecAttributes(tecTable, severity);
                this.addOperationalStatusData(snmpTable, tecTable, oldStatus, newStatus);
                String msgId = "ALR4029W";
                if (newStatus == 0) {
                    msgId = "ALR4030I";
                }
                Object[] msgValues = null;
                msgValues = new Object[]{snmpValues.get("label"), snmpValues.get("HLDLabel")};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: blade" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: blade" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    private void addOperationalStatusData(Hashtable snmpTable, Hashtable tecTable, int oldStatus, int newStatus) {
        snmpTable.put(MIBConstants.BTAOldStatus, "" + oldStatus);
        snmpTable.put(MIBConstants.BTANewStatus, "" + newStatus);
        tecTable.put("oldStatus", "" + oldStatus);
        tecTable.put("oldStatus", "" + newStatus);
    }

    private int getResourceId(String deviceId, Hashtable values) {
        int resourceId = -1;
        String tmpId = "" + (String)values.get("switchId");
        resourceId = tmpId.equals("") ? Integer.parseInt(deviceId) : Integer.parseInt(tmpId);
        return resourceId;
    }

    private void addCommonTecAttributes(Hashtable tecTable, String severty) {
        String ipAddress = "";
        String hostName = "";
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
            hostName = InetAddress.getByName(ipAddress).getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        tecTable.put("hostname", hostName);
        tecTable.put("origin", ipAddress);
        tecTable.put("severity", severty);
    }

    private String getPEValue(int index, Hashtable values) {
        if (peVarNames[index].equals("description")) {
            return peVarNames[index];
        }
        if (peVarNames[index].equals("messageId")) {
            return peVarNames[index];
        }
        return (String)values.get(peVarNames[index]);
    }

    public Alert populateStateChange(String ID, int newState, int oldState, HashMap attributeMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

