/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.interfaces;

import java.util.Calendar;
import org.eclipse.aperi.monitor.eventcorrelator.data.EventConstants;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.InvalidParameterException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.NotSupportedException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.SmartAction;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.Source;
import org.eclipse.aperi.sanmgmt.event.data.SANEvent;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class SmartEvent
extends SANEvent
implements EventConstants {
    static ILogger msgLogger = LogConstants.msgLogger;
    static ILogger traceLogger = LogConstants.traceLogger;
    static final String className = SmartEvent.class.getName();
    private static String MSG_FILE = "org.eclipse.aperi.sanmgmt.sanmgr.resources.EventCorrelatorFactory";
    protected SmartAction smartAction;
    private Source source;
    private int eventType;
    private int priority = 0;
    private String description = "";
    private Calendar timeStamp;

    public int getPriority() {
        return 0;
    }

    public SmartEvent() {
    }

    public SmartEvent(Source eventSource, SmartAction action, int eventType, int priority, String description, Calendar timestamp) throws InvalidParameterException {
        String methodName = "SmartEvent";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName, new Object[]{eventSource, action, new Integer(priority), description, timestamp});
        }
        if (eventSource == null || action == null || timestamp == null || eventType < 0 || priority < 0) {
            throw new InvalidParameterException();
        }
        this.source = eventSource;
        this.smartAction = action;
        this.eventType = eventType;
        this.priority = priority;
        this.description = description;
        this.timeStamp = timestamp;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public SmartEvent(String sourceName, String sourceAddress, String specificInfo, String actionTarget, int actionType, String actionDescription, int eventType, int priority, String description, Calendar timestamp) throws InvalidParameterException {
        String methodName = "SmartEvent";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName, new Object[]{sourceName, sourceAddress, specificInfo, actionTarget, new Integer(actionType), actionDescription, new Integer(priority), description, timestamp});
        }
        if (timestamp == null || eventType < 0 || priority < 0) {
            throw new InvalidParameterException();
        }
        this.source = new Source(sourceName, sourceAddress, specificInfo);
        this.smartAction = new SmartAction(actionTarget, actionType, actionDescription);
        this.eventType = eventType;
        this.priority = priority;
        this.description = description;
        this.timeStamp = timestamp;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getDescription() throws NotSupportedException {
        return this.description;
    }

    public Calendar getTimeStamp() {
        return this.timeStamp;
    }

    public String getSourceName() {
        return this.source.getName();
    }

    public String getSourceAddress() {
        return this.source.getAddress();
    }

    public String getSourceSpecificInfo() throws NotSupportedException {
        return this.source.getSpecificInfo();
    }

    public String getActionTarget() throws NotSupportedException {
        return this.smartAction.getTarget();
    }

    public int getActionType() throws NotSupportedException {
        return this.smartAction.getType();
    }

    public String getActionDescription() throws NotSupportedException {
        return this.smartAction.getDescription();
    }

    public String toString() {
        String sName = " ";
        String sAddress = " ";
        String sSpecificInfo = " ";
        String aTarget = " ";
        String aDescription = " ";
        String sTime = " ";
        int aType = 0;
        if (this.source != null) {
            sName = this.source.getName();
            sAddress = this.source.getAddress();
        }
        if (this.source != null && this.smartAction != null) {
            try {
                sSpecificInfo = this.getSourceSpecificInfo();
                aType = this.getActionType();
                aTarget = this.getActionTarget();
                aDescription = this.getActionDescription();
            }
            catch (NotSupportedException nse) {
                // empty catch block
            }
        }
        if (this.timeStamp != null) {
            sTime = this.timeStamp.getTime().toString();
        }
        String out = "Event Type:" + this.eventType + "\t" + "Event Priority:" + this.priority + "\t" + "Event Description:" + this.description + "\t" + "TimeStamp:" + sTime + "\t" + "Source Name:" + sName + "\t" + "Source Address:" + sAddress + "\t" + "Source Specific Information:" + sSpecificInfo + "\t" + "Action Type:" + aType + "\t" + "Action Target:" + aTarget + "\t" + "Action Description:" + aDescription;
        return out;
    }

    public boolean equals(Object obj) {
        boolean out;
        String methodName;
        block5: {
            methodName = "equals";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter= " + obj));
            }
            if (!(obj instanceof SmartEvent)) {
                return false;
            }
            SmartEvent tempEvent = (SmartEvent)obj;
            out = false;
            try {
                out = this.getSourceName().equals(tempEvent.getSourceName()) && this.getSourceAddress().equals(tempEvent.getSourceAddress()) && this.getActionTarget().equals(tempEvent.getActionTarget()) && this.getActionDescription().equals(tempEvent.getActionDescription()) && this.getDescription().equals(tempEvent.getDescription()) && this.getEventType() == tempEvent.getEventType() && this.getPriority() == tempEvent.getPriority() && this.getActionType() == tempEvent.getActionType();
                long tempCurrent = tempEvent.getTimeStamp().getTime().getTime();
                long thisCurrent = this.getTimeStamp().getTime().getTime();
                long tolerance = 60000L;
                long upper = thisCurrent + tolerance;
                long lower = thisCurrent - tolerance;
                out = out && lower <= tempCurrent && upper >= tempCurrent;
            }
            catch (NotSupportedException nse) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "SmartEvent_NotSupportedException");
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)nse);
                if (!traceLogger.isLogging()) break block5;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)nse);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return out;
    }
}

