/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.outbandchangeagent;

import org.eclipse.aperi.monitor.MonitorActivator;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class OutbandChangeAgentProperty {
    static final String className = OutbandChangeAgentProperty.class.getName();
    static ILogger msgLogger = EventCorrelatorFactory.msgLogger;
    static ILogger traceLogger = EventCorrelatorFactory.traceLogger;
    String TRAPPORT = "162";

    public OutbandChangeAgentProperty() {
        String methodName = "SnmpChangeAgentProperty";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        IConfigService bConfigService = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
        String ownerHostName = bConfigService.getProperty("manager.loc", "setup");
        String ownerHostPort = bConfigService.getProperty("manager.port", "setup");
        bConfigService.register("SnmpTrapPort", "user", ownerHostName + ":" + ownerHostPort, "SANEventCorrelatorFactory");
        if (bConfigService.getProperty("SnmpTrapPort", "user") == null) {
            bConfigService.setProperty("SnmpTrapPort", "user", this.TRAPPORT);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void setSnmpTrapPort(String portNum) {
        String methodName = "setSnmpTrapPort";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.TRAPPORT = portNum;
        IConfigService dbp = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
        dbp.setProperty("SnmpTrapPort", "user", this.TRAPPORT);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "The SNMP trap port was set to " + portNum);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public String getSnmpTrapPort() {
        IConfigService dbp;
        String port;
        String methodName = "getSnmpTrapPort";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if ((port = (dbp = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService")).getProperty("SnmpTrapPort", "user")) == null) {
            port = this.TRAPPORT;
        }
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Returning the SNMP trap port = " + port);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return port;
    }
}

