/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableUpdater;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.HostManager;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.SANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.TdmAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.LogWrapper;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

class AgentHeartbeatMonitor
extends Thread {
    static final String className = AgentHeartbeatMonitor.class.getName();
    final int defaultHeartbeatInterval = 60000;
    private int _agentHeartbeatInterval = 60000;
    private boolean _done = false;
    private Map hostMap = null;
    private AgentTableUpdater tableAccess = null;
    private LogWrapper messages = SANDiskMgrHostService.messages;
    private LogWrapper trace = SANDiskMgrHostService.trace;

    public void safeStop() {
        this._done = true;
        this.interrupt();
    }

    public void setHeartbeatInterval(String interval) {
        String methodName;
        block4: {
            methodName = "setHeartbeatInterval";
            if (this.trace.isLogging()) {
                this.trace.entry((Object)this, methodName, (Object)interval);
            }
            try {
                this._agentHeartbeatInterval = Integer.parseInt(interval);
            }
            catch (NumberFormatException e) {
                this.messages.exception((Object)this, methodName, (Throwable)e);
                if (!this.trace.isLogging()) break block4;
                this.trace.exception((Object)this, methodName, (Throwable)e);
            }
        }
        if (this.trace.isLogging()) {
            this.trace.exit((Object)this, methodName);
        }
    }

    AgentHeartbeatMonitor(String heartbeat_interval, Map hostMap) {
        String methodName = "AgentHeartbeatMonitor";
        AgentHeartbeatMonitor.currentThread().setName("AgentHeartbeatMonitor");
        this.hostMap = hostMap;
        if (heartbeat_interval == null) {
            heartbeat_interval = Integer.toString(this._agentHeartbeatInterval);
        }
        this.setHeartbeatInterval(heartbeat_interval);
        if (this.trace.isLogging()) {
            String msg = "HeartbeatMonitor initialized with interval: " + this._agentHeartbeatInterval;
            this.trace.text(IRecordType.TYPE_OBJ_CREATE, (Object)className, "AgentHeartbeatMonitor", msg);
        }
    }

    private boolean timeExpired(TdmAgent host) {
        String methodName = "timeExpired";
        Date current = new Date();
        long change = current.getTime() - host.status_lstchanged.getTime();
        Long l = new Long(change);
        String msg = host.getNameGuidPort() + "  elapsed time: " + l.toString();
        this.trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "timeExpired", msg);
        return (int)change > this._agentHeartbeatInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String methodName = "run";
        try {
            if (this.trace.isLogging()) {
                this.trace.entry((Object)this, "run");
            }
            this.tableAccess = SANDiskMgrHostService.getHostTableUpdater();
            while (!this._done) {
                block20: {
                    int sleepInterval = this._agentHeartbeatInterval;
                    try {
                        if (this.trace.isLogging()) {
                            String msg = "sleeping... " + sleepInterval;
                            this.trace.text(IRecordType.TYPE_OBJ_CREATE, (Object)className, "run", msg);
                        }
                        AgentHeartbeatMonitor.sleep(sleepInterval);
                    }
                    catch (InterruptedException e) {
                        if (!this.trace.isLogging()) break block20;
                        this.trace.text(IRecordType.TYPE_WARN, (Object)className, "run", "Message: " + e.getMessage());
                    }
                }
                try {
                    Set s = this.hostMap.keySet();
                    Timestamp ts = new Timestamp(new Date().getTime());
                    Map map = this.hostMap;
                    synchronized (map) {
                        for (Object obj : s) {
                            TdmAgent host = (TdmAgent)this.hostMap.get(obj);
                            String uniqueAgentName = host.getUniqueAgentName();
                            if (!host.status.equals("AC") || !this.timeExpired(host)) continue;
                            host.status = "IA";
                            this.tableAccess.updateStatus(host.guid, host.agentPort, ts, "IA");
                            HostManager.fireDiskMgrHostEvent(host.guid, host.agentPort, "IA");
                            this.messages.message(IRecordType.TYPE_WARN, (Object)this, "run", "Agent_inActive", (Object)host.toAgentString());
                            if (!this.trace.isLogging()) continue;
                            String msg = "Mark Agent " + host.getNameGuidPort() + " INACTIVE";
                            this.trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "run", msg);
                        }
                        if (this._done) {
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    this.messages.exception((Object)this, "run", (Throwable)e);
                    if (!this.trace.isLogging()) continue;
                    this.trace.exception((Object)this, "run", (Throwable)e);
                }
            }
            if (this.trace.isLogging()) {
                this.trace.exit((Object)this, "run");
            }
        }
        catch (Exception e) {
            this.messages.exception((Object)this, "run", (Throwable)e);
            if (this.trace.isLogging()) {
                this.trace.exception((Object)this, "run", (Throwable)e);
            }
        }
        finally {
            if (this.tableAccess != null) {
                this.tableAccess.close();
            }
        }
    }
}

