/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentBuilder;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.SANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.Agent;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.IAgentBuilder;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.DatabaseConnectException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.SqlException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.TdmException;

class AgentListImpl {
    static final String className = AgentListImpl.class.getName();

    AgentListImpl() {
    }

    static Agent[] getHostList() throws TdmException {
        String methodName = "getHostList";
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "getHostList");
        }
        Agent[] hostList = new Agent[]{};
        AgentTableReader tableAccess = null;
        try {
            tableAccess = SANDiskMgrHostService.getHostTableReader();
            hostList = AgentListImpl.getHostList(tableAccess);
        }
        catch (SQLException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "getHostList", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getHostList", (Throwable)e);
            }
            throw new SqlException(e);
        }
        catch (InterruptedException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "getHostList", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getHostList", (Throwable)e);
            }
            throw new DatabaseConnectException(e);
        }
        finally {
            if (tableAccess != null) {
                tableAccess.close();
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "getHostList");
        }
        return hostList;
    }

    static Agent[] getHostList(AgentTableReader tableAccess) throws SQLException, TdmException {
        String methodName = "getHostList";
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "getHostList");
        }
        DeviceAgent.DeviceAgentCursor hostResults = tableAccess.listHosts();
        Vector<AgentBuilder> v = new Vector<AgentBuilder>();
        while (hostResults.next()) {
            v.addElement(new AgentBuilder(hostResults, tableAccess));
        }
        hostResults.close();
        hostResults = null;
        Agent[] hostList = new Agent[v.size()];
        for (int i = 0; i < hostList.length; ++i) {
            hostList[i] = new Agent((IAgentBuilder)v.elementAt(i));
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "getHostList");
        }
        return hostList;
    }
}

