/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.Null;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.SANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.LogWrapper;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

class AgentTableReader {
    static final String className = AgentTableReader.class.getName();
    protected String _hostTable;
    protected DBConnection _dbc = null;
    PreparedStatement _queryHost1 = null;
    PreparedStatement _queryHost2 = null;
    PreparedStatement _listActiveHosts = null;
    PreparedStatement _listHosts = null;
    PreparedStatement _listAgentsInDomain = null;
    PreparedStatement _queryDomainID = null;
    protected LogWrapper _messages = SANDiskMgrHostService.messages;
    protected LogWrapper _trace = SANDiskMgrHostService.trace;

    AgentTableReader(DBConnection dbc, String tableName) throws InterruptedException, SQLException {
        String methodName = "HostTableReader";
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "HostTableReader", (Object)tableName);
        }
        this._hostTable = tableName;
        this._dbc = dbc;
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "HostTableReader");
        }
    }

    void close() {
        block5: {
            String methodName = "close";
            if (this._trace.isLogging()) {
                this._trace.entry((Object)this, "close");
            }
            if (this._dbc != null) {
                try {
                    this._dbc.close();
                    this._dbc = null;
                }
                catch (SQLException e) {
                    if (!this._trace.isLogging()) break block5;
                    this._trace.exception((Object)this, "close", (Throwable)e);
                }
            }
        }
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "close");
        }
    }

    static String osName(short osType) {
        String[] list = new String[]{"Unknown", "Linux", "AIX", "HP-UX", "Windows NT", "Windows", "Solaris", "HP-UX 10.x"};
        return list[osType];
    }

    static short osType(String osName) {
        int osType = 0;
        String os = osName.toLowerCase();
        if (os.startsWith("linux")) {
            osType = 1;
        } else if (os.startsWith("aix")) {
            osType = 2;
        } else if (os.startsWith("hp")) {
            osType = 3;
        } else if (os.startsWith("window")) {
            osType = os.indexOf("nt") > 0 ? 4 : 5;
        } else if (os.startsWith("solaris") || os.startsWith("sun")) {
            osType = 6;
        }
        return (short)osType;
    }

    Host getResHost(int host_id) {
        Host host;
        block4: {
            String methodName = "getResHost";
            if (this._trace.isLogging()) {
                this._trace.entry((Object)this, "getResHost", (Object)("" + host_id));
            }
            host = null;
            try {
                host = new Host();
                host.setComputerId(host_id);
                host.retrieve(this._dbc);
            }
            catch (SQLException e) {
                if (!this._trace.isLogging()) break block4;
                this._trace.exception((Object)this, "getResHost", (Throwable)e);
            }
        }
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "getResHost");
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Host getResHost(GUID g) {
        String methodName = "getResHost";
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "getResHost", (Object)g);
        }
        Host host = null;
        Hashtable<ColumnInfo, String> htWhere = new Hashtable<ColumnInfo, String>();
        htWhere.put(Host.getColumnInfo((String)"GUID"), g.toNoDotString());
        Host.HostCursor hc = null;
        try {
            hc = Host.getCursor((DBConnection)this._dbc, htWhere, null);
            if (hc.next()) {
                host = hc.getAttributes();
            }
        }
        catch (SQLException e) {
            if (this._trace.isLogging()) {
                this._trace.exception((Object)this, "getResHost", (Throwable)e);
            }
        }
        finally {
            if (hc != null) {
                try {
                    hc.close();
                }
                catch (SQLException ignore) {}
            }
        }
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "getResHost");
        }
        return host;
    }

    DeviceAgent.DeviceAgentCursor queryHost(GUID guid, int port) throws SQLException {
        String methodName = "queryHost";
        String name = guid + ":" + port;
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "queryHost", (Object)name);
        }
        Host host = this.getResHost(guid);
        Hashtable<ColumnInfo, Object> htWhere = new Hashtable<ColumnInfo, Object>();
        if (host == null) {
            htWhere.put(DeviceAgent.getColumnInfo((String)"HOST_ID"), new Null());
        } else {
            htWhere.put(DeviceAgent.getColumnInfo((String)"HOST_ID"), "" + host.getComputerId());
        }
        htWhere.put(DeviceAgent.getColumnInfo((String)"PORT"), "" + port);
        DeviceAgent.DeviceAgentCursor dac = DeviceAgent.getCursor((DBConnection)this._dbc, htWhere, null);
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "queryHost");
        }
        return dac;
    }

    DeviceAgent.DeviceAgentCursor listActiveHosts() throws SQLException {
        String methodName = "listActiveHost";
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "listActiveHost");
        }
        Hashtable<ColumnInfo, String> htWhere = new Hashtable<ColumnInfo, String>();
        htWhere.put(DeviceAgent.getColumnInfo((String)"STATUS"), "AC");
        DeviceAgent.DeviceAgentCursor dac = DeviceAgent.getCursor((DBConnection)this._dbc, htWhere, null);
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "listActiveHost");
        }
        return dac;
    }

    DeviceAgent.DeviceAgentCursor listHosts() throws SQLException {
        String methodName = "listHost";
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "listHost");
        }
        DeviceAgent.DeviceAgentCursor dac = DeviceAgent.getCursor((DBConnection)this._dbc, null, null);
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "listHost");
        }
        return dac;
    }

    DeviceAgent.DeviceAgentCursor listAgentsInDomain(int domainID) throws SQLException {
        String methodName = "listAgentsInDomain";
        boolean domainID_null = false;
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "listAgentsInDomain");
        }
        Hashtable<ColumnInfo, Object> htWhere = new Hashtable<ColumnInfo, Object>();
        if (domainID == 0) {
            htWhere.put(DeviceAgent.getColumnInfo((String)"POLICY_DOMAIN_ID"), new Null());
        } else {
            htWhere.put(DeviceAgent.getColumnInfo((String)"POLICY_DOMAIN_ID"), "" + domainID);
        }
        if (this._trace.isLogging()) {
            this._trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "listAgentsInDomain", htWhere + " " + domainID);
        }
        DeviceAgent.DeviceAgentCursor dac = DeviceAgent.getCursor((DBConnection)this._dbc, htWhere, null);
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "listAgentsInDomain");
        }
        return dac;
    }

    int getPolicyDomainIDFromAgent(GUID guid, int port) throws SQLException {
        DeviceAgent da;
        String methodName = "getPolicyDomainIDFromAgent";
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "getPolicyDomainIDFromAgent");
        }
        int id = -1;
        Hashtable<ColumnInfo, String> htWhere = new Hashtable<ColumnInfo, String>();
        Host host = this.getResHost(guid);
        htWhere.put(DeviceAgent.getColumnInfo((String)"HOST_ID"), "" + host.getComputerId());
        htWhere.put(DeviceAgent.getColumnInfo((String)"PORT"), "" + port);
        Vector<String> columns = new Vector<String>();
        columns.add("POLICY_DOMAIN_ID");
        DeviceAgent.DeviceAgentCursor dac = DeviceAgent.getCursor((DBConnection)this._dbc, htWhere, columns);
        if (dac.next() && (da = dac.getAttributes()) != null) {
            if (this._trace.isLogging()) {
                this._trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "getPolicyDomainIDFromAgent", da.toString());
            }
            id = da.getPolicyDomainId();
        }
        dac.close();
        dac = null;
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "getPolicyDomainIDFromAgent", id);
        }
        return id;
    }
}

